/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;

class Chart {
    private JCChart chart;
    private JCAxis xAxis;
    private JCAxis yAxis;
    public static final int NORTH = 16;
    public static final int SOUTH = 32;
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTHEAST = 17;
    public static final int NORTHWEST = 18;
    public static final int SOUTHEAST = 33;
    public static final int SOUTHWEST = 34;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    protected Chart(int n) {
        this.chart = new JCChart(n);
        this.xAxis = this.chart.getChartArea().getXAxis(0);
        this.yAxis = this.chart.getChartArea().getYAxis(0);
    }

    public JComponent getComponentObj() {
        return this.chart;
    }

    public void setXaxisTitle(String string) {
        this.xAxis.setTitle(new JCAxisTitle(string));
    }

    public void setYaxisTitle(String string) {
        this.yAxis.setTitle(new JCAxisTitle(string));
        this.yAxis.getTitle().setPlacement(2);
        this.yAxis.getTitle().setRotation(3);
    }

    public void setGridVisible(boolean bl) {
        this.yAxis.setGridVisible(bl);
    }

    public void setOrigin(double d) {
        this.yAxis.setOrigin(d);
    }

    public void setMin(double d) {
        this.yAxis.setMin(d);
    }

    public void setBackground(Color color) {
        this.chart.getChartArea().setBackground(color);
        this.chart.getChartArea().setOpaque(true);
    }

    public void setAutoLabel(boolean bl) {
        this.getChartDataView().setAutoLabel(bl);
    }

    public void setDataSource(ChartDataModel chartDataModel) {
        this.getChartDataView().setDataSource(chartDataModel);
    }

    public void setHeader(String string) {
        this.chart.getHeader().setVisible(true);
        ((JLabel)this.chart.getHeader()).setText(string);
    }

    public void setFooter(String string) {
        this.chart.getFooter().setVisible(true);
        ((JLabel)this.chart.getFooter()).setText(string);
    }

    public void setLegendAnchor(int n) {
        this.chart.getLegend().setAnchor(n);
    }

    public void setLegendOrientation(int n) {
        this.chart.getLegend().setOrientation(n);
    }

    public void setLegendVisible(boolean bl) {
        this.chart.getLegend().setVisible(bl);
    }

    protected ChartDataView getChartDataView() {
        return this.chart.getDataView(0);
    }
}

