/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DetailedLog;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.Icon;

public class DetailedProgressDialog
extends DetailedLogDialog
implements IDetailedProgressDialog {
    private DetailedLog currentLog;
    private IDetailedProgressController controller;

    public DetailedProgressDialog(Frame frame, String string, DetailedLog detailedLog, IDetailedProgressController iDetailedProgressController) {
        super(frame, string, (Icon)CerentDialog.INFO_ICON, "", detailedLog, true, 1);
        this.controller = iDetailedProgressController;
        this.init();
    }

    public DetailedProgressDialog(Dialog dialog, String string, DetailedLog detailedLog, IDetailedProgressController iDetailedProgressController) {
        super(dialog, string, (Icon)CerentDialog.INFO_ICON, "", detailedLog, true, 1);
        this.controller = iDetailedProgressController;
        this.init();
    }

    public void start() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                DetailedProgressDialog.this.controller.start(DetailedProgressDialog.this);
            }
        });
        thread.start();
        this.show();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public boolean isCompleted() {
        return !this.isCancelled();
    }

    public void addLog(String string, DetailedLog detailedLog) {
        this.setMainLabel(string);
        if (detailedLog != null) {
            this.addDetailedLog(detailedLog, true);
        }
        this.currentLog = detailedLog;
    }

    public void addLog(DetailedLog detailedLog) {
        this.addDetailedLog(detailedLog, true);
        this.currentLog = detailedLog;
    }

    public void appendChild(DetailedLog detailedLog) {
        if (this.currentLog != null) {
            this.currentLog.setType(Math.max(this.currentLog.getType(), detailedLog.getType()));
            this.currentLog.addChild(detailedLog);
            this.updateDetailedLog(this.currentLog, true);
        }
    }

    public void setCancelled() {
        this.cancelled = true;
        this.setMainLabel("User Cancelled");
        this.setCancelEnabled(true);
    }

    public void setCompleted(boolean bl) {
        if (bl) {
            this.setMainLabel("Completed");
        } else {
            this.setMainLabel("Failed");
        }
        this.setCancelEnabled(true);
        this.setCloseEnabled(bl);
    }

    private void init() {
        this.setCloseEnabled(false);
        this.setCancelEnabled(this.controller.isCancelSupported());
        this.setCloseText("Continue");
    }

    protected void setCancelEnabled(boolean bl) {
        super.setCancelEnabled(bl);
        if (!bl) {
            this.setDefaultCloseOperation(0);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }
}

