/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.job;

import cerent.util.KDebug;
import cerent.util.job.FIFOQueue;
import cerent.util.job.JobGroup;
import cerent.util.job.JobInfo;
import cerent.util.job.JobStatus;
import cerent.util.job.JobWorker;
import java.util.ArrayList;

public class JobController {
    private FIFOQueue threadPool;
    private FIFOQueue jobQueue;
    private JobWorker[] jobWorkers;
    private Thread scheduleThread;
    private volatile boolean noStopRequested;
    private String name = "";
    private int jobCnt = 0;
    private Object jobCntLock = new Object();
    private static final KDebug db = new KDebug("JobController");

    JobController(int n) {
        this.init(n, 500);
    }

    JobController(int n, int n2) {
        this.init(n, n2);
    }

    private JobWorker nextWorker() throws InterruptedException {
        return (JobWorker)this.threadPool.remove();
    }

    private JobInfo nextJob() throws InterruptedException {
        JobInfo jobInfo;
        while ((jobInfo = (JobInfo)this.jobQueue.remove()).getJobStatus().value() == 3) {
        }
        return jobInfo;
    }

    private void execute(JobWorker jobWorker, JobInfo jobInfo) throws InterruptedException {
        jobWorker.executeJob(jobInfo);
    }

    private void init(int n, int n2) {
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.noStopRequested = true;
        this.threadPool = new FIFOQueue(n);
        this.jobWorkers = new JobWorker[n];
        this.jobQueue = new FIFOQueue(n2);
        this.scheduleThread = new Thread(new Runnable(){

            public void run() {
                while (JobController.this.noStopRequested) {
                    try {
                        JobController.this.execute(JobController.this.nextWorker(), JobController.this.nextJob());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    JobController.this.jobQueue.removeAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "JC ScheduleThread");
        this.scheduleThread.start();
        for (int i = 0; i < this.jobWorkers.length; ++i) {
            this.jobWorkers[i] = new JobWorker(this, i + 1);
        }
        if (JobController.db.on) {
            this.println("Queue size = " + n2 + " Threads = " + n);
        }
    }

    public synchronized void submitJob(JobGroup jobGroup) {
        JobInfo[] jobInfoArray = jobGroup.getJobInfoList();
        for (int i = 0; i < jobInfoArray.length; ++i) {
            this.addJobToQueue(jobInfoArray[i]);
        }
    }

    private void addJobToQueue(JobInfo jobInfo) {
        jobInfo.jobStatusChange(new JobStatus(0));
        try {
            this.jobQueue.add(jobInfo);
            this.incJob();
        }
        catch (InterruptedException interruptedException) {
            this.println(interruptedException);
        }
    }

    public void addThreadToPool(JobWorker jobWorker) {
        try {
            this.println(jobWorker.getName() + " - add to thread pool");
            this.threadPool.add(jobWorker);
        }
        catch (InterruptedException interruptedException) {
            this.println(interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    private void stopAllJobWorkers() {
        this.stopIdleJobWorkers();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 0; i < this.jobWorkers.length; ++i) {
            if (!this.jobWorkers[i].isAlive()) continue;
            this.jobWorkers[i].stopRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortJob(JobGroup jobGroup) {
        int n;
        ArrayList<JobInfo> arrayList = new ArrayList<JobInfo>();
        ArrayList<JobInfo> arrayList2 = new ArrayList<JobInfo>();
        JobInfo[] jobInfoArray = jobGroup.getJobInfoList();
        Object object = this.jobQueue;
        synchronized (object) {
            for (n = 0; n < jobInfoArray.length; ++n) {
                boolean bl = false;
                for (int i = this.jobQueue.getStart(); i < this.jobQueue.getEnd(); ++i) {
                    JobInfo jobInfo = (JobInfo)this.jobQueue.get(i);
                    if (jobInfo == null || jobInfoArray[n] != jobInfo) continue;
                    jobInfo.abortJob();
                    arrayList.add(jobInfo);
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList2.add(jobInfoArray[n]);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (JobInfo)arrayList.get(n);
            try {
                this.decJob();
                ((JobInfo)object).jobStatusChange(new JobStatus(3, new Exception("Cancelled by user")));
                continue;
            }
            catch (Exception exception) {
                this.println(exception);
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            object = (JobInfo)arrayList2.get(n);
            try {
                ((JobInfo)object).getJob().abortJob();
                continue;
            }
            catch (Exception exception) {
                this.println(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Object object = this.jobCntLock;
        synchronized (object) {
            return this.jobCnt == 0;
        }
    }

    private boolean isThreadBusy() {
        for (int i = 0; i < this.jobWorkers.length; ++i) {
            if (!this.jobWorkers[i].isBusy()) continue;
            return true;
        }
        return false;
    }

    private void stopIdleJobWorkers() {
        try {
            Object[] objectArray = this.threadPool.removeAll();
            for (int i = 0; i < objectArray.length; ++i) {
                ((JobWorker)objectArray[i]).stopRequest();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void stopRequest() {
        this.noStopRequested = false;
        this.scheduleThread.interrupt();
    }

    void dispose() {
        this.println("disposing...");
        try {
            this.stopAllJobWorkers();
            this.stopRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        this.dispose();
    }

    private void println(Exception exception) {
        if (JobController.db.on) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    private void println(String string) {
        if (JobController.db.on) {
            db.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incJob() {
        Object object = this.jobCntLock;
        synchronized (object) {
            ++this.jobCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decJob() {
        Object object = this.jobCntLock;
        synchronized (object) {
            --this.jobCnt;
        }
    }
}

