/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.matcher;

import cerent.util.matcher.AbstractFieldMatcher;
import cerent.util.matcher.FieldMethod;

public class LongFieldMatcher
extends AbstractFieldMatcher {
    protected RangeCriteria criteria_;
    protected IAccessor accessor_;

    public LongFieldMatcher(String string, long l, long l2, IAccessor iAccessor, FieldMethod fieldMethod) {
        super(string, 4, fieldMethod);
        this.accessor_ = iAccessor;
        this.criteria_ = new RangeCriteria(l, l2);
    }

    public LongFieldMatcher(String string, long l, IAccessor iAccessor, FieldMethod fieldMethod) {
        this(string, l, l, iAccessor, fieldMethod);
    }

    public LongFieldMatcher(String string, int n, IAccessor iAccessor, FieldMethod fieldMethod) {
        this(string, n, n, iAccessor, fieldMethod);
    }

    public LongFieldMatcher(String string, short s, IAccessor iAccessor, FieldMethod fieldMethod) {
        this(string, s, s, iAccessor, fieldMethod);
    }

    public boolean doesMatch(Object object) {
        long l = this.accessor_.getAttribute(object);
        boolean bl = !this.isEnabled() || this.criteria_.doesMatch(l);
        return bl;
    }

    public IAccessor getIAccessor() {
        return this.accessor_;
    }

    public Object getCriteria() {
        return this.criteria_;
    }

    public long getFirstCriteria() {
        return this.criteria_.getFirst();
    }

    public Object getFirstCriteriaObj() {
        return this.criteria_.getFirstObj();
    }

    public long getLastCriteria() {
        return this.criteria_.getLast();
    }

    public static class RangeCriteria {
        Long first_;
        Long last_;

        public RangeCriteria(long l, long l2) {
            this.first_ = new Long(l);
            this.last_ = new Long(l2);
        }

        public long getFirst() {
            return this.first_;
        }

        public Long getFirstObj() {
            return this.first_;
        }

        public long getLast() {
            return this.last_;
        }

        public boolean doesMatch(long l) {
            return this.first_ <= l && l <= this.last_;
        }
    }

    public static interface IAccessor {
        public long getAttribute(Object var1);
    }
}

