/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.matcher;

import cerent.util.KDebug;
import cerent.util.ReflectionUtil;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.ClassMatcher;
import cerent.util.matcher.StringFieldMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class MethodMatcher
extends AbstractMatcher {
    private static final int START_STATE = 0;
    private static final int PARSE_MODIFIER = 0;
    private static final int PARSE_RETURN = 1;
    private static final int PARSE_NAME = 2;
    private static final int PARSE_ARG = 3;
    private static final int PARSE_DONE = 4;
    private static final String WILDCARD = "*";
    private static final String WILDLIST = "..";
    private static final String[] _reservedMods = new String[]{"*", "PUBLIC", "PROTECTED", "PRIVATE", "FINAL", "STATIC", "NATIVE"};
    private static final Set reservedMods = MethodMatcher.initReservedMods();
    private static final ClassMatcher[] ClassMatcherArrayTemplate = new ClassMatcher[0];
    private int modifierCrit;
    private String modifierCritStr;
    private ClassMatcher methodReturnCrit;
    private ClassMatcher methodClassCrit;
    private StringFieldMatcher nameCrit;
    private ClassMatcher[] argsCrit;
    private boolean arglistWild;
    private static KDebug db = new KDebug("MethodMatcher");
    static /* synthetic */ Class class$java$lang$reflect$Modifier;

    private static HashSet initReservedMods() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < _reservedMods.length; ++i) {
            hashSet.add(_reservedMods[i]);
        }
        return hashSet;
    }

    public MethodMatcher(String string) throws Exception {
        this("", string);
    }

    public MethodMatcher(String string, String string2) throws Exception {
        super(string, 0);
        ArrayList<ClassMatcher> arrayList = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,()");
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string3 = stringTokenizer.nextToken();
            if (db == null || db.isFinestEnabled()) {
                this.finest("+++ " + n + " / " + string3);
            }
            String string4 = null;
            if (n == 0) {
                string4 = string3.toUpperCase();
                if (!MethodMatcher.isReservedMod(string4) || n3 > 0 && string3.equals(WILDCARD)) {
                    ++n;
                    if (db == null || db.isFinestEnabled()) {
                        this.finest("+++ " + n + " / " + string3);
                    }
                } else {
                    ++n3;
                    this.modifierCritStr = this.modifierCritStr != null ? this.modifierCritStr + "|" + string3.toLowerCase() : string3.toLowerCase();
                }
            }
            switch (n) {
                case 0: {
                    if (string3.equals(WILDCARD)) {
                        this.modifierCrit = 0;
                        n = 1;
                        break;
                    }
                    Field field = (class$java$lang$reflect$Modifier == null ? MethodMatcher.class$("java.lang.reflect.Modifier") : class$java$lang$reflect$Modifier).getField(string4);
                    this.modifierCrit |= ((Integer)field.get(null)).intValue();
                    break;
                }
                case 1: {
                    this.methodReturnCrit = new ClassMatcher("return", string3);
                    n = 2;
                    break;
                }
                case 2: {
                    int n4 = string3.lastIndexOf(".");
                    String string5 = string3.substring(n4 + 1);
                    this.nameCrit = new StringFieldMatcher("", string5, 3, false, null, null);
                    String string6 = string3.substring(0, n4);
                    this.methodClassCrit = new ClassMatcher("decl class", string6);
                    n = 3;
                    break;
                }
                case 3: {
                    if (arrayList == null) {
                        arrayList = new ArrayList<ClassMatcher>();
                    }
                    if (string3.equals(WILDLIST)) {
                        this.arglistWild = true;
                        n = 4;
                        break;
                    }
                    ClassMatcher classMatcher = new ClassMatcher("arg # " + n2, string3);
                    arrayList.add(classMatcher);
                    ++n2;
                    break;
                }
                case 4: {
                    bl = true;
                    break;
                }
            }
        }
        if (this.argsCrit == null) {
            this.argsCrit = arrayList == null ? ClassMatcherArrayTemplate : arrayList.toArray(ClassMatcherArrayTemplate);
        }
    }

    private static boolean isReservedMod(String string) {
        boolean bl = reservedMods.contains(string);
        return bl;
    }

    public final boolean doesMatch(Object object) {
        boolean bl = object instanceof Method;
        return !bl ? false : this.doesMatch((Method)object);
    }

    public boolean doesMatch(Method method) {
        int n = method.getModifiers();
        if (!this.doesModifierMatch(n)) {
            if (db == null || db.on()) {
                this.println(method + " failed modifier matching");
            }
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (!this.doesReturnTypeMatch(clazz)) {
            if (db == null || db.on()) {
                this.println(method + " failed return type matching");
            }
            return false;
        }
        clazz = method.getDeclaringClass();
        if (!this.doesDeclaringClassMatch(clazz)) {
            if (db == null || db.on()) {
                this.println(method + " failed declaring class matching");
            }
            return false;
        }
        String string = method.getName();
        if (!this.doesNameMatch(string)) {
            if (db == null || db.on()) {
                this.println(method + " failed method name matching");
            }
            return false;
        }
        Class[] classArray = method.getParameterTypes();
        return this.doParameterTypesMatch(classArray, method);
    }

    protected boolean doesModifierMatch(int n) {
        boolean bl = (this.modifierCrit & n) == this.modifierCrit;
        return bl;
    }

    protected boolean doesReturnTypeMatch(Class clazz) {
        boolean bl = this.methodReturnCrit.doesMatch(clazz);
        return bl;
    }

    protected boolean doesDeclaringClassMatch(Class clazz) {
        boolean bl = this.methodClassCrit.doesMatch(clazz);
        return bl;
    }

    protected boolean doesNameMatch(String string) {
        boolean bl = this.nameCrit.doesMatch(string);
        return bl;
    }

    protected boolean doParameterTypesMatch(Class[] classArray, Method method) {
        boolean bl = true;
        int n = classArray == null ? 0 : classArray.length;
        int n2 = this.argsCrit == null ? 0 : this.argsCrit.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Class clazz = classArray[i];
            if (this.argsCrit[i].doesMatch(clazz)) continue;
            if (db == null || db.on()) {
                this.println(method + " failed arg type matching for arg#: " + i);
            }
            return false;
        }
        bl = n == n2 ? true : (n < n2 ? false : this.arglistWild);
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        if (string != null && string.length() > 0) {
            stringBuffer.append("name: '" + string + ", ");
        }
        stringBuffer.append("modifier crit: " + this.modifierCritStr + ", ");
        stringBuffer.append("method return crit: " + this.methodReturnCrit + ", ");
        stringBuffer.append("method declaring class crit: " + this.methodClassCrit + ", ");
        stringBuffer.append("method name crit: '" + this.nameCrit.getOrigCriteria() + ", ");
        int n = this.argsCrit == null ? 0 : this.argsCrit.length;
        stringBuffer.append("# method args crit: " + n + ", ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  " + this.argsCrit[i] + ", ");
        }
        stringBuffer.append("arg list wildcarded?: " + this.arglistWild);
        return stringBuffer.toString();
    }

    protected void println(String string) {
        if (db == null) {
            System.out.println(string);
        } else {
            db.println(string);
        }
    }

    protected void finer(String string) {
        if (db == null) {
            System.out.println(string);
        } else {
            db.finer(string);
        }
    }

    protected void finest(String string) {
        if (db == null) {
            System.out.println(string);
        } else {
            db.finest(string);
        }
    }

    public Object getCriteria() {
        return null;
    }

    public Object[] getMetadata() {
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            MethodMatcher methodMatcher = new MethodMatcher(stringArray[0]);
            System.out.println(methodMatcher.toString());
            System.out.println("");
            if (stringArray.length > 1) {
                Class<?> clazz = Class.forName(stringArray[1]);
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                for (int i = 0; i < methodArray.length; ++i) {
                    if (!methodMatcher.doesMatch(methodArray[i])) continue;
                    System.out.println("matches " + ReflectionUtil.getSignatureString(methodArray[i], true, false));
                    ++n;
                }
                System.out.println("# matches: " + n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

