/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.stats;

import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.RowDataSource;
import cerent.util.stats.HistoryEntry;
import cerent.util.stats.StatsBin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StatsMgr {
    private static final String PREFS_PREFIX = "ctc.stats";
    private static final String PREFS_LOW = "lowater";
    private static final String PREFS_HIW = "hiwater";
    private static final StatsMgr instance = new StatsMgr();
    private final KDebug dbg;
    private final SummaryRds okSummary = new SummaryRds();
    private final SummaryRds koSummary = new SummaryRds();
    private final HistoryRds hrds = new HistoryRds();
    private boolean started = false;

    private StatsMgr() {
        this.dbg = new KDebug("StatsMgr");
        this.dbg.addCommand((Object)this, "historysize", "Set history lowater and hiwater");
    }

    public static StatsMgr instance() {
        return instance;
    }

    public KDebug getDebug() {
        return this.dbg;
    }

    public Object beginOperation(Object object, String string, boolean bl, boolean bl2) {
        String string2 = object.getClass().getName();
        return this.beginOperation(string2, string, bl, bl2);
    }

    public Object beginOperation(String string, String string2, boolean bl, boolean bl2) {
        return this.hrds.beginOperation(string, string2, bl, bl2);
    }

    public void endOperation(Object object, String string, Exception exception) {
        if (object instanceof HistoryEntry) {
            HistoryEntry historyEntry = (HistoryEntry)object;
            this.hrds.endOperation(historyEntry, string, exception);
            if (!historyEntry.isUpdate()) {
                if (exception != null) {
                    this.koSummary.addToBin(historyEntry);
                } else {
                    this.okSummary.addToBin(historyEntry);
                }
            }
        }
    }

    public Object beginOperation(String string, String string2, int n, int n2) {
        return this.hrds.beginOperation(string, string2, n, n2);
    }

    public RowDataSource getOkSummary() {
        return this.okSummary;
    }

    public RowDataSource getFailSummary() {
        return this.koSummary;
    }

    public RowDataSource getHistory() {
        return this.hrds;
    }

    public final void resetOk() {
        this.okSummary.reset();
    }

    public final void resetFail() {
        this.koSummary.reset();
    }

    public final void historysize(int n, int n2) {
        if (n2 < 10) {
            n2 = 5000;
        }
        if (n > n2 || n < 5) {
            n = n2 / 2;
        }
        this.dbg.println("History table low water=" + n + " hi water=" + n2);
        Preferences.instance().setInt(PREFS_PREFIX, PREFS_LOW, n);
        Preferences.instance().setInt(PREFS_PREFIX, PREFS_HIW, n2);
        this.hrds.setSize(n, n2);
    }

    public final void clearOk() {
        this.okSummary.clear();
    }

    public final void clearFail() {
        this.koSummary.clear();
    }

    public final void clearHistory() {
        this.hrds.clear();
    }

    public final void start() {
        this.started = true;
    }

    public final void stop() {
        this.started = false;
    }

    public final boolean isStarted() {
        return this.started;
    }

    public final boolean isUpdateStarted() {
        return this.started;
    }

    public final long getHistoryCount() {
        return this.hrds.getRowCount();
    }

    private class HistoryRds
    extends AbstractRowDataSource {
        private int hiwater = Preferences.instance().getInt("ctc.stats", "hiwater", 2000);
        private int lowater = Preferences.instance().getInt("ctc.stats", "lowater", 1500);
        private HistoryEntry[] array = new HistoryEntry[this.hiwater];
        private int nextUnusedIndex = 0;

        private HistoryRds() {
        }

        public Object beginOperation(String string, String string2, boolean bl, boolean bl2) {
            HistoryEntry historyEntry = new HistoryEntry(string2, string, bl, bl2);
            this.submitEntry(historyEntry);
            return historyEntry;
        }

        public Object beginOperation(String string, String string2, int n, int n2) {
            HistoryEntry historyEntry = new HistoryEntry(string, string2, n, n2);
            this.submitEntry(historyEntry);
            return historyEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submitEntry(HistoryEntry historyEntry) {
            boolean bl = false;
            HistoryRds historyRds = this;
            synchronized (historyRds) {
                if (this.nextUnusedIndex >= this.hiwater) {
                    int n = this.nextUnusedIndex - this.lowater;
                    System.arraycopy(this.array, n, this.array, 0, this.lowater);
                    this.nextUnusedIndex = this.lowater;
                    bl = true;
                }
                this.array[this.nextUnusedIndex] = historyEntry;
                ++this.nextUnusedIndex;
            }
            if (bl) {
                this.fireDataSourceChanged();
            } else {
                this.fireRowsAdded(0, 0);
            }
        }

        public void endOperation(HistoryEntry historyEntry, String string, Exception exception) {
            if (string == null) {
                string = exception != null ? exception.getClass().getName() : "";
            } else if (exception != null) {
                string = string + " " + exception.getClass().getName();
            }
            historyEntry.finish(string);
            int n = historyEntry.uniqueId - this.array[0].uniqueId;
            n = this.nextUnusedIndex - n - 1;
            this.fireRowsUpdated(n, n);
        }

        public void clear() {
            this.nextUnusedIndex = 0;
            this.fireDataSourceChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSize(int n, int n2) {
            HistoryRds historyRds = this;
            synchronized (historyRds) {
                if (n2 != this.hiwater) {
                    HistoryEntry[] historyEntryArray = new HistoryEntry[n2];
                    if (n2 > this.nextUnusedIndex) {
                        System.arraycopy(this.array, 0, historyEntryArray, 0, this.nextUnusedIndex);
                    } else {
                        int n3 = this.nextUnusedIndex - n2;
                        System.arraycopy(this.array, n3, historyEntryArray, 0, n2);
                        this.nextUnusedIndex = n2;
                    }
                    this.array = historyEntryArray;
                    this.hiwater = n2;
                }
                this.lowater = n;
            }
            this.fireDataSourceChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            ArrayList<HistoryEntry> arrayList = new ArrayList<HistoryEntry>();
            HistoryRds historyRds = this;
            synchronized (historyRds) {
                for (int i = 0; i < this.nextUnusedIndex; ++i) {
                    arrayList.add(this.array[i]);
                }
            }
            return arrayList;
        }

        public Object getObjectAtRow(int n) {
            try {
                return this.array[this.nextUnusedIndex - n - 1];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        public int getRowCount() {
            return this.nextUnusedIndex;
        }
    }

    private class SummaryRds
    extends AbstractRowDataSource {
        private final Map map = new HashMap();
        private final ArrayList array = new ArrayList();

        private SummaryRds() {
        }

        synchronized void addToBin(HistoryEntry historyEntry) {
            String string = historyEntry.name;
            StatsBin statsBin = (StatsBin)this.map.get(string);
            if (statsBin == null) {
                int n = this.array.size();
                statsBin = new StatsBin(string, historyEntry.isCv(), n, historyEntry.elapsed);
                this.map.put(string, statsBin);
                this.array.add(statsBin);
                this.fireRowsAdded(n, n);
            } else {
                statsBin.addPm(historyEntry.elapsed);
                this.fireRowsUpdated(statsBin.index, statsBin.index);
            }
        }

        synchronized void reset() {
            for (int i = 0; i < this.array.size(); ++i) {
                ((StatsBin)this.array.get(i)).reset();
            }
            this.fireDataSourceChanged();
        }

        synchronized void clear() {
            this.map.clear();
            this.array.clear();
            this.fireDataSourceChanged();
        }

        public Collection getAllObjects() {
            return this.array;
        }

        public Object getObjectAtRow(int n) {
            return this.array.get(n);
        }

        public int getRowCount() {
            return this.array.size();
        }
    }
}

