/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartTypeFormat;
import java.awt.Point;
import java.io.Serializable;

public class JCPieChartFormat
implements JCChartTypeFormat,
Serializable {
    private String otherLabel = null;
    private JCChartStyle otherStyle = null;
    protected int thresholdMethod = 0;
    protected double thresholdValue = 0.0;
    protected int sortOrder = 0;
    protected int minSlices = 1;
    protected Point[] explodeList;
    protected int explodeOffset = 10;
    protected double startAngle = 135.0;
    protected Changeable parent = null;
    public static final int SLICE_CUTOFF = 0;
    public static final int PIE_PERCENTILE = 1;
    public static final int DATA_ORDER = 0;
    public static final int ASCENDING_ORDER = 1;
    public static final int DESCENDING_ORDER = 2;
    public static final int OTHER_SLICE = -10;

    public JCPieChartFormat() {
    }

    public JCPieChartFormat(Changeable changeable) {
        this.parent = changeable;
    }

    public void setParent(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public int getThresholdMethod() {
        return this.thresholdMethod;
    }

    public void setThresholdMethod(int n) {
        if (n == this.thresholdMethod) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                this.thresholdMethod = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for ThresholdMethod in JCPieChartFormat.  Must be one of SLICE_CUTOFF or PIE_PERCENTILE");
            }
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public double getThresholdValue() {
        return this.thresholdValue;
    }

    public void setThresholdValue(double d) {
        if (d == this.thresholdValue) {
            return;
        }
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException("ThresholdValue must be between 0.0 and 100.0");
        }
        this.thresholdValue = d;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int n) {
        if (n == this.sortOrder) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.sortOrder = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for SortOrder in JCPieChartFormat.  Must be one of ASCENDING_ORDER, DESCENDING_ORDER or DATA_ORDER");
            }
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getMinSlices() {
        return this.minSlices;
    }

    public void setMinSlices(int n) {
        if (this.minSlices == n) {
            return;
        }
        this.minSlices = n;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public String getOtherLabel() {
        if (this.otherLabel == null) {
            this.otherLabel = new String(JCChartBundle.string("com.klg.jclass.chart.Key3"));
        }
        return this.otherLabel;
    }

    public void setOtherLabel(String string) {
        if (this.otherLabel != null && this.otherLabel.equals(string)) {
            return;
        }
        this.otherLabel = string;
        if (this.parent != null) {
            this.parent.setChanged(true, 33);
        }
    }

    public JCChartStyle getOtherStyle() {
        if (this.otherStyle == null) {
            this.otherStyle = this.parent != null && this.parent instanceof ChartDataView ? JCChartStyle.makeDefault(((ChartDataView)this.parent).getParent(), this.parent, true) : new JCChartStyle();
        }
        return this.otherStyle;
    }

    public void setOtherStyle(JCChartStyle jCChartStyle) {
        if (jCChartStyle == null) {
            return;
        }
        this.otherStyle = jCChartStyle;
        if (this.parent != null) {
            this.parent.setChanged(true, 17);
        }
    }

    public Point[] getExplodeList() {
        return this.explodeList;
    }

    public void setExplodeList(Point[] pointArray) {
        this.explodeList = pointArray;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getExplodeOffset() {
        return this.explodeOffset;
    }

    public void setExplodeOffset(int n) {
        this.explodeOffset = n;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        if (d == this.startAngle) {
            return;
        }
        if (d < 0.0 || d > 360.0) {
            throw new IllegalArgumentException("StartAngle must be between 0.0 and 360.0 degrees");
        }
        this.startAngle = d;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }
}

