/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartTypeFormat;
import java.io.Serializable;

public class JCPolarRadarChartFormat
implements JCChartTypeFormat,
Serializable {
    protected Changeable parent = null;

    public JCPolarRadarChartFormat() {
    }

    public JCPolarRadarChartFormat(Changeable changeable) {
        this.parent = changeable;
    }

    public void setParent(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    protected JCAxis getYAxis() {
        JCAxis jCAxis = null;
        if (this.parent != null && this.parent instanceof ChartDataView) {
            jCAxis = ((ChartDataView)this.parent).getParent().getChartArea().getYAxis(0);
        }
        return jCAxis;
    }

    protected JCAxis getThetaAxis() {
        JCAxis jCAxis = null;
        if (this.parent != null && this.parent instanceof ChartDataView) {
            jCAxis = ((ChartDataView)this.parent).getParent().getChartArea().getXAxis(0);
        }
        return jCAxis;
    }

    protected int getCurrentAngleUnit() {
        if (this.parent != null && this.parent instanceof ChartDataView) {
            return ((ChartDataView)this.parent).getParent().getChartArea().getAngleUnit();
        }
        return 2;
    }

    public void setYAxisAngle(double d) {
        this.setYAxisAngle(this.getCurrentAngleUnit(), d);
    }

    public void setYAxisAngle(int n, double d) {
        JCAxis jCAxis = this.getYAxis();
        if (jCAxis != null) {
            jCAxis.polarAxisParams.setRadialAxisAngle(n, d);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public double getYAxisAngle() {
        return this.getYAxisAngle(this.getCurrentAngleUnit());
    }

    public double getYAxisAngle(int n) {
        JCAxis jCAxis = this.getYAxis();
        if (jCAxis != null) {
            return jCAxis.polarAxisParams.getRadialAxisAngle(n);
        }
        return 0.0;
    }

    public void setOriginBase(double d) {
        this.setOriginBase(this.getCurrentAngleUnit(), d);
    }

    public void setOriginBase(int n, double d) {
        JCAxis jCAxis = this.getThetaAxis();
        if (jCAxis != null) {
            jCAxis.polarAxisParams.setOriginBase(n, d);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public double getOriginBase() {
        return this.getOriginBase(this.getCurrentAngleUnit());
    }

    public double getOriginBase(int n) {
        JCAxis jCAxis = this.getThetaAxis();
        if (jCAxis != null) {
            return jCAxis.polarAxisParams.getOriginBase(n);
        }
        return 0.0;
    }

    public void setHalfRange(boolean bl) {
        JCAxis jCAxis = this.getThetaAxis();
        if (jCAxis != null) {
            jCAxis.polarAxisParams.setPolarHalfRange(bl);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public boolean isHalfRange() {
        JCAxis jCAxis = this.getThetaAxis();
        if (jCAxis != null) {
            return jCAxis.polarAxisParams.isPolarHalfRange();
        }
        return false;
    }

    public void setRadarCircularGrid(boolean bl) {
        JCAxis jCAxis = this.getYAxis();
        if (jCAxis != null) {
            jCAxis.polarAxisParams.setCircularGrid(bl);
            if (this.parent != null) {
                this.parent.setChanged(true, 2);
            }
        }
    }

    public boolean isRadarCircularGrid() {
        JCAxis jCAxis = this.getYAxis();
        if (jCAxis != null) {
            return jCAxis.polarAxisParams.isCircularGrid();
        }
        return true;
    }
}

