/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.ArrayDeclarator;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class ArrayTypeSpec
extends VectorType {
    ArrayDeclarator declarator = null;
    String typename = null;
    String dimensionStr = "";
    int[] dims = null;
    int my_dim = 0;
    String typeSig;
    private boolean written = false;

    public ArrayTypeSpec(int num, TypeSpec elem, ArrayDeclarator ad, String pack_name) {
        super(num);
        this.declarator = ad;
        this.name = this.declarator.name();
        this.set_token(ad.get_token());
        this.setEnclosingSymbol(ad.getEnclosingSymbol());
        this.pack_name = pack_name;
        this.type_spec = elem;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ArrayTypeSpec with declarator " + ad.name());
        }
    }

    private ArrayTypeSpec(int num, TypeSpec elem, ArrayDeclarator ad, String pack_name, int my_dim) {
        super(num);
        this.declarator = ad;
        this.name = this.declarator.name();
        this.dims = this.declarator.dimensions();
        this.set_token(ad.get_token());
        this.setEnclosingSymbol(ad.getEnclosingSymbol());
        this.pack_name = pack_name;
        this.my_dim = my_dim;
        this.type_spec = this.dims.length > my_dim + 1 ? new ArrayTypeSpec(ArrayTypeSpec.new_num(), elem, ad, pack_name, my_dim + 1) : elem;
        StringBuffer sb = new StringBuffer();
        for (int i = my_dim; i < this.dims.length; ++i) {
            sb.append("[]");
        }
        this.dimensionStr = sb.toString();
    }

    public Object clone() {
        ArrayTypeSpec st = new ArrayTypeSpec(ArrayTypeSpec.new_num(), this.type_spec, this.declarator, this.pack_name);
        st.dims = this.dims;
        st.included = this.included;
        st.typedefd = this.typedefd;
        st.inhibitionFlag = this.inhibitionFlag;
        st.dims = this.dims;
        st.my_dim = this.my_dim;
        st.dimensionStr = this.dimensionStr;
        st.set_token(this.get_token());
        st.setEnclosingSymbol(this.getEnclosingSymbol());
        return st;
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        throw new RuntimeException("ArrayTypeSpec.setPackage should never be called!");
    }

    public void markTypeDefd() {
        this.typedefd = true;
    }

    public void parse() throws ParseException {
        TypeSpec ts;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ArrayTypeSpec.parse " + this.declarator.name());
        }
        this.dims = this.declarator.dimensions();
        if (this.dims.length > 1) {
            this.type_spec = new ArrayTypeSpec(ArrayTypeSpec.new_num(), this.type_spec, this.declarator, this.pack_name, 1);
        } else if (this.type_spec.typeSpec() instanceof ConstrTypeSpec) {
            this.type_spec.parse();
        } else if (this.type_spec.typeSpec() instanceof ScopedName && (ts = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec()) != null) {
            this.type_spec = ts;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = this.my_dim; i < this.dims.length; ++i) {
            sb.append("[]");
        }
        this.dimensionStr = sb.toString();
        try {
            if (!this.typedefd) {
                NameTable.define(this.full_name(), "type");
            }
            if (!NameTable.defined(this.typeName(), "type")) {
                NameTable.define(this.typeName(), "type");
            }
        }
        catch (NameAlreadyDefined n) {
            parser.fatal_error("Name " + this.full_name() + " already defined.", null);
        }
    }

    public String getTypeCodeExpression() {
        String originalType = "org.omg.CORBA.ORB.init().create_array_tc(" + this.dims[this.my_dim] + "," + this.elementTypeSpec().getTypeCodeExpression() + ")";
        return originalType;
    }

    public String helperName() {
        return ScopedName.unPseudoName(this.full_name()) + "Helper";
    }

    public String holderName() {
        return ScopedName.unPseudoName(this.full_name()) + "Holder";
    }

    public String className() {
        String cName;
        String fullName = this.pack_name.length() > 0 ? ScopedName.unPseudoName(this.pack_name + "." + this.name) : ScopedName.unPseudoName(this.name);
        if (fullName.indexOf(46) > 0) {
            this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
            cName = fullName.substring(fullName.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            cName = fullName;
        }
        return cName;
    }

    public int length() {
        return this.dims[this.my_dim];
    }

    public String printReadStatement(String var_name, String streamname) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Array printReadStatement");
        }
        StringBuffer sb = new StringBuffer();
        String type = this.typeName();
        sb.append(var_name + " = new " + type.substring(0, type.indexOf("[")));
        sb.append("[" + this.length() + "]");
        sb.append(type.substring(type.indexOf(93) + 1) + ";\n");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String _tmp = this.elementTypeSpec().printReadExpression(streamname);
            sb.append("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(" + var_name + ",0," + this.length() + ");");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            sb.append("\t\t" + indent + "for (int " + idx_variable + "=0;" + idx_variable + "<" + this.length() + ";" + idx_variable + "++)\n\t\t" + indent + "{\n");
            sb.append("\t\t\t" + indent + this.elementTypeSpec().printReadStatement(var_name + "[" + idx_variable + "]", streamname) + "\n");
            sb.append("\t\t" + indent + "}\n");
        }
        return sb.toString();
    }

    public String printWriteStatement(String var_name, String streamname) {
        StringBuffer sb = new StringBuffer();
        String type = this.typeName();
        sb.append("\t\tif (" + var_name + ".length<" + this.length() + ")\n\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect array size \"+" + var_name + ".length+\", expecting " + this.length() + "\");\n");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String _tmp = this.elementTypeSpec().printWriteStatement(var_name, streamname);
            sb.append("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(" + var_name + ",0," + this.length() + ");");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            sb.append("\t\t" + indent + "for (int " + idx_variable + "=0; " + idx_variable + "<" + this.length() + ";" + idx_variable + "++)\n\t\t" + indent + "{\n");
            sb.append("\t\t\t" + indent + this.elementTypeSpec().printWriteStatement(var_name + "[" + idx_variable + "]", streamname) + "\n");
            sb.append("\t\t" + indent + "}\n");
        }
        return sb.toString();
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";\n");
        }
        String type = this.typeName();
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + type + " value;");
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + type + " initial)\n\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + className + "Helper.type ();");
        ps.println("\t}");
        TypeSpec m = this.type_spec;
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + className + "Helper.read (_in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + className + "Helper.write (_out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        String _tmp;
        if (Environment.JAVA14 && this.pack_name.equals("")) {
            lexer.emit_warn("No package defined for " + className + " - illegal in JDK1.4", this.token);
        }
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        String type = this.typeName();
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        TypeSpec.printHelperClassMethods(ps, type);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.print("\t\t" + type + " result = new " + type.substring(0, type.indexOf(91)) + "[" + this.length() + "]");
        ps.println(type.substring(type.indexOf(93) + 1) + "; // " + type);
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printReadExpression("_in");
            ps.println("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(result,0," + this.length() + ");");
        } else {
            ps.println("\t\tfor (int i = 0; i < " + this.length() + "; i++)\n\t\t{");
            ps.println("\t\t\t" + this.elementTypeSpec().printReadStatement("result[i]", "_in") + "\n\t\t}");
        }
        ps.println("\t\treturn result;");
        ps.println("\t}");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        ps.println("\t{");
        if (this.declarator.dimensions()[0] != 0) {
            ps.println("\t\tif (s.length != " + this.declarator.dimensions()[0] + ")");
            ps.println("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect array size\");");
        }
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printWriteStatement("s", "out");
            ps.println("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(s,0," + this.length() + ");");
        } else {
            ps.println("\t\tfor (int i = 0; i < s.length; i++)\n\t\t{");
            ps.println("\t\t\t" + this.elementTypeSpec().printWriteStatement("s[i]", "out") + "\n\t\t}");
        }
        ps.println("\t}");
        ps.println("}");
    }

    public void print(PrintWriter _ps) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        try {
            this.type_spec.print(_ps);
            if (!this.written && this.typedefd) {
                PrintWriter ps;
                String fname;
                File f;
                String className = this.className();
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    ps = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, ps);
                    ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    ps = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, ps);
                    ps.close();
                }
                this.written = true;
            }
        }
        catch (IOException i) {
            throw new RuntimeException("File IO error" + i);
        }
    }
}

