/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;

public class TaggedComponentList
implements Cloneable {
    private TaggedComponent[] components = null;

    public TaggedComponentList(InputStream in) {
        this.components = TaggedComponentSeqHelper.read(in);
    }

    public TaggedComponentList(byte[] data) {
        CDRInputStream in = new CDRInputStream(null, data);
        in.openEncapsulatedArray();
        this.components = TaggedComponentSeqHelper.read(in);
    }

    public TaggedComponentList() {
        this.components = new TaggedComponent[0];
    }

    public int size() {
        return this.components.length;
    }

    public boolean isEmpty() {
        return this.components.length == 0;
    }

    public TaggedComponent get(int index) {
        return this.components[index];
    }

    public Object clone() throws CloneNotSupportedException {
        TaggedComponentList result = (TaggedComponentList)super.clone();
        result.components = new TaggedComponent[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            result.components[i] = new TaggedComponent(this.components[i].tag, new byte[this.components[i].component_data.length]);
            System.arraycopy(this.components[i].component_data, 0, result.components[i].component_data, 0, this.components[i].component_data.length);
        }
        return result;
    }

    public TaggedComponent[] asArray() {
        return this.components;
    }

    public void addComponent(int tag, Object data, Class helper) {
        try {
            Method writeMethod = helper.getMethod("write", OutputStream.class, data.getClass());
            CDROutputStream out = new CDROutputStream();
            out.beginEncapsulatedArray();
            writeMethod.invoke(null, out, data);
            this.addComponent(tag, out.getBufferCopy());
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Helper " + helper.getName() + " has no appropriate write() method.");
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Cannot access write() method of helper " + helper.getName());
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Exception while marshaling component data: " + ex.getTargetException());
        }
    }

    public void addComponent(int tag, byte[] data) {
        this.addComponent(new TaggedComponent(tag, data));
    }

    public void addComponent(TaggedComponent component) {
        TaggedComponent[] newComponents = new TaggedComponent[this.components.length + 1];
        System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
        newComponents[this.components.length] = component;
        this.components = newComponents;
    }

    public void addAll(TaggedComponentList other) {
        TaggedComponent[] newComponents = new TaggedComponent[this.components.length + other.components.length];
        System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
        System.arraycopy(other.components, 0, newComponents, this.components.length, other.components.length);
        this.components = newComponents;
    }

    public Object getComponent(int tag, Class helper) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag != tag) continue;
            return this.getComponentData(this.components[i].component_data, helper);
        }
        return null;
    }

    public String getStringComponent(int tag) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag != tag) continue;
            CDRInputStream in = new CDRInputStream(null, this.components[i].component_data);
            in.openEncapsulatedArray();
            return in.read_string();
        }
        return null;
    }

    public List getComponents(int tag, Class helper) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag != tag) continue;
            result.add(this.getComponentData(this.components[i].component_data, helper));
        }
        return result;
    }

    private Object getComponentData(byte[] data, Class helper) {
        try {
            Method readMethod = helper.getMethod("read", InputStream.class);
            CDRInputStream in = new CDRInputStream(null, data);
            in.openEncapsulatedArray();
            return readMethod.invoke(null, in);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Helper " + helper.getName() + " has no appropriate read() method.");
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Cannot access read() method of helper " + helper.getName());
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Exception while reading component data: " + ex.getTargetException());
        }
    }
}

