/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dns;

import java.net.InetAddress;
import org.jacorb.orb.dns.DNSLookupDelegate;
import org.jacorb.util.Debug;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;

public class XbillDelegateImpl
implements DNSLookupDelegate {
    private String _inverseLookup(String addr) {
        try {
            Record[] r = dns.getRecords((String)addr, (short)12);
            if (r != null) {
                for (int i = 0; i < r.length; ++i) {
                    PTRRecord ptr_r;
                    if (!(r[i] instanceof PTRRecord) || (ptr_r = (PTRRecord)r[i]).getTarget() == null) continue;
                    String name = ptr_r.getTarget().toString();
                    if ((name = name.trim()).endsWith(".")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    Debug.output(2, "Resolved " + addr + " to " + name);
                    return name;
                }
            }
        }
        catch (Exception e) {
            Debug.output(1, e);
        }
        Debug.output(2, "Unable to resolve " + addr + " via DNS");
        return null;
    }

    public String inverseLookup(String ip) {
        return this._inverseLookup(dns.inaddrString((String)ip));
    }

    public String inverseLookup(InetAddress addr) {
        return this._inverseLookup(dns.inaddrString((InetAddress)addr));
    }
}

