/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;

public class PortRangeSocketFactory
extends PortRangeFactory
implements SocketFactory {
    public static final String MIN_PROP = "jacorb.net.socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.socket_factory.port.max";

    public PortRangeSocketFactory() {
        super(MIN_PROP, MAX_PROP);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                Socket socket = new Socket(host, port, localHost, localPort);
                Debug.output(2, "PortRangeSocketFactory: Created socket between " + localHost.getHostAddress() + ":" + localPort + " and " + host + ":" + port);
                return socket;
            }
            catch (IOException ex) {
                continue;
            }
        }
        Debug.output(2, "Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + host + ":" + port);
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    public boolean isSSL(Socket socket) {
        return false;
    }
}

