/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.portableInterceptor.DefaultServerInterceptor;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class BiDirConnectionServerInterceptor
extends DefaultServerInterceptor {
    private final String name = "BiDirConnectionServerInterceptor";
    private final ORB orb;
    private ClientConnectionManager conn_mg = null;

    public BiDirConnectionServerInterceptor(ORB orb, Codec codec) {
        this.orb = orb;
        this.conn_mg = orb.getClientConnectionManager();
    }

    public String name() {
        return "BiDirConnectionServerInterceptor";
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        if (this.orb.useBiDirGIOP()) {
            ServiceContext ctx = null;
            try {
                ctx = ri.get_request_service_context(5);
            }
            catch (BAD_PARAM bp) {
                // empty catch block
            }
            if (ctx == null) {
                return;
            }
            BiDirIIOPServiceContext bidir_ctx = null;
            CDRInputStream cdr_in = new CDRInputStream(this.orb, ctx.context_data);
            cdr_in.openEncapsulatedArray();
            bidir_ctx = BiDirIIOPServiceContextHelper.read(cdr_in);
            GIOPConnection connection = ((ServerRequestInfoImpl)ri).request.getConnection();
            for (int i = 0; i < bidir_ctx.listen_points.length; ++i) {
                ListenPoint p = bidir_ctx.listen_points[i];
                IIOPAddress addr = new IIOPAddress(p.host, p.port);
                Debug.output(2, "BiDirServerInterceptor: Added client conn to target " + addr);
                this.conn_mg.addConnection(connection, new IIOPProfile(addr, null));
            }
        }
    }
}

