/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORBConstants;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.SelectionStrategy;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class GIOPConnectionManager {
    private List server_giop_connections;
    private int max_server_giop_connections;
    private Class statistics_provider_class;
    private SelectionStrategy selection_strategy;
    private int wait_for_idle_interval;
    private final Logger logger;
    private ContextKey[] serviceContextKeyCache;
    private int svcId;

    public GIOPConnectionManager() {
        block3: {
            String s;
            this.server_giop_connections = null;
            this.max_server_giop_connections = 0;
            this.statistics_provider_class = null;
            this.selection_strategy = null;
            this.wait_for_idle_interval = 0;
            this.logger = Debug.getNamedLogger("jacorb.giop.conn");
            this.server_giop_connections = new LinkedList();
            this.max_server_giop_connections = Environment.getIntPropertyWithDefault("jacorb.connection.max_server_connections", Integer.MAX_VALUE);
            this.selection_strategy = (SelectionStrategy)Environment.getObjectProperty("jacorb.connection.selection_strategy_class");
            this.wait_for_idle_interval = Environment.getIntPropertyWithDefault("jacorb.connection.wait_for_idle_interval", 500);
            if (Environment.hasProperty("jacorb.connection.statistics_provider_class") && (s = Environment.getProperty("jacorb.connection.statistics_provider_class")) != null && s.length() > 0) {
                try {
                    this.statistics_provider_class = Environment.classForName(s);
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create class from property >jacorb.connection.statistics_provider_class<: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerGIOPConnection createServerGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener) {
        List list;
        if (this.server_giop_connections.size() >= this.max_server_giop_connections) {
            if (this.selection_strategy != null) {
                while (this.server_giop_connections.size() >= this.max_server_giop_connections) {
                    ServerGIOPConnection to_close = null;
                    list = this.server_giop_connections;
                    synchronized (list) {
                        to_close = this.selection_strategy.selectForClose(this.server_giop_connections);
                    }
                    if (to_close == null || !to_close.tryClose()) {
                        try {
                            Thread.sleep(this.wait_for_idle_interval);
                        }
                        catch (Exception e) {
                            Debug.output(1, e);
                        }
                        continue;
                    }
                    break;
                }
            } else if (this.logger.isErrorEnabled()) {
                this.logger.error("No. of max server giop connections set, but no SelectionStrategy present");
            }
        }
        ServerGIOPConnection connection = new ServerGIOPConnection(profile, transport, request_listener, reply_listener, this.getStatisticsProvider(), this);
        list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.add(connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServerGIOPConnection(ServerGIOPConnection connection) {
        List list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.remove(connection);
        }
    }

    public GIOPConnection createClientGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener) {
        return new ClientGIOPConnection(profile, transport, request_listener, reply_listener, null);
    }

    private StatisticsProvider getStatisticsProvider() {
        StatisticsProvider result;
        block3: {
            result = null;
            if (this.statistics_provider_class != null) {
                try {
                    result = (StatisticsProvider)this.statistics_provider_class.newInstance();
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create instance from Class " + this.statistics_provider_class);
                }
            }
        }
        return result;
    }

    byte[] addContextKey(byte[] object_key, byte[] oid, List scopes) {
        byte[] result = new byte[7];
        System.arraycopy(ORBConstants.JAC_TAG, 0, result, 0, 3);
        if (this.serviceContextKeyCache == null) {
            this.serviceContextKeyCache = new ContextKey[1000];
        } else if (this.svcId >= this.serviceContextKeyCache.length) {
            this.resizeCtxCache();
        } else if (this.serviceContextKeyCache[this.svcId] != null) {
            while (this.svcId < this.serviceContextKeyCache.length && this.serviceContextKeyCache[this.svcId] != null) {
                ++this.svcId;
            }
            if (this.svcId >= this.serviceContextKeyCache.length) {
                this.resizeCtxCache();
            }
        }
        result[3] = (byte)(this.svcId >> 24 & 0xFF);
        result[4] = (byte)(this.svcId >> 16 & 0xFF);
        result[5] = (byte)(this.svcId >> 8 & 0xFF);
        result[6] = (byte)(this.svcId & 0xFF);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Adding context at index " + this.svcId + " with scopes content " + scopes + " for key " + CorbaLoc.parseKey(object_key));
        }
        this.serviceContextKeyCache[this.svcId] = new ContextKey(object_key, oid, scopes);
        return result;
    }

    private void resizeCtxCache() {
        ContextKey[] temp = new ContextKey[this.serviceContextKeyCache.length * 2];
        System.arraycopy(this.serviceContextKeyCache, 0, temp, 0, this.serviceContextKeyCache.length);
        this.serviceContextKeyCache = temp;
    }

    void removeContextKey(int index) {
        if (this.serviceContextKeyCache[index] != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing context at index " + index + " with scopes content " + this.serviceContextKeyCache[index].getScopes() + " and svcId " + this.svcId);
            }
            this.serviceContextKeyCache[index] = null;
        } else {
            this.logger.warn("ContextKey element was already null for index " + index);
        }
        this.svcId = 0;
    }

    ContextKey getContextKey(byte[] key) {
        ContextKey result = null;
        if (this.serviceContextKeyCache != null && key != null && key.length == 7 && key[0] == 74 && key[1] == 65 && key[2] == 67) {
            int index = ((key[3] & 0xFF) << 24) + ((key[4] & 0xFF) << 16) + ((key[5] & 0xFF) << 8) + ((key[6] & 0xFF) << 0);
            try {
                result = this.serviceContextKeyCache[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new INTERNAL("Cache out of bounds - unable to retrieve cached key entry for " + index);
            }
            if (result == null) {
                throw new INTERNAL("Unable to retrieve cached key entry for " + index);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextKey returning scopes" + (result == null ? "<null>" : result.scopes.toString()) + " and key " + (result == null ? "<null>" : CorbaLoc.parseKey(result.getKey())));
        }
        return result;
    }

    public int getSvcID() {
        return this.svcId;
    }

    public static final class ContextKey {
        private final List scopes;
        private final byte[] key;
        private final byte[] oid;

        public ContextKey(byte[] _key, byte[] _oid, List _scopes) {
            this.key = _key;
            this.scopes = _scopes;
            this.oid = _oid;
        }

        public List getScopes() {
            return this.scopes;
        }

        public byte[] getOID() {
            return this.oid;
        }

        public byte[] getKey() {
            return this.key;
        }
    }
}

