/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class ClientIIOPConnection
extends IIOPConnection {
    private IIOPProfile target_profile;
    private boolean use_ssl = false;
    private int ssl_port = -1;
    private final Logger logger = Debug.getNamedLogger("jacorb.iiop.conn");
    private static int openTransports = 0;
    private Exception exception = null;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_HOST_MSG = "Unable to resolve local host - using default 127.0.0.1";

    public synchronized void connect(Profile server_profile, long time_out) {
        if (!this.connected) {
            if (!(server_profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + server_profile.getClass());
            }
            this.target_profile = (IIOPProfile)server_profile;
            this.checkSSL();
            int retries = Environment.noOfRetries();
            while (retries >= 0) {
                try {
                    this.createSocket(time_out);
                    this.socket.setTcpNoDelay(true);
                    if (Environment.getClientIdleTimeout() != 0) {
                        this.socket.setSoTimeout(Environment.getClientIdleTimeout());
                    }
                    this.socket.setKeepAlive(Environment.getClientKeepAlive());
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : ""));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException c) {
                    if (--retries < 0) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying to connect to " + this.connection_info);
                    }
                    try {
                        Thread.sleep(Environment.retryInterval());
                    }
                    catch (InterruptedException i) {}
                }
                catch (TIMEOUT e) {
                    this.target_profile = null;
                    this.use_ssl = false;
                    this.ssl_port = -1;
                    throw e;
                }
            }
            if (retries < 0) {
                this.target_profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createSocket(long time_out) throws IOException {
        ArrayList<IIOPAddress> addressList = new ArrayList<IIOPAddress>();
        addressList.add(this.target_profile.getAddress());
        addressList.addAll(this.target_profile.getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        this.exception = null;
        this.socket = null;
        while (this.socket == null && addressIterator.hasNext()) {
            String localhost;
            block29: {
                IIOPAddress address = (IIOPAddress)addressIterator.next();
                final SocketFactory factory = this.use_ssl ? this.getSSLSocketFactory() : this.getSocketFactory();
                final String ipAddress = address.getIP();
                final int port = this.use_ssl ? this.ssl_port : address.getPort();
                this.connection_info = ipAddress + ":" + port;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to connect to " + this.connection_info + " with timeout=" + time_out + (this.use_ssl ? " using SSL." : ""));
                }
                this.exception = null;
                this.socket = null;
                if (time_out > 0L) {
                    final ClientIIOPConnection self = this;
                    Thread thread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            ClientIIOPConnection clientIIOPConnection;
                            try {
                                try {
                                    ClientIIOPConnection.this.socket = factory.createSocket(ipAddress, port);
                                }
                                catch (Exception e) {
                                    ClientIIOPConnection.this.exception = e;
                                    Object var3_2 = null;
                                    ClientIIOPConnection clientIIOPConnection3 = self;
                                    synchronized (clientIIOPConnection3) {
                                        self.notifyAll();
                                        return;
                                    }
                                }
                                Object var3_1 = null;
                                clientIIOPConnection = self;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                ClientIIOPConnection clientIIOPConnection2 = self;
                                synchronized (clientIIOPConnection2) {
                                    self.notifyAll();
                                    throw throwable;
                                }
                            }
                            synchronized (clientIIOPConnection) {
                                self.notifyAll();
                                return;
                            }
                        }
                    }, "SocketConnectorThread");
                    thread.setDaemon(true);
                    try {
                        ClientIIOPConnection clientIIOPConnection = self;
                        synchronized (clientIIOPConnection) {
                            thread.start();
                            self.wait(time_out);
                        }
                    }
                    catch (InterruptedException _ex) {
                        // empty catch block
                    }
                    if (this.socket == null) {
                        if (this.exception == null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("connect to " + this.connection_info + " with timeout=" + time_out + " timed out");
                            }
                            thread.interrupt();
                            this.exception = new TIMEOUT("connection timeout of " + time_out + " milliseconds expired");
                        } else if (this.logger.isDebugEnabled()) {
                            this.logger.debug("connect to " + this.connection_info + " with timeout=" + time_out + " raised exception: " + this.exception.toString());
                        }
                    }
                    break block29;
                }
                this.socket = factory.createSocket(ipAddress, port);
            }
            Object var14_13 = null;
            if (this.socket == null || SocketFactoryManager.getTCPListener() == null) continue;
            try {
                this.socket.getInetAddress();
                localhost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(DEFAULT_HOST_MSG);
                }
                localhost = DEFAULT_HOST;
            }
            SocketFactoryManager.getTCPListener().connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
            {
                continue;
                catch (Exception e) {
                    this.exception = e;
                    var14_13 = null;
                    if (this.socket == null || SocketFactoryManager.getTCPListener() == null) continue;
                    try {
                        this.socket.getInetAddress();
                        localhost = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(DEFAULT_HOST_MSG);
                        }
                        localhost = DEFAULT_HOST;
                    }
                    SocketFactoryManager.getTCPListener().connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_13 = null;
                if (this.socket != null && SocketFactoryManager.getTCPListener() != null) {
                    try {
                        this.socket.getInetAddress();
                        localhost = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(DEFAULT_HOST_MSG);
                        }
                        localhost = DEFAULT_HOST;
                    }
                    SocketFactoryManager.getTCPListener().connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
                }
                throw throwable;
            }
        }
        if (this.exception != null) {
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof TIMEOUT) {
                throw (TIMEOUT)this.exception;
            }
            throw new IOException("Unexpected exception occured: " + this.exception.toString());
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void close() {
        block16: {
            String localhost;
            if (this.connected && this.socket != null) {
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
                --openTransports;
            }
            this.connected = false;
            Object var3_1 = null;
            if (this.socket == null || SocketFactoryManager.getTCPListener() == null) break block16;
            try {
                this.socket.getLocalAddress();
                localhost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(DEFAULT_HOST_MSG);
                }
                localhost = DEFAULT_HOST;
            }
            SocketFactoryManager.getTCPListener().connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
            {
                break block16;
                catch (IOException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exception when closing the socket", ex);
                    }
                    throw this.to_COMM_FAILURE(ex);
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (this.socket != null && SocketFactoryManager.getTCPListener() != null) {
                    try {
                        this.socket.getLocalAddress();
                        localhost = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(DEFAULT_HOST_MSG);
                        }
                        localhost = DEFAULT_HOST;
                    }
                    SocketFactoryManager.getTCPListener().connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
                }
                throw throwable;
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
        }
    }

    public boolean isSSL() {
        return this.use_ssl;
    }

    public Profile get_server_profile() {
        return this.target_profile;
    }

    private void checkSSL() {
        if (this.target_profile.getSSL() == null) {
            return;
        }
        CompoundSecMechList sas = (CompoundSecMechList)this.target_profile.getComponent(33, CompoundSecMechListHelper.class);
        TLS_SEC_TRANS tls = null;
        if (sas != null && sas.mechanism_list[0].transport_mech.tag == 36) {
            try {
                byte[] tagData = sas.mechanism_list[0].transport_mech.component_data;
                CDRInputStream in = new CDRInputStream(null, tagData);
                in.openEncapsulatedArray();
                tls = TLS_SEC_TRANSHelper.read(in);
            }
            catch (Exception ex) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + ex);
            }
        }
        SSL ssl = (SSL)this.target_profile.getComponent(20, SSLHelper.class);
        int minimum_options = 126;
        int client_required = 0;
        int client_supported = 0;
        if (Environment.getSupportSSL()) {
            client_required = Environment.getIntProperty("jacorb.security.ssl.client.required_options", 16);
            client_supported = Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16);
        }
        if (tls != null && (tls.target_supports & minimum_options) != 0 && Environment.getSupportSSL() && (client_supported & minimum_options) != 0 && ((tls.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            this.use_ssl = true;
            this.ssl_port = tls.addresses[0].port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
        } else if (ssl != null && (ssl.target_supports & minimum_options) != 0 && Environment.getSupportSSL() && (client_supported & minimum_options) != 0 && ((ssl.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            this.use_ssl = true;
            this.ssl_port = ssl.port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
        } else {
            if (Environment.getSupportSSL() && (client_required & minimum_options) != 0) {
                throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
            }
            this.use_ssl = false;
            this.ssl_port = -1;
        }
    }

    private SocketFactory getSocketFactory() {
        return SocketFactoryManager.getSocketFactory();
    }

    private SocketFactory getSSLSocketFactory() {
        return SocketFactoryManager.getSSLSocketFactory();
    }
}

