/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.util.EventObject;
import javax.security.cert.X509Certificate;

public class SSLSessionEvent
extends EventObject {
    private final String remoteIP;
    private final int remotePort;
    private final int localPort;
    private final String localIP;
    private String remoteDN = null;
    private final X509Certificate[] peerCerts;

    public SSLSessionEvent(Object source, String remoteIP, int remotePort, X509Certificate[] peerCerts, int localPort, String localIP) {
        super(source);
        this.remoteIP = remoteIP;
        this.remotePort = remotePort;
        this.peerCerts = peerCerts;
        this.localPort = localPort;
        this.localIP = localIP;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteDN() {
        if (this.remoteDN == null && this.peerCerts != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.peerCerts.length; ++i) {
                sb.append(this.peerCerts[i].toString());
                sb.append("\n\n");
            }
            this.remoteDN = sb.toString();
        }
        if (this.remoteDN == null || this.remoteDN.length() == 0) {
            this.remoteDN = "[Unable to verify peer certificates]";
        }
        return this.remoteDN;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public X509Certificate[] getPeerCertificateChain() {
        return this.peerCerts;
    }

    public String toString() {
        return super.toString() + " with local port " + this.localPort + " and local IP " + this.localIP + " and remote port " + this.remotePort + " and remote IP " + this.remoteIP + " and certificates " + this.getRemoteDN();
    }
}

