/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.naming;

import org.jacorb.orb.naming.Iiop;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class INSUtil {
    public static NameComponent[] insToComponent(String n) throws InvalidName {
        NameComponent[] components = null;
        StringBuffer str = new StringBuffer("");
        components = Iiop.getComponents(n);
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                components[i].id = INSUtil.unescapeString(components[i].id);
                components[i].kind = INSUtil.unescapeString(components[i].kind);
            }
        } else {
            throw new InvalidName();
        }
        return components;
    }

    public static String componentToIns(NameComponent[] n) throws InvalidName {
        StringBuffer str = new StringBuffer();
        if (n != null && n.length != 0) {
            for (int i = 0; i < n.length; ++i) {
                str.append(INSUtil.convertCOStoString(n[i]));
                if (i >= n.length - 1) continue;
                str.append('/');
            }
        } else {
            throw new InvalidName();
        }
        return str.toString();
    }

    public static NameComponent convertStringToCOS(String component) {
        NameComponent result = new NameComponent();
        StringBuffer id = new StringBuffer("");
        StringBuffer kind = new StringBuffer("");
        boolean first = true;
        char previous = '\u0000';
        for (int i = 0; i < component.length(); ++i) {
            char current = component.charAt(i);
            if (current == '.' && previous != '\\') {
                first = false;
            } else if (current != '\\' || current == '\\' && previous == '\\') {
                if (first) {
                    id.append(current);
                } else {
                    kind.append(current);
                }
            }
            previous = previous == current ? (char)'\u0000' : current;
        }
        result.id = id.toString();
        result.kind = kind.toString();
        return result;
    }

    public static String convertCOStoString(NameComponent n) {
        char[] v;
        int counter = 0;
        int idlength = n.id.length();
        int kindlength = n.kind.length();
        if (idlength == 0 && kindlength == 0) {
            v = new char[1];
            v[counter++] = 46;
        } else {
            char current;
            int z;
            v = new char[(idlength + kindlength) * 3];
            if (idlength == 0) {
                v[counter++] = 46;
            } else {
                for (z = 0; z < idlength; ++z) {
                    current = n.id.charAt(z);
                    switch (current) {
                        case '.': 
                        case '/': 
                        case '\\': {
                            v[counter++] = 92;
                        }
                    }
                    v[counter++] = current;
                }
            }
            if (kindlength != 0) {
                if (idlength != 0) {
                    v[counter++] = 46;
                }
                for (z = 0; z < kindlength; ++z) {
                    current = n.kind.charAt(z);
                    switch (current) {
                        case '.': 
                        case '/': 
                        case '\\': {
                            v[counter++] = 92;
                        }
                    }
                    v[counter++] = current;
                }
            }
        }
        return new String(v, 0, counter);
    }

    private static String byteToHex(byte b) {
        StringBuffer result = new StringBuffer();
        result.append(Character.forDigit(b >> 4 & 0xF, 16));
        result.append(Character.forDigit(b & 0xF, 16));
        return result.toString();
    }

    public static String encode(String name) {
        StringBuffer result = new StringBuffer();
        char[] chrs = name.toCharArray();
        for (int i = 0; i < chrs.length; ++i) {
            if (!INSUtil.isLetterOrDigit(chrs[i])) {
                switch (chrs[i]) {
                    case '!': 
                    case '$': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '=': 
                    case '?': 
                    case '@': 
                    case '_': 
                    case '~': {
                        result.append(chrs[i]);
                        break;
                    }
                    default: {
                        result.append('%');
                        result.append(INSUtil.byteToHex((byte)chrs[i]));
                        break;
                    }
                }
                continue;
            }
            result.append(chrs[i]);
        }
        return result.toString();
    }

    private static boolean isLetterOrDigit(char c) {
        boolean result = false;
        if (c >= '0') {
            if (c <= '9') {
                result = true;
            } else if (c >= 'A') {
                if (c <= 'Z') {
                    result = true;
                }
                if (c >= 'a' && c <= 'z') {
                    result = true;
                }
            }
        }
        return result;
    }

    private static String unescapeString(String source) {
        StringBuffer str = new StringBuffer("");
        boolean skip = true;
        for (int z = 0; z < source.length(); ++z) {
            char currchar = source.charAt(z);
            if (currchar == '\\' && skip) {
                skip = false;
                continue;
            }
            str.append(currchar);
            skip = true;
        }
        return str.toString();
    }
}

