/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.orb.ORB;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAManagerMonitor;
import org.jacorb.poa.POAManagerMonitorLightImpl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INTERNAL;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer._POAManagerLocalBase;

public class POAManager
extends _POAManagerLocalBase {
    public State state = State.HOLDING;
    private ORB orb;
    private Vector poas = new Vector();
    private POAManagerMonitor monitor;
    protected boolean poaCreationFailed;

    protected POAManager(ORB _orb) {
        this.orb = _orb;
        this.monitor = new POAManagerMonitorLightImpl();
        this.monitor.init(this);
        this.monitor.openMonitor();
        this.monitor.printMessage("ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws AdapterInactive {
        this.checkCreation();
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 1: {
                break;
            }
            default: {
                Object[] poaArray;
                this.state = State.ACTIVE;
                this.monitor.setToActive();
                POAManager pOAManager = this;
                synchronized (pOAManager) {
                    poaArray = new POA[this.poas.size()];
                    this.poas.copyInto(poaArray);
                }
                Thread thread = new Thread(new Runnable((POA[])poaArray){
                    private final /* synthetic */ POA[] val$poaArray;
                    {
                        this.val$poaArray = val$poaArray;
                    }

                    public void run() {
                        for (int i = 0; i < this.val$poaArray.length; ++i) {
                            try {
                                this.val$poaArray[i].changeToActive();
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }, "POAChangeToActive");
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean etherealize_objects, boolean wait_for_completion) throws AdapterInactive {
        Object[] poaArray;
        this.checkCreation();
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
        }
        this.state = State.INACTIVE;
        this.monitor.setToInactive(wait_for_completion, etherealize_objects);
        boolean etherealize = etherealize_objects;
        POAManager pOAManager = this;
        synchronized (pOAManager) {
            poaArray = new POA[this.poas.size()];
            this.poas.copyInto(poaArray);
        }
        Thread thread = new Thread(new Runnable((POA[])poaArray, etherealize){
            private final /* synthetic */ POA[] val$poaArray;
            private final /* synthetic */ boolean val$etherealize;
            {
                this.val$poaArray = val$poaArray;
                this.val$etherealize = val$etherealize;
            }

            public void run() {
                for (int i = this.val$poaArray.length - 1; i >= 0; --i) {
                    try {
                        this.val$poaArray[i].changeToInactive(this.val$etherealize);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, "POAChangeToInactive");
        thread.start();
        if (wait_for_completion) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard_requests(boolean wait_for_completion) throws AdapterInactive {
        this.checkCreation();
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 2: {
                break;
            }
            default: {
                Object[] poaArray;
                this.state = State.DISCARDING;
                this.monitor.setToDiscarding(wait_for_completion);
                POAManager pOAManager = this;
                synchronized (pOAManager) {
                    poaArray = new POA[this.poas.size()];
                    this.poas.copyInto(poaArray);
                }
                Thread thread = new Thread(new Runnable((POA[])poaArray){
                    private final /* synthetic */ POA[] val$poaArray;
                    {
                        this.val$poaArray = val$poaArray;
                    }

                    public void run() {
                        for (int i = this.val$poaArray.length - 1; i >= 0; --i) {
                            try {
                                this.val$poaArray[i].changeToDiscarding();
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }, "POAChangeToDiscarding");
                thread.start();
                if (!wait_for_completion) break;
                try {
                    thread.join();
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public State get_state() {
        return this.state;
    }

    protected synchronized POA getRegisteredPOA(String name) {
        Enumeration en = this.poas.elements();
        while (en.hasMoreElements()) {
            POA result = (POA)en.nextElement();
            if (!name.equals(result._getQualifiedName())) continue;
            return result;
        }
        throw new INTERNAL("POA not registered: RootPOA/" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold_requests(boolean wait_for_completion) throws AdapterInactive {
        this.checkCreation();
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 0: {
                break;
            }
            default: {
                Object[] poaArray;
                this.state = State.HOLDING;
                this.monitor.setToHolding(wait_for_completion);
                POAManager pOAManager = this;
                synchronized (pOAManager) {
                    poaArray = new POA[this.poas.size()];
                    this.poas.copyInto(poaArray);
                }
                Thread thread = new Thread(new Runnable((POA[])poaArray){
                    private final /* synthetic */ POA[] val$poaArray;
                    {
                        this.val$poaArray = val$poaArray;
                    }

                    public void run() {
                        for (int i = this.val$poaArray.length - 1; i >= 0; --i) {
                            try {
                                this.val$poaArray[i].changeToHolding();
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }, "POAChangeToHolding");
                thread.start();
                if (!wait_for_completion) break;
                try {
                    thread.join();
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    protected synchronized void registerPOA(POA poa) {
        if (!this.poas.contains(poa)) {
            this.poas.addElement(poa);
            this.monitor.addPOA(poa._getQualifiedName());
        }
    }

    protected void setMonitor(POAManagerMonitor _monitor) {
        this.monitor = _monitor;
    }

    protected synchronized void unregisterPOA(POA poa) {
        this.poas.removeElement(poa);
        this.monitor.removePOA(poa._getQualifiedName());
    }

    private void checkCreation() {
        if (this.poaCreationFailed) {
            throw new INTERNAL("POA Creation failed; unable to deactive");
        }
    }
}

