/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.util.StringPair;
import org.jacorb.util.Environment;

public class RequestQueue {
    private RequestQueueListener queueListener;
    private RequestController controller;
    private Logger logger;
    private List queue = new ArrayList(10);

    private RequestQueue() {
    }

    protected RequestQueue(RequestController controller, Logger logger) {
        this.controller = controller;
        this.logger = logger;
    }

    protected synchronized void add(ServerRequest request) throws ResourceLimitReachedException {
        if (this.queue.size() >= Environment.queueMax()) {
            if (Environment.queueWait()) {
                while (this.queue.size() > Environment.queueMin()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                throw new ResourceLimitReachedException();
            }
        }
        this.queue.add(request);
        if (this.queue.size() == 1) {
            this.controller.continueToWork();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + request.requestId() + " opname: " + request.operation() + " is queued (queue size: " + this.queue.size() + ")");
        }
        if (this.queueListener != null) {
            this.queueListener.requestAddedToQueue(request, this.queue.size());
        }
    }

    protected synchronized void addRequestQueueListener(RequestQueueListener listener) {
        this.queueListener = EventMulticaster.add(this.queueListener, listener);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] result = new StringPair[this.queue.size()];
        Iterator en = this.queue.iterator();
        for (int i = 0; i < result.length; ++i) {
            ServerRequest sr = (ServerRequest)en.next();
            result[i] = new StringPair(sr.requestId() + "", new String(sr.objectId()));
        }
        return result;
    }

    protected synchronized ServerRequest getElementAndRemove(int rid) {
        if (!this.queue.isEmpty()) {
            Iterator en = this.queue.iterator();
            while (en.hasNext()) {
                ServerRequest result = (ServerRequest)en.next();
                if (result.requestId() != rid) continue;
                en.remove();
                this.notifyAll();
                if (this.queueListener != null) {
                    this.queueListener.requestRemovedFromQueue(result, this.queue.size());
                }
                return result;
            }
        }
        return null;
    }

    protected synchronized ServerRequest getFirst() {
        if (!this.queue.isEmpty()) {
            return (ServerRequest)this.queue.get(0);
        }
        return null;
    }

    protected boolean isEmpty() {
        return this.queue.isEmpty();
    }

    protected synchronized ServerRequest removeFirst() {
        if (!this.queue.isEmpty()) {
            ServerRequest result = (ServerRequest)this.queue.remove(0);
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(result, this.queue.size());
            }
            return result;
        }
        return null;
    }

    protected synchronized ServerRequest removeLast() {
        try {
            ServerRequest result = (ServerRequest)this.queue.remove(this.queue.size() - 1);
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(result, this.queue.size());
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected synchronized void removeRequestQueueListener(RequestQueueListener listener) {
        this.queueListener = EventMulticaster.remove(this.queueListener, listener);
    }
}

