/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.authentication;

import com.noelios.restlet.Engine;
import com.noelios.restlet.authentication.AuthenticationHelper;
import com.noelios.restlet.util.Base64;
import com.noelios.restlet.util.SecurityUtils;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.util.DateUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAmazonS3Helper
extends AuthenticationHelper {
    private static String getCanonicalizedAmzHeaders(Series<Parameter> requestHeaders) {
        TreeMap<String, String> amzHeaders = new TreeMap<String, String>();
        for (Parameter param : requestHeaders) {
            String headerName = param.getName().toLowerCase();
            if (!headerName.startsWith("x-amz-") || amzHeaders.containsKey(headerName)) continue;
            amzHeaders.put(headerName, requestHeaders.getValues(headerName));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : amzHeaders.entrySet()) {
            sb.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private static String getCanonicalizedResourceName(Reference resourceRef) {
        StringBuilder sb = new StringBuilder();
        sb.append(resourceRef.getPath());
        Form query = resourceRef.getQueryAsForm();
        if (query.getFirst("acl", true) != null) {
            sb.append("?acl");
        } else if (query.getFirst("torrent", true) != null) {
            sb.append("?torrent");
        }
        return sb.toString();
    }

    public HttpAmazonS3Helper() {
        super(ChallengeScheme.HTTP_AWS_S3, true, false);
    }

    @Override
    public String format(ChallengeRequest request) {
        return null;
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        String contentType;
        String contentMd5;
        String methodName = request.getMethod().getName();
        String date = "";
        if (httpHeaders.getFirstValue("X-Amz-Date", true) == null && (date = httpHeaders.getFirstValue("Date", true)) == null) {
            date = DateUtils.format(new Date(), DateUtils.FORMAT_RFC_1123.get(0));
            httpHeaders.add("Date", date);
        }
        if ((contentMd5 = httpHeaders.getFirstValue("Content-MD5", true)) == null) {
            contentMd5 = "";
        }
        if ((contentType = httpHeaders.getFirstValue("Content-Type", true)) == null) {
            boolean applyPatch = false;
            String jvmVendor = System.getProperty("java.vm.vendor");
            if (jvmVendor != null && jvmVendor.toLowerCase().startsWith("sun")) {
                int majorVersionNumber = Engine.getJavaMajorVersion();
                int minorVersionNumber = Engine.getJavaMinorVersion();
                if (majorVersionNumber == 1) {
                    if (minorVersionNumber < 5) {
                        applyPatch = true;
                    } else if (minorVersionNumber == 5) {
                        applyPatch = Engine.getJavaUpdateVersion() < 10;
                    }
                }
            }
            contentType = applyPatch && !request.getMethod().equals(Method.PUT) ? "application/x-www-form-urlencoded" : "";
        }
        String canonicalizedAmzHeaders = HttpAmazonS3Helper.getCanonicalizedAmzHeaders(httpHeaders);
        String canonicalizedResource = HttpAmazonS3Helper.getCanonicalizedResourceName(request.getResourceRef());
        StringBuilder rest = new StringBuilder();
        rest.append(methodName).append('\n').append(contentMd5).append('\n').append(contentType).append('\n').append(date).append('\n').append(canonicalizedAmzHeaders).append(canonicalizedResource);
        sb.append(challenge.getIdentifier()).append(':').append(Base64.encode(SecurityUtils.toHMac(rest.toString(), new String(challenge.getSecret())), false));
    }
}

