/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.PreferenceReader;
import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;

public class ContentType {
    private volatile MediaType mediaType;
    private volatile CharacterSet characterSet;

    public static MediaType parseContentType(String headerValue) throws IOException {
        PreferenceReader pr = new PreferenceReader(4, headerValue);
        Preference pref = pr.readPreference();
        return (MediaType)pref.getMetadata();
    }

    public ContentType(String headerValue) {
        try {
            this.mediaType = ContentType.parseContentType(headerValue);
            String charSet = this.mediaType.getParameters().getFirstValue("charset");
            if (charSet != null) {
                this.mediaType.getParameters().removeAll("charset");
                this.characterSet = new CharacterSet(charSet);
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("The Content Type could not be read.", ioe);
        }
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }
}

