/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.view.DBPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DialogHelper {
    private JFrame parent;
    public static JButton OK = null;
    public static JButton CANCEL = null;
    private String title;
    private boolean text;
    private Logger logger;
    public static final String FedWebSchemeMsg = "Your server federation uses HTTPS .\nIt is a requirement for servers in the same federation to use the same protocol.";

    public DialogHelper(JFrame parent, boolean text, Logger logger) {
        this.parent = parent;
        this.text = text;
        this.logger = logger;
        if (!text) {
            OK = new JButton("OK");
            CANCEL = new JButton("Cancel");
        }
    }

    public void beepAndDisplayParent() {
        this.parent.pack();
        this.parent.validate();
        this.parent.setVisible(true);
        Toolkit.getDefaultToolkit().beep();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean doUpgrade(String title) {
        this.beepAndDisplayParent();
        int rc = JOptionPane.showConfirmDialog(this.parent, title + " is already installed. Do you want to upgrade it?", title, 0, 3);
        return rc == 0;
    }

    public boolean doReinstall(String title) {
        String message = "<html><body>" + title + " is already installed. Do you want to reinstall it?<br>" + "<font color=ff0000><b>You will lose existing data.</b></font></body></html>";
        this.logger.info((Object)message);
        if (this.text) {
            return false;
        }
        this.beepAndDisplayParent();
        int rc = JOptionPane.showConfirmDialog(this.parent, message, title, 0, 3);
        return rc == 0;
    }

    public void showNoDowngrade() {
        String msg = this.title + " does not support downgrading.";
        this.logger.info((Object)msg);
        if (this.text) {
            return;
        }
        this.beepAndDisplayParent();
        JOptionPane.showMessageDialog(this.parent, msg, this.title, 0);
    }

    public void showFailure(String message) {
        this.logger.fatal((Object)message);
        if (this.text) {
            return;
        }
        this.beepAndDisplayParent();
        JOptionPane.showMessageDialog(this.parent, this.title + " has encountered a problem and must quit.\n" + "For further assistance, please contact customer support.\n" + "Cause: " + message, this.title, 0);
    }

    public void showWarning(String message) {
        this.logger.warn((Object)message);
        if (this.text) {
            return;
        }
        this.beepAndDisplayParent();
        JOptionPane.showMessageDialog(this.parent, message, this.title, 2);
    }

    public void showError(String message) {
        this.logger.error((Object)message);
        if (this.text) {
            return;
        }
        this.beepAndDisplayParent();
        JOptionPane.showMessageDialog(this.parent, message, this.title, 0);
    }

    public void showMessage(String message) {
        this.logger.info((Object)message);
        if (this.text) {
            return;
        }
        this.beepAndDisplayParent();
        JOptionPane.showMessageDialog(this.parent, message, this.title, 1);
    }

    public boolean ask(String message) {
        this.logger.info((Object)message);
        if (this.text) {
            String answer;
            Scanner in = new Scanner(System.in);
            do {
                System.out.print(message + " [Y/N]");
                answer = in.nextLine();
                if (!answer.trim().equalsIgnoreCase("n")) continue;
                return false;
            } while (!answer.trim().equalsIgnoreCase("y"));
            return true;
        }
        this.beepAndDisplayParent();
        return JOptionPane.showConfirmDialog(this.parent, message, this.title, 0) == 0;
    }

    public boolean showDialog(String title, String message, JComponent[] objects, JButton[] buttons) {
        JDialog loginDialog = new JDialog(this.parent, title, true);
        DialogActionListener listener = new DialogActionListener(loginDialog);
        loginDialog.setLocationRelativeTo(this.parent);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 2));
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setMinimumSize(new Dimension(70, buttons[i].getPreferredSize().height));
            buttons[i].setMaximumSize(new Dimension(70, buttons[i].getPreferredSize().height));
            buttons[i].setPreferredSize(new Dimension(70, buttons[i].getPreferredSize().height));
            buttons[i].addActionListener(listener);
            btnPanel.add(buttons[i]);
            if (i >= buttons.length) continue;
            btnPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        }
        loginDialog.setDefaultCloseOperation(2);
        loginDialog.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        loginDialog.add((Component)new JLabel(message), gbc);
        for (JComponent comp : objects) {
            ++gbc.gridy;
            loginDialog.add((Component)comp, gbc);
        }
        ++gbc.gridy;
        loginDialog.add((Component)btnPanel, gbc);
        loginDialog.pack();
        loginDialog.setVisible(true);
        Toolkit.getDefaultToolkit().beep();
        return listener.isSet();
    }

    public boolean doCancel() {
        if (this.text) {
            return false;
        }
        this.beepAndDisplayParent();
        int rc = JOptionPane.showConfirmDialog(this.parent, "Are you sure you want to quit installation?", this.title, 0, 3);
        return rc == 0;
    }

    public int showNoDbDialog() {
        String msg = "Unable to connect to database, click Yes to continue with the current settings,\n click No to edit the current settings.";
        if (this.text) {
            this.logger.error((Object)"Unable to connect to database.");
            System.exit(1);
        }
        return JOptionPane.showConfirmDialog(this.parent, msg, "Invalid Setting", 0, 2);
    }

    public void showPgInstalled() {
        String msg = "There is already an instance of PostgreSQL installed on your system.\nPlease go back and proceed with the existing database.";
        if (!this.text) {
            JOptionPane.showMessageDialog(this.parent, msg);
            return;
        }
        this.logger.error((Object)msg);
    }

    public void showGoBack() {
        String msg = "Please go back and enter a username and password";
        if (this.text) {
            this.logger.warn((Object)msg);
            System.exit(1);
        }
        JOptionPane.showMessageDialog(this.parent, msg);
    }

    public boolean showStartDB() {
        if (this.text) {
            this.logger.fatal((Object)"PostgreSQL is not running");
            System.exit(1);
        }
        return JOptionPane.showConfirmDialog(this.parent, "PostgreSQL is not running, would you like to start it?", null, 0, 3) == 0;
    }

    public boolean showUnableToVerify(DBPanel GUI, String dbUrl, String dbUser) {
        String msg = "Unable to connect to the database. Please go back and check your settings.\nCannot connect to " + dbUrl + " with " + dbUser + ".";
        if (this.text) {
            this.logger.info((Object)msg);
        }
        this.showError(msg);
        return false;
    }

    public void showVerified() {
        if (this.text) {
            return;
        }
        JOptionPane.showMessageDialog(this.parent, "Database connection verified.", "Database Connection", 1);
    }

    public static String getFedSameWebPortMsg(String webPort) {
        return "Your server federation uses web port " + webPort + ".\n" + "It is a requirement for servers in the same federation to use the same port.";
    }

    public static String getFedSameServerPortMsg(String serverPort) {
        return "Your server federation uses server port " + serverPort + ".\n" + "It is a requirement for servers in the same federation to use the same port.";
    }

    class DialogActionListener
    implements ActionListener {
        private boolean action = false;
        JDialog dialog;

        public DialogActionListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton btn = (JButton)e.getSource();
            char c = btn.getText().charAt(0);
            switch (c) {
                case 'O': 
                case 'V': 
                case 'Y': {
                    this.action = true;
                    break;
                }
            }
            this.dialog.setVisible(false);
        }

        public boolean isSet() {
            return this.action;
        }
    }
}

