/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.ClientInstaller;
import com.cisco.dcbu.install.DCNMInfo;
import com.cisco.dcbu.install.DMInstaller;
import com.cisco.dcbu.install.DialogHelper;
import com.cisco.dcbu.install.Installer;
import com.cisco.dcbu.install.JarLoader;
import com.cisco.dcbu.install.MoveDMFMTask;
import com.cisco.dcbu.install.PortConfigurator;
import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.Shortcut;
import com.cisco.dcbu.install.StreamReader;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.AAA;
import com.cisco.dcbu.install.model.DB;
import com.cisco.dcbu.install.model.DBConnection;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.install.model.TrustTool;
import com.cisco.dcbu.install.view.AAAPanel;
import com.cisco.dcbu.install.view.ConfigPanel;
import com.cisco.dcbu.install.view.ConfirmPanel;
import com.cisco.dcbu.install.view.DBPanel;
import com.cisco.dcbu.install.view.FMDiscoverPanel;
import com.cisco.dcbu.install.view.FinishPanel;
import com.cisco.dcbu.install.view.LicensePanel;
import com.cisco.dcbu.install.view.LocationPanel;
import com.cisco.dcbu.install.view.UserPanel;
import com.cisco.dcbu.install.view.WelcomePanel;
import com.cisco.dcbu.install.view.WizardPanel;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_4_2Encrypter;
import com.sun.net.ssl.internal.ssl.Provider;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarFile;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.codec.binary.Base64;

public class FMInstaller
extends Installer {
    static final int PROGRESS_MAX = 3755;
    static final String NAME = "Cisco Fabric Manager";
    static final String FEDERATION_EXIST_MSG = "Your existing installation participates in server federation.  This installation does not.  Do you wish to continue?";
    private String oldDB = "hsql";
    private String oldDBURL = null;
    private String oldDBUser = "admin";
    private String oldDBPass = "password";
    private DMInstaller dmi;
    private ClientInstaller cInstaller;
    private boolean createPgStarter = false;
    private boolean installPostgreSQL = false;
    private JTextField userTf = null;
    private JPasswordField passwdTf = null;
    private Properties addProp = new Properties();
    private String where = new String();
    boolean hasStandalone = false;
    private PortConfigurator portCon = null;
    private boolean updatedDbInstallDir = false;
    private boolean migrateDMFM = false;
    private boolean federated = false;
    private short serverId = (short)-1;
    private final String[] pgUtils = new String[]{"pgbackup", "pgrestore"};
    static final String ODRIVER_ENTRY_NAME = "oracle.jdbc.OracleDriver".replaceAll("[.]", "/") + ".class";
    private DBPanel dbPanel;
    private AAAPanel aPanel;
    private UserPanel uPanel;
    private FinishPanel fPanel;
    private ConfigPanel cPanel;
    private FMDiscoverPanel discoverPanel;
    private LocationPanel locPanel;
    private WelcomePanel welcomePanel;
    private Properties props = new Properties();
    private Properties smeProps = new Properties();
    private boolean upgrade = false;
    private boolean reinstall = false;
    protected boolean jserverIsInstalled = false;
    protected String jserverInstallDir = null;

    public FMInstaller(HashMap args) {
        super(args, "Cisco Fabric Manager Installer");
        this.textMode = this.existsArg("-text");
        this.setup();
    }

    private void setup() {
        if (!this.textMode) {
            this.welcomePanel = new WelcomePanel();
            this.welcomePanel.setMenuVisible(true);
            this.dbPanel = new DBPanel();
            this.dbPanel.setDBUser("admin");
            this.aPanel = new AAAPanel();
            this.uPanel = new UserPanel();
            this.locPanel = new LocationPanel(true);
            this.cPanel = new ConfigPanel(this.parent);
            this.discoverPanel = new FMDiscoverPanel();
            this.fPanel = new FinishPanel(this.iModel.getUserDir(), SysInfo.ONWINDOWS);
            progressMon.setMaximum(2740);
            this.userTf = new JTextField("admin", 20);
            this.passwdTf = new JPasswordField("password", 20);
        }
        Util.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAvailableClusterId() throws SQLException {
        try (DB db = null;){
            String dbUrl = this.getDbURL();
            String rdbms = this.getRDBMS(dbUrl);
            db = new DB(rdbms, dbUrl, this.getDbUser(), this.getDbPass());
            boolean bl = db.hasAvailableClusterID();
            return bl;
        }
    }

    private String getDbPass() {
        String dbPass = this.textMode ? this.getArg("-dbpass", "andiamo_4_5_6") : this.dbPanel.getPassword();
        return dbPass;
    }

    private String getDbUser() {
        String dbUser = this.textMode ? this.getArg("-dbuser", "andiamo") : this.dbPanel.getUsername();
        return dbUser;
    }

    private String getRDBMS(String dbUrl) {
        String rdbms = dbUrl.toLowerCase().contains("PostgreSQL".toLowerCase()) ? "PostgreSQL" : "Oracle";
        return rdbms;
    }

    private String getDbURL() {
        String dbUrl = this.textMode ? this.getArg("-dburl", "jdbc:postgresql://localhost:5432/dcmdb") : this.dbPanel.getURL();
        return dbUrl;
    }

    @Override
    public void checkEnvironment() {
        String msg;
        if (this.existsArg("-force")) {
            return;
        }
        boolean OKOS = true;
        boolean OKSP = true;
        StringBuffer errMsg = new StringBuffer("<html><h5>");
        String jreVendor = System.getProperty("java.vm.vendor", "Unknown");
        boolean OKVENDOR = jreVendor.toLowerCase().contains("Sun Microsystems".toLowerCase());
        if (SysInfo.UNKNOWN_OS || !SysInfo.OKJDK || !OKVENDOR) {
            String msg2 = "JRE " + SysInfo.JDK + " from " + jreVendor + " " + "is not supported. Please install JRE 1.5.x/1.6.x from Sun Microsystems Inc. before running this installer.\n\n" + "Supported Environments:\nWindows 2003 SP2, Server 2008 SP2, 7\nRedHat Linux AS5 (2.6 Kernel)\nSun Microsystems JRE 1.6.0_31 or 1.7.0.17";
            logger.fatal((Object)msg2);
            if (this.textMode) {
                System.exit(1);
            }
            this.msgHelper.beepAndDisplayParent();
            JOptionPane.showMessageDialog(this.parent, new JLabel("<html><body>" + msg2.replace("\n", "<br>") + "</body></html>"), "Unsupported Environment", 0);
            System.exit(1);
        }
        String os = System.getProperty("os.name", "Unknown");
        String pl = System.getProperty("sun.os.patch.level", "Service Pack 0");
        String ver = System.getProperty("os.version", "Unknown");
        logger.info((Object)("OS: " + os));
        logger.info((Object)("Patch Level: " + pl));
        logger.info((Object)("Version: " + ver));
        logger.info((Object)("JVM Vendor: " + jreVendor));
        logger.info((Object)("JVM Version: " + SysInfo.JDK));
        String arch = System.getProperty("sun.arch.data.model", "unknown");
        if (SysInfo.ONWINDOWS) {
            if (pl != null) {
                if (os.contains("XP")) {
                    OKSP = false;
                } else if (os.contains("2003")) {
                    OKSP = pl.toLowerCase().contains("Service Pack 2".toLowerCase());
                } else if (os.toLowerCase().contains("vista")) {
                    OKSP = false;
                } else if (os.toLowerCase().contains("Server 2008".toLowerCase())) {
                    OKSP = pl.toLowerCase().contains("Service Pack 2".toLowerCase());
                    if (!OKSP) {
                        OKSP = os.toLowerCase().contains("Server 2008 R2".toLowerCase());
                    }
                } else {
                    OKSP = os.toLowerCase().contains("Server 2003".toLowerCase()) ? pl.toLowerCase().contains("Service Pack 2".toLowerCase()) : os.toLowerCase().contains("Windows 7".toLowerCase());
                }
            } else {
                OKSP = false;
            }
        } else if (SysInfo.ONSOLARIS) {
            OKSP = false;
        } else if (SysInfo.ONLINUX) {
            if (!this.iModel.isRH5() || !ver.startsWith("2.6")) {
                msg = "This Linux platform is not supported.\nSupported Environments:\nWindows 2003 SP2, Server 2008 SP2, 7\nRedHat Linux AS5 (2.6 Kernel)\nSun Microsystems JRE 1.6.0_31 or 1.7.0.17";
                logger.fatal((Object)msg);
                logger.fatal((Object)msg);
                if (!this.textMode) {
                    this.msgHelper.beepAndDisplayParent();
                    JOptionPane.showMessageDialog(this.parent, new JLabel("<html><body>" + msg.replace("\n", "<br>") + "</body></html>"), "Unsupported Environment", 0);
                }
                System.exit(1);
            }
        } else {
            OKOS = false;
        }
        if (!OKOS || !OKSP) {
            msg = "is(are) incompatible with this version of " + this.name + ".\n" + "Cisco do NOT test DCNM with this OS and/or JRE. \n" + "You may continue at your own risk, but Cisco recommends\n" + "that you press Exit and use a supported environment.";
            os = os + " " + (!SysInfo.ONWINDOWS ? ver : "") + " " + (SysInfo.ONWINDOWS ? pl : "");
            if (!this.textMode) {
                errMsg.append(os);
                errMsg.append("</h5>");
                errMsg.append("<br></br>" + msg.replaceAll("\n", "<br>") + "<br><br>" + "Supported Environments:\nWindows 2003 SP2, Server 2008 SP2, 7\nRedHat Linux AS5 (2.6 Kernel)\nSun Microsystems JRE 1.6.0_31 or 1.7.0.17".replace("\n", "<br>") + "</br>");
                errMsg.append("</html>");
                Toolkit.getDefaultToolkit().beep();
                logger.warn((Object)errMsg);
                Object[] options = new Object[]{"Continue", "Exit"};
                JPanel pane = new JPanel();
                pane.add(new JLabel(errMsg.toString()));
                this.msgHelper.beepAndDisplayParent();
                int rc = JOptionPane.showOptionDialog(this.parent, pane, "Unsupported Environment", 0, 2, null, options, options[0]);
                if (rc != 0) {
                    System.exit(1);
                }
            } else {
                Scanner in = new Scanner(System.in);
                while (true) {
                    Toolkit.getDefaultToolkit().beep();
                    logger.warn((Object)(os + "\n" + msg + "\nPress 'C' to continue, 'E' to exit.  [C/E]"));
                    String answer = in.nextLine();
                    if (answer.trim().equalsIgnoreCase("C")) break;
                    if (!answer.trim().equalsIgnoreCase("E")) continue;
                    System.exit(1);
                }
            }
        }
    }

    private void loadOracleDriver(String driverPath) throws Exception {
        try {
            URL[] ojdbc = new URL[]{new URL("file", null, driverPath)};
            URLClassLoader ojdbcLdr = JarLoader.newInstance(ojdbc, this.getClass().getClassLoader());
            ojdbcLdr.loadClass("oracle.jdbc.OracleDriver").newInstance();
        }
        catch (ClassNotFoundException notFoundEx) {
            throw new Exception("Invalid driver.\nUnable load " + notFoundEx.getMessage());
        }
        catch (Exception ex) {
            throw new Exception("Unable to load driver: " + ex.getMessage());
        }
        DBConnection.loadJar = driverPath;
    }

    private boolean isAtLeastOneAAA() {
        if (this.textMode) {
            return true;
        }
        boolean ret = false;
        char m = this.aPanel.getMode().charAt(0);
        switch (m) {
            case 'L': {
                ret = true;
                break;
            }
            case 'R': {
                ret = !this.aPanel.getRadiusPrimaryServer().equalsIgnoreCase("") || !this.aPanel.getRadiusSecondaryServer().equalsIgnoreCase("") || !this.aPanel.getRadiusTertiaryServer().equalsIgnoreCase("");
                break;
            }
            case 'T': {
                ret = !this.aPanel.getTacacsPrimaryServer().equalsIgnoreCase("") || !this.aPanel.getTacacsSecondaryServer().equalsIgnoreCase("") || !this.aPanel.getTacacsTertiaryServer().equalsIgnoreCase("");
                break;
            }
            case 'M': {
                ret = !this.aPanel.getSwitchPrimaryIP().equalsIgnoreCase("") || !this.aPanel.getSwitchSecondaryIP().equalsIgnoreCase("") || !this.aPanel.getSwitchTertiaryIP().equalsIgnoreCase("");
                break;
            }
        }
        return ret;
    }

    private void checkDBChange() {
        boolean isPg;
        if (!this.upgrade) {
            return;
        }
        String dbDriver = this.props.getProperty("db.driver", "org.hsqldb.jdbcDriver");
        if ("org.hsqldb.jdbcDriver".equals(dbDriver)) {
            return;
        }
        boolean isOracle = dbDriver.toLowerCase().contains("Oracle".toLowerCase());
        boolean bl = isPg = this.textMode ? this.existsArg("-usepg") : "PostgreSQL".equalsIgnoreCase(this.dbPanel.getRDBMS());
        if (isPg == isOracle) {
            this.msgHelper.showWarning("Switching between PostgreSQL and Oracle, or visa versa, is an extremely unsafe operation.\nContinuing with this configuration may destabilize Fabric Manager.");
            if (this.textMode) {
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
    }

    private boolean checkSolarisPg() {
        if (!SysInfo.ONSOLARIS) {
            return false;
        }
        try {
            if (this.upgrade && this.iModel.isPgInstalled() && this.dbPanel.getURL().toLowerCase().contains("localhost") && !this.iModel.isPgRunning()) {
                this.iModel.startSunPg();
                if (!this.iModel.isPgRunning()) {
                    throw new Exception("Unable to start PostgreSQL");
                }
                return true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to start PostgreSQL.");
        }
        if (!this.iModel.hasSunPgBinary()) {
            return false;
        }
        if (this.getArg("-pgpath") == null && !this.msgHelper.ask("Unable to connect to the database. Would you like to install PostgreSQL locally?")) {
            return true;
        }
        if (Util.isRoot() && this.getArg("-pgStarter") == null) {
            this.obtainPgStarter();
        }
        this.dbPanel.setDBUrl("jdbc:postgresql://localhost:5432/dcmdb");
        this.installPostgreSQL = true;
        return true;
    }

    public void obtainPgStarter() {
        if (this.getArg("-pgpath") != null) {
            return;
        }
        if (this.getArg("-pgstarter") != null) {
            logger.debug((Object)("pgstarter: " + this.getArg("-pgstarter")));
            return;
        }
        JTextField user = new JTextField(20);
        String pgStarter = null;
        while (true) {
            if ((pgStarter = this.dbPanel.inputPgStarter()) == null || "".equals(pgStarter)) {
                this.dbPanel.setPgStarter("postgres");
                try {
                    if (this.iModel.isSystemUser("postgres")) break;
                    this.createPgStarter = true;
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to test postgres user.");
                    this.createPgStarter = true;
                }
                break;
            }
            try {
                if (this.iModel.isSystemUser(pgStarter)) break;
                this.msgHelper.showError(pgStarter + " is an invalid system user");
            }
            catch (Exception e) {
                logger.error((Object)("Unable to verify system user " + pgStarter + ": " + e.getCause()));
                return;
            }
        }
    }

    private boolean checkFedSameWebSchemeAndShowMsg(boolean https) {
        boolean useFederation;
        boolean installPg;
        boolean bl = this.textMode ? this.existsArg("-installpg") || this.existsArg("-createuser") : (installPg = this.dbPanel.isInstallDB() || this.dbPanel.isCreateUser());
        if (installPg) {
            return true;
        }
        boolean bl2 = useFederation = this.textMode ? this.existsArg("-federated") : this.locPanel.useFederation();
        if (useFederation) {
            boolean isHttps = this.textMode ? this.existsArg("-https") : this.cPanel.useHTTPS();
            return isHttps == https;
        }
        return true;
    }

    private boolean checkFedSameWebPortAndShowMsg(String webPort) {
        boolean useFederation;
        boolean installPg;
        boolean bl = this.textMode ? this.existsArg("-installpg") || this.existsArg("-createuser") : (installPg = this.dbPanel.isInstallDB() || this.dbPanel.isCreateUser());
        if (installPg) {
            return true;
        }
        boolean bl2 = useFederation = this.textMode ? this.existsArg("-federated") : this.locPanel.useFederation();
        if (useFederation) {
            String newPort;
            String string = this.textMode ? this.getArg("-webstart", this.existsArg("-https") ? "443" : "80") : (newPort = this.cPanel.getWebPort().trim());
            if (!newPort.equals(webPort)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkFedSameServerPortAndShowMsg(String serverPort) {
        boolean useFederation;
        boolean installPg;
        boolean bl = this.textMode ? this.existsArg("-installpg") || this.existsArg("-createuser") : (installPg = this.dbPanel.isInstallDB() || this.dbPanel.isCreateUser());
        if (installPg) {
            return true;
        }
        boolean bl2 = useFederation = this.textMode ? this.existsArg("-federated") : this.locPanel.useFederation();
        if (useFederation) {
            String newPort;
            String string = newPort = this.textMode ? this.getArg("-serverport", Integer.toString(9099)) : this.cPanel.getServerPort().trim();
            if (!newPort.equals(serverPort)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasOtherClusterNode() {
        String dbUrl = this.getDbURL();
        String rdbms = this.getRDBMS(dbUrl);
        try (DB db = null;){
            db = new DB(rdbms, dbUrl, this.getDbUser(), this.getDbPass());
            Map<Integer, InetAddress> clusters = db.getClusterNodes();
            InetAddress thisServer = this.getServerInetAddress();
            Set<Integer> keys = clusters.keySet();
            for (Integer key : keys) {
                InetAddress value = clusters.get(key);
                if (value.equals(thisServer)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private int checkWebPort(String portStr) {
        try {
            int p;
            block8: {
                block9: {
                    p = Integer.parseInt(portStr);
                    if (this.existsArg("-force")) {
                        return p;
                    }
                    String curPortStr = this.confProps.getProperty("mds.web.startPort");
                    int curPort = -1;
                    if (curPortStr != null) {
                        curPort = Integer.parseInt(curPortStr);
                    }
                    if (curPort == p) break block8;
                    curPort = Util.freePort(true, p);
                    if (curPort != p || curPort == -1) break block9;
                    if (PortConfigurator.testServerPort(p)) break block8;
                }
                return -1;
            }
            return p;
        }
        catch (NumberFormatException nfe) {
            String message = "Invalid web port.";
            if (!this.textMode) {
                this.msgHelper.showError(message);
            }
            logger.error((Object)message);
            return -1;
        }
    }

    private int checkServerPort(String portStr) {
        try {
            int port;
            block8: {
                block9: {
                    int p = Integer.parseInt(portStr);
                    if (this.existsArg("-force")) {
                        return p;
                    }
                    port = Integer.parseInt(portStr);
                    String curPortStr = this.props.getProperty("server.port");
                    int curPort = -1;
                    if (curPortStr != null) {
                        curPort = Integer.parseInt(curPortStr);
                    }
                    if (curPort == port) break block8;
                    curPort = Util.freePort(true, port);
                    if (curPort != port || curPort == -1) break block9;
                    if (PortConfigurator.testServerPort(port)) break block8;
                }
                return -1;
            }
            return port;
        }
        catch (NumberFormatException nfe) {
            String message = "Invalid server port.";
            if (!this.textMode) {
                this.msgHelper.showError(message);
            }
            logger.error((Object)message);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAndOverrideDefaultSettings() {
        try {
            block99: {
                Properties props;
                String mode;
                if (!this.textMode) {
                    if (this.existsArg("-https")) {
                        this.cPanel.setHTTPS(true);
                    }
                    if (this.existsArg("-fcalias")) {
                        this.cPanel.setUseFCAlias(true);
                    }
                    if (this.existsArg("-nic")) {
                        this.cPanel.setNIC(this.getArg("-nic"));
                    }
                    this.fPanel.setCreateShortcutForAllUsers(this.existsArg("-allusers"));
                    this.iModel.setNoServer(this.existsArg("-noserver"));
                    if (this.existsArg("-standalone")) {
                        this.locPanel.setStandaloneOverEnterprise(true);
                    } else if (this.existsArg("-server")) {
                        this.locPanel.setStandaloneOverEnterprise(false);
                    }
                    if (this.existsArg("-installpg")) {
                        this.dbPanel.setInstallPostgreSQL(true);
                        this.ifUpdaterExit();
                    } else if (this.existsArg("-usepg")) {
                        this.dbPanel.setInstallPostgreSQL(false);
                        this.dbPanel.setRDBMS("PostgreSQL");
                    } else if (this.existsArg("-useoracle")) {
                        this.dbPanel.setInstallPostgreSQL(false);
                        this.dbPanel.setRDBMS("Oracle");
                    }
                } else {
                    if (!(this.existsArg("-useoracle") || this.existsArg("-usepg") || this.existsArg("-installpg"))) {
                        throw new Exception("Please use one of the following options: -useoracle, -usepg, or -installpg.");
                    }
                    if (this.existsArg("-useoracle")) {
                        String driverPath = this.promptUserOjdbc();
                        if (driverPath == null) {
                            System.exit(-1);
                        }
                        this.loadOracleDriver(driverPath);
                    }
                    if (!(this.existsArg("-server") || this.existsArg("-standalone") || this.existsArg("-noserver"))) {
                        throw new Exception("Please specify either -server or -standalone.");
                    }
                    this.iModel.setIsHTTPS(this.existsArg("-https"));
                    this.iModel._allUsers = this.existsArg("-allusers");
                    this.iModel.setNoServer(this.existsArg("-noserver"));
                    this.iModel.setIsStandalone(!this.existsArg("-server"));
                }
                if (this.textMode) {
                    this.assertDcnm42();
                }
                String dbDir = this.getArg("-dbdir");
                String dbURL = this.getArg("-dburl");
                String dbPass = this.getArg("-dbpass");
                String dbUser = this.getArg("-dbuser");
                String adminUser = this.getArg("-adminuser");
                String adminPass = this.getArg("-adminpass");
                if (this.textMode) {
                    if (dbURL == null || dbPass == null || dbUser == null) {
                        if (!this.existsArg("-installpg")) {
                            throw new Exception("Invalid database options. See -dburl -dbuser -dbpass.");
                        }
                        if (dbPass == null || dbUser == null) {
                            throw new Exception("Unable to parse DB login information. See -dbuser -dbpass.");
                        }
                    }
                    if (this.existsArg("-createuser") && this.existsArg("-federation")) {
                        throw new Exception("Invalid command -createuser -federation:  Cannot create DB user when joining a server federation.");
                    }
                    if (this.existsArg("-createuser") && (this.existsArg("-useoracle") || this.existsArg("-usepg"))) {
                        if (!this.existsArg("-adminuser") || !this.existsArg("-adminpass")) {
                            throw new Exception("Invalid command -createuser: -adminuser and -adminpass not specified.");
                        }
                        if (!this.existsArg("-force") && !this.checkDBShareUrl()) {
                            System.exit(-1);
                        }
                        try (DB db = new DB(this.getRDBMS(this.getDbURL()), this.getDbURL(), this.getArg("-adminuser"), this.getArg("-adminpass"));){
                            if (!db.hasConnection()) {
                                throw new Exception("Unable to connect to DB at " + this.getDbURL() + " with " + this.getArg("-adminuser") + ".");
                            }
                        }
                    }
                    if (!this.existsArg("-federated") && !this.checkDbUserNotDcnmUser()) {
                        System.exit(-1);
                    }
                    if (this.existsArg("-createuser")) {
                        if (!this.checkDbUserNotAdminUser() || !this.checkDbUserExist()) {
                            System.exit(-1);
                        }
                        if (!this.createDBUser()) {
                            System.exit(-1);
                        }
                    }
                    if (!this.checkDBFebSameAsDCNM()) {
                        System.exit(-1);
                    }
                    if ((this.reinstall || this.upgrade) && !this.existsArg("-federated") && !this.upgradeAuthenFMUser()) {
                        System.exit(-1);
                    }
                } else {
                    String fmPass;
                    String fmUser;
                    if (dbDir != null) {
                        if (Util.exists(dbDir)) {
                            if (!Util.touch("writable")) {
                                throw new Exception("Unable to write to " + dbDir + ".");
                            }
                            Util.delete("writable");
                        } else if (!Util.mkdir(dbDir)) {
                            throw new Exception("Unabel to create " + dbDir + ".");
                        }
                        this.dbPanel.setInstallLocation(dbDir);
                    }
                    if (dbURL != null) {
                        this.dbPanel.setDBUrl(dbURL);
                    }
                    if (dbPass != null) {
                        this.dbPanel.setDBPassword(dbPass);
                    }
                    if (dbUser != null) {
                        this.dbPanel.setDBUser(dbUser);
                    }
                    if ((fmUser = this.getArg("-fmuser")) != null) {
                        this.uPanel.setUser(fmUser);
                    }
                    if ((fmPass = this.getArg("-fmpass")) != null) {
                        this.uPanel.setPassword(fmPass);
                    }
                }
                if (!((mode = this.getArg("-authmode")) == null || mode.equalsIgnoreCase("Local") || mode.equalsIgnoreCase("RADIUS") || mode.equalsIgnoreCase("TACACS") || mode.equalsIgnoreCase("MDS") || !this.textMode)) {
                    throw new Exception("Invalid authentication mode.");
                }
                if (mode != null && !this.textMode) {
                    this.aPanel.setMode(mode);
                }
                this.checkAuthOpt(mode, null);
                if (this.existsArg("-authurl2")) {
                    this.checkAuthOpt(mode, "2");
                }
                if (this.existsArg("-authurl3")) {
                    this.checkAuthOpt(mode, "3");
                }
                if (this.textMode) {
                    try {
                        if (!(!this.textMode ? this.dbPanel.isInstallDB() : this.existsArg("-installpg"))) {
                            props = this.loadPropsFromDB();
                            String webPortProp = props.getProperty("web.port", this.existsArg("-https") ? "443" : "80").trim();
                            if (!this.checkFedSameWebPortAndShowMsg(webPortProp)) {
                                this.msgHelper.showMessage(DialogHelper.getFedSameWebPortMsg(webPortProp));
                                System.exit(-1);
                            }
                            if (!this.checkFedSameWebSchemeAndShowMsg(Boolean.parseBoolean(props.getProperty("mds.web.https", "false")))) {
                                this.msgHelper.showMessage("Your server federation uses HTTPS .\nIt is a requirement for servers in the same federation to use the same protocol.");
                                System.exit(-1);
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.msgHelper.showError("Unable to load server federation properties from DB: " + ex.getMessage());
                        return;
                    }
                }
                if (this.existsArg("-webstart")) {
                    try {
                        String webPort = this.getArg("-webstart", this.existsArg("-https") ? "443" : "80");
                        if (!this.textMode) {
                            int wPort = Integer.parseInt(webPort);
                            this.cPanel.setWebPort(Integer.parseInt(webPort));
                        } else if (!this.iModel.isStandalone()) {
                            this.assertWebPortTextMode(webPort);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        String message = "Invalid web port.";
                        if (!this.textMode) {
                            this.msgHelper.showError(message);
                        }
                        logger.error((Object)message);
                        System.exit(-1);
                    }
                }
                if (this.textMode) {
                    try {
                        String svrPortProp;
                        if (!this.existsArg("-installpg") && !this.checkFedSameServerPortAndShowMsg(svrPortProp = (props = this.loadPropsFromDB()).getProperty("server.port", Integer.toString(9099)).trim())) {
                            this.msgHelper.showMessage(DialogHelper.getFedSameServerPortMsg(svrPortProp));
                            System.exit(-1);
                        }
                    }
                    catch (Exception ex) {
                        this.msgHelper.showError("Unable to load server federation properties from DB: " + ex.getMessage());
                        System.exit(-1);
                    }
                }
                if (this.existsArg("-serverport")) {
                    String serverPort = this.getArg("-serverport", Integer.toString(9099));
                    try {
                        int sPort = Integer.parseInt(serverPort);
                        if (!this.textMode) {
                            this.cPanel.setServerPort(Integer.parseInt(serverPort));
                            break block99;
                        }
                        if (this.iModel.isStandalone()) break block99;
                        boolean exist = serverPort.equalsIgnoreCase(this.props.getProperty("server.port", ""));
                        if (sPort == Util.freePort(true, sPort)) {
                            if (PortConfigurator.testServerPort(sPort)) break block99;
                        }
                        if (!exist) {
                            if (this.existsArg("-force")) {
                                logger.warn((Object)("Server port " + serverPort + " is not available. Forcing " + serverPort + "."));
                            } else {
                                logger.error((Object)("Server port " + serverPort + " is not available. Please choose a different port."));
                                System.exit(1);
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        String message = "Invalid server port.";
                        if (!this.textMode) {
                            this.msgHelper.showError(message);
                        } else {
                            logger.error((Object)message);
                        }
                        System.exit(-1);
                    }
                }
            }
            if (this.existsArg("-federated")) {
                String nic;
                if (this.existsArg("-text") && !this.existsArg("-server")) {
                    this.msgHelper.showError("Federation can only be used with server installation.");
                    System.exit(-1);
                }
                if (this.existsArg("-installpg")) {
                    this.msgHelper.showError("Servers in the same federation are required to use same database.");
                    System.exit(-1);
                }
                if ((nic = this.getArg("-nic")) != null && !"".equals(nic.trim())) {
                    try {
                        if (InetAddress.getByName(nic).isLoopbackAddress()) {
                            this.msgHelper.showError("Bind address is loop back.  Please choose another bind address.");
                            System.exit(-1);
                        }
                    }
                    catch (Exception ex) {
                        this.msgHelper.showError("Unable to get bind address " + nic + ": " + ex.getMessage());
                    }
                }
            }
            boolean useFederation = Boolean.parseBoolean(this.confProps.getProperty("mds.server.federation", "false"));
            if (this.existsArg("-text")) {
                if (useFederation && !this.existsArg("-federated") && (this.upgrade || this.reinstall) && this.existsArg("-server")) {
                    Scanner in = new Scanner(System.in);
                    while (true) {
                        System.out.print("Your existing installation participates in server federation.  This installation does not.  Do you wish to continue? [Y/N]");
                        String answer = in.nextLine();
                        if (answer.trim().equalsIgnoreCase("n")) {
                            System.exit(-1);
                            continue;
                        }
                        if (answer.trim().equalsIgnoreCase("y")) break;
                    }
                }
            } else {
                this.locPanel.setUseFederation(useFederation || this.existsArg("-federated"));
            }
            try {
                if (this.textMode && !this.checkClustering()) {
                    System.exit(1);
                }
            }
            catch (SQLException ex) {
                this.msgHelper.showError("Unable query database: " + ex.getMessage());
                System.exit(1);
            }
            catch (UnknownHostException ex) {
                this.msgHelper.showError("Error obtaining server address: " + ex.getMessage());
                System.exit(1);
            }
        }
        catch (Exception ex) {
            if (this.textMode) {
                this.printUsage();
                logger.error((Object)ex.getMessage());
                System.exit(1);
            }
            logger.debug((Object)ex.getCause());
        }
    }

    private boolean checkDBFebSameAsDCNM() {
        boolean federated;
        boolean bl = federated = this.textMode ? this.existsArg("-federated") : this.locPanel.useFederation();
        if (federated) {
            try {
                DCNMInfo dcnm = DCNMInfo.getInstance();
                if (dcnm.isCompatible() && dcnm.getDbURL() != null && this.getDbURL().trim().equalsIgnoreCase(this.getDbURL().trim()) && dcnm.getDbUser() != null && dcnm.getDbUser().trim().equalsIgnoreCase(this.getDbUser().trim())) {
                    boolean yes = this.msgHelper.ask("ALERT: The database account in your federation is the same as the database\naccount used by DCNM.  This appears to be a misconfiguration.  Please\ncheck your settings before continuing.  If you find that this is a correct \nconfiguration and wish to continue, " + (this.textMode ? "press 'Y'" : "click Yes") + ".  " + "Otherwise, " + (this.textMode ? "press 'N'" : "click No") + ".");
                    return yes;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to get DCNM installation settings: " + ex.getMessage()));
            }
        }
        return true;
    }

    private void assertWebPortTextMode(String webPort) throws NumberFormatException {
        if (this.iModel.isStandalone()) {
            return;
        }
        if (!this.textMode) {
            return;
        }
        int wPort = Integer.parseInt(webPort);
        boolean exist = webPort.equalsIgnoreCase(this.confProps.getProperty("mds.web.startPort", ""));
        if (!(wPort == Util.freePort(true, wPort) && PortConfigurator.testServerPort(wPort) || exist)) {
            if (this.existsArg("-force")) {
                logger.warn((Object)("Web port " + webPort + " is not available. Forcing " + webPort + "."));
            } else {
                logger.error((Object)("Web port " + webPort + " is not available. Please specify a different port with -webstart option" + ". If this is intentional, then use the -force option."));
                System.exit(1);
            }
        }
    }

    private void ifUpdaterExit() {
        if (this.iModel.isUpdater()) {
            this.msgHelper.showError("Database installation is not available on this version of Cisco Fabric Manager Installer.  Please install a database prior to running to this installer or obtain a complete copy of Cisco Fabric Manager Installer.");
            System.exit(-1);
        }
    }

    private void checkAuthOpt(String mode, String suf) throws Exception {
        String url;
        String actPortOpt;
        String urlOpt = suf == null ? "-authurl" : "-authurl" + suf;
        String secretOpt = suf == null ? "-authsecret" : "-authsecret" + suf;
        String aPortOpt = suf == null ? "-authport" : "-authport" + suf;
        String string = actPortOpt = suf == null ? "-acctport" : "-acctport" + suf;
        if ("RADIUS".equalsIgnoreCase(mode) || "TACACS".equalsIgnoreCase(mode)) {
            String url2 = this.getArg(urlOpt);
            String secretkey = this.getArg(secretOpt);
            String authPort = this.getArg(aPortOpt);
            String acctPort = this.getArg(actPortOpt);
            if (url2 == null || secretkey == null) {
                throw new Exception("Invalid " + urlOpt + " or " + secretOpt);
            }
            if ("TACACS".equalsIgnoreCase(mode)) {
                this.checkAuthPort(authPort, aPortOpt);
            }
            if ("RADIUS".equalsIgnoreCase(mode)) {
                this.checkAuthPort(authPort, aPortOpt);
                this.checkAcctPort(acctPort, actPortOpt);
            }
        } else if ("MDS".equalsIgnoreCase(mode) && (url = this.getArg(urlOpt)) == null) {
            throw new Exception("Invalid " + urlOpt);
        }
    }

    private void checkAuthPort(String authPort, String opt) throws Exception {
        if (authPort == null) {
            throw new Exception("Invalid " + opt);
        }
        try {
            Integer.parseInt(authPort);
        }
        catch (Exception ex) {
            throw new Exception("Invalid " + opt + ": " + ex.getMessage());
        }
    }

    private void checkAcctPort(String authPort, String opt) throws Exception {
        if (authPort == null) {
            throw new Exception("Invalid " + opt);
        }
        try {
            Integer.parseInt(authPort);
        }
        catch (Exception ex) {
            throw new Exception("Invalid " + opt + ": " + ex.getMessage());
        }
    }

    private void parseProperties(String properties) throws Exception {
        String[] splits;
        for (String split : splits = properties.split(";")) {
            String[] params = (split = split.trim()).split("=");
            if (params.length != 2) {
                throw new Exception(split + " does not appear to be a valid property");
            }
            logger.info((Object)("Loading " + params[0] + " = " + params[1]));
            this.props.put(params[0], params[1]);
        }
    }

    private void doDbDirCheck() {
        boolean answer;
        if (!this.dbPanel.isInstallDB()) {
            return;
        }
        String iDir = this.locPanel.getInstallFolder();
        String dbDir = this.dbPanel.getInstallLocation();
        String def = iDir + SysInfo.FS + "dcm" + SysInfo.FS + "db";
        if (!Util.isSamePath(def, dbDir) && (answer = this.msgHelper.ask("The database install location is not in its default path.  Do you wish\nto use to the default location?\n\nClick Yes to change it to " + def + ".\n" + "Click No to continue with the existing location."))) {
            this.dbPanel.setInstallLocation(def);
        }
    }

    private boolean doPasswordCheck(String user, String password, String cPassword, boolean atLeast6) {
        if (atLeast6 && password.length() < 6) {
            this.msgHelper.showMessage("Password must be at least 6 characters long.");
            return false;
        }
        if (user == null || "".equalsIgnoreCase(user)) {
            this.msgHelper.showMessage("User field cannot be empty.");
            return false;
        }
        if (!Util.validateUser(user)) {
            this.msgHelper.showMessage("Invalid username.  A username consists of only alphanumeric \ncharacters.  It must be less than or equal to 32 characters and \ncontain no space or special characters.");
            return false;
        }
        if (password == null || "".equalsIgnoreCase(password)) {
            this.msgHelper.showMessage("Password field cannot be empty.");
            return false;
        }
        if (!Util.validatePassword(password)) {
            this.msgHelper.showMessage("Invalid password.  A password consists of only alphanumeric \ncharacters.  It must be less than or equal to 64 characters and\ncontain no space.");
            return false;
        }
        if (!cPassword.equals(password)) {
            this.msgHelper.showMessage("Password fields do not match.");
            return false;
        }
        return true;
    }

    private boolean upgradeAuthenFMUser() {
        if (this.upgrade || this.reinstall) {
            try {
                String pass;
                String user = this.textMode ? this.getArg("-fmuser", "") : this.uPanel.getUser();
                String string = pass = this.textMode ? this.getArg("-fmpass", "") : this.uPanel.getPassword();
                if (user == null || "".equals(user.trim())) {
                    this.msgHelper.showError("Unable to authenticate local FM user:  User cannot be null or empty.\nIn order to upgrade/reinstall FM on this host, please authenticate with a local user who has privilege as network-admin.");
                    return false;
                }
                if (pass == null || "".equals(pass.trim())) {
                    this.msgHelper.showError("Unable to authenticate local FM user:  Password cannot be null or empty.\nIn order to upgrade/reinstall FM on this host, please authenticate with a local user who has priviledge as network-admin.");
                    return false;
                }
                if (!this.authenticateFMUser(user, pass)) {
                    this.msgHelper.showError(user + " is not a network admin.");
                    return false;
                }
            }
            catch (Exception ex) {
                this.msgHelper.showError(ex.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateFMUser(String user, String password) throws Exception {
        String dbUrl = this.getDbURL();
        String rdbms = this.getRDBMS(dbUrl);
        try (DB db = null;){
            db = new DB(rdbms, dbUrl, this.getDbUser(), this.getDbPass());
            boolean bl = db.authenticateFMAdmin(user, password);
            return bl;
        }
    }

    private void verify(final int hashcode) {
        JPanel loginPanel;
        WizardPanel panel = this.wizard.getCurrent();
        String name = panel.getName();
        if (name.equals("Database Options")) {
            if (!this.doPasswordCheck(this.dbPanel.getUsername().trim(), this.dbPanel.getPassword().trim(), this.dbPanel.getPassword().trim(), false)) {
                return;
            }
            if (this.testConnection()) {
                this.msgHelper.showVerified();
            } else {
                this.msgHelper.showUnableToVerify(this.dbPanel, this.dbPanel.getURL(), this.dbPanel.getUsername());
            }
            return;
        }
        switch (this.aPanel.getMode().charAt(0)) {
            case 'R': 
            case 'T': {
                if (!"".equals(this.aPanel.getServer(hashcode).trim()) && !"".equals(this.aPanel.getSecret(hashcode).trim())) break;
                this.msgHelper.showMessage("Auth address or secret cannot be empty.");
                return;
            }
            case 'M': {
                if (!"".equals(this.aPanel.getServer(hashcode).trim())) break;
                this.msgHelper.showMessage("Auth address cannot be empty.");
                return;
            }
        }
        final AAAPanel aPanel = (AAAPanel)panel;
        final JButton OKBtn = new JButton("OK");
        CaretListener cListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                String user = FMInstaller.this.userTf.getText();
                String pass = new String(FMInstaller.this.passwdTf.getPassword());
                if (pass.length() == 0 || user.length() == 0) {
                    OKBtn.setEnabled(false);
                } else {
                    OKBtn.setEnabled(true);
                }
            }
        };
        this.userTf.addCaretListener(cListener);
        this.passwdTf.addCaretListener(cListener);
        try {
            loginPanel = WizardPanel.createForm(new JLabel[]{new JLabel("Username:"), new JLabel("Password:")}, new JComponent[]{this.userTf, this.passwdTf});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        boolean ret = true;
        String mode = aPanel.getMode();
        ret = this.msgHelper.showDialog("Login", "Please enter login information", new JComponent[]{loginPanel}, new JButton[]{OKBtn, new JButton("Cancel")});
        if (!ret) {
            return;
        }
        Thread authenticate = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                authStatus = "Authentication verified.";
                try {
                    authen = new AAA();
                    mode = aPanel.getMode();
                    FMInstaller.access$200(FMInstaller.this);
                    FMInstaller.this.wizard.getNextButton().setEnabled(false);
                    FMInstaller.this.wizard.getBackButton().setEnabled(false);
                    aPanel.setEnabled(false);
                    switch (mode.charAt(0)) {
                        case 'R': {
                            host = aPanel.getServer(hashcode);
                            secret = aPanel.getSecret(hashcode);
                            authPort = aPanel.getAuthPrimaryPort();
                            acctPort = aPanel.getAcctPrimaryPort();
                            method = aPanel.getRadiusAuthMethod();
                            authen.setRadiusInfo(host, secret, authPort, acctPort, method);
                            authen.setUserInfo(FMInstaller.access$000(FMInstaller.this).getText().trim(), new String(FMInstaller.access$100(FMInstaller.this).getPassword()).trim());
                            authen.setMethod("PAP");
                            try {
                                authen.doRadiusAuthentication();
                                ** break;
lbl22:
                                // 1 sources

                                break;
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex.getMessage());
                            }
                        }
                        case 'T': {
                            host = aPanel.getServer(hashcode);
                            secret = aPanel.getSecret(hashcode);
                            port = aPanel.getTacacPrimaryPort();
                            method = aPanel.getTacacsAuthMethod();
                            authen.setTacacsInfo(host, secret, port, method);
                            authen.setUserInfo(FMInstaller.access$000(FMInstaller.this).getText().trim(), new String(FMInstaller.access$100(FMInstaller.this).getPassword()).trim());
                            authen.setMethod("PAP");
                            try {
                                authen.doTacacsAthentication();
                                ** break;
lbl36:
                                // 1 sources

                                break;
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex.getMessage());
                            }
                        }
                        case 'M': {
                            host = aPanel.getServer(hashcode);
                            authen.verifyMDS(host, FMInstaller.access$000(FMInstaller.this).getText().trim(), new String(FMInstaller.access$100(FMInstaller.this).getPassword()).trim());
                            ** break;
lbl43:
                            // 1 sources

                            break;
                        }
                        ** default:
lbl45:
                        // 1 sources

                        break;
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(aPanel, ex.getMessage(), "Authentication Status", 0);
                    ex.printStackTrace();
                    return;
                }
                finally {
                    FMInstaller.this.wizard.getNextButton().setEnabled(true);
                    FMInstaller.this.wizard.getBackButton().setEnabled(true);
                    aPanel.setEnabled(true);
                    FMInstaller.access$300(FMInstaller.this);
                }
                JOptionPane.showMessageDialog(aPanel, authStatus, "Authentication Status", 1);
            }
        };
        authenticate.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() {
        try (DB db = null;){
            db = new DB(this.dbPanel.getRDBMS(), this.dbPanel.getURL(), this.dbPanel.getUsername(), this.dbPanel.getPassword());
            boolean bl = db.hasConnection();
            return bl;
        }
    }

    public void collectInstallInfo2() {
        String dcnmInstallDir;
        String dcnmInstallDir2;
        SwitchVersion dmVer;
        String dmVersion;
        if (this.textMode && this.getArg("-dir") == null) {
            logger.error((Object)"Invalid installation directory. Please specify an install directory using -dir=INSTALLDIR option.");
            System.exit(-1);
        }
        String nmsRoot = this.confProps.getProperty("mds.nmsRoot");
        String oldDir = this.findNMSRoot(nmsRoot);
        String iDir = null;
        SwitchVersion oldVersion = this.getVersion(null);
        if (oldDir != null) {
            oldVersion = this.getVersion(oldDir);
            if (!oldVersion.isUnknown()) {
                if (oldVersion.lessThan(this.VER412)) {
                    String dcnmInstallDir3 = this.getDCNMDir();
                    iDir = dcnmInstallDir3 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir3;
                } else {
                    iDir = this.confProps.getProperty("mds.ciscoRoot");
                    if (this.textMode && !Util.isSamePath(iDir, this.getArg("-dir"))) {
                        logger.error((Object)("Cisco Management Software is already installed under " + iDir + ".  Please use the existing install directory."));
                        System.exit(-1);
                    }
                }
            } else {
                dmVersion = this.confProps.getProperty("mds.dm.version");
                if (dmVersion != null) {
                    dmVer = new SwitchVersion(dmVersion);
                    if (!dmVer.lessThan(this.VER412)) {
                        iDir = this.confProps.getProperty("mds.ciscoRoot");
                        if (this.textMode && Util.isSamePath(iDir, this.getArg("-dir"))) {
                            logger.error((Object)("Cisco Management Software is already installed under " + iDir + ".  Please use the existing install directory."));
                            System.exit(-1);
                        }
                        if (iDir == null) {
                            dcnmInstallDir2 = this.getDCNMDir();
                            iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                        }
                    } else {
                        dcnmInstallDir2 = this.getDCNMDir();
                        iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                        this.migrateDMFM = true;
                    }
                } else {
                    dcnmInstallDir = this.getDCNMDir();
                    iDir = dcnmInstallDir == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir;
                }
            }
        } else {
            dmVersion = this.confProps.getProperty("mds.dm.version");
            if (dmVersion != null) {
                dmVer = new SwitchVersion(dmVersion);
                if (!dmVer.lessThan(this.VER412)) {
                    iDir = this.confProps.getProperty("mds.ciscoRoot");
                    if (iDir == null) {
                        dcnmInstallDir2 = this.getDCNMDir();
                        iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                    } else if (!this.checkInstallDir412(iDir)) {
                        dcnmInstallDir2 = this.getDCNMDir();
                        iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                    }
                } else {
                    dcnmInstallDir2 = this.getDCNMDir();
                    iDir = dcnmInstallDir2 == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir2;
                    this.migrateDMFM = true;
                }
            } else {
                dcnmInstallDir = this.getDCNMDir();
                iDir = dcnmInstallDir == null ? (this.textMode ? this.getArg("-dir") : this.getDefaultInstallDir()) : dcnmInstallDir;
            }
        }
        if (this.textMode && !Util.isSamePath(iDir, this.getArg("-dir"))) {
            logger.error((Object)("Cisco Management Software is already installed under " + iDir + ".  Please use the existing install directory."));
            System.exit(-1);
        }
        this.iModel.setInstallDir(iDir);
        this.iModel.setOldVersion(oldVersion);
        this.iModel.setOldInstallDir(oldDir);
        SwitchVersion ver = this.getVersion();
        this.iModel.setVersion(ver);
        this.iModel.setCodebase(this.getArg("-home"));
        String pathToExistingDb = this.confProps.getProperty("mds.db.dir");
        if (pathToExistingDb != null) {
            this.iModel.setInstallPgDir(pathToExistingDb);
        } else {
            this.iModel.setInstallPgDir(this.iModel.getDBDir());
        }
        String stopPortStr = this.confProps.getProperty("mds.web.stopPort");
        if (stopPortStr != null) {
            this.iModel.setWebStopPort(Integer.parseInt(stopPortStr));
        }
    }

    public void collectInstallInfo() {
        String ciscoRoot;
        String iDir = this.getArg("-dir");
        String nmsRoot = this.confProps.getProperty("mds.nmsRoot");
        if (iDir == null) {
            String ciscoRoot2;
            if (this.textMode) {
                System.out.println("\nInvalid install folder.\n");
                this.printUsage();
                System.exit(-1);
            }
            iDir = Util.exists(ciscoRoot2 = this.confProps.getProperty("mds.ciscoRoot")) && this.checkInstallDir412(ciscoRoot2 + SysInfo.FS + "dcm") ? ciscoRoot2 : this.getDefaultInstallDir();
        }
        iDir = new File(iDir).getAbsolutePath();
        logger.info((Object)("Install folder: " + iDir));
        String oldIDir = this.findInstallDir(nmsRoot);
        if (oldIDir != null) {
            this.iModel.setOldInstallDir(oldIDir);
            logger.info((Object)("Existing installation folder: " + oldIDir));
            if (this.confProps.getProperty("mds.ciscoRoot") != null) {
                iDir = oldIDir;
            }
        }
        if ((ciscoRoot = this.confProps.getProperty("mds.ciscoRoot")) != null) {
            iDir = ciscoRoot;
        }
        this.iModel.setInstallDir(iDir);
        SwitchVersion oldVer = this.getVersion(nmsRoot);
        this.iModel.setOldVersion(oldVer);
        SwitchVersion ver = this.getVersion();
        this.iModel.setVersion(ver);
        this.iModel.setCodebase(this.getArg("-home"));
        String pathToExistingDb = this.confProps.getProperty("mds.db.dir");
        if (pathToExistingDb != null) {
            this.iModel.setInstallPgDir(pathToExistingDb);
        } else {
            this.iModel.setInstallPgDir(this.iModel.getDBDir());
        }
        String stopPortStr = this.confProps.getProperty("mds.web.stopPort");
        if (stopPortStr != null) {
            this.iModel.setWebStopPort(Integer.parseInt(stopPortStr));
        }
    }

    @Override
    public void preInstall() {
        String smePropName;
        if (this.existsArg("-help") || this.existsArg("-h") || this.existsArg("--help") || this.existsArg("--h")) {
            this.printUsage();
            System.exit(0);
        }
        this.checkEnvironment();
        this.collectInstallInfo2();
        this.portCon = new PortConfigurator(this.iModel.getDCMDir(), "fm");
        this.checkUpgradeAndReinstallation();
        logger.info((Object)("JAVA_HOME: " + SysInfo.JHOME));
        logger.info((Object)("OS: " + SysInfo.OS));
        logger.info((Object)("Reinstall: " + this.reinstall));
        logger.info((Object)("Upgrade: " + this.upgrade));
        logger.info((Object)("Previous version: " + this.iModel.getOldVersion()));
        logger.info((Object)("Current version: " + this.iModel.getVersion()));
        if (!this.textMode) {
            this.locPanel.setLocation(this.iModel.getInstallDir());
            this.cPanel.setWebPort(this.findFreeWebPort());
            this.cPanel.setServerPort(this.findFreeServerPort());
        }
        this.parseAndSetDB();
        this.loadExistingConfig();
        if (this.VER32.compareTo(this.iModel.getVersion()) <= 0) {
            String serverFile = this.iModel.getDCMDir() + FS + this.serverXml;
            try {
                if (Util.exists(serverFile)) {
                    Util.copy(serverFile, serverFile + "_bak");
                }
            }
            catch (Exception ex) {
                this.msgHelper.showWarning("Unable to preserve: " + serverFile);
            }
        }
        if (Util.exists(smePropName = this.iModel.getOldConfDir() + FS + "smeserver.properties")) {
            this.smeProps = Util.loadProps(smePropName);
        }
        this.jserverInstallDir = this.confProps.getProperty("mds.smisRoot");
        this.jserverIsInstalled = Boolean.parseBoolean(this.confProps.getProperty("mds.smis.installed", "false"));
        if (this.jserverIsInstalled && Util.exists(this.jserverInstallDir + SysInfo.FS + "server" + SysInfo.FS + "jserver" + SysInfo.FS + "bin" + SysInfo.FS + (SysInfo.ONWINDOWS ? "jserverd.exe" : "jserverd"))) {
            this.locPanel.setJServerEnabled(false);
            this.locPanel.setInstallJServer(true);
            this.locPanel.setJServerSelectable(false);
        }
        if (this.upgrade) {
            String upgMsg;
            String message = "Cisco Database Service is down. You will lose existing data upgrading.\nRestart the database before installing if you want to keep configured data.";
            if (this.iModel.getOldVersion().compareTo(new SwitchVersion("3.3(0)")) < 0) {
                upgMsg = "Due to database requirement, please upgrade to FM 3.3(x) before starting this upgrade process.";
                this.msgHelper.showMessage(upgMsg);
                System.exit(0);
            }
            if (this.VER31.compareTo(this.iModel.getOldVersion()) > 0) {
                upgMsg = "Cisco strongly recommends that you upgrade to version 3.1.x before\nupgrading to this version, otherwise you will lose existing Performance\nManager data.";
                if (!this.props.containsKey("db.url")) {
                    if (!Service.isRunning("FMPersist")) {
                        this.msgHelper.showWarning(message + "\n" + upgMsg);
                        if (this.textMode) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    } else {
                        this.msgHelper.showWarning(upgMsg);
                        if (this.textMode) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                }
            } else if (this.VER32.compareTo(this.iModel.getOldVersion()) > 0 && !Service.isRunning("FMPersist") && !this.props.containsKey("db.url")) {
                this.msgHelper.showWarning(message);
                if (this.textMode) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
        this.handleUpgradeForCluster();
        this.setAndOverrideDefaultSettings();
        if (!this.updaterCheck() && this.textMode) {
            System.exit(-1);
        }
        if (this.textMode) {
            this.checkDBChange();
        }
        if (!this.textMode) {
            int maxCount;
            SwitchVersion fmcVersion = new SwitchVersion(this.confProps.getProperty("mds.fm.version"));
            boolean existsFM = this.confProps.containsKey("mds.fm.version") && (Util.exists(this.iModel.getLibDir() + FS + "fmclient.jar") || Util.exists(this.iModel.getFMLibDir() + FS + "fmclient.jar")) && Util.exists(this.iModel.getBinDir() + FS + "FabricManager" + SysInfo.ESUFFIX);
            SwitchVersion dmVersion = new SwitchVersion(this.confProps.getProperty("mds.dm.version"));
            boolean existsDM = this.confProps.containsKey("mds.dm.version") && Util.exists(this.iModel.getBinDir() + FS + "DeviceManager" + SysInfo.ESUFFIX);
            this.assertDcnm42();
            DCNMInfo dcnmInfo = null;
            try {
                dcnmInfo = DCNMInfo.getInstance();
                if (DCNMInfo.getInstance().isCompatible() && !this.upgrade && !this.reinstall) {
                    this.welcomePanel.setMenuVisible(false);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to get DCNM Installation settings: " + ex.getMessage()));
            }
            if (dcnmInfo != null && dcnmInfo.isCompatible() && dcnmInfo.getInstallLocation() != null) {
                this.locPanel.setSelectorEnabled(false);
            } else if (!this.iModel.getOldVersion().isUnknown() && this.iModel.getOldVersion().lessThan(this.VER412)) {
                this.locPanel.setSelectorEnabled(true);
            } else if (!(this.iModel.getOldVersion().lessThan(this.VER412) && dmVersion.lessThan(this.VER412) && fmcVersion.lessThan(this.VER412))) {
                this.locPanel.setSelectorEnabled(!this.upgrade && !this.reinstall && !existsFM && !existsDM);
            }
            this.iModel.setDeleteOldExec(this.iModel.getOldVersion().lessThan(this.VER412) || dmVersion.lessThan(this.VER412) || fmcVersion.lessThan(this.VER412));
            this.wizard.addCard(this.welcomePanel);
            this.wizard.addCard(new LicensePanel());
            String authServer1 = null;
            String authServer2 = null;
            String authServer3 = null;
            String authSecret1 = null;
            String authSecret2 = null;
            String authSecret3 = null;
            switch (this.aPanel.getMode().charAt(0)) {
                case 'R': {
                    authServer1 = this.aPanel.getRadiusPrimaryServer();
                    authSecret1 = this.aPanel.getRadiusPrimarySecret();
                    authServer2 = this.aPanel.getRadiusSecondaryServer();
                    authSecret2 = this.aPanel.getRadiusSecondarySecret();
                    authServer3 = this.aPanel.getRadiusTertiaryServer();
                    authSecret3 = this.aPanel.getRadiusTertiarySecret();
                    break;
                }
                case 'T': {
                    authServer1 = this.aPanel.getTacacsPrimaryServer();
                    authSecret1 = this.aPanel.getTacacsPrimarySecret();
                    authServer2 = this.aPanel.getTacacsSecondaryServer();
                    authSecret2 = this.aPanel.getTacacsSecondarySecret();
                    authServer3 = this.aPanel.getTacacsTertiaryServer();
                    authSecret3 = this.aPanel.getTacacsTertiarySecret();
                    break;
                }
                case 'S': {
                    authServer1 = this.aPanel.getSwitchPrimaryIP();
                    authServer2 = this.aPanel.getSwitchSecondaryIP();
                    authServer3 = this.aPanel.getSwitchTertiaryIP();
                    break;
                }
            }
            this.uPanel.setShowCreateUser(!this.reinstall && !this.upgrade);
            this.wizard.addCard(new ConfirmPanel(this.iModel.getVersion().toString(), this.locPanel.getInstallFolder(), this.dbPanel.isInstallDB(), this.dbPanel.getRDBMS(), this.dbPanel.getUsername(), this.upgrade ? this.dbPanel.getPassword() : "password_1_2_3", this.uPanel.getUser(), "password", this.aPanel.getMode(), authServer1, authServer2, authServer3, authSecret1, authSecret2, authSecret3, this.cPanel.useFCAlias(), this.cPanel.getSNMPv3(), !this.upgrade && !this.reinstall));
            this.wizard.addCard(this.locPanel);
            this.wizard.addCard(this.dbPanel);
            this.wizard.addCard(this.uPanel);
            this.wizard.addCard(this.aPanel);
            this.wizard.addCard(this.cPanel);
            this.wizard.addCard(this.discoverPanel);
            this.wizard.addCard(this.progressPanel);
            this.wizard.addCard(this.fPanel);
            this.wizard.first();
            this.updateButtonPreference();
            if (this.iModel.isUpdater()) {
                this.parent.setTitle(this.parent.getTitle() + " - Update only");
                this.welcomePanel.setNotes("This is not a complete installer. This wizard can only patch existing installation that does not require a new database or JBoss server.");
            }
            ActionListener verifyDB = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FMInstaller.this.verify(-1);
                }
            };
            ActionListener dbVerifyListener = FMInstaller.createCursorController(this.parent, verifyDB);
            this.aPanel.addVerifyListener(this);
            JButton backBtn = this.wizard.getBackButton();
            backBtn.addActionListener(this);
            JButton nextBtn = this.wizard.getNextButton();
            nextBtn.addActionListener(this);
            JButton cancelBtn = this.wizard.getCancelButton();
            cancelBtn.addActionListener(this);
            this.wizard.getBackButton().setEnabled(false);
            if (this.iModel.isUpdater()) {
                this.dbPanel.setInstallEnabled(false);
            }
            this.displayWizard();
            int n = maxCount = this.locPanel.isStandalone() ? 2500 : 8473;
            if (!SysInfo.ONWINDOWS && this.dbPanel.isInstallDB()) {
                maxCount += 2800;
            }
            progressMon.setMaximum(maxCount);
        }
        this.federated = this.textMode ? this.existsArg("-federated") : this.locPanel.useFederation();
    }

    private void assertDcnm42() {
        DCNMInfo dcnmInfo = null;
        String msg = "To ensure compatibility with DCNM, it is a requirement that you upgrade\nDCNM to version 4.2 or higher before installing Cisco Fabric Manager\nand visa versa.";
        try {
            boolean federated = this.textMode ? this.existsArg("-federated") : this.locPanel.useFederation();
            dcnmInfo = DCNMInfo.getInstance();
            if (!(dcnmInfo.isCompatible() || dcnmInfo.getInstallLocation() == null || this.upgrade || this.reinstall || federated)) {
                this.msgHelper.showMessage("Installation has detected that you have DCNM installed on this host.\nTo ensure compatibility with DCNM, it is a requirement that you upgrade\nDCNM to version 4.2 or higher before installing Cisco Fabric Manager\nand visa versa.");
                System.exit(-1);
            }
        }
        catch (Exception ex) {
            this.msgHelper.showError("Unable to check if DCNM is version 4.2 or higher: " + ex.getMessage() + ".\n\n" + "To ensure compatibility with DCNM, it is a requirement that you upgrade\nDCNM to version 4.2 or higher before installing Cisco Fabric Manager\nand visa versa.");
        }
    }

    private void displayWizard() {
        this.parent.pack();
        this.parent.setVisible(true);
        String inDir = this.locPanel.getInstallFolder();
        boolean installDB = this.dbPanel.isInstallDB();
        String dbms = this.dbPanel.getRDBMS();
        String dbUrl = this.dbPanel.getURL();
        String dbUser = this.dbPanel.getUsername();
        String dbPass = this.dbPanel.getPassword();
        String dbCPass = this.dbPanel.getConfirmPassword();
        String authMode = this.aPanel.getMode();
        String rSecret1 = this.aPanel.getRadiusPrimarySecret();
        String rSecret2 = this.aPanel.getRadiusSecondarySecret();
        String rSecret3 = this.aPanel.getRadiusTertiarySecret();
        String rServer1 = this.aPanel.getRadiusPrimaryServer();
        String rServer2 = this.aPanel.getRadiusSecondaryServer();
        String rServer3 = this.aPanel.getRadiusTertiaryServer();
        String tSecret1 = this.aPanel.getTacacsPrimarySecret();
        String tSecret2 = this.aPanel.getTacacsSecondarySecret();
        String tSecret3 = this.aPanel.getTacacsTertiarySecret();
        String tServer1 = this.aPanel.getTacacsPrimaryServer();
        String tServer2 = this.aPanel.getTacacsSecondaryServer();
        String tServer3 = this.aPanel.getTacacsTertiaryServer();
        String sIP1 = this.aPanel.getSwitchPrimaryIP();
        String sIP2 = this.aPanel.getSwitchSecondaryIP();
        String sIP3 = this.aPanel.getSwitchTertiaryIP();
        boolean useSnmpV3 = this.cPanel.getSNMPv3();
        boolean useFcAlias = this.cPanel.useFCAlias();
        this.pause();
        if (this.welcomePanel.isExpress()) {
            Util.mkdir(inDir);
            this.locPanel.setInstallFolder(inDir);
            this.dbPanel.setInstallDB(installDB);
            this.dbPanel.setRDBMS(dbms);
            this.dbPanel.setDBUrl(dbUrl);
            this.dbPanel.setDBUser(dbUser);
            this.dbPanel.setDBPassword(dbPass);
            this.aPanel.setMode(authMode);
            this.aPanel.setRadiusPrimarySecret(rSecret1);
            this.aPanel.setRadiusSecondarySecret(rSecret2);
            this.aPanel.setRadiusTertiarySecret(rSecret3);
            this.aPanel.setRadiusPrimaryServer(rServer1);
            this.aPanel.setRadiusSecondaryServer(rServer2);
            this.aPanel.setRadiusTertiaryServer(rServer3);
            this.aPanel.setRadiusTertiaryServer(rServer3);
            this.aPanel.setTacacsPrimarySecret(tSecret1);
            this.aPanel.setTacacsSecondarySecret(tSecret2);
            this.aPanel.setTacacsTertiarySecret(tSecret3);
            this.aPanel.setTacacsPrimaryServer(tServer1);
            this.aPanel.setTacacsSecondaryServer(tServer2);
            this.aPanel.setTacacsTertiaryServer(tServer3);
            this.aPanel.setSwitchPrimaryIP(sIP1);
            this.aPanel.setSwitchSecondaryIP(sIP2);
            this.aPanel.setSwitchTertiaryIP(sIP3);
            this.cPanel.setSNMPv3(useSnmpV3);
            this.cPanel.setUseFCAlias(useFcAlias);
            this.createPgStarter = true;
        }
    }

    private void handleUpgradeForCluster() {
        if (!this.upgrade) {
            return;
        }
        boolean alreadyFederated = Boolean.parseBoolean(this.confProps.getProperty("mds.server.federation", "false"));
        boolean doFed = this.existsArg("-federated");
        if (this.textMode) {
            if (alreadyFederated != doFed) {
                logger.error((Object)(alreadyFederated ? "This server is in a federation, please restart this installation with -federated option." : "Joining a federation from this upgrade is not allowed."));
                System.exit(-1);
            }
            boolean isSA = Boolean.parseBoolean(this.confProps.getProperty("mds.standalone", "false"));
            if (!(alreadyFederated && this.existsArg("-standalone") && isSA)) {
                // empty if block
            }
            return;
        }
        this.locPanel.setAllowFederationEnabled(false);
        if (alreadyFederated) {
            this.locPanel.setAllowSAEnabled(false);
        }
    }

    private void loadExistingConfig() {
        String aaaPropertyFile;
        String rdbms;
        if (!this.upgrade && !this.reinstall) {
            return;
        }
        String serverProperty = this.iModel.getOldConfDir() + FS + "server.properties";
        if (!Util.exists(serverProperty)) {
            logger.error((Object)"Unable to load existing properties/configuration.");
            return;
        }
        this.props = Util.loadProps(serverProperty);
        this.oldDB = this.props.getProperty("db.driver");
        if (this.oldDB == null) {
            this.oldDB = "hsql";
        } else if (this.oldDB.toLowerCase().contains("oracle")) {
            this.oldDB = "Oracle";
        } else if (this.oldDB.toLowerCase().contains("postgres")) {
            this.oldDB = "PostgreSQL";
        }
        this.oldDBUser = this.props.getProperty("db.user", "cisco");
        this.oldDBPass = this.props.getProperty("db.password", "andiamo_4_5_6");
        this.oldDBURL = this.props.getProperty("db.url", "jdbc:hsqldb:hsql://localhost");
        String dbDriver = this.props.getProperty("db.driver", "org.postgresql.Driver");
        String dbUrl = this.props.getProperty("db.url", "jdbc:postgresql://localhost:5432/dcmdb");
        String dbUser = this.props.getProperty("db.user", "");
        String dbPass = this.props.getProperty("db.password", "");
        String string = rdbms = dbDriver.toLowerCase().contains("oracle") ? "Oracle" : "PostgreSQL";
        if (dbPass.startsWith("#")) {
            try {
                dbPass = this.iModel.getOldVersion().compareTo(new SwitchVersion("3.2(0.190)")) > 0 ? JBoss_4_2Encrypter.decrypt(dbPass.substring(1)) : StringEncrypter.DESedeDecrypt(dbPass.substring(1));
            }
            catch (Exception ex) {
                logger.error((Object)("Can not decrypt password:" + dbPass.substring(1)));
            }
        }
        if (!this.textMode) {
            String libDir;
            this.dbPanel.setRDBMS(rdbms);
            this.dbPanel.setDBUrl(this.getArg("-dburl", dbUrl));
            this.dbPanel.setDBUser(this.getArg("-dbuser", dbUser));
            this.dbPanel.setDBPassword(this.getArg("-dbpass", dbPass));
            String driver = this.props.getProperty("db.driver");
            if (driver != null && !"".equals(driver.trim())) {
                this.dbPanel.setInstallPostgreSQL(false);
            } else {
                this.dbPanel.setInstallPostgreSQL(true);
                this.dbPanel.setDBUrl("jdbc:postgresql://localhost:5432/dcmdb");
            }
            if (this.dbPanel.isPostgres() || Util.exists(libDir = this.iModel.getOldInstallDir() + FS + "lib")) {
                // empty if block
            }
        }
        try {
            Properties propFromDB = this.loadPropsFromDB();
            this.props.putAll((Map<?, ?>)propFromDB);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to get properties from db: " + ex.getMessage()));
        }
        Boolean allUsers = new Boolean(this.confProps.getProperty("mds.winAllUsers"));
        if (!this.textMode) {
            this.fPanel.setCreateShortcutForAllUsers(allUsers);
            String webPortStr = this.confProps.getProperty("mds.web.startPort");
            if (this.existsArg("-webstart")) {
                webPortStr = this.getArg("-webstart", webPortStr);
            }
            if (webPortStr != null) {
                this.cPanel.setWebPort(Integer.parseInt(webPortStr));
                this.cPanel.setUpgradePort(Integer.parseInt(webPortStr));
            }
            String serverPortStr = this.props.getProperty("server.port", Integer.toString(9099));
            if (this.existsArg("-serverport")) {
                serverPortStr = this.getArg("-serverport", serverPortStr);
            }
            if (serverPortStr != null) {
                this.cPanel.setServerPort(Integer.parseInt(serverPortStr));
            }
            try {
                this.cPanel.setSNMPv3(Boolean.parseBoolean(this.props.getProperty("snmp.v3only", "true")));
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to get snmp.v3only property: " + ex.getMessage()));
                this.cPanel.setSNMPv3(false);
            }
            String ba = this.props.getProperty("server.bindaddrs", "0.0.0.0");
            if (this.existsArg("-nic")) {
                ba = this.getArg("-nic", ba);
            }
            this.cPanel.setNIC(ba);
            boolean hasHTTPS = Boolean.parseBoolean(this.confProps.getProperty("mds.web.https", "false"));
            this.cPanel.setHTTPS(this.existsArg("-https") ? true : hasHTTPS);
            boolean useFcAlias = false;
            String fcAlias = this.props.getProperty("fabric.fcalias");
            if (this.existsArg("-fcalias")) {
                fcAlias = "true";
            }
            if (fcAlias == null) {
                String globalAlias = this.props.getProperty("fabric.globalAlias", "true");
                useFcAlias = new Boolean(globalAlias = globalAlias.trim());
                useFcAlias = !useFcAlias;
            } else {
                useFcAlias = new Boolean(fcAlias.trim());
            }
            this.cPanel.setUseFCAlias(useFcAlias);
            this.hasStandalone = Boolean.parseBoolean(this.confProps.getProperty("mds.standalone", "true"));
            this.welcomePanel.setMenuVisible(this.hasStandalone);
            this.locPanel.setStandaloneOverEnterprise(this.existsArg("-server") ? false : this.hasStandalone);
        }
        try {
            Util.copy(serverProperty, serverProperty + "_bak");
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to back up " + serverProperty));
        }
        try {
            String smePropFile = this.iModel.getOldConfDir() + FS + "smeserver.properties";
            Util.copy(smePropFile, smePropFile + "_bak");
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to back up smeserver.properties");
        }
        if (this.iModel.getOldVersion().compareTo(this.VER32) < 0 && Util.exists(aaaPropertyFile = this.iModel.getOldInstallDir() + FS + "AAA.properties")) {
            Properties aProps = Util.loadProps(aaaPropertyFile);
            if (aProps != null) {
                this.props.putAll((Map<?, ?>)aProps);
            }
            try {
                Util.copy(aaaPropertyFile, aaaPropertyFile + "_bak");
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to back up " + aaaPropertyFile));
            }
        }
        if (!this.textMode) {
            String mode = this.props.getProperty("authentication.mode", this.getArg("-authmode", "local"));
            String server = this.props.getProperty("aaa.server.primary.name", "");
            String secret = this.props.getProperty("aaa.server.primary.secret", "");
            String method = this.props.getProperty("aaa.server.primary.auth-method", "pap");
            String portStr = this.props.getProperty("tacacs.server.primary.port", "49");
            String authPort = this.props.getProperty("radius.server.primary.auth-port", "1812");
            String acctPort = this.props.getProperty("radius.server.primary.acct-port", "1813");
            if ("RADIUS".equalsIgnoreCase(mode)) {
                this.aPanel.setMode("RADIUS");
                this.aPanel.setRadiusPrimaryServer(this.getArg("-authurl", server));
                this.aPanel.setRadiusPrimarySecret(this.getArg("-authsecret", secret));
                this.aPanel.setRadiusAuthMethod(method);
                int authP = 1812;
                try {
                    authP = Integer.parseInt(this.getArg("-authport", authPort));
                }
                catch (Exception ex) {
                    authP = 1812;
                }
                int acctP = 1813;
                try {
                    acctP = Integer.parseInt(this.getArg("-acctport", acctPort));
                }
                catch (Exception ex) {
                    acctP = 1813;
                }
                this.aPanel.setAuthPrimaryPort(authP);
                this.aPanel.setAcctPrimaryPort(acctP);
                this.aPanel.setRadiusSecondaryServer(this.props.getProperty("aaa.server.secondary.name", this.getArg("-authurl2", "")));
                this.aPanel.setRadiusSecondarySecret(this.props.getProperty("aaa.server.secondary.secret", this.getArg("-authsecret2", "")));
                this.aPanel.setRadiusTertiaryServer(this.props.getProperty("aaa.server.tertiary.name", this.getArg("-authurl3", "")));
                this.aPanel.setRadiusTertiarySecret(this.props.getProperty("aaa.server.tertiary.secret", this.getArg("-authsecret3", "")));
            } else if ("TACACS".equalsIgnoreCase(mode)) {
                this.aPanel.setMode("TACACS");
                this.aPanel.setTacacsPrimaryServer(this.getArg("-authurl", server));
                this.aPanel.setTacacsPrimarySecret(this.getArg("-authsecret", secret));
                this.aPanel.setTacacsAuthMethod(method);
                int authP = 49;
                try {
                    authP = Integer.parseInt(this.getArg("-authport", portStr));
                }
                catch (Exception ex) {
                    authP = 49;
                }
                this.aPanel.setTacacPrimaryPort(authP);
                this.aPanel.setTacacsSecondaryServer(this.props.getProperty("aaa.server.secondary.name", this.getArg("-authurl2", "")));
                this.aPanel.setTacacsSecondarySecret(this.props.getProperty("aaa.server.secondary.secret", this.getArg("-authsecret2", "")));
                this.aPanel.setTacacsTertiaryServer(this.props.getProperty("aaa.server.tertiary.name", this.getArg("-authurl3", "")));
                this.aPanel.setTacacsTertiarySecret(this.props.getProperty("aaa.server.tertiary.secret", this.getArg("-authsecret3", "")));
            } else if ("MDS".equalsIgnoreCase(mode)) {
                this.aPanel.setMode("MDS");
                server = this.props.getProperty("proxy.mds.primary", this.getArg("-authurl", ""));
                this.aPanel.setSwitchPrimaryIP(server);
                this.aPanel.setSwitchSecondaryIP(this.props.getProperty("proxy.mds.secondary", this.getArg("-authurl2", "")));
                this.aPanel.setSwitchTertiaryIP(this.props.getProperty("proxy.mds.tertiary", this.getArg("-authurl3", "")));
            } else {
                this.aPanel.setMode("Local");
            }
        }
    }

    private void checkUpgradeAndReinstallation() {
        if (!this.iModel.getOldVersion().isUnknown()) {
            if (this.iModel.getVersion().compareTo(this.iModel.getOldVersion()) > 0) {
                if (this.textMode) {
                    logger.info((Object)("Upgrading to Cisco Fabric Manager " + this.iModel.getVersion().toString()));
                } else if (!this.msgHelper.doUpgrade(NAME)) {
                    System.exit(0);
                }
                this.upgrade = true;
                if (!this.textMode) {
                    progressMon.setMaximum(3755);
                }
            } else if (this.iModel.getVersion().compareTo(this.iModel.getOldVersion()) == 0) {
                if (!this.existsArg("-force")) {
                    if (this.textMode) {
                        String msg = "Cisco Fabric Manager " + this.iModel.getVersion().toString() + " is already installed.\n Use -force to reinstall.";
                        logger.info((Object)msg);
                        System.out.println(msg);
                        System.exit(0);
                    } else if (!this.msgHelper.doReinstall("Cisco Fabric Manager " + this.iModel.getVersion().toString())) {
                        System.exit(0);
                    }
                }
                this.reinstall = true;
            } else {
                if (this.textMode) {
                    logger.info((Object)"Downgrade is not supported");
                } else {
                    this.msgHelper.showNoDowngrade();
                }
                System.exit(1);
            }
        }
    }

    private boolean updaterCheck() {
        boolean isServer;
        if (!this.iModel.isUpdater()) {
            return true;
        }
        boolean bl = this.textMode ? this.existsArg("-server") : (isServer = !this.locPanel.isStandalone());
        if (!(!isServer || Util.exists(this.iModel.getJBossDir()) && Util.exists(this.iModel.getJBossDir() + FS + "server" + FS + "default" + FS + "deploy" + FS + "fmserver-ds.xml"))) {
            if (this.hasStandalone) {
                this.msgHelper.showError("JBoss framework appear be unavailable in existing installation.\nThis version of Cisco Fabric Manager Installer cannot continue.\nPlease obtain a complete version of Cisco Fabric Manager Installer.");
            } else {
                this.msgHelper.showError("JBoss framework appear to be unavailable or corrupted.\nThis version of Cisco Fabric Manager Installer cannot continue.\nPlease obtain a complete version of Cisco Fabric Manager Installer.");
            }
            return false;
        }
        return true;
    }

    public String findOJdbc(String dir) {
        File directory = new File(dir);
        if (!directory.isDirectory()) {
            return null;
        }
        String[] files = directory.list();
        if (files == null) {
            return null;
        }
        for (String file : files) {
            try {
                String path = directory.getCanonicalPath() + FS + file;
                String jarPath = this.findDriverClass(path);
                if (jarPath == null) continue;
                return jarPath;
            }
            catch (IOException ioe) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)ioe.getMessage());
            }
        }
        return null;
    }

    public String findDriverClass(String path) throws IOException {
        JarFile jarFile = new JarFile(path);
        if (jarFile.getEntry(ODRIVER_ENTRY_NAME) != null) {
            logger.debug((Object)("Oracle driver " + path + " found."));
            return path;
        }
        return null;
    }

    public void parseAndSetDB() {
        this.installPostgreSQL = this.existsArg("-installpg");
        if (!this.textMode) {
            this.dbPanel.setInstallDB(this.installPostgreSQL);
        }
        if (this.installPostgreSQL && (SysInfo.ONSOLARIS || SysInfo.ONLINUX)) {
            this.ifUpdaterExit();
            if (Util.isRoot()) {
                String pgstarter = this.getArg("-pgstarter");
                if (pgstarter != null) {
                    try {
                        if (this.iModel.isSystemUser(pgstarter)) {
                            if (!this.textMode) {
                                this.dbPanel.setPgStarter(pgstarter);
                            }
                            this.iModel.setPgStarter(pgstarter);
                        } else {
                            String ermsg = "Unable to verify " + pgstarter + " as system user.";
                            if (!this.textMode) {
                                this.msgHelper.showError(ermsg);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to perform test on " + pgstarter + ": " + e.getCause()));
                    }
                } else {
                    this.createPgStarter = true;
                }
            }
        }
    }

    public int findFreeWebPort() {
        int port = -1;
        int[] ports = new int[]{80, 8080};
        port = this.portCon.findFreePorts(ports);
        if (port != 80 && port != 8080) {
            port = 80;
        }
        return port;
    }

    public int findFreeServerPort() {
        int port = -1;
        int[] ports = new int[]{9099, 1099};
        port = this.portCon.findFreePorts(ports);
        if (port != 1099 && port != 9099) {
            port = 9099;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install() {
        try {
            String method;
            String secret;
            String server;
            DB db;
            logger.warn((Object)"Installing...");
            String rdbms = null;
            String dbUrl = null;
            String dbUser = null;
            String dbPass = "password_1_2_3";
            this.mkdirs(this.iModel.getInstallDir());
            this.mkdirs(this.iModel.getLibDir());
            this.mkdirs(this.iModel.getBinDir());
            this.mkdirs(this.iModel.getConfDir());
            this.mkdirs(this.iModel.getHelpDir());
            this.mkdirs(this.iModel.getLogDir());
            this.mkdirs(this.iModel.getLibDir());
            this.mkdirs(this.iModel.getDownloadDir());
            this.mkdirs(this.iModel.getDBDir());
            this.mkdirs(this.iModel.getConfDir());
            this.mkdirs(this.iModel.getPmDir());
            this.mkdirs(this.iModel.getPmDir() + FS + "db");
            this.mkdirs(this.iModel.getPmDir() + FS + "www");
            this.mkdirs(this.iModel.getReportDir());
            this.mkdirs(this.iModel.getReportDir() + FS + "fcpolicy");
            this.mkdirs(this.iModel.getDCMDir() + FS + "licenses");
            String tftpDir = this.iModel.getUserDir() + FS + "tftp";
            this.mkdirs(tftpDir);
            if (!this.textMode) {
                rdbms = this.dbPanel.getRDBMS();
                dbUrl = this.dbPanel.getURL();
                dbUser = this.dbPanel.getUsername();
                if (!this.welcomePanel.isExpress()) {
                    dbPass = this.dbPanel.getPassword();
                } else {
                    if (!this.dbPanel.isInstallDB()) {
                        dbPass = this.dbPanel.getPassword();
                    } else {
                        this.dbPanel.setDBPassword("password_1_2_3");
                        this.dbPanel.setDBUser("admin");
                    }
                    this.uPanel.setUser("admin");
                    this.uPanel.setPassword("password");
                }
                this.installPostgreSQL = this.dbPanel.isInstallDB();
                this.iModel.setPgStarter(this.dbPanel.getPgStarter());
                this.iModel.setIsPostgres(this.dbPanel.getRDBMS().equalsIgnoreCase("PostgreSQL"));
                this.iModel.setIsStandalone(this.locPanel.isStandalone());
            } else {
                this.iModel.setIsPostgres(!this.existsArg("-useoracle"));
                dbUser = this.getArg("-dbuser");
                dbPass = this.getArg("-dbpass");
                if (dbPass.startsWith("#")) {
                    dbPass = JBoss_4_2Encrypter.decrypt(dbPass.substring(1));
                }
                rdbms = (dbUrl = this.getArg("-dburl", "jdbc:postgresql://localhost:5432/dcmdb")).toLowerCase().contains("PostgreSQL".toLowerCase()) ? "PostgreSQL" : "Oracle";
                this.iModel.setPgStarter(this.getArg("-pgstarter"));
                this.iModel.setIsStandalone(!this.existsArg("-server"));
            }
            this.iModel.stopFMS();
            if (this.reinstall) {
                Util.delete(this.iModel.getLogDir() + FS + "sme.log");
            }
            if (!this.textMode) {
                this.iModel.setInstallDir(this.locPanel.getInstallFolder());
                this.iModel.setDBURL(this.dbPanel.getURL());
                this.iModel.setDBUser(this.dbPanel.getUsername());
                this.iModel.setDBPassword(this.dbPanel.getPassword());
                this.iModel.setIsHTTPS(this.cPanel.useHTTPS());
                this.iModel.setIsPostgres(this.dbPanel.getRDBMS().toLowerCase().contains("PostgreSQL".toLowerCase()));
                this.iModel.setIsStandalone(this.locPanel.isStandalone());
                this.iModel.setInstallPgDir(this.dbPanel.getInstallLocation());
            } else {
                this.iModel.setIsHTTPS(this.existsArg("-https"));
                this.iModel.setIsPostgres(dbUrl.toLowerCase().contains("postgres"));
                this.iModel.setIsStandalone(!this.existsArg("-server"));
                if (this.getArg("-dbdir") != null) {
                    this.iModel.setInstallPgDir(this.getArg("-dbdir"));
                }
            }
            this.portCon.setInstallDir(this.iModel.getDCMDir());
            if (this.textMode) {
                this.iModel.setNIC(this.getArg("-nic"));
                if (!this.iModel.isStandalone()) {
                    String webPort = this.getArg("-webstart", this.existsArg("-https") ? "443" : "80");
                    this.assertWebPortTextMode(webPort);
                }
                int webPort = Integer.parseInt(this.getArg("-webstart", this.existsArg("-https") ? "443" : "80"));
                this.iModel.setWebStartPort(webPort);
                this.installPostgreSQL = this.existsArg("-installpg");
            } else {
                String ifAddress = this.cPanel.getNIC();
                this.iModel.setNIC(ifAddress);
                int webPort = Integer.parseInt(this.cPanel.getWebPort());
                this.iModel.setWebStartPort(webPort);
                this.installPostgreSQL = this.dbPanel.isInstallDB();
            }
            Util.extract(this.iModel.getTmpDir() + FS + "configuration.jar", this.iModel.getTmpDir());
            if (this.existsArg("-bundleVM")) {
                try {
                    String jreDir = this.iModel.getDCMDir() + FS + "jre";
                    if (!Util.exists(jreDir + FS + "bin" + FS + (SysInfo.ONWINDOWS ? "java.exe" : "java"))) {
                        logger.info((Object)"Installing VM");
                        this.mkdirs(jreDir);
                        Util.copyFiles(SysInfo.JHOME, jreDir);
                        SysInfo.JHOME = jreDir;
                        SysInfo.JEXEC = jreDir + FS + "bin" + FS + (SysInfo.ONWINDOWS ? "javaw.exe" : "java");
                        SysInfo.JCMDEXEC = jreDir + FS + "bin" + FS + (SysInfo.ONWINDOWS ? "java.exe" : "java");
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("Unable to install VM:" + ex.getMessage()));
                    throw ex;
                }
            }
            if (this.installPostgreSQL) {
                if (SysInfo.ONWINDOWS) {
                    this.iModel.installPostgresWin(dbUser, dbPass, dbPass, this.existsArg("-userdomain"));
                    DB db2 = new DB("PostgreSQL", "jdbc:postgresql://localhost:5432/postgres", dbUser, dbPass);
                    try {
                        db2.createPgDB();
                        dbUrl = "jdbc:postgresql://localhost:5432/dcmdb";
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Unable to create dcmdb: " + ex.getMessage()));
                    }
                    try {
                        db2.addDBUser("andiamo", "andiamo_4_5_6");
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Error creating admin db user: " + ex.getMessage()));
                    }
                    finally {
                        db2.close();
                    }
                    db2 = new DB("PostgreSQL", dbUrl, dbUser, dbPass);
                    try {
                        if (!db2.existDBSchema(dbUser)) {
                            db2.createDBSchema(dbUser, dbUser);
                        }
                        db2.grantDBSchema(dbUser, dbUser);
                        db2.setDBSearchPath(dbUser, dbUser);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Unable to assign schema to user " + dbUser));
                    }
                    finally {
                        db2.close();
                    }
                } else if (SysInfo.ONLINUX || SysInfo.ONSOLARIS) {
                    String user;
                    if (this.iModel.isPgRunning()) {
                        this.msgHelper.showPgInstalled();
                        System.exit(1);
                    }
                    if (!Util.isRoot()) {
                        throw new RuntimeException("Must be root to install PostgreSQL.");
                    }
                    if (this.textMode && !(!SysInfo.ONLINUX ? this.iModel.checkSolarisMemorySetting() : this.iModel.checkSharedMemory())) {
                        String msg = "Your shared memory settings may be too low to run PostgreSQL.\nYou may want to reconfigure kernel resources before installing.\nPlease visit http://www.postgresql.org/docs/8.2/interactive/kernel-resources.html for more information.";
                        this.msgHelper.showWarning(msg);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (this.textMode) {
                        user = this.getArg("-pgstarter", "");
                        if ("".equals(user.trim()) && !this.iModel.isSystemUser(user = "postgres")) {
                            this.createPgStarter = true;
                        }
                    } else {
                        user = this.dbPanel.getPgStarter();
                        if (user == null) {
                            user = "postgres";
                            this.iModel.setPgStarter(user);
                        }
                    }
                    if (this.createPgStarter) {
                        if (this.iModel.isSystemUser(user)) {
                            logger.info((Object)("User " + user + " already exist."));
                        } else {
                            logger.info((Object)("creating user account: " + user));
                            this.iModel.creatUNIXUser(user);
                        }
                    }
                    logger.warn((Object)"Setting up PostgreSQL");
                    if (SysInfo.ONSOLARIS) {
                        this.iModel.installPostgresSolaris(user);
                    } else {
                        this.iModel.installPostgresLinux(this.iModel.getPgStarter());
                    }
                    this.iModel.startSunPg();
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    try (DB db3 = SysInfo.ONSOLARIS ? new DB() : new DB("PostgreSQL", "jdbc:postgresql://localhost:5432/dcmdb", "andiamo", "andiamo_4_5_6");){
                        if (!db3.hasConnection() && !db3.retryConnection(5)) {
                            String msg = "Unable to start the database.";
                            db3.close();
                            throw new RuntimeException(msg);
                        }
                        this.createDBUser(db3, dbUser, dbPass);
                        db3.close();
                        this.enablePGStartup();
                    }
                }
            }
            if (!(db = new DB(rdbms, dbUrl, dbUser, dbPass)).hasConnection()) {
                throw new RuntimeException("Unable to connect to the database.");
            }
            db.setLogger(logger);
            logger.warn((Object)"Creating schema");
            String schemaFile = this.iModel.getTmpDir() + FS + (this.iModel.isPostgres() ? "postgrescreate.sql" : "oraclesetup.sql");
            if (this.upgrade && this.iModel.getOldVersion().compareTo(new SwitchVersion("3.3(0)")) < 0) {
                throw new Exception("Please upgrade to 3.3 first");
            }
            InetAddress clusterAddr = this.getServerInetAddress();
            boolean doDBUpgrade = true;
            if (this.federated) {
                doDBUpgrade = false;
            } else if (db.isClusterExist(clusterAddr) <= 0) {
                doDBUpgrade = true;
            }
            if (this.upgrade && doDBUpgrade) {
                String smeupgrade;
                if (this.iModel.getOldVersion().compareTo(new SwitchVersion("3.2(0)")) < 0) {
                    if (!Util.exists(schemaFile)) {
                        throw new Exception("Schema file not found.");
                    }
                    db.createSchema(schemaFile);
                }
                if (this.iModel.getOldVersion().compareTo(this.VER60) < 0) {
                    if (!this.iModel.isPostgres() && this.oldDB.equals("Oracle")) {
                        String oracleUpgradeScript = this.iModel.getTmpDir() + FS + "oracleupgrade.sql";
                        if (!Util.exists(oracleUpgradeScript)) {
                            throw new Exception("Oracle upgrade schema file not found.");
                        }
                        db.createSchema(oracleUpgradeScript);
                    } else if (this.iModel.isPostgres()) {
                        String postgresUpgradeScript = this.iModel.getTmpDir() + FS + "postgresupgrade.sql";
                        if (!Util.exists(postgresUpgradeScript)) {
                            throw new Exception("Postgres upgrade schema file not found.");
                        }
                        db.createSchema(postgresUpgradeScript);
                    }
                }
                if (this.iModel.getOldVersion().compareTo(new SwitchVersion("3.2(2)")) < 0) {
                    smeupgrade = this.iModel.getTmpDir() + FS + (this.iModel.isPostgres() ? "sme322pgupgrade.sql" : "sme322oracleupgrade.sql");
                    db.createSchema(smeupgrade);
                }
                if (this.iModel.getOldVersion().compareTo(new SwitchVersion("4.0(0)")) < 0) {
                    smeupgrade = this.iModel.getTmpDir() + FS + (this.iModel.isPostgres() ? "sme41pgupgrade.sql" : "sme41oracleupgrade.sql");
                    db.createSchema(smeupgrade);
                }
            } else {
                if (!Util.exists(schemaFile)) {
                    throw new Exception("Schema file not found.");
                }
                if (!this.federated) {
                    db.createSchema(schemaFile);
                }
            }
            if (db.isPostgres() && this.upgrade && this.iModel.getOldVersion().lessThan(new SwitchVersion("4.2(0)"))) {
                try {
                    db.addDBUser(dbUser, dbPass);
                }
                catch (Exception ex) {
                    logger.error((Object)("Unable to alter user role: " + ex.getMessage()));
                }
            }
            if (!this.federated) {
                try {
                    String fmUser = "admin";
                    String fmPassword = "password";
                    if (this.textMode) {
                        fmUser = this.getArg("-fmuser", "admin");
                        fmPassword = this.getArg("-fmpass", "password");
                    } else {
                        fmUser = this.uPanel.getUser();
                        fmPassword = this.uPanel.getPassword();
                    }
                    logger.warn((Object)"Creating Fabric Manager User");
                    db.createFMUser(fmUser, fmPassword);
                }
                catch (Exception ex) {
                    String message = ex.getMessage();
                    if (message.toLowerCase().contains("duplicate")) {
                        this.msgHelper.showWarning(message);
                    }
                    this.msgHelper.showError("Unable to create user. " + ex.getMessage());
                }
            }
            try {
                boolean federatedNode = Boolean.parseBoolean(this.confProps.getProperty("mds.server.federation", "false"));
                if (!this.upgrade) {
                    this.serverId = db.addClusterNode(clusterAddr);
                    logger.info((Object)("Server cluster ID assigned " + this.serverId));
                } else if (this.iModel.getOldVersion().compareTo(this.VER413) < 0) {
                    this.serverId = db.addClusterNode(clusterAddr);
                    logger.info((Object)("Server cluster ID assigned " + this.serverId));
                } else if (this.iModel.getOldVersion().lessThan(this.VER42) && !federatedNode && !this.isStandalone()) {
                    db.replaceClusterNode(clusterAddr);
                    logger.info((Object)("Server cluster updated with " + clusterAddr));
                }
            }
            catch (SQLException sqle) {
                this.msgHelper.showWarning("Unable to assign cluster ID: " + sqle.getMessage());
            }
            if ((this.reinstall || this.upgrade) && !this.confProps.getProperty("mds.standalone", "false").equalsIgnoreCase("true")) {
                logger.warn((Object)"Stopping services");
                this.iModel.stopServices();
                this.iModel.deleteServices();
            }
            if (this.reinstall) {
                // empty if block
            }
            this.iModel.setLogger(logger);
            if (this.upgrade) {
                this.iModel.backupFiles();
                if (!this.hasStandalone && !this.iModel.isStandalone()) {
                    this.iModel.backupCert();
                }
            }
            if (this.migrateDMFM) {
                try {
                    MoveDMFMTask mTask = new MoveDMFMTask(this.iModel.getOldInstallDir(), this.iModel.getFMDir());
                    mTask.execute();
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to migrate existing FM/DM to new directory.");
                }
            }
            if (this.upgrade || this.reinstall) {
                for (String pgFile : this.pgUtils) {
                    String pgbackup = this.iModel.getOldInstallDir() + SysInfo.FS + "bin" + SysInfo.FS + pgFile + SysInfo.ESUFFIX;
                    Util.copy(pgbackup, pgbackup + "_bak");
                }
            }
            this.iModel.setNIC(this.textMode ? this.getArg("-nic", "0.0.0.0") : this.cPanel.getNIC());
            this.iModel.downloadFiles();
            this.iModel.extractFiles();
            this.iModel.touchOld();
            try {
                this.setupJServer();
            }
            catch (Exception ex) {
                this.msgHelper.showError("Error installing JServer and SMIS: " + ex.getMessage());
            }
            String inPlugFile = this.iModel.getBinDir() + FS + "m9000-lc1-gplug-mz.1.0.3.bin";
            Util.copy(inPlugFile, tftpDir + FS + "m9000-lc1-gplug-mz.1.0.3.bin");
            Util.delete(inPlugFile);
            if (SysInfo.ONWINDOWS) {
                this.iModel.installServerDll();
            }
            if (!this.iModel.isStandalone() && !this.iModel.isUpdater()) {
                this.iModel.installJCE();
            }
            if (!this.upgrade) {
                this.props = Util.loadProps(this.iModel.getConfDir() + FS + "server.properties");
            }
            String dbDriver = this.iModel.isPostgres() ? "org.postgresql.Driver" : "oracle.jdbc.OracleDriver";
            String dbPasswordEncrypted = JBoss_4_2Encrypter.encrypt(dbPass);
            this.props.put("db.driver", dbDriver);
            this.props.put("db.url", dbUrl);
            this.props.put("db.user", dbUser);
            this.props.put("db.password", "#" + dbPasswordEncrypted);
            this.props.put("db.validationquery", this.iModel.isPostgres() ? "select 1" : "select 1 from dual");
            String mode = this.textMode ? this.getArg("-authmode", "local") : this.aPanel.getMode();
            this.props.put("authentication.mode", mode);
            if (mode.equalsIgnoreCase("RADIUS")) {
                server = this.textMode ? this.getArg("-authurl") : this.aPanel.getRadiusPrimaryServer();
                secret = this.textMode ? this.getArg("-authsecret") : this.aPanel.getRadiusPrimarySecret();
                method = AAA.methods[3];
                int authPort = -1;
                int acctPort = -1;
                if (this.textMode) {
                    authPort = Integer.parseInt(this.getArg("-authport"));
                    acctPort = Integer.parseInt(this.getArg("-acctport"));
                } else {
                    authPort = this.aPanel.getAuthPrimaryPort();
                    acctPort = this.aPanel.getAcctPrimaryPort();
                }
                this.props.put("aaa.server.primary.name", server);
                this.props.put("aaa.server.primary.secret", secret);
                this.props.put("aaa.server.primary.auth-method", method);
                this.props.put("radius.server.primary.auth-port", Integer.toString(authPort));
                this.props.put("radius.server.primary.acct-port", Integer.toString(acctPort));
                this.props.put("aaa.server.secondary.name", this.textMode ? this.getArg("-authurl2", this.props.getProperty("aaa.server.secondary.name", "")) : this.aPanel.getRadiusSecondaryServer());
                this.props.put("aaa.server.secondary.secret", this.textMode ? this.getArg("-authsecret2", this.props.getProperty("aaa.server.secondary.secret", "")) : this.aPanel.getRadiusSecondarySecret());
                this.props.put("aaa.server.secondary.auth-method", method);
                this.props.put("radius.server.secondary.auth-port", this.textMode ? this.getArg("-authport2", this.props.getProperty("radius.server.secondary.auth-port", "1812")) : Integer.toString(this.aPanel.getAuthSecondaryPort()));
                this.props.put("radius.server.secondary.acct-port", this.textMode ? this.getArg("-acctport2", this.props.getProperty("radius.server.secondary.acct-port", "1813")) : Integer.toString(this.aPanel.getAcctSecondaryPort()));
                this.props.put("aaa.server.tertiary.name", this.textMode ? this.getArg("-authurl3", this.props.getProperty("aaa.server.tertiary.name", "")) : this.aPanel.getRadiusTertiaryServer());
                this.props.put("aaa.server.tertiary.secret", this.textMode ? this.getArg("-authsecret3", this.props.getProperty("aaa.server.tertiary.secret", "")) : this.aPanel.getRadiusTertiarySecret());
                this.props.put("aaa.server.tertiary.auth-method", method);
                this.props.put("radius.server.tertiary.auth-port", this.textMode ? this.getArg("-authport3", this.props.getProperty("radius.server.tertiary.auth-port", "1812")) : Integer.toString(this.aPanel.getAuthTertiaryPort()));
                this.props.put("radius.server.tertiary.acct-port", this.textMode ? this.getArg("-acctport3", this.props.getProperty("radius.server.tertiary.acct-port", "1813")) : Integer.toString(this.aPanel.getAcctTertiaryPort()));
            } else if (mode.equalsIgnoreCase("TACACS")) {
                server = this.textMode ? this.getArg("-authurl") : this.aPanel.getTacacsPrimaryServer();
                secret = this.textMode ? this.getArg("-authsecret") : this.aPanel.getTacacsPrimarySecret();
                method = AAA.methods[3];
                int port = this.textMode ? Integer.parseInt(this.getArg("-authport", "49")) : this.aPanel.getTacacPrimaryPort();
                this.props.put("aaa.server.primary.name", server);
                this.props.put("aaa.server.primary.secret", secret);
                this.props.put("aaa.server.primary.auth-method", method);
                this.props.put("tacacs.server.primary.port", Integer.toString(port));
                this.props.put("aaa.server.secondary.name", this.textMode ? this.getArg("-authurl2", this.props.getProperty("aaa.server.secondary.name", "")) : this.aPanel.getTacacsSecondaryServer());
                this.props.put("aaa.server.secondary.secret", this.textMode ? this.getArg("-authsecret2", this.props.getProperty("aaa.server.secondary.secret", "")) : this.aPanel.getTacacsSecondarySecret());
                this.props.put("aaa.server.secondary.auth-method", method);
                this.props.put("tacacs.server.secondary.port", this.textMode ? this.getArg("-authport2", this.props.getProperty("tacacs.server.secondary.port", "49")) : Integer.toString(this.aPanel.getTacacSecondaryPort()));
                this.props.put("aaa.server.tertiary.name", this.textMode ? this.getArg("-authurl3", this.props.getProperty("aaa.server.tertiary.name", "")) : this.aPanel.getTacacsTertiaryServer());
                this.props.put("aaa.server.tertiary.secret", this.textMode ? this.getArg("-authsecret3", this.props.getProperty("aaa.server.tertiary.secret", "")) : this.aPanel.getTacacsTertiarySecret());
                this.props.put("aaa.server.tertiary.auth-method", method);
                this.props.put("tacacs.server.tertiary.port", this.textMode ? this.getArg("-authport3", this.props.getProperty("tacacs.server.tertiary.port", "49")) : Integer.toString(this.aPanel.getTacacTertiaryPort()));
            } else if (mode.equalsIgnoreCase("proxy") || mode.equalsIgnoreCase("MDS")) {
                server = this.textMode ? this.getArg("-authurl") : this.aPanel.getSwitchPrimaryIP();
                this.props.put("proxy.mds.primary", server);
                this.props.put("proxy.mds.secondary", this.textMode ? this.getArg("-authurl2", this.props.getProperty("proxy.mds.secondary", "")) : this.aPanel.getSwitchSecondaryIP());
                this.props.put("proxy.mds.tertiary", this.textMode ? this.getArg("-authurl3", this.props.getProperty("proxy.mds.tertiary", "")) : this.aPanel.getSwitchTertiaryIP());
            }
            this.props.put("snmp.v3only", Boolean.toString(this.textMode ? this.existsArg("-disablesnmpv2") : this.cPanel.getSNMPv3()));
            this.props.put("server.port", this.getServerPort());
            if (!this.textMode) {
                this.props.put("fabric.fcalias", Boolean.toString(this.cPanel.useFCAlias()));
                String bindAddress = this.cPanel.getNIC();
                if (bindAddress == null) {
                    bindAddress = "";
                } else if ("0.0.0.0".equals(bindAddress.trim())) {
                    bindAddress = "";
                }
                this.props.put("server.bindaddrs", bindAddress);
            } else {
                this.props.put("fabric.fcalias", Boolean.toString(this.existsArg("-fcalias")));
                String bindaddress = this.getArg("-nic", "");
                if ("0.0.0.0".equals(bindaddress.trim())) {
                    bindaddress = "";
                }
                this.props.put("server.bindaddrs", bindaddress);
            }
            logger.info((Object)"Updating server properties");
            String serverProperty = this.iModel.getConfDir() + FS + "server.properties";
            String properties = this.getArg("-props");
            if (properties != null) {
                this.parseProperties(properties);
            }
            this.props.put("web.port", this.textMode ? this.getArg("-webstart", this.existsArg("-https") ? "443" : "80") : this.cPanel.getWebPort().trim());
            if (this.textMode ? this.existsArg("-https") : this.cPanel.useHTTPS()) {
                this.props.put("mds.web.https", "true");
            } else {
                this.props.put("mds.web.https", "false");
            }
            if (this.federated) {
                Properties dbProps = db.loadProperties();
                this.props.putAll((Map<?, ?>)dbProps);
            } else {
                db.persistProperties(this.props);
            }
            this.props.remove("cdp.includedDevices");
            Util.copy(serverProperty, serverProperty + "_copy");
            Util.updateProperties(serverProperty + "_copy", serverProperty, this.props.keySet().toArray(new String[0]), this.props.values().toArray(new String[0]), true);
            Util.delete(serverProperty + "_copy");
            if (this.upgrade) {
                this.iModel.restoreFiles();
                if (!this.hasStandalone && !this.iModel.isStandalone()) {
                    this.iModel.restoreCert();
                }
            }
            this.configFM(dbUser);
            this.configJBoss(dbUser, dbPasswordEncrypted, dbUrl, dbDriver);
            this.configSA();
            logger.info((Object)"Updating SME server properties");
            String smePropName = this.iModel.getConfDir() + FS + "smeserver.properties";
            Util.copy(smePropName, smePropName + "_copy");
            Util.updateProperties(smePropName + "_copy", smePropName, this.smeProps.keySet().toArray(new String[0]), this.smeProps.values().toArray(new String[0]), true);
            Util.delete(smePropName + "_copy");
            if (this.upgrade) {
                Util.delete(this.iModel.getLibDir() + FS + "patch.jar");
                Util.delete(this.iModel.getFMLibDir() + FS + "patch.jar");
            }
            if (!this.iModel.noServer() && !this.iModel.isStandalone()) {
                if (!SysInfo.ONWINDOWS) {
                    try {
                        this.iModel.enableStartup(this.iModel.getBinDir() + FS + "fmserver", "fmserver");
                    }
                    catch (Exception ex) {
                        this.msgHelper.showWarning("An error has occurred creating startup file: " + ex.getMessage() + "\nCisco Fabric Manager Server may not restart" + "\nautomatically after you reboot your computer.");
                    }
                    try {
                        this.iModel.enableStartup(this.iModel.getBinDir() + FS + "ciscosmis", "ciscosmis");
                    }
                    catch (Exception ex) {
                        this.msgHelper.showWarning("An error has occurred creating startup file: " + ex.getMessage() + "\nCisco Cisco SMI-S Agent may not restart" + "\nautomatically after you reboot your computer.");
                    }
                }
                this.portCon.addUsedPort(Integer.parseInt(this.textMode ? this.getArg("-webstart", Integer.toString(80)) : this.cPanel.getWebPort()));
                this.portCon.addUsedPort(Integer.parseInt(this.textMode ? this.getArg("-serverport", Integer.toString(9099)) : this.cPanel.getServerPort()));
                this.portCon.autoConfigure();
            }
            this.iModel.migratePMData();
            String ojdbc14jarPath = this.iModel.getUserDir() + SysInfo.FS + "endorsed" + SysInfo.FS + "ojdbc14.jar";
            if (!this.iModel.isPostgres() && Util.exists(ojdbc14jarPath)) {
                Util.copy(ojdbc14jarPath, this.iModel.getLibDir() + SysInfo.FS + "ojdbc14.jar");
            }
            if (this.iModel.isStandalone()) {
                HashMap<String, String> dmArgs = new HashMap<String, String>(this.args);
                dmArgs.put("-text", "");
                dmArgs.put("-selfstart", "");
                dmArgs.put("-dir", this.iModel.getInstallDir());
                this.dmi = new DMInstaller(dmArgs);
                this.dmi.setCreateUninstall(false);
                this.dmi.preInstall();
                this.dmi.install();
            } else if (SysInfo.ONWINDOWS) {
                // empty if block
            }
            if (!this.iModel.isStandalone()) {
                String myWebPort;
                String nicAddr = "localhost";
                try {
                    nicAddr = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (Exception ex) {
                    nicAddr = "localhost";
                }
                boolean useHttps = this.textMode ? this.existsArg("-https") : this.cPanel.useHTTPS();
                String serverURL = (useHttps ? "https://" : "http://") + nicAddr;
                String string = this.textMode ? this.getArg("-webstart", useHttps ? "443" : "80") : (myWebPort = this.cPanel.getWebPort());
                if (useHttps && !"443".equals(myWebPort)) {
                    serverURL = serverURL + ":" + myWebPort;
                } else if (!useHttps && !"80".equals(myWebPort)) {
                    serverURL = serverURL + ":" + myWebPort;
                }
                if (!this.existsArg("-nostart")) {
                    boolean isUp = this.startService(serverURL);
                    String downloadURL = serverURL + "/download.do";
                    this.where = "<html>" + (isUp ? "" : "<font color=ff0000><b>Unable to confirm server startup.</b></font>  Please check for errors.  Once server is up, ") + "Fabric Manager (client)" + " and " + "Device Manager" + " are available for download at " + "<a href=\"" + downloadURL + "\">" + downloadURL + "</a>" + ".  " + "Device Manager is also available on MDS." + "</html>";
                    this.startJServer();
                }
            }
            this.backupOldFiles();
            if (!this.iModel.isStandalone()) {
                logger.warn((Object)"Installing client");
                HashMap<String, String> clientArgs = new HashMap<String, String>(this.args);
                clientArgs.put("-text", "");
                clientArgs.put("-selfstart", "");
                clientArgs.put("-dir", this.iModel.getInstallDir());
                this.cInstaller = new ClientInstaller(clientArgs, true, true);
                this.cInstaller.setCreateUninstall(false);
                this.cInstaller.preInstall();
                this.cInstaller.install();
            }
            if (!this.textMode) {
                this.wizard.getNextButton().setText("Finish");
                this.wizard.getNextButton().setEnabled(true);
                this.wizard.getNextButton().revalidate();
                this.wizard.getCancelButton().setEnabled(false);
                this.fPanel.setLaunchVisible(this.iModel.isStandalone());
                if (!this.iModel.isStandalone()) {
                    this.fPanel.setLaunchFMVisible(true);
                    this.fPanel.setGetFMLabel(this.where);
                    this.fPanel.setShortCutText("Create menu items for all users");
                }
                this.wizard.doNext();
                this.pause();
            }
            if (this.iModel.isStandalone()) {
                Util.delete(this.iModel.getDownloadDir());
                Util.delete(this.iModel.getBinDir() + FS + "FabricManager" + SysInfo.ESUFFIX);
                Util.delete(this.iModel.getFMLibDir());
                if (SysInfo.ONWINDOWS) {
                    String fmShortcut = "Cisco Fabric Manager.lnk";
                    Util.delete(Service.getAllDesktop() + SysInfo.FS + fmShortcut);
                    Util.delete(Service.getDesktop() + SysInfo.FS + fmShortcut);
                    fmShortcut = NAME + SysInfo.FS + fmShortcut;
                    Util.delete(Service.getAllStartMenu() + SysInfo.FS + fmShortcut);
                    Util.delete(Service.getStartMenu() + SysInfo.FS + fmShortcut);
                }
            }
            this.createLICProps();
        }
        catch (Exception ex) {
            String msg = "Install encountered a problem. " + (ex.getCause() != null ? ex.getCause() + "." : "");
            if (ex.getMessage() != null) {
                msg = msg + " " + ex.getMessage();
            }
            ex.printStackTrace(System.err);
            msg = msg + "\nAn installation log can be found at " + this.iModel.getUserDir() + FS + "install.log";
            logger.fatal((Object)msg);
            if (!this.textMode) {
                this.msgHelper.showFailure(ex.getMessage());
            }
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupJServer() throws Exception, IOException {
        boolean installServer;
        boolean bl = installServer = this.existsArg("-text") ? this.existsArg("-smis") : this.locPanel.isInstallJServer();
        if (!installServer) {
            return;
        }
        String SMISROOT = this.iModel.getDCMDir() + SysInfo.FS + "smis";
        if (!this.jserverIsInstalled) {
            this.iModel.installJServer(SMISROOT);
            this.jserverIsInstalled = true;
            this.jserverInstallDir = SMISROOT;
        }
        Util.copy(this.iModel.getConfDir() + SysInfo.FS + "smis.properties", this.iModel.getConfDir() + SysInfo.FS + "smis.properties_bak");
        FileInputStream fin = null;
        try {
            String fmPass = this.existsArg("-text") ? this.getArg("-fmpass", "password") : this.uPanel.getPassword();
            fin = new FileInputStream(this.iModel.getConfDir() + SysInfo.FS + "smis.properties_bak");
            Util.copy(fin, this.iModel.getConfDir() + SysInfo.FS + "smis.properties", new String[]{"SMISSERVERADDR", "SMISSERVERHTTPPORT", "SMISSERVERPORT", "MDSNMSPASSWORD", "SMISSERVERSSL"}, new String[]{this.iModel.getNIC(), Integer.toString(this.iModel.getWebStartPort()), this.textMode ? this.getArg("-serverport", Integer.toString(9099)) : this.cPanel.getServerPort(), fmPass, this.iModel.isHTTPS() ? "true" : "false"});
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to write smis.properties");
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            Util.delete(this.iModel.getConfDir() + SysInfo.FS + "smis.properties_bak");
        }
        String JSERVERROOT = SMISROOT + SysInfo.FS + "server" + SysInfo.FS + "jserver";
        String cmon = JSERVERROOT + SysInfo.FS + "bin" + SysInfo.FS + "cimom.properties";
        Util.copy(this.iModel.getConfDir() + SysInfo.FS + "cimom.properties", JSERVERROOT + SysInfo.FS + "bin" + SysInfo.FS + "cimom.properties");
        Util.copy(this.iModel.getConfDir() + SysInfo.FS + "jserver.properties", JSERVERROOT + SysInfo.FS + "bin" + SysInfo.FS + "jserver.properties");
        this.iModel.installSmis(JSERVERROOT);
        Properties props = new Properties();
        props.put("disc.seedip", this.discoverPanel.getSeed());
        props.put("disc.seedip2", this.discoverPanel.getSeed2());
        props.put("disc.username", this.discoverPanel.getUserName());
        String encryptedPass = "#" + JBoss_4_2Encrypter.encrypt(this.discoverPanel.getPassword());
        props.put("disc.password", encryptedPass);
        props.put("disc.protocol", this.discoverPanel.getDigest().toString());
        File discFile = new File(this.iModel.getConfDir() + SysInfo.FS + "discover.Properties_tmp");
        try {
            if (!discFile.exists()) {
                discFile.createNewFile();
            }
            fin = new FileInputStream(discFile);
            Util.updateProperties(discFile.getAbsolutePath(), this.iModel.getConfDir() + SysInfo.FS + "discover.properties", props.keySet().toArray(new String[0]), props.values().toArray(new String[0]), true);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to write discove r properties: " + e.getMessage()));
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            Util.delete(discFile.getAbsolutePath());
        }
    }

    private void startJServer() throws Exception, IOException {
        if (SysInfo.ONWINDOWS) {
            block18: {
                try {
                    if (!Service.isInstalled("CiscoSMIS")) break block18;
                    if (Service.isRunning("CiscoSMIS")) {
                        Service.stop("CiscoSMIS");
                        try {
                            Thread.sleep(40000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (Service.delete("CiscoSMIS")) {
                        String message = "Removing SMI-S JServer";
                        logger.error((Object)message);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                }
            }
            String install = "\"" + this.iModel.getBinDir() + File.separator + "Wrapper.exe\" -i \"" + this.iModel.getConfDir() + SysInfo.FS + "CiscoSMIS" + ".conf\"";
            Process proc = Runtime.getRuntime().exec(install);
            StreamReader oReader = new StreamReader(proc.getInputStream());
            StreamReader eReader = new StreamReader(proc.getErrorStream());
            oReader.start();
            eReader.start();
            int rc = proc.waitFor();
            if (rc != 0) {
                String message = "Starting SMI-S J Server failed: " + rc;
                logger.info((Object)message);
            }
            logger.warn((Object)"Starting SMI-S JServer Service");
            Service.start("CiscoSMIS");
        } else if (SysInfo.ONLINUX) {
            try {
                if (Service.isInstalled("CiscoSMIS") && Service.isRunning("CiscoSMIS")) {
                    Service.stop("CiscoSMIS");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            String script = this.iModel.getBinDir() + File.separator + "CiscoSMIS" + ".sh";
            String[] cmds = new String[]{script, "start"};
            Process proc = Runtime.getRuntime().exec(cmds);
            StreamReader oReader = new StreamReader(proc.getInputStream());
            StreamReader eReader = new StreamReader(proc.getErrorStream());
            oReader.start();
            eReader.start();
            int rc = proc.waitFor();
            if (rc != 0) {
                String message = "Starting CiscoSMIS failed: " + rc;
                logger.error((Object)message);
                throw new Exception(message);
            }
        }
        try {
            Thread.sleep(60000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createLICProps() {
        try {
            String shareDir = this.iModel.getDCMDir() + SysInfo.FS + "share";
            if (Util.mkdir(shareDir)) {
                Properties shareProps = new Properties();
                KeyGenerator keyGenerator = KeyGenerator.getInstance("Blowfish");
                keyGenerator.init(128);
                SecretKey gkey = keyGenerator.generateKey();
                String secret = new String(Base64.encodeBase64((byte[])gkey.getEncoded()));
                shareProps.put("secret", secret);
                shareProps.put("passphrase", "fm" + System.currentTimeMillis());
                this.storeConf(shareDir + SysInfo.FS + "auth.conf", shareProps.keySet().toArray(new String[0]), shareProps.values().toArray(new String[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createDBUser(DB db, String user, String password) throws SQLException {
        if (db.isPostgres()) {
            try {
                db.startTx();
                db.addDBUser(user, password);
                if (!db.existDBSchema(user)) {
                    db.createDBSchema(user, user);
                }
                db.grantDBSchema(user, user);
                db.setDBSearchPath(user, user);
                db.commitTx();
            }
            catch (SQLException e) {
                db.rollbackTx();
                throw e;
            }
            return;
        }
        db.addOracleUser(user, password);
        try {
            db.grantOraclePrivilege(user);
        }
        catch (SQLException ex) {
            try {
                db.delOracleUser(user);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to delete oracle user " + user + ": " + ex.getMessage()));
            }
            throw ex;
        }
    }

    private InetAddress getServerInetAddress() throws UnknownHostException {
        InetAddress clusterAddr;
        if (this.textMode) {
            String nic = this.getArg("-nic");
            if (nic == null || "".equals(nic.trim())) {
                logger.warn((Object)("Binding interface not specified, using " + SysInfo.INET_INFO.getHostAddress()));
                clusterAddr = SysInfo.INET_INFO;
            } else {
                clusterAddr = InetAddress.getByName(nic.trim());
            }
        } else {
            clusterAddr = InetAddress.getByName(this.cPanel.getNIC());
        }
        return clusterAddr;
    }

    private void moveDM() throws Exception {
        SwitchVersion dmSwVersion;
        String dmVersion = this.confProps.getProperty("mds.dm.version");
        if (dmVersion != null && (dmSwVersion = new SwitchVersion(dmVersion)).lessThan(this.VER412) && this.iModel.getOldVersion().lessThan(this.VER412)) {
            try {
                MoveDMFMTask moveTask = new MoveDMFMTask(this.iModel.getOldInstallDir(), this.iModel.getFMDir());
                moveTask.execute();
            }
            catch (Exception ex) {
                logger.error((Object)"Unable to migrate existing FM/DM to new directory.");
            }
        }
    }

    private void enablePGStartup() {
        try {
            this.iModel.enableStartup(this.iModel.getInstallPgDir() + FS + "bin" + FS + "DB", "fmspgsql");
        }
        catch (Exception ex) {
            this.msgHelper.showWarning("An error has occurred creating startup file: " + ex.getMessage() + "\nPostgreSQL may not restart automatically after you reboot your computer.\n");
        }
    }

    private void backupOldFiles() {
        String file2Backup;
        int i;
        String backupDir = this.iModel.getFMDir() + FS + "backup";
        String suffix = SysInfo.ESUFFIX;
        String[] binFiles = new String[]{"FMPersist" + suffix, "FMWebClient" + suffix, "PMUpgrade" + suffix, "hsqlprompt" + suffix, "dbname.backup", "dbname.data", "dbname.script", "dbname.properties", "mdsdb.properties", "server.properties", "dbname.properties.new", "sqltool.rc"};
        String[] deleteFiles = new String[]{"FMWebClient.conf", "FMPersist.conf"};
        String[] inFiles = new String[]{"AAA.properties", "AAA.properties_bak", "FMPersist.log", "FMServer.log", "FMWebClient.log", "emccallhome.properties", "emccallhome.properties_bak", "fmcKS", "fmsKS", "lastver.txt", "log4j_fms.xml", "logging.properties", "server.properties", "server.properties_bak"};
        if (!Util.exists(backupDir)) {
            Util.mkdir(backupDir);
        }
        logger.info((Object)"Backing up files.");
        for (i = 0; i < binFiles.length; ++i) {
            file2Backup = this.iModel.getBinDir() + FS + binFiles[i];
            if (!Util.exists(file2Backup)) continue;
            try {
                Util.copy(file2Backup, backupDir + FS + binFiles[i]);
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to backup " + file2Backup));
            }
            try {
                Util.delete(file2Backup);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to backup " + file2Backup));
            }
        }
        for (i = 0; i < inFiles.length; ++i) {
            file2Backup = this.iModel.getInstallDir() + FS + inFiles[i];
            if (!Util.exists(file2Backup)) continue;
            try {
                Util.copy(file2Backup, backupDir + FS + inFiles[i]);
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to backup " + file2Backup));
            }
            try {
                Util.delete(file2Backup);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to backup " + file2Backup));
            }
        }
        for (i = 0; i < deleteFiles.length; ++i) {
            String file2Delete = this.iModel.getConfDir() + FS + deleteFiles[i];
            if (!Util.exists(file2Delete)) continue;
            try {
                Util.delete(file2Delete);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to delete " + file2Delete));
            }
        }
    }

    void winSetup2(String iDir, String uDir, boolean allUsers) throws IOException {
        String[] links;
        for (String l : links = new String[]{NAME, "Cisco Device Manager", "Cisco Fabric Manager SA", "Uninstall", "Server Properties"}) {
            Util.deleteForce(Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + l + ".lnk");
            Util.deleteForce(Service.getStartMenu() + FS + "Cisco MDS9000" + FS + l + ".lnk");
        }
        String libDir = iDir + FS + "lib";
        String binDir = iDir + FS + "bin";
        String confDir = iDir + FS + "conf";
        String startMenu = allUsers ? Service.getAllStartMenu() : Service.getStartMenu();
        startMenu = startMenu + FS + NAME;
        String desktop = allUsers ? Service.getAllDesktop() : Service.getDesktop();
        logger.debug((Object)("mkdir " + startMenu));
        Util.mkdir(startMenu);
        logger.warn((Object)"Creating shortcuts");
        Shortcut shortcut = new Shortcut(desktop, iDir, libDir, binDir, startMenu);
        if (this.iModel.isStandalone()) {
            shortcut.createFMSALinks();
        } else {
            shortcut.createFMSLinks();
        }
    }

    void winSetup(String iDir, String uDir, boolean allUsers) throws IOException {
        int i;
        String libDir = iDir + FS + "lib";
        String binDir = iDir + FS + "bin";
        String confDir = iDir + FS + "conf";
        String startMenu = allUsers ? Service.getAllStartMenu() : Service.getStartMenu();
        startMenu = startMenu + FS + "Cisco MDS9000";
        String icon = libDir + FS + "mds9000.ico";
        String desktop = allUsers ? Service.getAllDesktop() : Service.getDesktop();
        logger.debug((Object)("Mkdir " + startMenu));
        Util.mkdir(startMenu);
        logger.warn((Object)"Creating shortcuts");
        String notepad = System.getenv("WINDIR") + FS + "System32" + FS + "notepad.exe";
        String launchSP = iDir + FS + "conf" + FS + "server.properties";
        FileOutputStream sFS = new FileOutputStream(binDir + FS + "serverproperties.bat");
        PrintStream printer = new PrintStream(new BufferedOutputStream(sFS));
        printer.println("cls");
        printer.println("@echo off");
        printer.println("\"" + notepad + "\" \"" + launchSP + "\"");
        printer.println("exit");
        printer.close();
        String[] links = new String[]{desktop + FS + "Cisco Fabric Manager SA" + ".lnk", binDir + FS + "FabricManagerSA.bat", "Cisco Fabric Manager SA", startMenu + FS + "Cisco Fabric Manager SA" + ".lnk", binDir + FS + "FabricManagerSA.bat", "Cisco Fabric Manager SA", startMenu + FS + "Server Properties.lnk", launchSP, "Server Properties", startMenu + FS + "Uninstall.lnk", iDir + FS + "Uninstall.bat", "Uninstall"};
        int n = i = this.iModel.isStandalone() ? 0 : 6;
        while (i < links.length) {
            Service.createLink(links[i++], links[i++], links[i], iDir, icon);
            ++i;
        }
        logger.info((Object)"Building Uninstall.bat");
        String winUnins = iDir + FS + "Uninstall.bat";
        FileOutputStream fs = new FileOutputStream(winUnins);
        PrintStream ps = new PrintStream(new BufferedOutputStream(fs));
        ps.println("cls");
        ps.println("@echo off");
        ps.println("rem Auto-Generated Cisco MDS9000 Installer.");
        ps.println("set /p unanswer=Are you sure you want to Uninstall? Press 'Y' to uninstall, 'A' to remove all files or 'N' to exit. [Y/A/N] ");
        ps.println("IF /i %unanswer% EQU n ( exit )");
        ps.println("IF /i %unanswer% EQU Y ( echo Uninstalling... ) else ( ");
        ps.println("IF /i %unanswer% EQU A ( echo Uninstalling... ) else ( ");
        ps.println("echo Nothing to do...quiting && exit )");
        ps.println(")");
        if (this.installPostgreSQL) {
            ps.println("set /p panswer=Would you like to remove PostgreSQL? [Y/N] ");
        }
        ps.println("echo Stopping services...");
        ps.println("net stop SAN Server");
        ps.println("\"" + binDir + FS + "Wrapper.exe\" -r \"" + confDir + FS + "SAN Server" + ".conf\"");
        if (this.installPostgreSQL) {
            ps.println("IF /i %panswer% EQU Y (  ");
            ps.println("net stop pgsql-8.2");
            ps.println("msiexec /x \"" + this.iModel.getUserDir() + FS + "postgres-win" + FS + "postgresql-8.2-int.msi\" /qn");
            ps.println("net user /delete postgres");
            ps.println(")");
        }
        ps.println("echo Removing shortcuts...");
        ps.println("del \"" + Service.getAllDesktop() + FS + "Cisco Device Manager" + ".lnk\"");
        ps.println("del \"" + Service.getDesktop() + FS + "Cisco Device Manager" + ".lnk\"");
        ps.println("del \"" + Service.getAllDesktop() + FS + "Cisco Fabric Manager SA" + ".lnk\"");
        ps.println("del \"" + Service.getDesktop() + FS + "Cisco Fabric Manager SA" + ".lnk\"");
        ps.println("del \"" + Service.getStartMenu() + FS + "Cisco MDS9000" + FS + "Cisco Device Manager" + ".lnk\"");
        ps.println("del \"" + Service.getStartMenu() + FS + "Cisco MDS9000" + FS + "Cisco Fabric Manager SA" + ".lnk\"");
        ps.println("del \"" + Service.getStartMenu() + FS + "Cisco MDS9000" + FS + "Uninstall.lnk\"");
        ps.println("del \"" + Service.getStartMenu() + FS + "Cisco MDS9000" + FS + "Server Properties.lnk\"");
        ps.println("del \"" + Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + "Cisco Device Manager" + ".lnk\"");
        ps.println("del \"" + Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + "Cisco Fabric Manager SA" + ".lnk\"");
        ps.println("del \"" + Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + "Uninstall.lnk\"");
        ps.println("del \"" + Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + "Server Properties.lnk\"");
        ps.println("echo Removing Files...");
        ps.println("rmdir /s /q \"" + startMenu + "\"");
        ps.println("del \"" + iDir + FS + "install.conf\"");
        ps.println("del \"" + uDir + FS + "install.conf\"");
        ps.println("del \"" + iDir + FS + "README.txt\"");
        ps.println("del \"" + iDir + FS + "logs" + FS + "sme.log\"");
        ps.println("rmdir /s /q \"" + uDir + FS + "bin\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "jboss-4.2.2.GA\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "bin\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "lib\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "conf\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "help\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "download\"");
        if (this.existsArg("-bundleVM")) {
            ps.println("rmdir /s /q \"" + iDir + FS + "jre\"");
        }
        ps.println("IF /i %unanswer% EQU A ( ");
        ps.println("echo Removing directories ...");
        ps.println("rmdir /s /q \"" + iDir + FS + "reports\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "db\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "logs\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "pm\"");
        ps.println("rmdir /s /q \"" + iDir + FS + "backup\"");
        ps.println("rmdir /s /q \"" + uDir + "\"");
        ps.println(")");
        ps.println("echo Uninstall complete...");
        ps.println("del \"" + iDir + FS + "Uninstall.bat\"");
        ps.println("exit");
        ps.close();
    }

    protected void unixSetup(String iDir, String uDir) throws Exception {
        String dir;
        String binDir = iDir + FS + "bin";
        String unixUnins = iDir + FS + "Uninstall.sh";
        FileOutputStream fs = new FileOutputStream(unixUnins);
        PrintStream ps = new PrintStream(new BufferedOutputStream(fs));
        ps.println("#!/bin/sh");
        ps.println("# WARNING !!!");
        ps.println("# File generated by Cisco MDS9000 Installer.");
        ps.println("# Might get overwritten in next upgrade.");
        ps.println("# ");
        ps.println("if [ \"X`echo -n`\" = \"X-n\" ]; then");
        ps.println("echo_n() { echo ${1+\"$@\"}\"\\c\"; }");
        ps.println("else");
        ps.println("echo_n() { echo -n ${1+\"$@\"}; }");
        ps.println("fi");
        ps.println("removepg=b");
        ps.println("PID=1");
        ps.println("getPgPid(){");
        ps.println("PID=`ps -ef | grep postgres | grep -v grep | awk '{print $2}' | tail -1`");
        ps.println("}");
        ps.println("echo_n \"Are you sure you want to Uninstall? Press 'Y' to uninstall, 'A' to remove all files or 'N' to exit. [Y/A/N] \"");
        ps.println("read unanswer");
        ps.println("case $unanswer in");
        ps.println("\"Y\")");
        ps.println(";;");
        ps.println("\"y\")");
        ps.println(";;");
        ps.println("\"N\")");
        ps.println("exit 0;");
        ps.println(";;");
        ps.println("\"n\")");
        ps.println("exit 0;");
        ps.println(";;");
        ps.println("\"A\")");
        ps.println(";;");
        ps.println("\"a\")");
        ps.println(";;");
        ps.println("*)");
        ps.println("exit 1;");
        ps.println(";;");
        ps.println("esac");
        String dbScript = this.iModel.getInstallPgDir() + FS + "bin" + FS + "DB";
        if ((this.upgrade || this.reinstall) && (dir = this.confProps.getProperty("mds.db.dir")) != null && Util.exists(dir)) {
            dbScript = dir + FS + "db" + FS + "bin" + FS + "DB";
            this.iModel.setInstallPgDir(dir);
        }
        ps.println("if [ -f \"" + dbScript + "\" ]");
        ps.println("then");
        ps.println("echo_n \"Would you like to uninstall PostgreSQL? [Y/N] \"");
        ps.println("read removepg");
        ps.println("fi");
        ps.println(binDir + FS + "SAN Server" + ".sh stop");
        ps.println("rm -f " + iDir + FS + "install.conf 2>/dev/null");
        ps.println("rm -f " + uDir + FS + "install.conf 2>/dev/null");
        ps.println("rm -f " + iDir + FS + "dbname.* 2>/dev/null");
        ps.println("rm -f " + iDir + FS + "README.txt");
        ps.println("rm -f " + iDir + FS + "logs" + FS + "sme.log");
        ps.println("rm -rf " + uDir + FS + "bin");
        ps.println("rm -rf " + iDir + FS + "jboss-4.2.2.GA");
        ps.println("rm -rf " + iDir + FS + "bin");
        ps.println("rm -rf " + iDir + FS + "lib");
        ps.println("rm -rf " + iDir + FS + "conf");
        ps.println("rm -rf " + iDir + FS + "help");
        ps.println("rm -rf " + iDir + FS + "download");
        if (this.existsArg("-bundleVM")) {
            ps.println("rm -rf " + iDir + FS + "jre");
        }
        ps.println("if [ $removepg = \"y\" -o $removepg = \"Y\" ]; then");
        this.removeStartup(ps, "fmspgsql");
        ps.println(dbScript + " stop 2> /dev/null");
        ps.println("while [ \"$PID\" != \"\" ] ");
        ps.println("do");
        ps.println("getPgPid");
        ps.println("kill -9 $PID 2> /dev/null");
        ps.println("getPgPid");
        ps.println("done");
        ps.println("rm -f /tmp/.s.PGSQL.* 2> /dev/null");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "bin");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "data");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "doc");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "include");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "info");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "lib");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "man");
        ps.println("rm -rf " + this.iModel.getInstallPgDir() + FS + "pgsql");
        ps.println("fi");
        ps.println("if [ $unanswer = \"a\" -o $unanswer = \"A\" ]; then ");
        ps.println("rm -rf " + uDir);
        ps.println("rm -rf " + iDir + FS + "pm");
        ps.println("rm -rf " + iDir + FS + "logs");
        ps.println("rm -rf " + iDir + FS + "reports");
        ps.println("rm -rf " + iDir + FS + "backup");
        ps.println("fi");
        if (!this.iModel.isStandalone() && !this.iModel.noServer()) {
            this.removeStartup(ps, "fmserver");
            if (this.jserverIsInstalled) {
                this.removeStartup(ps, "ciscosmis");
            }
        }
        ps.println("rm -f " + iDir + FS + "Uninstall.sh");
        ps.close();
        logger.info((Object)"Setting exec permission on *.sh");
        Util.createExec(iDir + FS + "bin");
        String addUserFile = iDir + FS + "bin" + FS + "addUser.sh";
        Util.chmod(addUserFile, "u=rwx");
        Util.chmod(addUserFile, "o=");
        Util.chmod(addUserFile, "g=");
        Util.createExec(iDir, "Uninstall.sh");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    protected void unixSetup2(String iDir, String uDir) throws Exception {
        String binDir = iDir + FS + "bin";
        String unixUnins = iDir + FS + "Uninstall.sh";
        logger.info((Object)"Setting exec permission on *.sh");
        Util.createExec(iDir + FS + "bin");
        String addUserFile = iDir + FS + "bin" + FS + "addUser.sh";
        Util.chmod(addUserFile, "u=rwx");
        Util.chmod(addUserFile, "o=");
        Util.chmod(addUserFile, "g=");
        Util.createExec(iDir, "Uninstall.sh");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private void removeStartup(PrintStream ps, String name) {
        String file;
        if (SysInfo.ONWINDOWS) {
            return;
        }
        for (String link : SysInfo.STARTDIR) {
            file = link + FS + "S85" + name;
            if (Util.exists(file)) {
                ps.println("rm -rf " + file);
            }
            if (Util.exists(file = link + FS + "S86" + name)) {
                ps.println("rm -rf " + file);
            }
            if (!Util.exists(file = link + FS + "S84" + name)) continue;
            ps.println("rm -rf " + file);
        }
        for (String link : SysInfo.STOPDIR) {
            file = link + FS + "K03" + name;
            if (!Util.exists(file)) continue;
            ps.println("rm -rf " + file);
        }
        String initDir = FS + "etc" + FS + "init.d";
        if (SysInfo.ONLINUX && Util.exists(FS + "etc" + FS + "rc.d" + FS + "init.d")) {
            initDir = FS + "etc" + FS + "rc.d" + FS + "init.d";
        }
        if (Util.exists(initDir + FS + name)) {
            ps.println("rm -rf " + initDir + FS + name);
        }
    }

    public void jserverd(String jserverRoot, String arg) throws Exception {
        String JSERVER_BIN = jserverRoot + SysInfo.FS + "bin";
        String DAEMON = JSERVER_BIN + SysInfo.FS + (SysInfo.ONWINDOWS ? "jserverd.exe" : "jserverd");
        String[] cmds = new String[]{DAEMON, arg};
        int rc = 0;
        Process proc = Runtime.getRuntime().exec(cmds);
        StreamReader oReader = new StreamReader(proc.getInputStream());
        StreamReader eReader = new StreamReader(proc.getErrorStream());
        oReader.start();
        eReader.start();
        rc = proc.waitFor();
        if (rc != 0) {
            throw new Exception("Unable to install JServer " + (SysInfo.ONWINDOWS ? "service." : "daemon."));
        }
    }

    public boolean startService(String serverURL) throws Exception {
        FMInstaller.startServer(this.iModel.getBinDir(), this.iModel.getConfDir());
        int tryNum = 9;
        boolean connected = false;
        boolean isUp = false;
        if (serverURL.startsWith("https")) {
            System.setProperty("java.protocol.handler.pkgs", "javax.net.ssl");
            Security.addProvider((java.security.Provider)new Provider());
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            KeyManager[] km = null;
            TrustManager[] tma = new TrustManager[]{tm};
            SSLContext sc = SSLContext.getInstance("ssl");
            sc.init(km, tma, new SecureRandom());
            SSLSocketFactory sf = sc.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sf);
        }
        URLConnection conn = null;
        URL url = new URL(serverURL);
        while (!connected && tryNum > 0) {
            try {
                conn = url.openConnection();
                conn.setReadTimeout(10000);
                conn.connect();
                connected = true;
            }
            catch (Exception ex) {
                try {
                    logger.info((Object)"Waiting for server to start...");
                    Thread.sleep(30000L);
                }
                catch (Exception wake) {
                    // empty catch block
                }
            }
            --tryNum;
        }
        url = new URL(serverURL + "/download/fabric-manager.jnlp");
        while (connected && !isUp && tryNum > 0) {
            try {
                conn = url.openConnection();
                conn.setReadTimeout(10000);
                conn.connect();
                InputStream is = conn.getInputStream();
                if (is != null) {
                    isUp = true;
                    is.close();
                }
            }
            catch (Exception ex) {
                try {
                    if (tryNum > 0) {
                        logger.info((Object)"Waiting for server to start...");
                        Thread.sleep(30000L);
                    }
                }
                catch (Exception wake) {
                    // empty catch block
                }
            }
            --tryNum;
        }
        if (!isUp) {
            logger.info((Object)"Starting server time out.");
        } else {
            logger.info((Object)"Server is up.");
        }
        return isUp;
    }

    public static void startServer(String binDir, String confDir) throws IOException, InterruptedException, Exception {
        if (SysInfo.ONWINDOWS) {
            block17: {
                try {
                    if (!Service.isInstalled("SAN Server")) break block17;
                    if (Service.isRunning("SAN Server")) {
                        Service.stop("SAN Server");
                        try {
                            Thread.sleep(40000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (Service.delete("SAN Server")) {
                        String message = "Removing SAN Server";
                        logger.error((Object)message);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                }
            }
            String install = "\"" + binDir + File.separator + "Wrapper.exe\" -i \"" + confDir + SysInfo.FS + "SAN Server" + ".conf\"";
            Process proc = Runtime.getRuntime().exec(install);
            StreamReader oReader = new StreamReader(proc.getInputStream());
            StreamReader eReader = new StreamReader(proc.getErrorStream());
            oReader.start();
            eReader.start();
            int rc = proc.waitFor();
            if (rc != 0) {
                String message = "Starting SAN Server failed: " + rc;
                logger.info((Object)message);
            }
            logger.warn((Object)"Starting SAN Server Service");
            Service.start("SAN Server");
        } else {
            try {
                if (Service.isInstalled("SAN Server") && Service.isRunning("SAN Server")) {
                    Service.stop("SAN Server");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            String script = binDir + File.separator + "SAN Server" + ".sh";
            String[] cmds = new String[]{script, "start"};
            Process proc = Runtime.getRuntime().exec(cmds);
            StreamReader oReader = new StreamReader(proc.getInputStream());
            StreamReader eReader = new StreamReader(proc.getErrorStream());
            oReader.start();
            eReader.start();
            int rc = proc.waitFor();
            if (rc != 0) {
                String message = "Starting SAN Server failed: " + rc;
                logger.error((Object)message);
                throw new Exception(message);
            }
        }
        try {
            Thread.sleep(60000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generateKS(String ks, String keypass) throws Exception {
        String keytool = System.getProperty("java.home") + FS + "bin" + FS + "keytool";
        String fmServerCert = this.iModel.getDownloadDir() + FS + "fmserver.cert";
        String alias = "sme";
        if (SysInfo.ONWINDOWS) {
            keytool = keytool + ".exe";
        }
        Util.delete(ks);
        String ha = "localhost";
        try {
            ha = InetAddress.getLocalHost().getCanonicalHostName();
            String ipaddress = InetAddress.getLocalHost().getHostAddress();
            if (ipaddress.equals(ha)) {
                ha = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException uhe) {
            logger.error((Object)("Unknown host. Creating keystore with " + ha + ". May cause security alerts during Fabric Manager (client) download."));
        }
        String genArg = "-genkey -alias " + alias + " -keystore \"" + ks + "\" -storepass " + keypass + " -keypass " + keypass + " -keyalg RSA";
        String dname = "-dname \"CN=" + ha + ", OU=Data Center, O=Cisco Systems, L=San Jose, S=CA, C=US\"";
        String cmd = keytool + " " + genArg + " " + dname;
        String[] cmdArray = new String[]{keytool, "-genkey", "-alias", alias, "-keystore", ks, "-storepass", keypass, "-keypass", keypass, "-keyalg", "RSA", "-dname", "CN=" + ha + ", OU=Data Center, O=Cisco Systems, L=San Jose, S=CA, C=US", "-validity", "10000"};
        int rc = Runtime.getRuntime().exec(cmdArray).waitFor();
        if (rc != 0) {
            logger.error((Object)(cmd + " executed unsuccesfully."));
        }
        if (!Util.exists(ks)) {
            throw new Exception(ks + " doesn't exists.");
        }
        String signArg = "-selfcert -alias " + alias + " -keystore \"" + ks + "\" -storepass " + keypass + " -keypass " + keypass;
        cmd = keytool + " " + signArg;
        String[] cmdArray2 = new String[]{keytool, "-selfcert", "-alias", alias, "-keystore", ks, "-storepass", keypass, "-keypass", keypass, "-validity", "10000"};
        rc = Runtime.getRuntime().exec(cmdArray2).waitFor();
        if (rc != 0) {
            logger.error((Object)(cmd + " executed unsuccesfully."));
        }
        if (!Util.exists(ks)) {
            throw new Exception(ks + " doesn't exists.");
        }
        if (Util.exists(fmServerCert)) {
            Util.delete(fmServerCert);
        }
        cmd = keytool + " " + " -export -alias " + alias + " -file \"" + fmServerCert + "\" -keystore \"" + ks + "\" -storepass " + keypass;
        String[] cmdArray3 = new String[]{keytool, "-export", "-alias", alias, "-file", fmServerCert, "-keystore", ks, "-storepass", keypass};
        rc = Runtime.getRuntime().exec(cmdArray3).waitFor();
        if (rc != 0) {
            logger.error((Object)(cmd + " executed unsuccesfully."));
        }
        if (!Util.exists(fmServerCert)) {
            logger.error((Object)"fmserver.cert was not properly exported for download");
        }
    }

    private void createKeyStore(String ks, String ca, String keypass) throws Exception {
        if (!Util.exists(ca)) {
            throw new Exception(ca + " doesn't exists.");
        }
        String keytool = System.getProperty("java.home") + FS + "bin" + FS + "keytool";
        if (SysInfo.ONWINDOWS) {
            keytool = keytool + ".exe";
        }
        String ha = "localhost";
        try {
            ha = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            logger.error((Object)("Unknown host. Creating keystore with " + ha + ". May cause security alerts during FM Client download."));
        }
        Util.delete(ks);
        String genkey = "-genkey -keystore \"" + ks + "\" -dname \"CN=" + ha + ", OU=Data Center, O=Cisco Systems, L=San Jose, S=CA, C=US\" -keypass " + keypass + " -storepass " + keypass;
        String cmd = keytool + " " + genkey;
        logger.debug((Object)(cmd + "\n"));
        int rc = Runtime.getRuntime().exec(cmd).waitFor();
        if (rc != 0) {
            logger.error((Object)(cmd + " executed unsuccesfully."));
        }
        if (!Util.exists(ks)) {
            throw new Exception(ks + " doesn't exists.");
        }
        String del = "-delete -keystore \"" + ks + "\" -alias mykey -storepass " + keypass;
        cmd = keytool + " " + del;
        logger.debug((Object)(cmd + "\n"));
        rc = Runtime.getRuntime().exec(cmd).waitFor();
        if (rc != 0) {
            logger.error((Object)(cmd + " executed unsuccesfully."));
        }
        if (!Util.exists(ks)) {
            throw new Exception(ks + " doesn't exists.");
        }
        String importArg = "-import -v -noprompt -alias " + ha + " -file \"" + ca + "\" -keystore \"" + ks + "\" -keypass " + keypass + " -storepass " + keypass;
        cmd = keytool + " " + importArg;
        logger.debug((Object)(cmd + "\n"));
        rc = Runtime.getRuntime().exec(cmd).waitFor();
        if (rc != 0) {
            logger.error((Object)(cmd + " executed unsuccesfully."));
        }
        if (!Util.exists(ks)) {
            throw new Exception(ks + " doesn't exists.");
        }
    }

    private void configFM(String dbUser) {
        try {
            if (this.upgrade || this.reinstall) {
                for (String pgFile : this.pgUtils) {
                    String pgbackup = this.iModel.getOldInstallDir() + SysInfo.FS + "bin" + SysInfo.FS + pgFile + SysInfo.ESUFFIX;
                    String tPgbackup = this.iModel.getFMDir() + SysInfo.FS + "bin" + SysInfo.FS + pgFile + SysInfo.ESUFFIX;
                    Util.copy(pgbackup + "_bak", tPgbackup);
                    Util.delete(pgbackup + "_bak");
                }
            } else {
                for (String file : this.pgUtils) {
                    String bakFile = this.iModel.getBinDir() + FS + file + SysInfo.ESUFFIX + "_bak";
                    String myFile = this.iModel.getBinDir() + FS + file + SysInfo.ESUFFIX;
                    try {
                        Util.copy(myFile, bakFile);
                        Util.copy(new FileInputStream(bakFile), myFile, new String[]{"MDSNMSDBHOME", "MDSNMSDBUSER"}, new String[]{this.iModel.getDBDir(), dbUser});
                        Util.delete(bakFile);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to config FM: " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configSA() {
        if (!this.iModel.isStandalone()) {
            return;
        }
        String[] names = new String[]{"MDSNMSDBDIALECT"};
        String[] values = new String[]{this.iModel.isPostgres() ? "PostgreSQLDialect" : "Oracle9Dialect"};
        FileInputStream fin = null;
        String meta = this.iModel.getConfDir() + FS + "META-INF";
        try {
            fin = new FileInputStream(this.iModel.getTmpDir() + FS + "persistence.xml");
            logger.warn((Object)"Writing persistence.xml");
            Util.mkdir(meta);
            Util.copy(fin, meta + FS + "persistence.xml", names, values);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to close file handler");
                }
            }
            Util.delete(this.iModel.getDCMDir() + FS + "persistence.xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configJBoss(String dbUser, String dbPass, String dbUrl, String dbDriver) throws Exception {
        boolean isOracle;
        String HTTPToken;
        String HTTPSToken;
        String caFile;
        if (this.iModel.isStandalone()) {
            return;
        }
        logger.warn((Object)"Configuring JBoss");
        String keyStore = "fmserver.jks";
        String certFile = "fmserver.cert";
        String trustStore = "fmtrust.jks";
        String keyPass = "fmserver_1_2_3";
        String dest = this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "conf";
        boolean isSelfSigned = this.textMode ? this.existsArg("-https") : this.cPanel.isSelfSigned();
        String string = caFile = this.textMode ? null : this.cPanel.getCAFile();
        if (this.iModel.isHTTPS()) {
            if (isSelfSigned) {
                try {
                    this.handleKeyStore(dest, keyStore, trustStore, certFile);
                }
                catch (Exception e) {
                    logger.warn((Object)"Generating self-signed cert failed, using predefined keystore.");
                    Util.copy(this.iModel.getConfDir() + FS + "cert" + FS + keyStore, dest + FS + keyStore);
                    Util.copy(this.iModel.getConfDir() + FS + "cert" + FS + keyStore, dest + FS + trustStore);
                    Util.copy(this.iModel.getConfDir() + FS + "cert" + FS + "fmserver.cert", this.iModel.getDownloadDir() + FS + "fmserver.cert");
                }
            } else {
                logger.info((Object)"Importing CA file");
                this.createKeyStore(dest + FS + keyStore, caFile, keyPass);
                Util.copy(caFile, this.iModel.getDownloadDir() + FS + "cert");
            }
            HTTPSToken = " ";
            HTTPToken = "-->";
        } else {
            HTTPSToken = "-->";
            HTTPToken = " ";
            Util.copy(this.iModel.getConfDir() + FS + "cert" + FS + keyStore, dest + FS + keyStore);
            Util.copy(this.iModel.getConfDir() + FS + "cert" + FS + trustStore, dest + FS + trustStore);
        }
        String[] names = new String[]{"MDSWEBSTART", "MDSWEBSTOP", "MDSPMROOT", "MDSREPORTROOT", "MDSNMSROOT", "MDSNMSLIBROOT", "MDSNMSHELPROOT", "MDSNMSUSEHTTP", "MDSNMSUSESSLHTTP", "MDSNMSWEBKS", "MDSNMSWEBKP"};
        String[] values = new String[]{Integer.toString(this.iModel.getWebStartPort()), Integer.toString(this.iModel.getWebStopPort()), this.iModel.getPmDir(), this.iModel.getReportDir(), this.iModel.getFMDir(), this.iModel.getDownloadDir(), this.iModel.getHelpDir(), HTTPToken, HTTPSToken, keyStore, keyPass};
        String serverFile = this.iModel.getDCMDir() + FS + this.serverXml;
        try (FileInputStream fin = null;){
            fin = new FileInputStream(this.iModel.getTmpDir() + FS + "server.xml.in");
            logger.warn((Object)"Writing server.xml");
            Util.copy(fin, serverFile, names, values);
        }
        names = new String[]{"MDSNMSDBDIALECT"};
        values = new String[]{this.iModel.isPostgres() ? "PostgreSQLDialect" : "Oracle9Dialect"};
        try {
            fin = new FileInputStream(this.iModel.getTmpDir() + FS + "persistence_dcm.xml");
            logger.warn((Object)"Writing persistence.xml");
            Util.copy(fin, this.iModel.getDCMDir() + FS + this.persistenceXml, names, values);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            Util.delete(this.iModel.getDCMDir() + FS + this.persistenceXml + ".in");
        }
        names = new String[]{"MDSNMSSERVERPORT"};
        values = new String[]{this.textMode ? this.getArg("-serverport", Integer.toString(9099)) : this.cPanel.getServerPort()};
        String jbossTmpFile = this.iModel.getTmpDir() + FS + "jboss-service.xml";
        try {
            fin = new FileInputStream(jbossTmpFile);
            logger.warn((Object)"Writing jboss-service.xml");
            Util.copy(fin, this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "conf" + FS + "jboss-service.xml", names, values);
        }
        catch (IOException ioe) {
            logger.error((Object)("Unable to config server port. Using default, but server.properties MAY be out of sync. " + ioe.getMessage()));
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        String jmsConfFile = "";
        jmsConfFile = this.iModel.isPostgres() ? this.iModel.getConfDir() + FS + "postgres-jdbc2-service.xml" : this.iModel.getConfDir() + FS + "oracle-jdbc2-service.xml";
        String jsmDestFile = this.iModel.getDCMDir() + FS + this.jmsDsXml;
        logger.info((Object)("copy " + jmsConfFile + " to " + this.jmsDsXml));
        Util.copy(jmsConfFile, jsmDestFile);
        Util.copy(this.iModel.getTmpDir() + FS + "quartz-service.xml", this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "deploy" + FS + "quartz-service.xml");
        Util.copy(this.iModel.getTmpDir() + FS + "security-service.xml", this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "deploy" + FS + "security-service.xml");
        Util.copy(this.iModel.getTmpDir() + FS + "fmserver-ds.xml", this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "deploy" + FS + "fmserver-ds.xml");
        Util.copy(this.iModel.getTmpDir() + FS + "jboss-log4j.xml", this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "conf" + FS + "jboss-log4j.xml");
        Util.copy(this.iModel.getTmpDir() + FS + "ejb3-interceptors-aop.xml", this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "deploy" + FS + "ejb3-interceptors-aop.xml");
        Util.copy(this.iModel.getTmpDir() + FS + "jbossmq-destinations-service.xml", this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "deploy" + FS + "jms" + FS + "jbossmq-destinations-service.xml");
        logger.info((Object)"Updating Datasource Configuration");
        String dsFile = this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "deploy" + FS + "fmserver-ds.xml";
        String ds = this.iModel.getTmpDir() + FS + "fmserver-ds.xml";
        Util.chmod(dsFile, "g+w");
        Util.copy(new FileInputStream(ds), dsFile, new String[]{"MDSNMSDBURL", "MDSNMSDBDRIVER", "MDSNMSDBVALIDATION"}, new String[]{dbUrl, dbDriver, this.iModel.isPostgres() ? "select 1" : "select 1 from dual"});
        String qsFile = this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "deploy" + FS + "quartz-service.xml";
        String qService = this.iModel.getTmpDir() + FS + "quartz-service.xml";
        Util.chmod(qsFile, "g+w");
        Util.chmod(qService, "g+w");
        Util.copy(new FileInputStream(qService), qsFile, new String[]{"MDSNMSDBDELEGATE"}, new String[]{this.iModel.isPostgres() ? "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate" : "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate"});
        String loginFile = this.iModel.getJBossDir() + FS + "server" + FS + "fm" + FS + "conf" + FS + "login-config.xml";
        String loginConfig = this.iModel.getTmpDir() + FS + "login-config.xml";
        Util.chmod(loginFile, "g+w");
        Util.chmod(loginConfig, "g+w");
        Util.copy(new FileInputStream(loginConfig), loginFile, new String[]{"MDSNMSDBUSER", "MDSNMSDBPASSWORD"}, new String[]{dbUser, dbPass});
        boolean bl = this.textMode ? this.existsArg("-useoracle") : (isOracle = !this.dbPanel.isPostgres());
        if (isOracle) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyStore(String dest, String keyStore, String trustStore, String certName) throws Exception {
        try (DB db = null;){
            File fmcaHandle;
            logger.info((Object)"Generating certificate");
            String fmca = dest + SysInfo.FS + "fmca.jks";
            String cn = "localhost";
            try {
                cn = InetAddress.getLocalHost().getCanonicalHostName();
                String ipaddress = InetAddress.getLocalHost().getHostAddress();
                if (ipaddress.equals(cn)) {
                    cn = InetAddress.getLocalHost().getHostName();
                }
                cn = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException uhe) {
                logger.error((Object)("Unknown host. Creating keystore with " + cn + ". May cause security alerts during Fabric Manager (client) download."));
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to get CN: " + ex.getMessage()));
            }
            String SME = "sme";
            String oldKs = dest + SysInfo.FS + keyStore;
            String fmserverKS = dest + SysInfo.FS + keyStore;
            String fmCert = dest + SysInfo.FS + certName;
            String dbUrl = this.getDbURL();
            String rdbms = this.getRDBMS(dbUrl);
            db = new DB(rdbms, dbUrl, this.getDbUser(), this.getDbPass());
            if (this.federated) {
                if (!this.upgrade) {
                    fmcaHandle = db.getFMCA("fmca", fmca);
                    if (fmcaHandle.exists()) {
                        Certificate cert = TrustTool.getCert(fmca, "sme", "fmserver_1_2_3");
                        TrustTool.export(cert, new File(fmCert), true);
                        TrustTool.createKSWithCA(fmca, cn, new File(fmserverKS));
                    } else {
                        logger.error((Object)"Error retreiving fmca from database...creating new keyStore.");
                        logger.info((Object)"This federation will be using multiple certs.");
                        Certificate c = TrustTool.generateSSKS(cn, new File(fmserverKS));
                        TrustTool.export(c, new File(fmCert), true);
                    }
                }
            } else if (!this.upgrade) {
                fmcaHandle = new File(fmca);
                Certificate cert = TrustTool.generateSSKS(cn, fmcaHandle);
                TrustTool.export(cert, new File(fmCert), true);
                if (!this.persistKeyStore("sme", fmca, db)) {
                    logger.error((Object)("Unable to persist " + fmca));
                }
                TrustTool.createKSWithCA(fmca, cn, new File(fmserverKS));
                if (!this.persistKeyStore("sme", fmca, db)) {
                    logger.error((Object)"Unable to persist fmca.");
                }
            } else if (!this.iModel.getOldVersion().isUnknown() && this.iModel.getOldVersion().lessThan(new SwitchVersion("4.2(0)")) && Util.exists(oldKs)) {
                KeyStore ks = TrustTool.loadKeyStore(oldKs);
                if (!ks.containsAlias("sme") || !ks.isKeyEntry("sme")) {
                    File fmcaHandle2 = new File(fmca);
                    Certificate cert = TrustTool.generateSSKS(cn, fmcaHandle2);
                    TrustTool.export(cert, new File(fmCert), true);
                } else {
                    logger.info((Object)("Copying " + oldKs + " to " + fmca));
                    Util.copy(oldKs, fmca);
                }
                if (!this.persistKeyStore("sme", fmca, db)) {
                    logger.error((Object)("Unable to persist " + fmca));
                }
            }
            if (Util.exists(fmCert)) {
                try {
                    Util.copy(fmCert, this.iModel.getDownloadDir() + FS + certName);
                }
                catch (Exception ex) {
                    logger.error((Object)("Unable to place " + fmCert + " in download: " + ex.getMessage()));
                }
            }
            if (Util.exists(fmserverKS)) {
                String trustStorePath = dest + FS + trustStore;
                if (Util.exists(trustStorePath)) {
                    logger.info((Object)"Adding fmca cert to truststore");
                    TrustTool.importX509Cert(trustStorePath, fmCert, "fmca");
                } else {
                    logger.info((Object)"Creating truststore");
                    Util.copy(dest + FS + keyStore, dest + FS + trustStore);
                }
            }
        }
    }

    private boolean persistKeyStore(String SME, String fmserverKS, DB db) throws CertificateEncodingException {
        PrivateKey privateKey = (PrivateKey)TrustTool.getPrivateKey(fmserverKS, SME, "fmserver_1_2_3");
        Certificate cert = TrustTool.getCert(fmserverKS, SME, "fmserver_1_2_3");
        if (privateKey == null) {
            logger.error((Object)"Unable to persistKeyStore, privateKey is null. ");
            return false;
        }
        if (cert == null) {
            logger.error((Object)"Unable to persistKeyStore, privateKey is null. ");
            return false;
        }
        boolean persisted = db.persistFMCA("fmca", privateKey.getEncoded(), cert.getEncoded(), cert.getType(), privateKey.getFormat(), privateKey.getAlgorithm(), SME, "fmserver_1_2_3");
        return persisted;
    }

    protected void updateButtonPreference() {
        String cardname = this.wizard.getCurrent().getName();
        if (cardname.equals("Ready to Install")) {
            if (this.welcomePanel.isExpress()) {
                this.wizard.getNextButton().setText("Install");
                this.wizard.getNextButton().setIcon(null);
            }
        } else {
            this.wizard.resetNavigator();
        }
    }

    @Override
    public void postInstall() {
        boolean allUser;
        Util.delete(this.iModel.getBinDir() + FS + "fmserver");
        Util.delete(this.iModel.getBinDir() + FS + "postgresql");
        Util.delete(this.iModel.getLibDir() + FS + "jh.jar");
        boolean bl = allUser = this.textMode ? this.existsArg("-allusers") : this.fPanel.createShortcutForAllUsers();
        if (!this.confProps.containsKey("mds.dm.version") && !this.iModel.isStandalone()) {
            this.clean32DMShortcuts();
        }
        if (!this.confProps.containsKey("mds.fm.version")) {
            this.cleanFMCShortcuts();
        }
        if (!this.iModel.isStandalone()) {
            this.clean32FMSAShortcuts();
            Util.delete(this.iModel.getBinDir() + FS + "FabricManagerSA." + (SysInfo.ONWINDOWS ? "bat" : "sh"));
        }
        this.cleanOldFMShortcuts();
        this.cleanOldDMShortcuts();
        this.cleanUninstallShortcuts();
        if (this.iModel.isStandalone()) {
            this.dmi.setAllUsers(allUser);
            this.dmi.postInstall();
        } else {
            this.cInstaller.setAllUsers(allUser);
            this.cInstaller.postInstall();
        }
        Util.delete(this.iModel.getInstallDir() + FS + "oraclesetup.sql");
        Util.delete(this.iModel.getInstallDir() + FS + "oracleclean.sql");
        try {
            this.storeConf(allUser);
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to write to configuration files.");
        }
        try {
            this.iModel.deleteOldExec();
            if (this.iModel.isStandalone() && SysInfo.ONWINDOWS) {
                try {
                    if (Service.isInstalled("SAN Server")) {
                        if (Service.isRunning("SAN Server")) {
                            Service.stop("SAN Server");
                        }
                        Service.delete("SAN Server");
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                }
            }
            if (!this.iModel.isStandalone()) {
                if (!this.confProps.containsKey("mds.fm.version")) {
                    // empty if block
                }
                Util.delete(this.iModel.getBinDir() + FS + "FabricManagerSA" + (SysInfo.ONWINDOWS ? ".bat" : ".sh"));
                if (!this.confProps.containsKey("mds.dm.version")) {
                    // empty if block
                }
            }
            if (this.existsArg("-nostart")) {
                return;
            }
            if (SysInfo.ONWINDOWS) {
                this.winSetup2(this.iModel.getFMDir(), this.iModel.getUserDir(), allUser);
                if (!this.textMode && this.fPanel.showInstallLog()) {
                    try {
                        Runtime.getRuntime().exec("cmd /c start notepad " + this.iModel.getUserDir() + FS + "install.log");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                this.unixSetup2(this.iModel.getFMDir(), this.iModel.getUserDir());
            }
            if (!this.textMode) {
                String host;
                if (this.fPanel.launchFM()) {
                    String[] stringArray;
                    host = this.getServerHost();
                    if (!this.getServerPort().equals("9099")) {
                        host = host + ":" + this.getServerPort();
                    }
                    String string = (this.iModel.isStandalone() ? "FabricManagerSA" : "FabricManager") + SysInfo.ESUFFIX;
                    if (this.iModel.isStandalone()) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "";
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "-s";
                        stringArray = stringArray3;
                        stringArray3[1] = host;
                    }
                    this.runApp(string, stringArray, this.iModel.getBinDir());
                }
                if (this.fPanel.launchDM()) {
                    host = this.getArg("-host");
                    host = null;
                    this.runApp("DeviceManager" + SysInfo.ESUFFIX, new String[]{host}, this.iModel.getBinDir());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.warn((Object)"Cisco Management Software installation completed.");
        logger.warn((Object)new JLabel(this.where).getText());
        System.exit(0);
    }

    public void storeConf(boolean allUser) {
        String iDir = this.iModel.getFMDir();
        String pgDir = this.installPostgreSQL ? this.iModel.getInstallPgDir() : "";
        String val = this.confProps.getProperty("mds.db.dir");
        if (val != null && !this.installPostgreSQL) {
            pgDir = val;
        }
        if (pgDir != null && SysInfo.ONWINDOWS) {
            pgDir = Util.preserveBackslash(pgDir);
        }
        String ciscoDir = this.iModel.getInstallDir();
        if (SysInfo.ONWINDOWS && ciscoDir != null) {
            ciscoDir = Util.preserveBackslash(ciscoDir);
        }
        String dcmDir = this.iModel.getDCMDir();
        if (SysInfo.ONWINDOWS && dcmDir != null) {
            dcmDir = Util.preserveBackslash(dcmDir);
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("mds.jvm", SysInfo.ONWINDOWS ? Util.preserveBackslash(SysInfo.JHOME) : SysInfo.JHOME);
        info.put("mds.version", this.iModel.getVersion().toString());
        info.put("mds.nmsRoot", SysInfo.ONWINDOWS ? Util.preserveBackslash(iDir) : iDir);
        info.put("mds.winAllUsers", Boolean.toString(allUser));
        info.put("mds.web.startPort", Integer.toString(this.iModel.getWebStartPort()));
        info.put("mds.web.stopPort", Integer.toString(this.iModel.getWebStopPort()));
        info.put("mds.standalone", Boolean.toString(this.iModel.isStandalone()));
        info.put("mds.web.https", Boolean.toString(this.iModel.isHTTPS()));
        info.put("mds.db.dir", pgDir);
        info.put("mds.ciscoRoot", ciscoDir);
        info.put("mds.dcmRoot", dcmDir);
        info.put("mds.server.federation", Boolean.toString(this.federated));
        info.put("mds.smis.installed", Boolean.toString(this.jserverIsInstalled));
        this.createConf(info.keySet().toArray(new String[0]), info.values().toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        cmd = e.getActionCommand();
        if ("Go".equals(cmd)) {
            cmd = this.wizard.getNextButton().getActionCommand();
        }
        switch (cmd.charAt(0)) {
            case 'B': {
                this.wizard.doBack();
                if (this.wizard.isFirst()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FMInstaller.this.wizard.getBackButton().setEnabled(false);
                        }
                    });
                    this.wizard.getNavigator().revalidate();
                }
                if ((pane = this.wizard.getCurrent()) == null) break;
                if (pane.getName().equals("Database Options")) {
                    this.installPostgreSQL = false;
                    break;
                }
                if (pane.getName().equals("Ready to Install")) {
                    if (this.welcomePanel.isExpress()) break;
                    this.wizard.doBack();
                    break;
                }
                if (!pane.getName().equals("Authentication Options") || !this.locPanel.useFederation()) break;
                this.wizard.doBack();
                this.wizard.doBack();
                break;
            }
            case 'C': {
                if (!this.msgHelper.doCancel()) ** GOTO lbl41
                if (this.serverId > 0) {
                    dbUrl = this.getDbURL();
                    rdbms = this.getRDBMS(dbUrl);
                    db = null;
                    try {
                        db = new DB(rdbms, dbUrl, this.getDbUser(), this.getDbPass());
                        db.removeClusterNode(this.serverId);
                    }
                    catch (SQLException ex) {
                        FMInstaller.logger.error((Object)("Unable to remove cluster id " + this.serverId + ": " + ex.getMessage()));
                    }
                    finally {
                        if (db != null) {
                            db.close();
                        }
                    }
                }
                System.exit(0);
                break;
lbl41:
                // 1 sources

                return;
            }
            case 'F': {
                this.resume();
                return;
            }
            case 'I': {
                if (this.locPanel.isInstallJServer()) ** GOTO lbl50
                if (!this.doConfigCheck()) {
                    return;
                }
                ** GOTO lbl92
lbl50:
                // 1 sources

                seed = this.discoverPanel.getSeed();
                username = this.discoverPanel.getUserName();
                password = this.discoverPanel.getPassword();
                if ("".equals(seed.trim())) {
                    this.msgHelper.showError("Invalid seed");
                    return;
                }
                if ("".equals(username.trim())) {
                    this.msgHelper.showError("Invalid username");
                    return;
                }
                if ("".equals(password.trim())) {
                    this.msgHelper.showError("Invalid password");
                    return;
                }
                try {
                    InetAddress.getByName(seed);
                }
                catch (Exception ex) {
                    this.msgHelper.showError("Invalid seed " + seed + ".\n" + "Cause: " + ex.getMessage());
                    return;
                }
                ERROR_MSG = "Unable to connect to ";
                seeds = this.discoverPanel.getSeed();
                if (!this.discoverPanel.getSeed2().trim().equals("")) {
                    seeds = seeds + "/" + this.discoverPanel.getSeed2();
                }
                try {
                    this.busyCursor();
                    Util.doSnmpCheck(this.discoverPanel.getSeed(), this.discoverPanel.getSeed2(), this.discoverPanel.getDigest().getAuthProtocol(), this.discoverPanel.getDigest().getPrivProtocol(), this.discoverPanel.getUserName(), this.discoverPanel.getPassword());
                }
                catch (UnknownHostException ue) {
                    ue.printStackTrace();
                    JOptionPane.showMessageDialog(this.parent, "Unable to connect to " + seeds + ": unknown host", this.name, 0);
                    return;
                }
                catch (SnmpException se) {
                    se.printStackTrace();
                    JOptionPane.showMessageDialog(this.parent, "Unable to connect to " + seeds + ": " + se.getMessage(), this.name, 0);
                    return;
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                    JOptionPane.showMessageDialog(this.parent, "Unable to connect to " + seeds + ": " + ie.getMessage(), this.name, 0);
                    return;
                }
                finally {
                    this.defaultCursor();
                }
lbl92:
                // 2 sources

                this.wizard.getNextButton().setEnabled(false);
                this.wizard.getBackButton().setEnabled(false);
                this.wizard.getNavigator().revalidate();
                this.wizard.show("Installing");
                this.resume();
                return;
            }
            case 'N': {
                p = this.wizard.getNext();
                if (p != null && "Installing".equals(name = p.getName())) {
                    this.resume();
                }
                if (!(name = (cur = this.wizard.getCurrent()).getName()).equals(LicensePanel.NAME)) ** GOTO lbl110
                license = (LicensePanel)cur;
                if (!license.isAccepted()) {
                    license.showDialog();
                    return;
                }
                if (!this.welcomePanel.isExpress()) {
                    this.wizard.doNext();
                }
                ** GOTO lbl342
lbl110:
                // 1 sources

                if (!name.equals("Install Options")) ** GOTO lbl162
                location = (LocationPanel)cur;
                if (!this.createInstallLocation(location)) {
                    return;
                }
                if (!this.updaterCheck()) {
                    return;
                }
                path = location.getInstallFolder();
                this.iModel.setInstallDir(path);
                if (!this.updatedDbInstallDir) {
                    this.dbPanel.setInstallLocation(this.iModel.getDBDir());
                    this.updatedDbInstallDir = true;
                }
                dcnmInfo = null;
                try {
                    dcnmInfo = DCNMInfo.getInstance();
                }
                catch (Exception ex) {
                    FMInstaller.logger.error((Object)("Unable to get DCNM Installation settings: " + ex.getMessage()));
                }
                this.dbPanel.setInstallEnabled(location.useFederation() == false);
                if (location.useFederation()) {
                    this.dbPanel.setShareDB(false);
                    this.dbPanel.setInstallPostgreSQL(false);
                    this.dbPanel.revalidate();
                } else if (dcnmInfo != null && dcnmInfo.isCompatible() && dcnmInfo.getInstallLocation() != null) {
                    this.locPanel.setSelectorEnabled(false);
                    if (!this.upgrade && !this.reinstall) {
                        this.dbPanel.setInstallPostgreSQL(false);
                        if (dcnmInfo.getDbURL() != null) {
                            if (dcnmInfo.getDbDriver() != null) {
                                if (dcnmInfo.getDbDriver().toLowerCase().contains("Oracle".toLowerCase())) {
                                    this.dbPanel.setShareDB(true);
                                    this.dbPanel.setRDBMS("Oracle");
                                } else if (dcnmInfo.getDbDriver().toLowerCase().contains("PostgreSQL".toLowerCase())) {
                                    this.dbPanel.setShareDB(true);
                                    this.dbPanel.setRDBMS("PostgreSQL");
                                }
                                this.dbPanel.setAdminUser(dcnmInfo.getDbAdminUser());
                                this.dbPanel.setAdminPassword(dcnmInfo.getDbAdminPass());
                            }
                            this.dbPanel.setDBUrl(dcnmInfo.getDbURL());
                        }
                        this.dbPanel.revalidate();
                    }
                }
                if (this.dbPanel.isShareDB()) {
                    this.dbPanel.setInstallEnabled(false);
                    this.dbPanel.setInstallEnabled(false);
                    this.dbPanel.setOracleUrlEnabled(false);
                    this.dbPanel.setEnableRDBMS(false);
                    this.dbPanel.setView("ShareDB");
                    this.dbPanel.revalidate();
                }
                this.cPanel.setLoopAllow(location.useFederation() == false);
                useFederation = Boolean.parseBoolean(this.confProps.getProperty("mds.server.federation", "false"));
                if (useFederation && !location.useFederation() && !this.msgHelper.ask("Your existing installation participates in server federation.  This installation does not.  Do you wish to continue?")) {
                    return;
                }
                ** GOTO lbl342
lbl162:
                // 1 sources

                if (!name.equals("Database Options")) ** GOTO lbl302
                dbPanel = (DBPanel)cur;
                if (!dbPanel.hasAllFields()) {
                    dbPanel.showNeedFields();
                    return;
                }
                if (dbPanel.isShareDB()) {
                    if (!this.checkDbUserNotDcnmUser()) {
                        return;
                    }
                    if (!this.checkDbUserNotAdminUser()) {
                        return;
                    }
                }
                if ((dbPanel.isInstallDB() || dbPanel.isCreateUser()) && !this.doPasswordCheck(dbUsername = dbPanel.getUsername().trim(), dbPassword = dbPanel.getPassword().trim(), cPassword = dbPanel.getConfirmPassword().trim(), true)) {
                    return;
                }
                if (dbPanel.isInstallDB()) {
                    this.doDbDirCheck();
                    dbIPath = dbPanel.getInstallLocation();
                    if (dbIPath == null || "".equals(dbIPath.trim())) {
                        this.msgHelper.showMessage("Please specify an installation directory.");
                        return;
                    }
                    if (!Util.exists(dbIPath) && !Util.mkdir(dbIPath)) {
                        this.msgHelper.showError("Unable to create directory " + dbIPath + ".\n" + "Please make sure you have write permission.");
                        return;
                    }
                }
                if (!dbPanel.isPostgres()) {
                    driverPath = this.promptUserOjdbc();
                    if (driverPath == null) {
                        return;
                    }
                    try {
                        this.loadOracleDriver(driverPath);
                    }
                    catch (Exception ex) {
                        this.msgHelper.showError(ex.getMessage());
                        return;
                    }
                } else {
                    DBConnection.loadJar = null;
                }
                db = null;
                try {
                    this.busyCursor();
                    db = new DB(dbPanel.getRDBMS(), dbPanel.getURL(), dbPanel.isCreateUser() != false ? dbPanel.getAdminUser() : dbPanel.getUsername(), dbPanel.isCreateUser() != false ? dbPanel.getAdminPassword() : dbPanel.getPassword());
                    rdbms = dbPanel.getRDBMS();
                    if (!dbPanel.isInstallDB()) {
                        if (db.hasConnection()) {
                            dbOK = true;
                            if (db.isPostgres()) {
                                if (!db.checkVersion("PostgreSQL 8.1") && !db.checkVersion("PostgreSQL 8.2")) {
                                    dbOK = false;
                                }
                            } else if (!db.checkVersion("Oracle Database 10g") && !db.checkVersion("Oracle Database 11g")) {
                                dbOK = false;
                            }
                            if (!dbOK && !this.existsArg("-force")) {
                                msg = db.getVersion() == null ? "Unknown Database" : db.getVersion() + " is not supported.\n";
                                JOptionPane.showMessageDialog(this.parent, new JLabel("<html><body>" + msg.replace("\n", "<br>") + "</body></html>"), "Unsupported Environment", 0);
                                FMInstaller.logger.fatal((Object)msg);
                                return;
                            }
                        } else {
                            this.msgHelper.showUnableToVerify(dbPanel, db.getUrl(), db.getUsername());
                            return;
                        }
                        this.checkDBChange();
                    } else if (SysInfo.ONWINDOWS || SysInfo.ONLINUX || SysInfo.ONSOLARIS) {
                        if (!dbPanel.isInstallDB()) {
                            this.msgHelper.showUnableToVerify(dbPanel, db.getUrl(), db.getUsername());
                        }
                        if (dbPanel.isInstallDB()) {
                            if (SysInfo.ONWINDOWS && Service.isInstalled("pgsql-8.2")) {
                                this.msgHelper.showPgInstalled();
                                dbPanel.setInstallDB(false);
                                return;
                            }
                            if ((SysInfo.ONLINUX || SysInfo.ONSOLARIS) && this.iModel.isPgRunning()) {
                                this.msgHelper.showPgInstalled();
                                dbPanel.setInstallDB(false);
                                return;
                            }
                        } else {
                            return;
                        }
                        if (!SysInfo.ONWINDOWS && !Util.isRoot()) {
                            this.msgHelper.showError("You are not root. You do not have permission to install PostgreSQL.");
                            return;
                        }
                        if ((SysInfo.ONLINUX || SysInfo.ONSOLARIS) && Util.isRoot()) {
                            this.obtainPgStarter();
                        }
                        if (this.iModel.isPgRunning()) {
                            this.msgHelper.showPgInstalled();
                            return;
                        }
                        if (SysInfo.ONLINUX && !this.iModel.checkSharedMemory()) {
                            msg = "Your shared memory settings may be too low to run PostgreSQL.\nYou may want to reconfigure kernel resources before installing.\nPlease visit http://www.postgresql.org/docs/8.2/interactive/kernel-resources.html for more information.";
                            this.msgHelper.showWarning(msg);
                        }
                        if (SysInfo.ONSOLARIS && !this.iModel.checkSolarisMemorySetting()) {
                            msg = "Your shared memory settings may be too low to run PostgreSQL.\nYou may want to reconfigure kernel resources before installing.\nPlease visit http://www.postgresql.org/docs/8.2/interactive/kernel-resources.html for more information.";
                            this.msgHelper.showWarning(msg);
                        }
                    } else if (this.checkSolarisPg()) {
                        user = dbPanel.getUsername();
                        passwd = dbPanel.getPassword();
                        if (user != null && "".equals(user.trim()) && passwd != null && "".equals(passwd.trim())) {
                            this.msgHelper.showGoBack();
                            return;
                        }
                        if (!dbPanel.isInstallDB()) {
                            return;
                        }
                        if (this.iModel.isPgRunning()) {
                            this.msgHelper.showPgInstalled();
                            return;
                        }
                    }
                    if (dbPanel.isShareDB() && dbPanel.isCreateUser()) {
                        try {
                            if (db.existUser(dbPanel.getUsername())) {
                                this.msgHelper.showMessage(dbPanel.getUsername() + " already exists.\n" + "Please go back and verify your settings or select Use Existing Account.");
                                return;
                            }
                        }
                        catch (Exception ex) {
                            errMsg = "Unable to check if user " + dbPanel.getUsername() + " exists.\nDetails: " + ex.getMessage();
                            this.msgHelper.showError(errMsg);
                            return;
                        }
                    }
                    if (this.locPanel.useFederation() && !this.checkDBFebSameAsDCNM()) {
                        return;
                    }
                }
                finally {
                    this.defaultCursor();
                    if (db != null) {
                        db.close();
                    }
                }
                if (this.locPanel.useFederation() && !this.locPanel.isStandalone()) {
                    try {
                        fedProps = this.loadPropsFromDB();
                        isHttps = Boolean.parseBoolean(fedProps.getProperty("mds.web.https", "false"));
                        this.cPanel.setHTTPS(isHttps);
                        this.cPanel.setWebPort(Integer.parseInt(fedProps.getProperty("web.port", "80")));
                        this.cPanel.setServerPort(Integer.parseInt(fedProps.getProperty("server.port", "9099")));
                    }
                    catch (Exception e1) {
                        this.msgHelper.showError("Unable to load server federation properties from DB: " + e1.getMessage());
                        return;
                    }
                }
                if (this.locPanel.isStandalone()) {
                    // empty if block
                }
                this.wizard.doNext();
                if (this.locPanel.useFederation()) {
                    this.cPanel.setServerComponentEnabledVisible(this.locPanel.isStandalone() == false, this.locPanel.useFederation());
                    this.wizard.getNextButton().setText("Install");
                    this.wizard.getNextButton().setIcon(null);
                    this.wizard.getNavigator().revalidate();
                    this.wizard.doNext();
                    this.wizard.doNext();
                }
                if (this.upgrade && !this.iModel.getOldVersion().lessThan(this.VER42)) {
                    this.cPanel.setNICEnabled(false);
                }
                return;
lbl302:
                // 1 sources

                if (name.equals("User Options")) {
                    if (this.upgrade || this.reinstall) {
                        if (this.upgradeAuthenFMUser()) {
                            this.wizard.doNext();
                        }
                    } else if (this.doPasswordCheck(this.uPanel.getUser(), this.uPanel.getPassword(), this.uPanel.getConfirmPassword(), false)) {
                        this.wizard.doNext();
                    }
                    return;
                }
                if (name.equals("Authentication Options")) {
                    if (!this.isAtLeastOneAAA()) {
                        this.msgHelper.showMessage("Please specify one or more authentication server.");
                        return;
                    }
                    this.cPanel.setServerComponentEnabledVisible(this.locPanel.isStandalone() == false, this.locPanel.useFederation());
                    isInstallingJServer = this.locPanel.isInstallJServer();
                    if (!isInstallingJServer) {
                        this.wizard.getNextButton().setText("Install");
                        this.wizard.getNextButton().setIcon(null);
                    }
                    this.wizard.getNavigator().revalidate();
                    this.wizard.doNext();
                    return;
                }
                if (name.equals(ConfigPanel.NAME)) {
                    if (this.locPanel.isInstallJServer() && !this.doConfigCheck()) {
                        return;
                    }
                    this.wizard.getNextButton().setText("Install");
                    this.wizard.getNextButton().setIcon(null);
                    this.wizard.getNavigator().revalidate();
                    this.wizard.doNext();
                    return;
                }
                if (name.equals("Installing")) {
                    isInstallingJServer = this.locPanel.isInstallJServer();
                    if (isInstallingJServer) {
                        this.wizard.doNext();
                        return;
                    }
                    this.wizard.getNextButton().setEnabled(true);
                    this.wizard.getNextButton().setText("Finish");
                    this.wizard.getNextButton().setIcon(null);
                    this.wizard.getCancelButton().setEnabled(false);
                    this.wizard.getNavigator().revalidate();
                    this.wizard.doNext();
                    return;
                }
lbl342:
                // 4 sources

                this.wizard.doNext();
                if (this.wizard.isFirst()) break;
                this.wizard.getBackButton().setEnabled(true);
                break;
            }
            case 'V': {
                hashcode = e.getSource().hashCode();
                v = new Runnable(){

                    @Override
                    public void run() {
                        FMInstaller.this.verify(hashcode);
                    }
                };
                SwingUtilities.invokeLater(v);
                break;
            }
            default: {
                return;
            }
        }
        this.updateButtonPreference();
    }

    private void defaultCursor() {
        this.parent.setCursor(origCursor);
    }

    private void busyCursor() {
        this.parent.setCursor(busyCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConfigCheck() {
        WizardPanel current = this.wizard.getCurrent();
        if (!(current == null || current.getName().equals(ConfigPanel.NAME) || current.getName().equals("User Options") || current.getName().equals("Ready to Install"))) {
            return false;
        }
        if (this.locPanel.isStandalone()) {
            if (this.welcomePanel.isExpress()) {
                boolean isInstalled;
                if (!(this.upgrade || this.reinstall || SysInfo.ONWINDOWS || Util.isRoot())) {
                    this.msgHelper.showMessage("To install PostgreSQL, you must be logged in as root user.\nYou do not have permission to install PostgreSQL.  Please\nlog in as root and restart this wizard.");
                    return false;
                }
                boolean bl = isInstalled = SysInfo.ONWINDOWS ? Service.isInstalled("pgsql-8.2") : this.iModel.isPgRunning();
                if (isInstalled && !this.upgrade && !this.reinstall) {
                    this.msgHelper.showWarning("There is already an instance of PostgreSQL installed on your system.\nPlease go back and choose Custom to proceed with the existing database.");
                    return false;
                }
            } else if (!(this.upgrade || this.reinstall || this.doPasswordCheck(this.uPanel.getUser(), this.uPanel.getPassword(), this.uPanel.getConfirmPassword(), false))) {
                return false;
            }
        } else {
            if (this.cPanel.getNIC() == null || "".equals(this.cPanel.getNIC().trim())) {
                this.msgHelper.showWarning("You have not selected a server bind address.\nIf there is no active interface, please enable\nan interface before continuing.  Once you're\ndone, click OK.  Then select a server bind address\nusing the Local Interface drop-down menu.");
                this.cPanel.refresh();
                return false;
            }
            if (this.dbPanel.isShareDB() && this.dbPanel.isCreateUser()) {
                if (!this.checkDbUserExist()) {
                    return false;
                }
                try {
                    this.busyCursor();
                    if (!this.createDBUser()) {
                        boolean isInstalled = false;
                        return isInstalled;
                    }
                }
                finally {
                    this.defaultCursor();
                }
            }
            try {
                if (this.textMode ? !this.existsArg("-installpg") : !this.dbPanel.isInstallDB() && !this.welcomePanel.isExpress()) {
                    Properties props = this.loadPropsFromDB();
                    String webPortProp = props.getProperty("web.port", this.cPanel.getWebPort()).trim();
                    if (!this.checkFedSameWebPortAndShowMsg(webPortProp)) {
                        this.msgHelper.showMessage(DialogHelper.getFedSameWebPortMsg(webPortProp));
                        return false;
                    }
                    if (!this.checkFedSameWebSchemeAndShowMsg(Boolean.parseBoolean(props.getProperty("mds.web.https", "false")))) {
                        this.msgHelper.showMessage("Your server federation uses HTTPS .\nIt is a requirement for servers in the same federation to use the same protocol.");
                        return false;
                    }
                }
            }
            catch (Exception ex) {
                this.msgHelper.showError("Unable to load server federation properties from DB: " + ex.getMessage());
                return false;
            }
            int port = this.checkWebPort(this.cPanel.getWebPort());
            if (port == -1) {
                int newPort = this.portCon.scanPort(8080);
                if (this.cPanel.useHTTPS()) {
                    String message = "Port " + this.cPanel.getWebPort() + " is not available. Please free up port 443 or 8443.\n" + "If this is intentional, then use the -force option.";
                    if (!this.existsArg("-text")) {
                        this.msgHelper.showWarning(message);
                    }
                    logger.error((Object)message);
                } else {
                    String message = "Port " + this.cPanel.getWebPort() + " is not available. Please enter a different port" + (newPort != -1 ? ", i.e., " + newPort + "." : ". If this is intentional, then use the -force option.");
                    if (!this.existsArg("-text")) {
                        this.msgHelper.showWarning(message);
                    }
                    logger.error((Object)message);
                }
                return false;
            }
            this.iModel.setWebStartPort(port);
            try {
                Properties props;
                String svrPortProp;
                if ((this.textMode ? !this.existsArg("-installpg") : !this.dbPanel.isInstallDB() && !this.welcomePanel.isExpress()) && !this.checkFedSameServerPortAndShowMsg(svrPortProp = (props = this.loadPropsFromDB()).getProperty("server.port", this.cPanel.getServerPort()).trim())) {
                    this.msgHelper.showMessage(DialogHelper.getFedSameServerPortMsg(svrPortProp));
                    return false;
                }
            }
            catch (Exception ex) {
                this.msgHelper.showError("Unable to load server federation properties from DB: " + ex.getMessage());
                return false;
            }
            int sPort = this.checkServerPort(this.cPanel.getServerPort());
            if (sPort == -1) {
                int newPort = this.portCon.scanPort(1099);
                String message = "Port " + this.cPanel.getServerPort() + " is not available. Please enter a different port" + (newPort != -1 ? ", i.e., " + newPort + "." : ". If this is intentional, then use the -force option.");
                if (!this.existsArg("-text")) {
                    this.msgHelper.showError(message);
                }
                logger.error((Object)message);
                return false;
            }
        }
        try {
            if (!this.checkClustering()) {
                return false;
            }
        }
        catch (SQLException ex) {
            this.msgHelper.showError("Unable query database: " + ex.getMessage());
        }
        catch (UnknownHostException ex) {
            this.msgHelper.showError("Error obtaining server address: " + ex.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDBUser() {
        String dbUrl = this.getDbURL();
        String rdbms = this.getRDBMS(dbUrl);
        String adminUser = this.textMode ? this.getArg("-adminuser") : this.dbPanel.getAdminUser();
        String adminPass = this.textMode ? this.getArg("-adminpass") : this.dbPanel.getAdminPassword();
        String dbUser = this.getDbUser();
        String dbPass = this.getDbPass();
        try (DB db = new DB(rdbms, dbUrl, adminUser, adminPass);){
            this.createDBUser(db, dbUser, dbPass);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDbUserExist() {
        String dbUser = this.getDbUser();
        try (DB db = null;){
            String dbUrl = this.getDbURL();
            String rdbms = this.getRDBMS(dbUrl);
            String adminUser = this.textMode ? this.getArg("-adminuser") : this.dbPanel.getAdminUser();
            String adminPass = this.textMode ? this.getArg("-adminpass") : this.dbPanel.getAdminPassword();
            db = new DB(rdbms, dbUrl, adminUser, adminPass);
            if (db.existUser(dbUser)) {
                this.msgHelper.showMessage(dbUser + " already exists.\n" + "Please go back and verify your database settings.");
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean checkDbUserNotDcnmUser() {
        try {
            String username;
            DCNMInfo dcnm = DCNMInfo.getInstance();
            if (dcnm == null) {
                return true;
            }
            if (!dcnm.isCompatible()) {
                return true;
            }
            String dcnmDBUser = dcnm.getDbUser();
            if (dcnmDBUser != null) {
                dcnmDBUser = dcnmDBUser.trim();
            }
            String string = username = this.textMode ? this.getArg("-dbuser") : this.dbPanel.getUsername();
            if (username == null) {
                throw new RuntimeException("DB user is not specified or null.");
            }
            if (username.trim().equals(dcnmDBUser)) {
                this.msgHelper.showError("Database user " + dcnmDBUser + " is being used by DCNM.  " + "Please choose enter a different account.");
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error checking FM and DCNM database account: " + ex.getMessage()));
        }
        return true;
    }

    private boolean checkDBShareUrl() {
        try {
            DCNMInfo dcnm = DCNMInfo.getInstance();
            if (dcnm == null) {
                return true;
            }
            if (!dcnm.isCompatible()) {
                return true;
            }
            String url = this.getDbURL();
            String shareURL = DCNMInfo.getInstance().dbURL;
            if (shareURL != null && !url.trim().equals(shareURL.trim())) {
                this.msgHelper.showError("Invalid configuration, please use the same database as DCNM.");
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check FM database settingagainst DCNM database setting.");
        }
        return true;
    }

    private boolean checkDbUserNotAdminUser() {
        try {
            String adminUser;
            boolean createUser;
            boolean bl = createUser = this.textMode ? this.existsArg("-createuser") : this.dbPanel.isCreateUser();
            if (!createUser) {
                return true;
            }
            String username = this.textMode ? this.getArg("-dbuser") : this.dbPanel.getUsername();
            String string = adminUser = this.textMode ? this.getArg("-adminuser") : this.dbPanel.getAdminUser();
            if (username == null) {
                throw new RuntimeException("DB user is not specified or null.");
            }
            if (adminUser == null) {
                throw new RuntimeException("DB admin user is not specified or null.");
            }
            if (username.trim().equals(adminUser.trim())) {
                this.msgHelper.showError("Cannot create DB user that is already an admin user.");
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error checking FM and DCNM database account: " + ex.getMessage()));
        }
        return true;
    }

    private boolean isStandalone() {
        return this.textMode ? this.existsArg("-standalone") : this.locPanel.isStandalone();
    }

    private boolean checkClustering() throws UnknownHostException, SQLException {
        boolean isExpress;
        if (this.isStandalone()) {
            return true;
        }
        boolean installDB = this.textMode ? this.existsArg("-installpg") || this.existsArg("-createuser") : this.dbPanel.isInstallDB() || this.dbPanel.isCreateUser();
        boolean bl = isExpress = this.textMode ? false : this.welcomePanel.isExpress();
        if (!installDB && !isExpress) {
            String msg = "There may be another server using this database. Continuing\nwith this database can cause instability to the exisiting\nserver.  Do you wish to continue?";
            if (this.textMode ? this.existsArg("-federated") : this.locPanel.useFederation() && !this.welcomePanel.isExpress()) {
                if (!this.isClusterExist() && !this.hasAvailableClusterId()) {
                    String MSG = "The maximum number of servers for this server federation is reached.\nPlease choose a different server federation.";
                    this.msgHelper.showMessage("The maximum number of servers for this server federation is reached.\nPlease choose a different server federation.");
                    return false;
                }
            } else if (this.hasOtherClusterNode()) {
                if (this.upgrade && this.iModel.getOldVersion().lessThan(this.VER42)) {
                    return true;
                }
                if (!this.isClusterExist()) {
                    return this.msgHelper.ask("There may be another server using this database. Continuing\nwith this database can cause instability to the exisiting\nserver.  Do you wish to continue?");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClusterExist() throws UnknownHostException {
        String dbUrl = this.getDbURL();
        String rdbms = this.getRDBMS(dbUrl);
        try (DB db = null;){
            db = new DB(rdbms, dbUrl, this.getDbUser(), this.getDbPass());
            boolean bl = db.isClusterExist(this.getServerInetAddress()) >= 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropsFromDB() {
        boolean installPg;
        boolean bl = this.textMode ? this.existsArg("-installpg") || this.existsArg("-createuser") : (installPg = this.dbPanel.isInstallDB() || this.dbPanel.isCreateUser());
        if (installPg) {
            return new Properties();
        }
        String dbUrl = this.getDbURL();
        String rdbms = this.getRDBMS(dbUrl);
        try (DB db = null;){
            db = new DB(rdbms, dbUrl, this.getDbUser(), this.getDbPass());
            Properties properties = db.loadProperties();
            return properties;
        }
    }

    public String promptUserOjdbc() {
        String endorsedDir = this.iModel.getUserDir() + SysInfo.FS + "endorsed" + SysInfo.FS;
        if (!Util.exists(endorsedDir)) {
            Util.mkdir(endorsedDir);
        }
        String driverPath = null;
        driverPath = this.findOJdbc(endorsedDir);
        if (driverPath == null) {
            String msg = "A JDBC driver is required to access your Oracle database.\nThe driver file (ojdbc14.jar) can be obtained from your\ndatabase installation. Please take a moment to find the\ndriver JAR file and place a copy in\n";
            if (this.textMode) {
                logger.warn((Object)(msg + endorsedDir + " before continuing.\n" + "Restart the installer when you're done.\n" + "NOTE:  Please give this file read access to all users.\n\n"));
            } else {
                JEditorPane ojdbcMsg = new JEditorPane();
                ojdbcMsg.setContentType("text/html");
                ojdbcMsg.setEditable(false);
                ojdbcMsg.addHyperlinkListener(this.dbPanel);
                ojdbcMsg.setBackground(this.dbPanel.getBackground());
                ojdbcMsg.setFont(this.dbPanel.getFont());
                String htmlMsg = "<html>" + msg.replace("\n", "<br>") + "<a href=\"file://" + endorsedDir + "\" >" + endorsedDir + "</a><br>" + "before continuing.<br>" + "<b>NOTE:</b>  Please give this file read access to all users." + "</html>";
                ojdbcMsg.setText(htmlMsg);
                this.msgHelper.beepAndDisplayParent();
                JOptionPane.showMessageDialog(this.parent, ojdbcMsg);
            }
            return null;
        }
        return driverPath;
    }

    public String getServerHost() {
        String bindAddress;
        String string = bindAddress = this.textMode ? this.getArg("-nic", "localhost") : this.cPanel.getNIC();
        if (bindAddress == null || "0.0.0.0".equals(bindAddress.trim())) {
            bindAddress = "localhost";
        }
        return bindAddress;
    }

    public String getServerPort() {
        return this.textMode ? this.getArg("-serverport", Integer.toString(9099)) : this.cPanel.getServerPort();
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> argMap = new HashMap<String, String>();
        argMap.put("-home", "jar:file:/E:/au_fmclient/nms/build/html/m9000-fm-DEVEL.jar!/");
        argMap.put("-version", "6.2(4a)");
        FMInstaller installer = new FMInstaller(argMap);
        installer.winSetup2("C:\\Program Files\\Cisco Systems", System.getProperty("user.home"), false);
    }

    static /* synthetic */ void access$200(FMInstaller x0) {
        x0.busyCursor();
    }

    static /* synthetic */ void access$300(FMInstaller x0) {
        x0.defaultCursor();
    }
}

