/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.Shortcut;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.SysInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MoveDMFMTask {
    private String oldDir;
    private String newDir;

    public MoveDMFMTask(String source, String target) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("source: " + source + "and/or target: " + target + " is null");
        }
        if (!Util.exists(source)) {
            throw new IllegalArgumentException(source + " source directory does not exist");
        }
        this.oldDir = source;
        this.newDir = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        try {
            if (!Util.exists(this.newDir) && !Util.mkdir(this.newDir)) {
                throw new IOException("Unable to create " + this.newDir);
            }
            this.moveLib();
            this.moveDMConf();
            this.moveDMBin();
            this.moveFMConf();
            this.moveFMBin();
            if (SysInfo.ONWINDOWS) {
                this.updateShortcut();
            }
        }
        finally {
            this.delete(this.oldDir + SysInfo.FS + "Uninstall" + SysInfo.ESUFFIX);
        }
    }

    protected void updateShortcut() {
        if (!SysInfo.ONWINDOWS) {
            return;
        }
        this.updateMenu("Cisco MDS9000");
        this.updateMenu("Cisco Fabric Manager");
    }

    private void updateMenu(String menuName) {
        String allDesktop = Service.getAllDesktop();
        String allMenu = Service.getAllStartMenu() + SysInfo.FS + menuName;
        String desktop = Service.getDesktop();
        String menu = Service.getStartMenu() + SysInfo.FS + menuName;
        String iDir = this.newDir;
        String libDir = this.newDir + SysInfo.FS + "lib";
        String binDir = this.newDir + SysInfo.FS + "bin";
        String nAllDesktop = Service.getAllDesktop();
        String nAllMenu = Service.getAllStartMenu() + SysInfo.FS + "Cisco Fabric Manager";
        String nDesktop = Service.getDesktop();
        String nMenu = Service.getStartMenu() + SysInfo.FS + "Cisco Fabric Manager";
        Shortcut nAllShortcut = new Shortcut(nAllDesktop, iDir, libDir, binDir, nAllMenu);
        File aDmLinkHandle = new File(Service.getAllStartMenu() + SysInfo.FS + "Cisco MDS9000" + SysInfo.FS + "Cisco Device Manager.lnk");
        File aFmLinkHandle = new File(Service.getAllStartMenu() + SysInfo.FS + "Cisco MDS9000" + SysInfo.FS + "Cisco Fabric Manager.lnk");
        if (aDmLinkHandle.exists()) {
            Util.mkdir(nAllMenu);
            nAllShortcut.createDMLinks();
            if (!aDmLinkHandle.delete()) {
                aDmLinkHandle.deleteOnExit();
            }
        }
        if (aFmLinkHandle.exists()) {
            Util.mkdir(nAllMenu);
            nAllShortcut.createFMLinks();
            if (!aFmLinkHandle.delete()) {
                aFmLinkHandle.deleteOnExit();
            }
        }
        File dmLinkHandle = new File(Service.getStartMenu() + SysInfo.FS + "Cisco MDS9000" + SysInfo.FS + "Cisco Device Manager.lnk");
        File fmLinkHandle = new File(Service.getStartMenu() + SysInfo.FS + "Cisco MDS9000" + SysInfo.FS + "Cisco Fabric Manager.lnk");
        Shortcut nshortcut = new Shortcut(nDesktop, iDir, libDir, binDir, nMenu);
        if (dmLinkHandle.exists()) {
            Util.mkdir(nMenu);
            nshortcut.createDMLinks();
            if (!dmLinkHandle.delete()) {
                dmLinkHandle.deleteOnExit();
            }
        }
        if (fmLinkHandle.exists()) {
            Util.mkdir(nMenu);
            nshortcut.createFMLinks();
            if (!fmLinkHandle.delete()) {
                fmLinkHandle.deleteOnExit();
            }
        }
    }

    protected void delete(String dir) {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                Util.delete(file.getAbsolutePath());
            }
        } else {
            f.delete();
        }
    }

    private String parseDir(String f, String key) throws IOException {
        String line;
        File file = new File(f);
        FileInputStream inStream = new FileInputStream(file);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)inStream, "US-ASCII"));
        String l = null;
        while ((line = r.readLine()) != null) {
            if (!line.contains(key) || line.charAt(0) == '#') continue;
            l = line.substring(line.lastIndexOf(key), line.length());
            l = l.substring(l.indexOf("=") + "=".length());
            break;
        }
        if (l != null) {
            return l.trim();
        }
        return null;
    }

    protected void moveDMBin() throws Exception {
        String dm = this.oldDir + SysInfo.FS + "bin" + SysInfo.FS + "DeviceManager" + SysInfo.ESUFFIX;
        String parsedDir = this.oldDir;
        try {
            parsedDir = this.parseDir(dm, "INSTALLDIR");
        }
        catch (Exception ex) {
            System.err.println("Unable to parse install dir " + ex.getMessage());
        }
        String toDir = this.newDir + SysInfo.FS + "bin";
        String toFile = toDir + SysInfo.FS + "DeviceManager" + SysInfo.ESUFFIX;
        Util.mkdir(toDir);
        String[] names = new String[]{parsedDir};
        String[] values = new String[]{this.newDir};
        if (Util.exists(dm)) {
            FileInputStream inFile = new FileInputStream(dm);
            Util.copy(inFile, toFile, names, values);
            ((InputStream)inFile).close();
        }
    }

    protected void moveFMBin() throws Exception {
        String dm = this.oldDir + SysInfo.FS + "bin" + SysInfo.FS + "FabricManager" + SysInfo.ESUFFIX;
        String toDir = this.newDir + SysInfo.FS + "bin";
        String toFile = toDir + SysInfo.FS + "FabricManager" + SysInfo.ESUFFIX;
        Util.mkdir(toDir);
        String[] names = new String[]{this.oldDir};
        String[] values = new String[]{this.newDir};
        if (Util.exists(dm)) {
            FileInputStream inFile = new FileInputStream(dm);
            Util.copy(inFile, toFile, names, values);
            ((InputStream)inFile).close();
        }
    }

    protected void moveLib() throws Exception {
        String libDirName = this.oldDir + SysInfo.FS + "lib";
        String toDirName = this.newDir + SysInfo.FS + "lib";
        this.moveFile(libDirName, toDirName);
    }

    protected void moveDMLib() throws Exception {
        String libDirName = this.oldDir + SysInfo.FS + "lib" + SysInfo.FS + "dm";
        String toDirName = this.newDir + SysInfo.FS + "lib" + SysInfo.FS + "dm";
        this.moveFile(libDirName, toDirName);
    }

    protected void moveFMLib() throws Exception {
        String libDirName = this.oldDir + SysInfo.FS + "lib" + SysInfo.FS + "fm";
        String toDirName = this.newDir + SysInfo.FS + "lib" + SysInfo.FS + "fm";
        this.moveFile(libDirName, toDirName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFile(String libDirName, String toDirName) throws FileNotFoundException, IOException {
        File[] libFiles;
        File toDir = new File(toDirName);
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        File fromDir = new File(libDirName);
        for (File file : libFiles = fromDir.listFiles()) {
            if (file.isFile()) {
                try (FileInputStream is = new FileInputStream(file);){
                    Util.copy(is, toDir + SysInfo.FS + file.getName());
                    continue;
                }
            }
            if (!file.isDirectory()) continue;
            this.moveFile(file.getAbsolutePath(), toDirName + SysInfo.FS + file.getName());
        }
    }

    private void moveDMConf() throws IOException {
        String log4jFile = this.oldDir + SysInfo.FS + "conf" + SysInfo.FS + "log4j_dm.xml";
        if (!Util.exists(log4jFile)) {
            return;
        }
        String toDir = this.newDir + SysInfo.FS + "conf";
        String toFile = toDir + SysInfo.FS + "log4j_dm.xml";
        Util.mkdir(toDir);
        Util.copy(log4jFile, toFile);
    }

    private void moveFMConf() throws IOException {
        String log4jFile = this.oldDir + SysInfo.FS + "conf" + SysInfo.FS + "log4j_fm.xml";
        if (!Util.exists(log4jFile)) {
            return;
        }
        String toDir = this.newDir + SysInfo.FS + "conf";
        String toFile = toDir + SysInfo.FS + "log4j_fm.xml";
        Util.mkdir(toDir);
        Util.copy(log4jFile, toFile);
    }

    public static void main(String[] args) throws Exception {
        String src = "C:\\\\Program Files\\\\Cisco Systems\\\\MDS 9000";
        String trg = "C:\\Program Files\\Cisco Systems\\dcm\\fm";
        MoveDMFMTask task = new MoveDMFMTask(src, trg);
        task.execute();
    }
}

