/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.ProgressTracker;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class ProgressMonitor
extends AppenderSkeleton
implements ProgressTracker {
    public static int INFO = Level.INFO.toInt();
    public static int WARN = Level.WARN.toInt();
    private JLabel note;
    private JTextArea board;
    private JProgressBar progress;
    private boolean trackByLine;
    private int count;
    private int line;
    private int level;

    public ProgressMonitor() {
    }

    public ProgressMonitor(JLabel note, JTextArea board, JProgressBar progress) {
        this.note = note;
        this.board = board;
        this.progress = progress;
        this.progress.setMaximum(100);
        this.line = 100;
        this.count = 0;
        this.trackByLine = true;
        this.level = INFO;
        this.setLayout(null);
    }

    public void trackByInputLine(boolean trackByLine) {
        this.trackByLine = trackByLine;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setMaximum(int max) {
        this.line = max;
    }

    public int getMaximum() {
        return this.line;
    }

    public void setNote(String note) {
        if (this.note == null) {
            return;
        }
        this.note.setText(note);
    }

    public void updateBoard(String note) {
        if (this.board == null) {
            return;
        }
        this.board.append(note);
        this.board.setCaretPosition(this.board.getDocument().getLength());
        if (this.trackByLine) {
            this.updateProgress();
        }
    }

    public void setProgress(int percent) throws Exception {
        if (this.trackByLine) {
            throw new Exception("TrackByInputLine is set");
        }
        this.progress.setValue(percent);
    }

    private void updateProgress() {
        if (this.progress == null) {
            return;
        }
        int value = 100 * ++this.count / this.line;
        this.progress.setValue(value);
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    protected void append(LoggingEvent event) {
        int loggerLevel = event.getLevel().toInt();
        if (loggerLevel == WARN) {
            this.setNote(event.getMessage().toString());
        }
        if (loggerLevel <= WARN) {
            this.updateBoard("    " + event.getMessage().toString() + "\n");
        }
        if (loggerLevel >= WARN) {
            System.out.println(event.getMessage().toString());
        }
    }

    @Override
    public void startDownload(String fileName) {
        this.updateBoard("    downloading " + fileName + "\n");
    }

    @Override
    public void setDownloadPercent(int percent) {
    }

    @Override
    public void startExtract(String fileName) {
    }

    @Override
    public void extractFile(String fileName) {
        this.updateBoard("    extracting " + fileName + "\n");
    }

    public void setUIComponents(JLabel note, JTextArea board, JProgressBar progress) {
        this.note = note;
        this.board = board;
        this.progress = progress;
    }
}

