/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.model;

import com.cisco.dcbu.install.CryptoHelper;
import com.cisco.dcbu.install.StreamReader;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.DBConnection;
import com.cisco.dcbu.install.model.PropertyConstants;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.install.model.TrustTool;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.security.UserRoles;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DB {
    public static final String HSQL = "hsql";
    public static final String POSTGRES = "PostgreSQL";
    public static final String ORACLE = "Oracle";
    public static final String HSQLDRIVER = "org.hsqldb.jdbcDriver";
    public static final String HSQLURL = "jdbc:hsqldb:hsql://localhost";
    public static final String OSQLDRIVER = "oracle.jdbc.OracleDriver";
    static final String OSQLURL = "jdbc:oracle:thin:@localhost:1521:XE";
    public static final String PSQLDRIVER = "org.postgresql.Driver";
    public static final String PSQLURL = "jdbc:postgresql://localhost:5432/dcmdb";
    public static final String PGURL_DEFAULT = "jdbc:postgresql://localhost:5432/postgres";
    public static final String USER = "admin";
    public static final String PASSWORD = "password_1_2_3";
    public static final String ANDUSER = "andiamo";
    public static final String ANDPASSWORD = "andiamo_4_5_6";
    public static final String CISCOUSER = "cisco";
    static Logger logger = Logger.getLogger(DB.class);
    private String rdbms;
    private String driver;
    private String url;
    private String username;
    private String password;
    private Connection con = null;
    private DBConnection dbc = new DBConnection();
    private String version = null;

    public DB() {
        this.rdbms = POSTGRES;
        this.url = PSQLURL;
        this.username = CISCOUSER;
        this.password = ANDPASSWORD;
        this.driver = PSQLDRIVER;
        this.dbc = new DBConnection();
        this.dbc.setConnectionInfo(this.url, this.driver, this.username, this.password);
        this.con = this.dbc.getConnection();
    }

    public DB(String db, String location, String user, String passwd) {
        this.rdbms = db;
        this.url = location;
        this.username = user;
        this.password = passwd;
        this.driver = this.url.indexOf("postgres") > -1 ? PSQLDRIVER : OSQLDRIVER;
        this.dbc = new DBConnection();
        this.dbc.setConnectionInfo(this.url, this.driver, this.username, passwd);
        this.con = this.dbc.getConnection();
    }

    public void setLogger(Logger logger) {
        DB.logger = logger;
    }

    public void setURL(String dbURL) {
        this.url = dbURL;
    }

    public void setUser(String user) {
        this.username = user;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public void setRDBMS(String dbType) {
        this.rdbms = dbType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        String sql = "SELECT version()";
        if (this.rdbms.equalsIgnoreCase(ORACLE)) {
            sql = "SELECT * from V$VERSION";
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            this.version = rs.getString(this.isPostgres() ? "version" : "banner");
            this.close(stmt, rs);
        }
        catch (SQLException sqle) {
            try {
                this.version = null;
                this.close(stmt, rs);
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return this.version;
    }

    public boolean checkVersion(String version) {
        String ver = this.getVersion();
        if (ver == null) {
            return false;
        }
        return ver.contains(version);
    }

    public boolean isPostgres() {
        return POSTGRES.contains(this.rdbms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(String schemaFile) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(schemaFile));
            StringBuffer sql = new StringBuffer();
            String read = null;
            while ((read = reader.readLine()) != null) {
                int endIdx;
                read = read.trim();
                sql.append(read);
                if (sql.length() == 0 || (endIdx = sql.indexOf(";")) != sql.length() - 1) continue;
                if (endIdx == sql.length() - 1) {
                    sql.deleteCharAt(endIdx);
                }
                int idx = sql.indexOf("drop");
                if (sql.indexOf("exit") == 0) {
                    this.con.commit();
                    return;
                }
                logger.info((Object)sql);
                try {
                    String query = sql.toString();
                    int cnt = this.executeUpdate(query);
                }
                catch (SQLException sqle) {
                    String msg = sqle.getMessage();
                    if (msg != null && (msg.contains("ORA-00955") || msg.contains("table") && msg.contains("does not exist") || msg.contains("relation") && msg.contains("already exists"))) continue;
                    logger.error((Object)sqle.getMessage());
                }
                finally {
                    sql = new StringBuffer();
                }
            }
            reader.close();
        }
        catch (IOException ioe) {
            logger.error((Object)"Reading error");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createFMUser(String login, String password) throws Exception {
        int id;
        Statement myStmt = null;
        ResultSet rs = null;
        Random _RandomGen = new Random();
        int salt = _RandomGen.nextInt();
        boolean version = false;
        try {
            myStmt = this.con.createStatement(1005, 1008);
            String query = "select id,version,userid,password,role, salt from dcnmuser";
            rs = myStmt.executeQuery(query);
            String qUser = new String("");
            long millisecs = System.currentTimeMillis();
            id = 0;
            while (rs.next()) {
                int idValue = rs.getInt("id");
                if (id < idValue) {
                    id = idValue;
                }
                qUser = rs.getString("userid");
                int salt2 = rs.getInt("salt");
                if (!qUser.equals(login)) continue;
                rs.updateString("password", StringEncrypter.DESedeEncrypt(password, salt2));
                rs.updateRow();
                this.close(myStmt, rs);
                return;
            }
        }
        catch (Exception ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(myStmt, rs);
                throw throwable;
            }
        }
        {
            rs.moveToInsertRow();
            rs.updateInt("id", ++id);
            rs.updateInt("version", 0);
            rs.updateString("userid", login);
            rs.updateString("password", StringEncrypter.DESedeEncrypt(password, salt));
            rs.updateString("role", "network-admin");
            rs.updateInt("salt", salt);
            rs.insertRow();
            this.close(myStmt, rs);
            return;
        }
    }

    private static int getSalt(String userName) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        int salt = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement("select salt from dcnmuser where userid = ?");
            stat.setString(1, userName);
            rs = stat.executeQuery();
            while (rs.next()) {
                salt = rs.getInt(1);
            }
            n = salt;
        }
        catch (SQLException ex) {
            try {
                logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close((Statement)stat);
                DbUtil.close((Connection)con);
                throw throwable;
            }
        }
        DbUtil.close((ResultSet)rs);
        DbUtil.close((Statement)stat);
        DbUtil.close((Connection)con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateFMAdmin(String login, String password) throws Exception {
        if (login == null || password == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if ("".equals(login) || "".equals(password)) {
            throw new IllegalArgumentException("Arguments cannot be empty.");
        }
        String eLogin = login;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int salt = DB.getSalt(login);
        String ePassword = StringEncrypter.DESedeEncrypt(password, salt);
        try {
            String QUERY = "select role from dcnmuser where userid=? and password=?";
            stmt = this.con.prepareStatement("select role from dcnmuser where userid=? and password=?");
            stmt.setString(1, eLogin);
            stmt.setString(2, ePassword);
            rs = stmt.executeQuery();
            String qRole = null;
            if (!rs.next()) {
                stmt.setString(1, eLogin);
                stmt.setString(2, CryptoHelper.INSTANCE.encrypt(password));
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new Exception("Invalid username and/or password.");
                }
                qRole = rs.getString("role");
            } else {
                qRole = rs.getString("role");
            }
            if (qRole != null && !UserRoles.INSTANCE.isAdminRole(qRole)) {
                boolean bl = false;
                this.close(stmt, rs);
                return bl;
            }
            this.close(stmt, rs);
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPgDB() throws Exception {
        if (!this.hasConnection()) {
            throw new SQLException("Invalid connection.");
        }
        String sql = "create database dcmdb";
        try {
            this.executeUpdate("create database dcmdb");
        }
        catch (SQLException sqle) {
            if (!sqle.getMessage().contains("already exists")) {
                throw sqle;
            }
        }
    }

    public static void stopDB(String path) throws IOException {
        if (!Util.exists(path)) {
            throw new IOException("Invalid db path");
        }
        String pgCtl = path + SysInfo.FS + "bin" + SysInfo.FS + "pg_ctl.exe";
        if (!Util.exists(pgCtl)) {
            throw new IOException("Unable to find pg_ctl.exe");
        }
        if (SysInfo.ONWINDOWS) {
            int rc;
            String cmd = "\"" + pgCtl + "\" -D " + path + SysInfo.FS + "data\" stop";
            Process proc = Runtime.getRuntime().exec(cmd);
            StreamReader err = new StreamReader(proc.getErrorStream());
            StreamReader out = new StreamReader(proc.getInputStream());
            err.start();
            out.start();
            try {
                rc = proc.waitFor();
                Thread.sleep(2000L);
            }
            catch (InterruptedException iex) {
                throw new IOException("Stopping DB was interrupted");
            }
            if (rc != 0) {
                throw new IOException("Stopping DB failed");
            }
        }
    }

    public void createDB(String db) throws SQLException {
        try {
            String sql = "CREATE DATABASE " + db + " WITH ENCODING = 'SQL_ASCII' TABLESPACE = pg_default";
            this.executeUpdate(sql);
        }
        catch (SQLException ex) {
            logger.error((Object)("Unable to CREATE database " + db + ": " + ex.getMessage()));
        }
    }

    public void createDBSchema(String user, String schema) throws SQLException {
        try {
            String sql = "create schema " + user + " authorization " + user;
            this.executeUpdate(sql);
        }
        catch (SQLException ex) {
            logger.error((Object)("Unable to CREATE schema " + user + " for user " + user + ": " + ex.getMessage()));
            throw ex;
        }
    }

    public boolean existDBSchema(String schema) throws SQLException {
        if (this.con == null) {
            throw new SQLException("DB Connection does not exists.");
        }
        String sql = "select * from pg_namespace where nspname=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement("select * from pg_namespace where nspname=?");
            stmt.setString(1, schema);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                this.close(stmt, rs);
                return bl;
            }
            this.close(stmt, rs);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)("Unable to query fm schema's existence: " + ex.getMessage()));
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return false;
    }

    public void grantDBSchema(String user, String schema) throws SQLException {
        try {
            String sql = "grant all on schema " + schema + " to " + user;
            this.executeUpdate(sql);
        }
        catch (SQLException ex) {
            logger.error((Object)("Unable to GRANT schema " + schema + " to user " + user + ": " + ex.getMessage()));
            throw ex;
        }
    }

    public void setDBSearchPath(String user, String schema) throws SQLException {
        try {
            String sql = "alter user " + user + " SET search_path TO " + schema;
            this.executeUpdate(sql);
        }
        catch (SQLException ex) {
            logger.error((Object)("Unable to set FM search_path for user " + user + ": " + ex.getMessage()));
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(String sql) throws SQLException {
        if (this.con == null) {
            throw new SQLException("DB Connection does not exists.");
        }
        Statement stmt = this.con.createStatement();
        try {
            int n = stmt.executeUpdate(sql);
            return n;
        }
        finally {
            this.close(stmt);
        }
    }

    public void addDBUser(String user, String passwd) throws SQLException {
        if (this.con == null) {
            throw new SQLException("DB Connection does not exists.");
        }
        passwd = passwd.replace("\\", "\\\\");
        String query = "USER " + user + " WITH SUPERUSER INHERIT CREATEDB CREATEROLE UNENCRYPTED PASSWORD '" + passwd + "'";
        String err = null;
        try {
            this.executeUpdate("CREATE " + query);
        }
        catch (SQLException sqle) {
            err = sqle.getMessage();
            if (err == null) {
                return;
            }
            if (!err.contains("exist")) {
                throw sqle;
            }
            this.executeUpdate("ALTER " + query);
        }
    }

    public void addOracleUser(String user, String password) throws SQLException {
        if (this.con == null) {
            throw new SQLException("DB Connection does not exist");
        }
        String createSql = "create user " + user + " identified by " + password;
        this.executeUpdate(createSql);
    }

    public void delOracleUser(String user) throws SQLException {
        if (this.con == null) {
            throw new SQLException("DB Connection does not exist");
        }
        String createSql = "drop user " + user;
        this.executeUpdate(createSql);
    }

    public void grantOraclePrivilege(String user) throws SQLException {
        if (this.con == null) {
            throw new SQLException("DB Connection does not exist");
        }
        String grantSql = "grant all privileges to " + user;
        this.executeUpdate(grantSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existUser(String user) throws SQLException {
        if (this.con == null) {
            throw new SQLException("DB Connection does not exists.");
        }
        String sql = this.isPostgres() ? "select * from pg_roles where rolname=?" : "select * from all_users where username=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement(sql);
            stmt.setString(1, user);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                this.close(stmt, rs);
                return bl;
            }
            this.close(stmt, rs);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)("Unable to query user " + user + " existence: " + ex.getMessage()));
                this.close(stmt, rs);
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAvailableClusterID() throws SQLException {
        int sCnt;
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            int MAX_CLUSTERS = 10;
            stmt = null;
            rs = null;
            try {
                String sql = "SELECT COUNT(*) FROM PHYSICAL_LOGICSVR";
                stmt = this.con.prepareStatement("SELECT COUNT(*) FROM PHYSICAL_LOGICSVR");
                rs = stmt.executeQuery();
                sCnt = -1;
                if (rs.next()) break block4;
                boolean bl = false;
                this.close(stmt, rs);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        sCnt = rs.getInt(1);
        System.out.println("size: " + sCnt);
        if (sCnt < 10) {
            boolean bl = true;
            this.close(stmt, rs);
            return bl;
        }
        this.close(stmt, rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short queryClusterNextID() throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            int MAX_CLUSTERS = 10;
            stmt = null;
            rs = null;
            try {
                String sql = "SELECT COUNT(*) FROM PHYSICAL_LOGICSVR";
                stmt = this.con.prepareStatement("SELECT COUNT(*) FROM PHYSICAL_LOGICSVR");
                rs = stmt.executeQuery();
                int sCnt = 0;
                while (rs.next()) {
                    ++sCnt;
                    System.out.println("row: " + rs.getRow());
                    byte[] addr = rs.getBytes("IP_ADDR");
                    InetAddress ip = null;
                    int serverID = -1;
                    try {
                        ip = InetAddress.getByAddress(addr);
                        serverID = rs.getShort("LSVR_ID");
                    }
                    catch (UnknownHostException ue) {
                        ue.printStackTrace();
                    }
                    System.out.println("Address: " + ip + " ID: " + serverID);
                }
                if (sCnt < 10) break block6;
                short s = -1;
                this.close(stmt, rs);
                return s;
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        short s = 0;
        this.close(stmt, rs);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, InetAddress> getClusterNodes() {
        Statement stmt = null;
        ResultSet rs = null;
        HashMap<Integer, InetAddress> nodes = new HashMap<Integer, InetAddress>();
        try {
            String sql = "SELECT * FROM PHYSICAL_LOGICSVR";
            stmt = this.con.createStatement();
            rs = stmt.executeQuery("SELECT * FROM PHYSICAL_LOGICSVR");
            try {
                while (rs.next()) {
                    byte[] byteAddr = rs.getBytes("IP_ADDR");
                    InetAddress server = InetAddress.getByAddress(byteAddr);
                    Integer id = rs.getInt("LSVR_ID");
                    nodes.put(id, server);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            this.close(stmt, rs);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)("Unable to get cluster nodes: " + ex.getMessage()));
                this.close(stmt, rs);
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short isClusterExist(InetAddress ipAddr) {
        PreparedStatement stmt = null;
        short ret = -1;
        ResultSet rs = null;
        try {
            String sql = "SELECT * FROM PHYSICAL_LOGICSVR WHERE IP_ADDR=?";
            stmt = this.con.prepareStatement("SELECT * FROM PHYSICAL_LOGICSVR WHERE IP_ADDR=?");
            stmt.setBytes(1, ipAddr.getAddress());
            rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    byte[] byteAddr = rs.getBytes("IP_ADDR");
                    ret = rs.getShort("LSVR_ID");
                    logger.debug((Object)(InetAddress.getByAddress(byteAddr).getHostName() + " exist with id " + ret));
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            this.close(stmt, rs);
        }
        catch (SQLException sqlE) {
            try {
                ret = -1;
                this.close(stmt, rs);
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short addClusterNode(InetAddress ip_addr) throws Exception {
        short serverId = this.isClusterExist(ip_addr);
        if (serverId >= 0) {
            return serverId;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT IP_ADDR, LSVR_ID FROM PHYSICAL_LOGICSVR";
            stmt = this.con.prepareStatement("SELECT IP_ADDR, LSVR_ID FROM PHYSICAL_LOGICSVR", 1005, 1008);
            rs = stmt.executeQuery();
            rs.last();
            if (rs.getRow() > 10) {
                throw new Exception("Number of cluster node exhausted.");
            }
            rs.beforeFirst();
            Vector<Short> ids = new Vector<Short>();
            while (rs.next()) {
                ids.add(rs.getShort("LSVR_ID"));
            }
            for (short i = 0; i <= 9; i = (short)(i + 1)) {
                if (ids.contains(i)) continue;
                serverId = i;
                break;
            }
            if (serverId == -1) {
                throw new Exception("ServerID exhausted, unable to assign server ID.");
            }
            rs.moveToInsertRow();
            rs.updateBytes("IP_ADDR", ip_addr.getAddress());
            rs.updateShort("LSVR_ID", serverId);
            rs.insertRow();
            this.close(stmt, rs);
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            throw throwable;
        }
        return serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replaceClusterNode(InetAddress ip_addr) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT IP_ADDR, LSVR_ID FROM PHYSICAL_LOGICSVR";
            stmt = this.con.prepareStatement("SELECT IP_ADDR, LSVR_ID FROM PHYSICAL_LOGICSVR", 1005, 1008);
            rs = stmt.executeQuery();
            rs.beforeFirst();
            while (rs.next()) {
                byte[] addr = rs.getBytes("IP_ADDR");
                InetAddress ip = null;
                try {
                    ip = InetAddress.getByAddress(addr);
                    System.out.println(ip.getHostAddress());
                    String hostAddress = ip.getHostAddress();
                    if (!"0.0.0.0".equals(hostAddress)) continue;
                    rs.updateBytes("IP_ADDR", ip_addr.getAddress());
                    rs.updateRow();
                    this.close(stmt, rs);
                    return;
                }
                catch (UnknownHostException ue) {
                    ue.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            throw throwable;
        }
        this.close(stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterNode(InetAddress ip_addr) throws SQLException {
        String sql = "delete from PHYSICAL_LOGICSVR where IP_ADDR=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement("delete from PHYSICAL_LOGICSVR where IP_ADDR=?");
            stmt.setBytes(1, ip_addr.getAddress());
            stmt.executeUpdate();
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterNode(short id) throws SQLException {
        String sql = "delete from PHYSICAL_LOGICSVR where LSVR_ID=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement("delete from PHYSICAL_LOGICSVR where LSVR_ID=?");
            stmt.setShort(1, id);
            stmt.executeUpdate();
        }
        finally {
            this.close(stmt);
        }
    }

    public boolean hasConnection() {
        return this.con != null;
    }

    public boolean retryConnection(int tries) {
        DBConnection dbc = new DBConnection();
        dbc.setConnectionInfo(this.url, this.driver, this.username, this.password);
        for (int i = 0; i < tries; ++i) {
            this.con = dbc.getConnection();
            if (this.con != null) {
                return true;
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existProps(String key) {
        String GetSvrPropSQL = "select key,value from svr_prop where key = ?";
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement("select key,value from svr_prop where key = ?");
            stmt.setString(1, key);
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            this.close(stmt, rs);
            return bl;
        }
        catch (SQLException ex) {
            logger.debug((Object)ex.getMessage());
        }
        finally {
            this.close(stmt, rs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistProperties(Properties props) throws SQLException {
        String InsertSvrPropSQL = "insert into svr_prop (key,value) values(?,?)";
        String UpdateSvrPropSQL = "update svr_prop set value = ? where key = ?";
        String GetSvrPropSQL = "select key,value from svr_prop";
        Vector<String> allKeys = PropertyConstants.getProps();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        for (String key : allKeys) {
            String value = props.getProperty(key);
            if (value == null) continue;
            try {
                if (!this.existProps(key)) {
                    stmt = this.con.prepareStatement("insert into svr_prop (key,value) values(?,?)");
                    stmt.setString(1, key);
                    stmt.setString(2, value);
                } else {
                    stmt = this.con.prepareStatement("update svr_prop set value = ? where key = ?");
                    stmt.setString(1, value);
                    stmt.setString(2, key);
                }
                stmt.executeUpdate();
                this.close(stmt, rs);
            }
            catch (SQLException sqle) {
                try {
                    logger.info((Object)sqle.getMessage());
                    this.close(stmt, rs);
                }
                catch (Throwable throwable) {
                    this.close(stmt, rs);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties() {
        String GetSvrPropSQL = "select key,value from svr_prop";
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> allKeys = PropertyConstants.getProps();
        Properties props = new Properties();
        try {
            stmt = this.con.createStatement();
            rs = stmt.executeQuery("select key,value from svr_prop");
            while (rs.next()) {
                String key = rs.getString("key");
                String value = rs.getString("value");
                if (value == null) continue;
                props.put(key, value);
            }
            this.close(stmt, rs);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                this.close(stmt, rs);
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persistFMCA(String name, byte[] privateKey, byte[] cert, String certType, String privateFormat, String privAlg, String alias, String encryptedPwd) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT NAME, FILE_STORE, CERT, CERT_TYPE, PRIVATE_KEY, PUBLIC_KEY, PUB_KEY_FORMAT, PRIV_KEY_FORMAT, PUB_KEY_ALG, PRIV_KEY_ALG, ALIAS, PASSWORD FROM FM_CA_STORE where NAME = ?";
            stmt = this.con.prepareStatement(sql, 1005, 1008);
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            boolean insert = false;
            if (!rs.next()) {
                rs.moveToInsertRow();
                insert = true;
            }
            rs.updateString("NAME", name);
            rs.updateString("PRIV_KEY_FORMAT", privateFormat);
            rs.updateString("PRIV_KEY_ALG", privAlg);
            rs.updateString("CERT_TYPE", certType);
            rs.updateString("ALIAS", alias);
            rs.updateString("PASSWORD", encryptedPwd);
            if (ORACLE.equalsIgnoreCase(this.rdbms)) {
                ByteArrayInputStream is = new ByteArrayInputStream(privateKey);
                rs.updateBinaryStream("PRIVATE_KEY", (InputStream)is, privateKey.length);
                ByteArrayInputStream cis = new ByteArrayInputStream(cert);
                rs.updateBinaryStream("CERT", (InputStream)cis, cert.length);
            } else {
                rs.updateBytes("PRIVATE_KEY", privateKey);
                rs.updateBytes("CERT", cert);
            }
            try {
                if (insert) {
                    rs.insertRow();
                } else {
                    rs.updateRow();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)("Unable to insert/update FMCA: " + ex.getMessage()));
                boolean bl = false;
                this.close(stmt, rs);
                return bl;
            }
            this.close(stmt, rs);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)("Error persisting keystore FMCA " + name + ": " + ex.getMessage()));
                boolean bl = false;
                this.close(stmt, rs);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFMCA(String name, String outFile) {
        ResultSet rs;
        PreparedStatement stmt;
        block12: {
            String sql = "SELECT NAME, FILE_STORE, CERT, CERT_TYPE, PRIVATE_KEY, PUBLIC_KEY, PUB_KEY_FORMAT, PRIV_KEY_FORMAT, PUB_KEY_ALG, PRIV_KEY_ALG, ALIAS, PASSWORD FROM FM_CA_STORE WHERE NAME = ?";
            stmt = null;
            rs = null;
            stmt = this.con.prepareStatement("SELECT NAME, FILE_STORE, CERT, CERT_TYPE, PRIVATE_KEY, PUBLIC_KEY, PUB_KEY_FORMAT, PRIV_KEY_FORMAT, PUB_KEY_ALG, PRIV_KEY_ALG, ALIAS, PASSWORD FROM FM_CA_STORE WHERE NAME = ?");
            stmt.setString(1, name);
            rs = stmt.executeQuery();
            if (rs.next()) break block12;
            File file = null;
            this.close(stmt, rs);
            return file;
        }
        try {
            try {
                byte[] cert = null;
                byte[] privateKey = null;
                if (ORACLE.equalsIgnoreCase(this.rdbms)) {
                    cert = this.getBinaryStream(rs, "CERT");
                    privateKey = this.getBinaryStream(rs, "PRIVATE_KEY");
                } else {
                    cert = rs.getBytes("CERT");
                    privateKey = rs.getBytes("PRIVATE_KEY");
                }
                String password = rs.getString("PASSWORD");
                String alias = rs.getString("ALIAS");
                String privAlg = rs.getString("PRIV_KEY_ALG");
                X509Certificate newCert = TrustTool.getCert(cert);
                PrivateKey newPrivateKey = TrustTool.getPrivateKey(privateKey, privAlg);
                TrustTool.createKS(newCert, newPrivateKey, outFile, alias, password);
            }
            catch (IOException ex) {
                logger.error((Object)("Unable to save file " + outFile + ": " + ex.getMessage()));
            }
            catch (SQLException ex) {
                logger.error((Object)("Error getting blob " + name + ": " + ex.getMessage()));
            }
            this.close(stmt, rs);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)("Unable to query FMCA from db: " + ex.getMessage()));
                this.close(stmt, rs);
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                throw throwable;
            }
        }
        return new File(outFile);
    }

    private byte[] getBinaryStream(ResultSet rs, String columnName) throws SQLException, IOException {
        InputStream is = rs.getBinaryStream(columnName);
        Vector<Byte> pv = new Vector<Byte>();
        int val = -1;
        while ((val = is.read()) > -1) {
            pv.add((byte)val);
        }
        byte[] cert = new byte[pv.size()];
        for (int i = 0; i < cert.length; ++i) {
            cert[i] = (Byte)pv.get(i);
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPgSuperUser(String user) throws Exception {
        if (this.rdbms != POSTGRES) {
            throw new Exception("isPgSuperUser() is not compatible with this DB.");
        }
        String sql = "select rolsuper from pg_roles where rolname=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isSuper = false;
        try {
            stmt = this.con.prepareStatement(sql);
            stmt.setString(1, user);
            rs = stmt.executeQuery();
            if (rs.next() && this.isPostgres()) {
                isSuper = rs.getBoolean("rolsuper");
            }
            this.close(stmt, rs);
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            throw throwable;
        }
        return isSuper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCreateUser(String user) throws SQLException {
        if (user == null) {
            return false;
        }
        String sql = this.isPostgres() ? "select rolcreaterole from pg_roles where rolname=?" : "select PRIVILEGE FROM dba_role_privs where GRANTEE=? AND PRIVILEGE=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean createrole = false;
        try {
            stmt = this.con.prepareStatement(sql);
            stmt.setString(1, user);
            if (!this.isPostgres()) {
                stmt.setString(2, "CREATE USER");
            }
            if ((rs = stmt.executeQuery()).next()) {
                createrole = this.isPostgres() ? rs.getBoolean("rolcreaterole") : rs.getString("PRIVILGE").equals("CREATE USER");
            }
            this.close(stmt, rs);
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            throw throwable;
        }
        return createrole;
    }

    protected void close(Statement stmt, ResultSet rs) {
        this.close(stmt);
        this.close(rs);
    }

    protected void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex) {
                logger.error((Object)("Error closing statement: " + ex.getMessage()));
            }
        }
    }

    protected void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ex) {
                logger.error((Object)("Error closing resultset: " + ex.getMessage()));
            }
        }
    }

    public void startTx() throws SQLException {
        this.con.setAutoCommit(false);
    }

    public void commitTx() throws SQLException {
        this.con.commit();
        this.con.setAutoCommit(true);
    }

    public void rollbackTx() throws SQLException {
        this.con.rollback();
        this.con.setAutoCommit(true);
    }

    public String getRdbms() {
        return this.rdbms;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    private static String convertSPWD(String authpwd, int salt) throws Exception {
        String tmp = StringEncrypter.DESedeDecrypt(authpwd);
        return StringEncrypter.DESedeEncrypt(tmp, salt);
    }

    private static String sconvertPWD(String spwd, int salt) throws Exception {
        String tmp = StringEncrypter.DESedeDecrypt(spwd, salt);
        return StringEncrypter.DESedeEncrypt(tmp);
    }

    public static void main(String[] args) throws Exception {
        String DbDriver = OSQLDRIVER;
        String DbUrl = OSQLURL;
        String DbUser = "mayli1";
        String DbPass = "mayli1";
        DB db = new DB(ORACLE, OSQLURL, "mayli1", "mayli1");
        db.createFMUser("admin2", "nbv12345");
        boolean result = db.authenticateFMAdmin("admin2", "nbv12345");
        System.out.println(result);
    }
}

