/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.VendorPanel;
import com.cisco.dcbu.lib.mds.FRUConstants;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CheckUpgrade {
    private static String[] _searchStrings = new String[]{"Device Manager Version ", "Interim version ", "Version "};

    public static boolean isUpgradeNeeded(String sysDescription, String deviceName, JFrame parent, int type, int chassisType) throws Exception {
        return CheckUpgrade.isUpgradeNeeded(sysDescription, deviceName, parent, type, chassisType, null);
    }

    public static boolean isUpgradeNeeded(String sysDescription, String deviceName, JFrame parent, int type, int chassisType, Properties vendorLinksProperties) throws Exception {
        int endIdx;
        String NMSVersion = "6.3(1)";
        int beginIdx = -1;
        for (String searchString : _searchStrings) {
            beginIdx = sysDescription.indexOf(searchString);
            if (beginIdx == -1) continue;
            beginIdx += searchString.length();
            break;
        }
        if (!CheckUpgrade.isUpgradeNeeded(sysDescription = sysDescription.substring(beginIdx, (endIdx = sysDescription.indexOf(44, beginIdx)) == -1 ? sysDescription.length() : endIdx), NMSVersion, chassisType)) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        if (type == 1) {
            if (FRUConstants.isN5K(chassisType)) {
                sb.append("Supported DM version is " + sysDescription + " or greater. Please check the Cisco site for availability.\n" + "When available, you may download the appropriate DCNM-SAN from Cisco \nor use DM from an appropriate installed FM/DCNM-SAN Server.");
                JOptionPane.showMessageDialog(parent, sb.toString(), parent.getTitle(), 1);
                return false;
            }
            sb.append(deviceName + " is running version " + sysDescription + ", do you want to upgrade DM?");
            Object[] options = new String[]{"Yes", "No"};
            if (JOptionPane.showOptionDialog(parent, sb.toString(), parent != null ? parent.getTitle() : "Check Upgrade", 0, 3, null, options, "No") == 0) {
                ExternalTools.openURL("http://" + deviceName);
                return true;
            }
            return false;
        }
        sb.append("<html>The switch is running version " + sysDescription + ".<br>A Cisco " + "DCNM-SAN" + " update is needed to manage new features.<br>Contact your support services provider for updates.<br><br></html>");
        VendorPanel vendorPanel = new VendorPanel(deviceName, new JLabel(sb.toString()), vendorLinksProperties);
        Object[] options = new String[]{"Yes", "No"};
        if (JOptionPane.showOptionDialog(parent, vendorPanel, parent != null ? parent.getTitle() : "Check Upgrade", 0, 3, null, options, "No") == 0) {
            ExternalTools.openURL(vendorPanel.getVendorURL());
            return true;
        }
        return false;
    }

    public static boolean isUpgradeNeeded(String swVersion, String nmsVersion, int chassisType) {
        try {
            SwitchVersion devVer = new SwitchVersion(swVersion);
            SwitchVersion nmsVer = new SwitchVersion(nmsVersion);
            if (devVer.lessThanEqual(nmsVer)) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }
}

