/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class ExternalTools {
    public static Logger _Logger = Logger.getLogger(ExternalTools.class);
    public static final boolean ONWIN = System.getProperty("os.name").startsWith("Win");
    public static final boolean NONWIN = !System.getProperty("os.name").startsWith("Win");
    public static final boolean ONMAC = System.getProperty("os.name").startsWith("Mac OS X");
    public static String _UnixBrowser = "firefox";
    public static String _TelnetClient = ONWIN ? "telnet.exe $host" : (ONMAC ? "telnet $host" : "telnet $host");
    public static boolean _UseSSH = false;
    public static String _SSHPath = ONWIN ? "C:\\Program Files\\SSH Communications Security\\SSH Secure Shell\\sshclient -h $host -u $user" : (ONMAC ? "ssh $host -l $user" : "ssh $host -l $user");

    public static boolean isUseSSH() {
        return _UseSSH;
    }

    public static void setUseSSH(boolean useSSH) {
        _UseSSH = useSSH;
    }

    public static String getSSHPath() {
        return _SSHPath;
    }

    public static void setSSHPath(String sshPath) {
        _SSHPath = sshPath;
    }

    public static void cli(String deviceName) throws Exception {
        ExternalTools.cli(deviceName, deviceName, null, _UseSSH);
    }

    public static void cli(String ipAddr, boolean useSsh) throws Exception {
        ExternalTools.cli(ipAddr, ipAddr, null, useSsh);
    }

    public static void cli(String deviceName, String ipAddr, String user) throws Exception {
        ExternalTools.cli(deviceName, ipAddr, user, _UseSSH);
    }

    public static void cli(String deviceName, String host, String user, boolean useSSH) throws Exception {
        block17: {
            String protocol;
            String cmd;
            if (useSSH) {
                cmd = _SSHPath;
                protocol = "SSH";
            } else {
                cmd = System.getProperty("mds.telnetClient", _TelnetClient);
                protocol = "TELNET";
            }
            String errDispMsg = protocol + " service is used for Command Line Interface." + "\nPlease install " + protocol + " client or check path in Preferences.";
            if (cmd == null || cmd.trim().length() == 0) {
                throw new Exception(errDispMsg);
            }
            if (ONWIN) {
                if (!useSSH) {
                    cmd = "cmd /c start \"" + deviceName + "\" " + cmd;
                }
            } else {
                cmd = ONMAC ? "/usr/X11/bin/xterm -sb -title " + deviceName + " -e " + cmd : "xterm -sb -title " + deviceName + " -e " + cmd;
            }
            cmd = cmd.replaceAll("\\$host", host);
            if (user != null) {
                cmd = cmd.replaceAll("\\$user", user);
            } else {
                cmd = cmd.replaceAll("-u \\$user", "");
                cmd = cmd.replaceAll("-l \\$user", "");
            }
            try {
                String errMsg;
                Process p = ExternalTools.callExec(cmd);
                Thread.sleep(2000L);
                if (p.exitValue() == 0) break block17;
                try (BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    errMsg = bri.readLine();
                }
                if (errMsg == null) {
                    throw new Exception((useSSH ? "SSH" : "Telnet") + " service unavailable");
                }
            }
            catch (IllegalThreadStateException ex) {
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)("Error running cmd " + cmd + ":" + ex.getClass() + " " + ex.getMessage()), (Throwable)ex);
                throw new Exception(errDispMsg);
            }
        }
    }

    public static Process callExec(String cmd) throws IOException {
        if (cmd == null || cmd.indexOf(34) == -1) {
            _Logger.debug((Object)("calling exec(String) no double-quote found in: " + cmd));
            return Runtime.getRuntime().exec(cmd);
        }
        ArrayList<String> s = ExternalTools.parseCmd(cmd.trim());
        if (s == null) {
            _Logger.debug((Object)("calling exec(String) parse failure in: " + cmd));
            return Runtime.getRuntime().exec(cmd);
        }
        StringBuffer cmdBuf = new StringBuffer();
        String[] cmdarray = new String[s.size()];
        for (int i = 0; i < s.size(); ++i) {
            cmdarray[i] = s.get(i);
            cmdBuf.append(s.get(i)).append("\n");
        }
        _Logger.debug((Object)("calling exec(String[]) for: " + cmd + "\n" + cmdBuf));
        return Runtime.getRuntime().exec(cmdarray);
    }

    public static ArrayList<String> parseCmd(String cmd) {
        int i;
        String[] s;
        ArrayList<String> retCmd = new ArrayList<String>();
        if (cmd == null) {
            return retCmd;
        }
        cmd = cmd.trim();
        int begin = -1;
        int end = -1;
        begin = cmd.indexOf(34);
        if (begin != -1) {
            end = cmd.indexOf(34, begin + 1);
            if (end == -1) {
                end = cmd.length() - 1;
            }
        } else {
            s = cmd.split(" ");
            for (i = 0; i < s.length; ++i) {
                retCmd.add(s[i]);
            }
        }
        if (begin > 0) {
            s = cmd.substring(0, begin).split(" ");
            for (i = 0; i < s.length; ++i) {
                retCmd.add(s[i]);
            }
        }
        if (begin != -1 && end != -1) {
            retCmd.add(cmd.substring(begin + 1, end));
        }
        ArrayList<String> retCmd2 = null;
        if (end != -1 && end < cmd.length() - 1) {
            retCmd2 = ExternalTools.parseCmd(cmd.substring(end + 1));
            retCmd.addAll(retCmd2);
        }
        return retCmd;
    }

    public static void invokeApp(String path, String args) throws Exception {
        block11: {
            String os = System.getProperty("os.name");
            String newargs = null;
            int ind = path.indexOf(" -");
            if (ind > 0) {
                newargs = path.substring(ind) + " " + args;
                path = path.substring(0, ind);
            } else {
                String string = newargs = args == null ? "" : args;
            }
            String cmd = os.startsWith("Win") ? "cmd /c start \"" + (args == null ? "" : args) + "\" \"" + path + "\" " + newargs : "xterm -sb" + (args == null || args.length() == 0 ? "" : " -title " + args) + " -e " + path + " " + newargs;
            try {
                String errMsg;
                Process p = Runtime.getRuntime().exec(cmd);
                Thread.sleep(2000L);
                if (p.exitValue() == 0) break block11;
                try (BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    errMsg = bri.readLine();
                }
                if (errMsg == null) {
                    throw new Exception(path + ":  unavailable");
                }
            }
            catch (IllegalThreadStateException ex) {
            }
            catch (IOException ex) {
                throw new IOException(ex + "\nPlease install " + path + " or check path");
            }
        }
    }

    public static void openURL(String url) throws Exception {
        String[] cmds = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            Runtime.getRuntime().exec(cmds);
        } else if (os.startsWith("Mac OS X")) {
            ExternalTools.macOpenUrl(url);
        } else {
            String browser = System.getProperty("mds.httpBrowser", _UnixBrowser);
            Runtime.getRuntime().exec(browser + " " + url);
        }
    }

    public static void displayURLs(String[] urls, String[] namedWindows) throws Exception {
        int i;
        if (urls == null || urls.length == 0) {
            return;
        }
        File shortcut = File.createTempFile("DisplayURLs", ".html");
        shortcut.deleteOnExit();
        shortcut = shortcut.getCanonicalFile();
        PrintWriter out = new PrintWriter(new FileWriter(shortcut));
        out.println("<!-- saved from url=(0014)about:internet -->");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>DCNM-SAN</title>");
        out.println("<base target=\"" + (namedWindows == null || namedWindows.length == 0 || namedWindows[0] == null ? "_blank" : namedWindows[0]) + "\">");
        out.println("<script language=\"javascript\" type=\"text/javascript\">");
        for (i = 1; i < urls.length; ++i) {
            out.println("window.open(\"" + urls[i] + "\", \"" + (namedWindows == null || namedWindows.length <= i || namedWindows[i] == null ? "_blank" : namedWindows[i]) + "\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        }
        out.println("location.href=\"" + urls[0] + "\";");
        out.println("</script>");
        out.println("</head>");
        out.println("<body onload=\"javascript:displayURLs()\">");
        out.println("<noscript>");
        for (i = 0; i < urls.length; ++i) {
            out.println("<a target=\"" + (namedWindows == null || namedWindows.length == 0 || namedWindows[0] == null ? "_blank" : namedWindows[0]) + "\" href=\"" + urls[i] + "\">" + urls[i] + "</a><br>");
        }
        out.println("</noscript>");
        out.println("</body>");
        out.println("</html>");
        out.close();
        ExternalTools.openURL(shortcut.toURL().toString());
    }

    public static void openUnknownFile(String path) throws Exception {
        String os = System.getProperty("os.name");
        if (os.startsWith("Win")) {
            Runtime.getRuntime().exec("rundll32.exe shell32.dll,OpenAs_RunDLL " + path);
        } else if (os.startsWith("Mac OS X")) {
            ExternalTools.macOpenUrl(path);
        } else {
            String browser = System.getProperty("mds.httpBrowser", _UnixBrowser);
            Runtime.getRuntime().exec(browser + " " + path);
        }
    }

    private static void macOpenUrl(String url) throws Exception {
        try {
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            Method openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        }
        catch (Exception ex) {
            System.err.println("Error opening url " + url);
            throw new Exception("Could not locate Mac Browser");
        }
    }
}

