/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import java.util.StringTokenizer;

public class SnmpBitmap
extends SnmpString {
    public SnmpBitmap(byte[] byteValue) {
        super(byteValue);
    }

    public SnmpBitmap(String bits) throws SnmpException {
        super(SnmpBitmap.parse(bits));
    }

    public SnmpBitmap(String bits, boolean isBase0, int maxAllowedNum) throws SnmpException {
        super(SnmpBitmap.parse(bits, isBase0, maxAllowedNum));
    }

    public SnmpBitmap(String bits, boolean isBase0) throws SnmpException {
        super(SnmpBitmap.parse(bits, isBase0));
    }

    public SnmpBitmap(String bits, int size) throws SnmpException {
        super(SnmpBitmap.parse(bits, false, size, size * 8));
    }

    public SnmpBitmap(String bits, int size, boolean isBase0) throws SnmpException {
        super(SnmpBitmap.parse(bits, isBase0, size, size * 8));
    }

    public SnmpBitmap(String bits, int size, int maxAllowedNum) throws SnmpException {
        super(SnmpBitmap.parse(bits, false, size, maxAllowedNum));
    }

    public String toString() {
        return SnmpBitmap.toString(this._byteValue);
    }

    public static String toString(byte[] b) {
        return SnmpBitmap.toString(b, false);
    }

    public static String toString(byte[] b, boolean isBase0) {
        int i;
        if (b.length == 0) {
            return "none";
        }
        StringBuffer sb = new StringBuffer();
        int max = b.length * 8;
        if (isBase0) {
            for (i = 1; i <= max && !SnmpString.getBitBase0((byte[])b, (int)(i - 1)); ++i) {
            }
        } else {
            while (i <= max && !SnmpString.getBit((byte[])b, (int)i)) {
                ++i;
            }
        }
        while (i <= max) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(isBase0 ? i : i - 1);
            while (i <= max) {
                int j;
                if (isBase0) {
                    for (j = i + 1; j <= max && SnmpString.getBitBase0((byte[])b, (int)(j - 1)); ++j) {
                    }
                } else {
                    while (j <= max && SnmpString.getBit((byte[])b, (int)j)) {
                        ++j;
                    }
                }
                if (j > i + 1) {
                    sb.append('-');
                    sb.append(isBase0 ? j - 1 : j - 2);
                }
                if (isBase0) {
                    for (i = j; i <= max && !SnmpString.getBitBase0((byte[])b, (int)(i - 1)); ++i) {
                    }
                } else {
                    while (i <= max && !SnmpString.getBit((byte[])b, (int)i)) {
                        ++i;
                    }
                }
                if (i > max) continue;
                sb.append(',');
                sb.append(isBase0 ? i : i - 1);
            }
        }
        return sb.toString();
    }

    public static byte[] parse(String bits) throws SnmpException {
        return SnmpBitmap.parse(bits, false);
    }

    public static byte[] parse(String bits, boolean isBase0) throws SnmpException {
        byte[] b = new byte[512];
        return SnmpBitmap.parse(bits, isBase0, b, false, 4093);
    }

    public static byte[] parse(String bits, boolean isBase0, int maxAllowedNum) throws SnmpException {
        byte[] b = new byte[512];
        return SnmpBitmap.parse(bits, isBase0, b, false, maxAllowedNum);
    }

    public static byte[] parse(String bits, boolean isBase0, int size, int maxAllowedNum) throws SnmpException {
        byte[] b = new byte[size];
        return SnmpBitmap.parse(bits, isBase0, b, false, maxAllowedNum);
    }

    public static byte[] parse(String bits, boolean isBase0, byte[] b, boolean trimTrailingZero, int maxAllowedNum) throws SnmpException {
        if (b == null) {
            b = new byte[512];
        }
        int bound = Math.min(b.length * 8, maxAllowedNum);
        StringTokenizer st = new StringTokenizer(bits, ",-", true);
        boolean thru = false;
        boolean delimit = true;
        int start = 0;
        try {
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.charAt(0) == ',') {
                    if (delimit) {
                        throw new SnmpException("Invalid input");
                    }
                    delimit = true;
                    continue;
                }
                if (t.charAt(0) == '-') {
                    if (delimit) {
                        throw new SnmpException("Invalid input");
                    }
                    thru = true;
                    delimit = true;
                    continue;
                }
                delimit = false;
                int bitNo = Integer.parseInt(t.trim());
                if (bitNo > maxAllowedNum || bitNo < 1) {
                    throw new SnmpException("cannot be 0 or above " + maxAllowedNum);
                }
                if (thru) {
                    if (start > bitNo) {
                        throw new SnmpException("Invalid range");
                    }
                    for (int i = start; i <= bitNo; ++i) {
                        if (isBase0) {
                            SnmpBitmap.setBitBase0((byte[])b, (int)(i - 1));
                            continue;
                        }
                        SnmpBitmap.setBit((byte[])b, (int)(i + 1));
                    }
                    thru = false;
                } else if (isBase0) {
                    SnmpBitmap.setBitBase0((byte[])b, (int)(bitNo - 1));
                } else {
                    SnmpBitmap.setBit((byte[])b, (int)(bitNo + 1));
                }
                start = bitNo + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SnmpException("cannot exceed " + bound);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(ex.getMessage() + ". Numbers should be separated by commas(,).");
        }
        if (trimTrailingZero) {
            return SnmpBitmap.trimTrailingZero(b);
        }
        return b;
    }

    public static byte[] parse(String bits, boolean isBase0, byte[] b, boolean trimTrailingZero, int maxAllowedNum, int minAllowedNum) throws SnmpException {
        if (b == null) {
            b = new byte[512];
        }
        int bound = Math.min(b.length * 8, maxAllowedNum);
        StringTokenizer st = new StringTokenizer(bits, ",-", true);
        boolean thru = false;
        boolean delimit = true;
        int start = 0;
        try {
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.charAt(0) == ',') {
                    if (delimit) {
                        throw new SnmpException("Invalid input");
                    }
                    delimit = true;
                    continue;
                }
                if (t.charAt(0) == '-') {
                    if (delimit) {
                        throw new SnmpException("Invalid input");
                    }
                    thru = true;
                    delimit = true;
                    continue;
                }
                delimit = false;
                int bitNo = Integer.parseInt(t.trim());
                if (bitNo > maxAllowedNum || bitNo < minAllowedNum) {
                    throw new SnmpException("cannot be 0 or above " + maxAllowedNum);
                }
                if (thru) {
                    if (start > bitNo) {
                        throw new SnmpException("Invalid range");
                    }
                    for (int i = start; i <= bitNo; ++i) {
                        if (isBase0) {
                            SnmpBitmap.setBitBase0((byte[])b, (int)(i - 1));
                            continue;
                        }
                        SnmpBitmap.setBit((byte[])b, (int)(i + 1));
                    }
                    thru = false;
                } else if (isBase0) {
                    SnmpBitmap.setBitBase0((byte[])b, (int)(bitNo - 1));
                } else {
                    SnmpBitmap.setBit((byte[])b, (int)(bitNo + 1));
                }
                start = bitNo + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SnmpException("cannot exceed " + bound);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(ex.getMessage() + ". Numbers should be separated by commas(,).");
        }
        if (trimTrailingZero) {
            return SnmpBitmap.trimTrailingZero(b);
        }
        return b;
    }

    public static byte[] trimTrailingZero(byte[] b) {
        int newLen = b.length;
        for (int i = newLen - 1; i >= 0 && b[i] == 0; --i) {
            --newLen;
        }
        if (newLen == b.length) {
            return b;
        }
        byte[] b1 = new byte[newLen];
        System.arraycopy(b, 0, b1, 0, newLen);
        return b1;
    }

    public static int[] valueOf(byte[] b, boolean isBase0) {
        int i;
        Array list = new Array();
        int max = b.length * 8;
        int n = i = isBase0 ? 0 : 2;
        while (i < max) {
            while (i < max && !SnmpBitmap.getBit((byte[])b, (int)i)) {
                ++i;
            }
            if (i >= max) continue;
            if (isBase0) {
                list.addElement((Object)new Integer(i + 1));
            } else {
                list.addElement((Object)new Integer(i - 1));
            }
            ++i;
        }
        int[] ids = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            ids[i] = (Integer)list.elementAt(i);
        }
        return ids;
    }
}

