/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpString;
import java.util.Arrays;
import java.util.StringTokenizer;

public class SnmpIntList
extends SnmpString {
    protected IfIndexIf _ifIndexIf;
    private static final int SHIFT_BITS = 12;
    public static final int MAX_PORTS = 704;

    public SnmpIntList(byte[] byteValue, IfIndexIf ifIndexIf) {
        super(byteValue);
        this._ifIndexIf = ifIndexIf;
    }

    public SnmpIntList(String s, IfIndexIf ifIndexIf) throws SnmpException {
        super(SnmpIntList.valueOf(SnmpIntList.parse(s, ifIndexIf)));
        this._value = s;
    }

    public SnmpIntList(String s, IfIndexIf ifIndexIf, int[] slotMembers, int[][] ifNameTypes) throws SnmpException {
        this(s, ifIndexIf, "fc", slotMembers, ifNameTypes);
    }

    public SnmpIntList(String s, IfIndexIf ifIndexIf, String defaultIfName, int[] slotMembers, int[][] ifNameTypes) throws SnmpException {
        super(SnmpIntList.valueOf(SnmpIntList.parse(s, ifIndexIf, defaultIfName, slotMembers, ifNameTypes)));
        this._value = s;
        this._ifIndexIf = ifIndexIf;
    }

    public String toString() {
        if (this._value == null) {
            this._value = SnmpIntList.toString(this._byteValue, this._ifIndexIf);
        }
        return this._value;
    }

    public static String toString(byte[] b, IfIndexIf ifIndexIf) {
        if (b == null || b.length == 0) {
            return null;
        }
        int[] ifIndeces = SnmpIntList.valueOf(b);
        StringBuffer sb = new StringBuffer(32);
        sb.append(ifIndexIf.ifIndexToName(ifIndeces[0]));
        boolean inRange = ifIndeces.length >= 2 && SnmpIntList.contigious(ifIndeces[0], ifIndeces[1], ifIndexIf);
        for (int i = 1; i < ifIndeces.length; ++i) {
            if (!SnmpIntList.contigious(ifIndeces[i - 1], ifIndeces[i], ifIndexIf)) {
                if (inRange) {
                    sb.append('-');
                    sb.append(ifIndexIf.ifIndexToName(ifIndeces[i - 1]));
                }
                sb.append(',');
                sb.append(ifIndexIf.ifIndexToName(ifIndeces[i]));
                inRange = false;
                continue;
            }
            inRange = true;
        }
        if (ifIndeces.length > 1 && inRange) {
            sb.append('-');
            sb.append(ifIndexIf.ifIndexToName(ifIndeces[ifIndeces.length - 1]));
        }
        return sb.toString();
    }

    public static String toString(int[] iList, IfIndexIf ifIndexIf, boolean bStripPortChannel) {
        if (iList == null || iList.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String strVal = ifIndexIf.ifIndexToName(iList[0]);
        if (bStripPortChannel && (strVal.startsWith("Channel") || strVal.startsWith("channel"))) {
            strVal = strVal.substring(7);
        }
        sb.append(strVal);
        boolean inRange = iList.length >= 2 && SnmpIntList.contigious(iList[0], iList[1], ifIndexIf);
        for (int i = 1; i < iList.length; ++i) {
            if (!SnmpIntList.contigious(iList[i - 1], iList[i], ifIndexIf)) {
                if (inRange) {
                    sb.append('-');
                    strVal = ifIndexIf.ifIndexToName(iList[i - 1]);
                    if (bStripPortChannel && (strVal.startsWith("Channel") || strVal.startsWith("channel"))) {
                        strVal = strVal.substring(7);
                    }
                    sb.append(strVal);
                }
                sb.append(',');
                strVal = ifIndexIf.ifIndexToName(iList[i]);
                if (bStripPortChannel && (strVal.startsWith("Channel") || strVal.startsWith("channel"))) {
                    strVal = strVal.substring(7);
                }
                sb.append(strVal);
                inRange = false;
                continue;
            }
            inRange = true;
        }
        if (iList.length > 1 && inRange) {
            sb.append('-');
            strVal = ifIndexIf.ifIndexToName(iList[iList.length - 1]);
            if (bStripPortChannel && strVal.startsWith("Channel")) {
                strVal = strVal.substring(7);
            }
            sb.append(strVal);
        }
        return sb.toString();
    }

    public static String toString(int[] iList) {
        if (iList == null || iList.length == 0) {
            return null;
        }
        Arrays.sort(iList);
        StringBuffer sb = new StringBuffer();
        sb.append(iList[0]);
        boolean inRange = iList.length >= 2 && SnmpIntList.contigious(iList[0], iList[1]);
        for (int i = 1; i < iList.length; ++i) {
            if (!SnmpIntList.contigious(iList[i - 1], iList[i])) {
                if (inRange) {
                    sb.append('-');
                    sb.append(iList[i - 1]);
                }
                sb.append(',');
                sb.append(iList[i]);
                inRange = false;
                continue;
            }
            inRange = true;
        }
        if (iList.length > 1 && inRange) {
            sb.append('-');
            sb.append(iList[iList.length - 1]);
        }
        return sb.toString();
    }

    public static String toString(int[] iList, IfIndexIf ifIndexIf) {
        if (iList == null || iList.length == 0) {
            return null;
        }
        Arrays.sort(iList);
        StringBuffer sb = new StringBuffer();
        sb.append(iList[0]);
        boolean inRange = iList.length >= 2 && SnmpIntList.contigious(iList[0], iList[1], ifIndexIf);
        for (int i = 1; i < iList.length; ++i) {
            if (!SnmpIntList.contigious(iList[i - 1], iList[i], ifIndexIf)) {
                if (inRange) {
                    sb.append('-');
                    sb.append(iList[i - 1]);
                }
                sb.append(',');
                sb.append(iList[i]);
                inRange = false;
                continue;
            }
            inRange = true;
        }
        if (iList.length > 1 && inRange) {
            sb.append('-');
            sb.append(iList[iList.length - 1]);
        }
        return sb.toString();
    }

    public static boolean contigious(int i1, int i2) {
        return (i2 >>= 12) - (i1 >>= 12) == 1;
    }

    public static boolean contigious(int i1, int i2, IfIndexIf ifIndexIf) {
        if (ifIndexIf.isPortRangeSupport()) {
            return (i2 >>= 12) - (i1 >>= 12) == 1;
        }
        return false;
    }

    public static int[] parse(String idList) throws SnmpException {
        return SnmpIntList.parse(idList, null, "fc", null, null);
    }

    public static int[] parse(String idList, IfIndexIf ifIndexIf) throws SnmpException {
        return SnmpIntList.parse(idList, ifIndexIf, "fc", null, null);
    }

    public static int[] parse(String idList, IfIndexIf ifIndexIf, int[] slotMembers, int[][] ifNameTypes) throws SnmpException {
        return SnmpIntList.parse(idList, ifIndexIf, "fc", slotMembers, ifNameTypes);
    }

    public static int[] parse(String idList, IfIndexIf ifIndexIf, String defaultIfName, int[] slotMembers, int[][] ifNameTypes) throws SnmpException {
        if (ifIndexIf == null) {
            return SnmpIntList.parse_MDS(idList, ifIndexIf, defaultIfName, slotMembers, ifNameTypes);
        }
        boolean isPortRangeSupport = ifIndexIf.isPortRangeSupport();
        boolean isPortBase0 = !isPortRangeSupport;
        int[] ids = new int[704];
        int idNum = 0;
        int supIdx = idList.indexOf("sup-fc0");
        if (supIdx != -1) {
            String st1 = idList.substring(0, supIdx);
            String st2 = idList.substring(supIdx + 7, idList.length());
            idList = st1 + "supfc0" + st2;
        }
        StringTokenizer st = new StringTokenizer(idList, ",-", true);
        boolean inRange = false;
        boolean isSingleId = false;
        int start = 0;
        String startString = "";
        String startTypeString = defaultIfName;
        int startType = 1;
        int lastCard = -1;
        int lastPort = -1;
        int lastSingleId = -1;
        while (st.hasMoreTokens()) {
            String typeString;
            String t = st.nextToken().trim();
            if (t.equals("supfc0")) {
                t = "sup-fc0";
            }
            if (t.charAt(0) == ',') continue;
            if (t.equals("vfc")) {
                String next;
                if (st.hasMoreTokens() && st.nextToken().trim().equals("-") && st.hasMoreTokens() && (next = st.nextToken().trim()).startsWith("po")) {
                    t = "vfc-" + next;
                }
            } else if (t.charAt(0) == '-') {
                if (isSingleId) {
                    lastSingleId = start;
                } else {
                    lastCard = ifIndexIf.ifIndex2Card(start) + 1;
                    lastPort = ifIndexIf.ifIndex2Port(start) + (isPortBase0 ? 0 : 1);
                }
                inRange = true;
                continue;
            }
            boolean needIfName = false;
            if (Character.isDigit(t.charAt(0))) {
                boolean ismdsPortFormat = t.indexOf(47) != -1;
                needIfName = !ismdsPortFormat || !defaultIfName.equals("fc");
            } else {
                needIfName = false;
            }
            if (needIfName && inRange && startString.indexOf(47) != -1) {
                int startOffset = startString.toLowerCase().indexOf(startTypeString.toLowerCase());
                StringBuffer sb = new StringBuffer();
                String slotString = startString.substring(startOffset == -1 ? 0 : startOffset + startTypeString.length(), startString.lastIndexOf(47));
                if (t.indexOf(47) == -1) {
                    sb.append(slotString);
                    sb.append('/');
                }
                sb.append(t);
                t = sb.toString();
            }
            int ifIndex = ifIndexIf.nameToIfIndex(needIfName ? (inRange ? startTypeString + t : defaultIfName + t) : t);
            String string = needIfName ? (inRange ? startTypeString : defaultIfName) : (typeString = SnmpIntList.getStartTypeString(t, SnmpIntList.getTypeString(ifIndexIf.getType(ifIndex))));
            if (inRange && !startTypeString.equals(typeString)) {
                throw new NumberFormatException("Ranges can't mix with different types");
            }
            isSingleId = SnmpIntList.isInterfaceSingleId(ifIndex);
            if (inRange) {
                if (isSingleId) {
                    if (ifIndex <= lastSingleId) {
                        throw new NumberFormatException("Invalid port range.");
                    }
                    int i = lastSingleId + 1;
                    while (i <= ifIndex) {
                        ids[idNum++] = i++;
                    }
                } else {
                    int i;
                    int card = ifIndexIf.ifIndex2Card(ifIndex) + 1;
                    int port = ifIndexIf.ifIndex2Port(ifIndex) + (isPortBase0 ? 0 : 1);
                    if (card != lastCard) {
                        if (slotMembers == null || ifNameTypes == null) {
                            throw new NumberFormatException("Ranges can't span across cards");
                        }
                        try {
                            if (card <= lastCard) {
                                throw new NumberFormatException("Invalid port range.");
                            }
                            for (i = lastPort + 1; i <= slotMembers[lastCard - 1]; ++i) {
                                ids[idNum++] = ifIndexIf.nameToIfIndex(lastCard, i, ifNameTypes[lastCard - 1][i - 1]);
                            }
                            for (i = lastCard + 1; i < card; ++i) {
                                for (int j = 1; j <= slotMembers[i - 1]; ++j) {
                                    if (ifNameTypes[i - 1][j - 1] != startType) continue;
                                    ids[idNum++] = ifIndexIf.nameToIfIndex(i, j, ifNameTypes[i - 1][j - 1]);
                                }
                            }
                            lastCard = card;
                            lastPort = 0;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            // empty catch block
                        }
                    }
                    if (port <= lastPort) {
                        throw new NumberFormatException("Invalid port range.");
                    }
                    for (i = lastPort + 1; i <= port; ++i) {
                        ids[idNum++] = ifIndexIf.nameToIfIndex(card, i, ifIndexIf.getActualType(IfIndexUtil.ifNameToifType(startTypeString)));
                    }
                }
                inRange = false;
            } else {
                ids[idNum++] = ifIndex;
            }
            start = ifIndex;
            startString = t;
            startTypeString = SnmpIntList.getStartTypeString(t, typeString);
            startType = IfIndexUtil.getType(ifIndex);
        }
        int[] ifIndeces = new int[idNum];
        System.arraycopy(ids, 0, ifIndeces, 0, ifIndeces.length);
        Arrays.sort(ifIndeces);
        return ifIndeces;
    }

    private static String getStartTypeString(String input, String defaultString) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isDigit(c)) continue;
            return i == 0 ? defaultString : input.substring(0, i);
        }
        return defaultString;
    }

    public static int[] parse_MDS(String idList, IfIndexIf ifIndexIf, String defaultIfName, int[] slotMembers, int[][] ifNameTypes) throws SnmpException {
        int[] ids = new int[704];
        int idNum = 0;
        int supIdx = idList.indexOf("sup-fc0");
        if (supIdx != -1) {
            String st1 = idList.substring(0, supIdx);
            String st2 = idList.substring(supIdx + 7, idList.length());
            idList = st1 + "supfc0" + st2;
        }
        StringTokenizer st = new StringTokenizer(idList, ",-", true);
        boolean inRange = false;
        boolean isSingleId = false;
        int start = 0;
        String startTypeString = defaultIfName;
        int startType = 1;
        int lastCard = -1;
        int lastPort = -1;
        int lastSingleId = -1;
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (t.equals("supfc0")) {
                t = "sup-fc0";
            }
            if (t.charAt(0) == ',') continue;
            if (t.charAt(0) == '-') {
                if (isSingleId) {
                    lastSingleId = start;
                } else {
                    lastCard = IfIndexUtil.ifIndex2Card(start) + 1;
                    lastPort = IfIndexUtil.ifIndex2Port(start) + 1;
                }
                inRange = true;
                continue;
            }
            int ifIndex = ifIndexIf.nameToIfIndex(Character.isDigit(t.charAt(0)) ? (inRange ? startTypeString + t : defaultIfName + t) : t);
            String typeString = SnmpIntList.getTypeString(ifIndex);
            if (inRange && !startTypeString.equals(typeString)) {
                throw new NumberFormatException("Ranges can't mix with different types");
            }
            isSingleId = SnmpIntList.isInterfaceSingleId(ifIndex);
            if (inRange) {
                if (isSingleId) {
                    int i = lastSingleId + 1;
                    while (i <= ifIndex) {
                        ids[idNum++] = i++;
                    }
                } else {
                    int i;
                    int card = IfIndexUtil.ifIndex2Card(ifIndex) + 1;
                    int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
                    if (card != lastCard) {
                        if (slotMembers == null || ifNameTypes == null) {
                            throw new NumberFormatException("Ranges can't span across cards");
                        }
                        try {
                            for (i = lastPort + 1; i <= slotMembers[lastCard - 1]; ++i) {
                                ids[idNum++] = IfIndexUtil.nameToIfIndex(lastCard, i, ifNameTypes[lastCard - 1][i - 1]);
                            }
                            for (i = lastCard + 1; i < card; ++i) {
                                for (int j = 1; j <= slotMembers[i - 1]; ++j) {
                                    if (ifNameTypes[i - 1][j - 1] != startType) continue;
                                    ids[idNum++] = IfIndexUtil.nameToIfIndex(i, j, ifNameTypes[i - 1][j - 1]);
                                }
                            }
                            lastCard = card;
                            lastPort = 0;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            // empty catch block
                        }
                    }
                    for (i = lastPort + 1; i <= port; ++i) {
                        ids[idNum++] = IfIndexUtil.nameToIfIndex(card, i, startType);
                    }
                }
                inRange = false;
            } else {
                ids[idNum++] = ifIndex;
            }
            start = ifIndex;
            startTypeString = typeString;
            startType = IfIndexUtil.getType(ifIndex);
        }
        int[] ifIndeces = new int[idNum];
        System.arraycopy(ids, 0, ifIndeces, 0, ifIndeces.length);
        Arrays.sort(ifIndeces);
        return ifIndeces;
    }

    public static byte[] valueOf(int[] ids) {
        byte[] b = new byte[ids.length * 4];
        int bCount = 0;
        for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            b[bCount++] = (byte)(id >> 24);
            b[bCount++] = (byte)(id >> 16);
            b[bCount++] = (byte)(id >> 8);
            b[bCount++] = (byte)id;
        }
        return b;
    }

    public static int[] valueOf(byte[] b) {
        int[] ids = new int[b.length / 4];
        int j = 0;
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = SnmpIntList.bytesToInt(b, j);
            j += 4;
        }
        return ids;
    }

    public static int bytesToInt(byte[] b, int offset) {
        return ((b[offset] & 0xFF) << 24) + ((b[offset + 1] & 0xFF) << 16) + ((b[offset + 2] & 0xFF) << 8) + (b[offset + 3] & 0xFF);
    }

    public static String getTypeString(int ifIndex) {
        int type = IfIndexUtil.getType(ifIndex);
        int subtype = IfIndexUtil.getSubType(ifIndex);
        switch (type) {
            case 2: {
                return "GigE";
            }
            case 4: {
                return "channel";
            }
            case 5: {
                return "mgmt";
            }
            case 6: {
                return "sup-fc0";
            }
            case 8: {
                return "vsan";
            }
            case 10: {
                return "fcip";
            }
            case 11: {
                return "iscsi";
            }
            case 12: {
                return "Avanti";
            }
            case 14: {
                return "fv";
            }
            case 26: 
            case 30: 
            case 31: {
                if (subtype == 0) {
                    return "vfc";
                }
                if (subtype == 2) {
                    return "vfc";
                }
                if (subtype == 4) {
                    return "vfc";
                }
                if (subtype == 1) {
                    return "vfc-po";
                }
            }
            case 28: {
                return IfIndexUtil.ifTypeToifName(type);
            }
        }
        return "fc";
    }

    public static boolean isInterfaceSingleId(int ifIndex) {
        int type = IfIndexUtil.getType(ifIndex);
        int subtype = IfIndexUtil.getSubType(ifIndex);
        return type != 1 && (type != 30 || subtype != 2 && subtype != 4) && type != 2 && type != 26 && type != 31 && type != 11 && type != 12 && type != 14;
    }
}

