/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class Wwn
implements Serializable,
Comparator,
Comparable {
    static final long serialVersionUID = 1L;
    public static final int LENGTH = 8;
    final byte[] _value;
    transient String _label;
    transient int _hash;
    transient boolean _isEnabled;
    transient boolean _isPrepend;

    public Wwn(byte[] value) {
        if (value.length == 16) {
            this._value = new byte[8];
            System.arraycopy(value, 0, this._value, 0, 8);
        } else {
            this._value = new byte[8];
            System.arraycopy(value, 0, this._value, 0, value.length);
        }
    }

    public Wwn(SnmpString string) {
        this(string.getValue());
    }

    public Wwn(String wwn_str, boolean withSemiColon) throws NumberFormatException {
        this._value = SnmpString.fromHexString((String)wwn_str, (boolean)withSemiColon);
    }

    public Wwn(String wwn_str) throws NumberFormatException {
        this(wwn_str, wwn_str.contains(":".subSequence(0, 1)));
    }

    public static byte[] fromHexString(String s) {
        return SnmpString.fromHexString((String)s);
    }

    public byte[] getValue() {
        return this._value;
    }

    public String toString() {
        if (this._label == null || WwnDictionary.isEnabled() != this._isEnabled || WwnDictionary.isPrepend() != this._isPrepend) {
            this._label = WwnDictionary.get(this._value);
            this._isEnabled = WwnDictionary.isEnabled();
            this._isPrepend = WwnDictionary.isPrepend();
        }
        return this._label;
    }

    public String toHexString(boolean useSemicolon) {
        if (this._value == null) {
            return "";
        }
        return SnmpString.toHexString((byte[])this._value, (int)0, (int)this._value.length, (boolean)useSemicolon);
    }

    public int hashCode() {
        if (this._hash == 0) {
            int lo = (this._value[3] << 24) + (this._value[2] << 16) + (this._value[1] << 8) + this._value[0];
            int hi = (this._value[7] << 24) + (this._value[6] << 16) + (this._value[5] << 8) + this._value[4];
            this._hash = lo ^ hi;
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object wwn) {
        if (this == wwn) {
            return true;
        }
        if (wwn == null || !(wwn instanceof Wwn)) {
            return false;
        }
        return Arrays.equals(this._value, ((Wwn)wwn)._value);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        Wwn wwn1 = (Wwn)o1;
        Wwn wwn2 = (Wwn)o2;
        for (int i = 0; i < 8; ++i) {
            if (wwn1._value[i] == wwn2._value[i]) continue;
            return (wwn1._value[i] & 0xFF) - (wwn2._value[i] & 0xFF);
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }
}

