/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpString;

public class WwnUtil {
    private static final int[] IBM_SHARK_FCHBA_PORT = new int[]{196, 195, 194, 193, 204, 203, 202, 201, 200, 199, 198, 197, 208, 207, 206, 205};
    private static final int[] IBM_SHARK_ESCON_PORT1 = new int[]{0, 4, 8, 12, 32, 36, 40, 44, 128, 132, 136, 140, 160, 164, 168, 172};
    private static final int[] IBM_SHARK_ESCON_PORT2 = new int[]{1, 5, 9, 13, 33, 37, 41, 45, 129, 133, 137, 141, 161, 165, 169, 173};
    private static final int[] IBM_DS6K_UC_PORT = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] IBM_DS6K_LC_PORT = new int[]{128, 129, 130, 131, 132, 133, 134, 135};

    public static boolean isIBMStorage_Shark_NWwn(byte[] nWwn) {
        if (nWwn == null || nWwn.length != 8) {
            return false;
        }
        int p = nWwn[5] & 0xFF;
        return p == 192 && WwnDictionary.getVendorId(nWwn) == 20598;
    }

    public static boolean isIBMStorage_DS8K_NWwn(byte[] nWwn) {
        if (nWwn == null || nWwn.length != 8) {
            return false;
        }
        int p1 = nWwn[5] & 0xFF;
        int p2 = nWwn[6] & 0xF0;
        return p1 == 255 && p2 == 192 && WwnDictionary.getVendorId(nWwn) == 20598;
    }

    public static boolean isIBMStorage_DS6K_NWwn(byte[] nWwn) {
        if (nWwn == null || nWwn.length != 8) {
            return false;
        }
        int p1 = nWwn[5] & 0xFF;
        boolean ret = false;
        if (p1 == 254 && WwnDictionary.getVendorId(nWwn) == 20598) {
            ret = true;
        } else if (p1 == 255) {
            ret = !WwnUtil.isIBMStorage_DS8K_NWwn(nWwn);
        }
        return ret;
    }

    public static boolean isIBMStorage_DS4800_NWwn(byte[] nWwn, byte[] pWwn) {
        if (nWwn == null || nWwn.length != 8 || pWwn == null || pWwn.length != 8) {
            return false;
        }
        int p1 = nWwn[1] & 0xFF;
        int p2 = pWwn[1] & 0xF0;
        return p1 == 4 && p2 >= 16 && WwnDictionary.getVendorId(nWwn) == 41144;
    }

    public static boolean isIBMStorage_DS4K_NWwn(byte[] nWwn, byte[] pWwn) {
        if (nWwn == null || nWwn.length != 8 || pWwn == null || pWwn.length != 8) {
            return false;
        }
        int p1 = nWwn[1] & 0xFF;
        int p2 = pWwn[1] & 0xFF;
        return (p1 == 2 || p1 == 4 || p1 == 6) && p2 < 16 && WwnDictionary.getVendorId(nWwn) == 41144;
    }

    public static String translateIBMStorage_Shark_PWwn(byte[] pWwn) {
        int i;
        String port = "Unknown_Port";
        int p = pWwn[5] & 0xFF;
        boolean found = false;
        for (i = 0; i < IBM_SHARK_FCHBA_PORT.length; ++i) {
            if (p != IBM_SHARK_FCHBA_PORT[i]) continue;
            port = "HB" + (i / 4 + 1) + "-S" + (i % 4 + 1) + "1";
            found = true;
            break;
        }
        if (!found) {
            for (i = 0; i < IBM_SHARK_ESCON_PORT1.length; ++i) {
                if (p != IBM_SHARK_ESCON_PORT1[i]) continue;
                port = "HB" + (i / 4 + 1) + "-S" + (i % 4 + 1) + "1";
                found = true;
                break;
            }
        }
        if (!found) {
            for (i = 0; i < IBM_SHARK_ESCON_PORT2.length; ++i) {
                if (p != IBM_SHARK_ESCON_PORT2[i]) continue;
                port = "HB" + (i / 4 + 1) + "-S" + (i % 4 + 1) + "2";
                found = true;
                break;
            }
        }
        String s = SnmpString.toHexString((byte[])pWwn, (int)0, (int)8, (boolean)false);
        return "IBM2105-" + s.substring(12, 16) + "-" + port;
    }

    public static String translateIBMStorage_DS6K_PWwn(byte[] pWwn) {
        int i;
        String port = "Unknown_Port";
        String s = SnmpString.toHexString((byte[])pWwn, (int)0, (int)8, (boolean)false);
        int p = pWwn[5] & 0xFF;
        boolean found = false;
        for (i = 0; i < IBM_DS6K_UC_PORT.length; ++i) {
            if (p != IBM_DS6K_UC_PORT[i]) continue;
            port = "UC-" + s.substring(10, 12);
            found = true;
            break;
        }
        if (!found) {
            for (i = 0; i < IBM_DS6K_LC_PORT.length; ++i) {
                if (p != IBM_DS6K_LC_PORT[i]) continue;
                port = "LC-" + s.substring(10, 12);
                found = true;
                break;
            }
        }
        return "IBM1750-" + s.substring(12, 16) + "-" + port;
    }

    public static String translateIBMStorage_DS8K_PWwn(byte[] pWwn) {
        String rack = "Unknown";
        String encl = "Unknown";
        String slot = "Unknown";
        String port = "Unknown";
        String s = SnmpString.toHexString((byte[])pWwn, (int)0, (int)8, (boolean)false);
        char y1 = s.charAt(10);
        char y2 = s.charAt(11);
        char y3 = s.charAt(12);
        if (y1 == '0') {
            rack = "R1";
            switch (y2) {
                case '0': {
                    encl = "XI1";
                    slot = "S1";
                    break;
                }
                case '1': {
                    encl = "XI1";
                    slot = "S2";
                    break;
                }
                case '3': {
                    encl = "XI1";
                    slot = "S4";
                    break;
                }
                case '4': {
                    encl = "XI1";
                    slot = "S5";
                    break;
                }
                case '8': {
                    encl = "XI2";
                    slot = "S1";
                    break;
                }
                case '9': {
                    encl = "XI2";
                    slot = "S2";
                    break;
                }
                case 'B': {
                    encl = "XI2";
                    slot = "S4";
                    break;
                }
                case 'C': {
                    encl = "XI2";
                    slot = "S5";
                }
            }
        } else if (y1 == '1') {
            rack = "R1";
            switch (y2) {
                case '0': {
                    encl = "XI3";
                    slot = "S1";
                    break;
                }
                case '1': {
                    encl = "XI3";
                    slot = "S2";
                    break;
                }
                case '3': {
                    encl = "XI3";
                    slot = "S4";
                    break;
                }
                case '4': {
                    encl = "XI3";
                    slot = "S5";
                    break;
                }
                case '8': {
                    encl = "XI4";
                    slot = "S1";
                    break;
                }
                case '9': {
                    encl = "XI4";
                    slot = "S2";
                    break;
                }
                case 'B': {
                    encl = "XI4";
                    slot = "S4";
                    break;
                }
                case 'C': {
                    encl = "XI4";
                    slot = "S5";
                }
            }
        } else if (y1 == '2') {
            rack = "R2";
            switch (y2) {
                case '0': {
                    encl = "XI1";
                    slot = "S1";
                    break;
                }
                case '1': {
                    encl = "XI1";
                    slot = "S2";
                    break;
                }
                case '3': {
                    encl = "XI1";
                    slot = "S4";
                    break;
                }
                case '4': {
                    encl = "XI1";
                    slot = "S5";
                    break;
                }
                case '8': {
                    encl = "XI2";
                    slot = "S1";
                    break;
                }
                case '9': {
                    encl = "XI2";
                    slot = "S2";
                    break;
                }
                case 'B': {
                    encl = "XI2";
                    slot = "S4";
                    break;
                }
                case 'C': {
                    encl = "XI2";
                    slot = "S5";
                }
            }
        } else if (y1 == '3') {
            rack = "R2";
            switch (y2) {
                case '0': {
                    encl = "XI3";
                    slot = "S1";
                    break;
                }
                case '1': {
                    encl = "XI3";
                    slot = "S2";
                    break;
                }
                case '3': {
                    encl = "XI3";
                    slot = "S4";
                    break;
                }
                case '4': {
                    encl = "XI3";
                    slot = "S5";
                    break;
                }
                case '8': {
                    encl = "XI4";
                    slot = "S1";
                    break;
                }
                case '9': {
                    encl = "XI4";
                    slot = "S2";
                    break;
                }
                case 'B': {
                    encl = "XI4";
                    slot = "S4";
                    break;
                }
                case 'C': {
                    encl = "XI4";
                    slot = "S5";
                }
            }
        }
        switch (y3) {
            case '0': {
                port = "1";
                break;
            }
            case '4': {
                port = "2";
                break;
            }
            case '8': {
                port = "3";
                break;
            }
            case 'C': {
                port = "4";
            }
        }
        return "IBM2107-" + s.substring(13, 16) + "-" + rack + "-" + encl + "-" + slot + port;
    }

    public static String translateIBMStorage_DS4800_PWwn(byte[] pWwn) {
        String ctlr = "Unknown_Controller";
        String s = SnmpString.toHexString((byte[])pWwn, (int)0, (int)8, (boolean)false);
        char port = s.charAt(2);
        char z = s.charAt(3);
        if (z == '4') {
            ctlr = "A";
        } else if (z == '5') {
            ctlr = "B";
        }
        return "IBMDS4800-" + s.substring(10, 16) + "-" + ctlr + port;
    }

    public static String translateIBMStorage_DS4K_PWwn(byte[] pWwn, byte[] nWwn) {
        String ctlr = "Unknown_Controller";
        String s1 = SnmpString.toHexString((byte[])pWwn, (int)0, (int)8, (boolean)false);
        String s2 = SnmpString.toHexString((byte[])nWwn, (int)0, (int)8, (boolean)false);
        char y1 = s1.charAt(15);
        char y2 = s2.charAt(15);
        char z = s1.charAt(3);
        if (z == '2' || z == '4' || z == '6') {
            ctlr = "A";
        } else if (z == '3' || z == '5' || z == '7') {
            ctlr = "B";
        }
        int port = y1 - y2;
        return "IBMDS4000-" + s1.substring(10, 15) + "-" + ctlr + port;
    }

    public static void main(String[] args) {
        String nWwn_str = "20:04:00:A0:B8:12:34:5D";
        String pWwn_str = "20:05:00:A0:B8:12:34:5E";
        byte[] nWwn = SnmpString.fromHexString((String)nWwn_str);
        byte[] pWwn = SnmpString.fromHexString((String)pWwn_str);
        String s = null;
        if (WwnUtil.isIBMStorage_Shark_NWwn(nWwn)) {
            s = WwnUtil.translateIBMStorage_Shark_PWwn(pWwn);
        } else if (WwnUtil.isIBMStorage_DS8K_NWwn(nWwn)) {
            s = WwnUtil.translateIBMStorage_DS8K_PWwn(pWwn);
        } else if (WwnUtil.isIBMStorage_DS6K_NWwn(nWwn)) {
            s = WwnUtil.translateIBMStorage_DS6K_PWwn(pWwn);
        } else if (WwnUtil.isIBMStorage_DS4800_NWwn(nWwn, pWwn)) {
            s = WwnUtil.translateIBMStorage_DS4800_PWwn(pWwn);
        } else if (WwnUtil.isIBMStorage_DS4K_NWwn(nWwn, pWwn)) {
            s = WwnUtil.translateIBMStorage_DS4K_PWwn(pWwn, nWwn);
        } else {
            System.out.println("Node WWN is not matching with any model: " + SnmpString.toHexString((byte[])nWwn));
        }
        System.out.println("PWWN=" + pWwn_str + ", after translation= " + s);
    }
}

