/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class CopyConfigUtil {
    public static final int WAITING = 1;
    public static final int RUNNING = 2;
    public static final int SUCCESSFUL = 3;
    public static final int FAILED = 4;
    public static final int CONFIGAPPLYFAILED = 7;
    public static final int REQUESTABORTED = 9;
    public static final int STARTUP_CONFIG = 3;
    public static final int RUNNING_CONFIG = 4;

    public static int[] CopyConfig(SnmpPeer peer, int src, int dst, String serverAddr, String fileName, int protocol, String user, String password, String version) throws SnmpException {
        VarBindList vb = new VarBindList();
        int[] _index = new int[]{CopyConfigUtil.getCopyConfigVbl(vb, peer, src, dst, serverAddr, fileName, protocol, user, password, version)};
        ArrayList<Integer> passwdList = new ArrayList<Integer>();
        for (int i = 0; i < vb.size(); ++i) {
            if (!SnmpOID.startsWith((int[])vb.get(i).getOid().getValue(), (int[])MibNode.get((String)"ccCopyUserPassword").getOid())) continue;
            passwdList.add(new Integer(i));
        }
        int[] maskList = new int[passwdList.size()];
        for (int i = 0; i < passwdList.size(); ++i) {
            maskList[i] = (Integer)passwdList.get(i);
        }
        SnmpPDU pdu = new SnmpPDU(-93, vb);
        pdu.setIgnoreSetCount(true);
        pdu.setVarBindMask(maskList);
        peer.set(pdu);
        return _index;
    }

    public static int getCopyConfigVbl(VarBindList vb, SnmpPeer peer, int src, int dst, String serverAddr, String fileName, int protocol, String user, String password) throws SnmpException {
        return CopyConfigUtil.getCopyConfigVbl(vb, peer, src, dst, serverAddr, fileName, protocol, user, password, null);
    }

    public static int getCopyConfigVbl(VarBindList vb, SnmpPeer peer, int src, int dst, String serverAddr, String fileName, int protocol, String user, String password, String switchVersion) throws SnmpException {
        boolean istftp;
        if (src == dst) {
            throw new SnmpException("Source and Destination must be different types");
        }
        boolean isCopyToFromServer = src == 1 || dst == 1;
        boolean bl = istftp = protocol == 1;
        if (isCopyToFromServer) {
            if (fileName == null || fileName.length() == 0) {
                throw new SnmpException("Please supply a FileName");
            }
            if (!(istftp || user.length() != 0 && password.length() != 0)) {
                throw new SnmpException("Please supply username and password");
            }
        }
        int index = (int)(Math.random() * 2.14748364E8) + 1;
        vb.add(MibNode.get((String)"ccCopyEntryRowStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
        vb.add(MibNode.get((String)"ccCopySourceFileType").getOid(), index, (SnmpVar)new SnmpInt(src));
        vb.add(MibNode.get((String)"ccCopyDestFileType").getOid(), index, (SnmpVar)new SnmpInt(dst));
        if (isCopyToFromServer) {
            try {
                SwitchVersion v3 = new SwitchVersion("3.0(0)");
                SwitchVersion swVersion = new SwitchVersion(switchVersion);
                InetAddress inetAddr = InetAddress.getByName(serverAddr);
                if (inetAddr instanceof Inet6Address || swVersion.compareTo(v3) >= 0) {
                    vb.add(MibNode.get((String)"ccCopyServerAddressType").getOid(), index, (SnmpVar)new SnmpInt(inetAddr instanceof Inet6Address ? 2 : 1));
                    vb.add(MibNode.get((String)"ccCopyServerAddressRev1").getOid(), index, (SnmpVar)new SnmpString(inetAddr.getAddress()));
                } else {
                    vb.add(MibNode.get((String)"ccCopyServerAddress").getOid(), index, (SnmpVar)new SnmpIpAddress(inetAddr.getHostAddress()));
                }
            }
            catch (UnknownHostException ex) {
                throw new SnmpException("Unknown Host: " + serverAddr);
            }
            vb.add(MibNode.get((String)"ccCopyFileName").getOid(), index, (SnmpVar)new SnmpString(fileName));
            vb.add(MibNode.get((String)"ccCopyProtocol").getOid(), index, (SnmpVar)new SnmpInt(protocol));
            if (!istftp) {
                vb.add(MibNode.get((String)"ccCopyUserName").getOid(), index, (SnmpVar)new SnmpString(user));
                vb.add(MibNode.get((String)"ccCopyUserPassword").getOid(), index, (SnmpVar)new SnmpString(password));
            }
        }
        return index;
    }

    public static SnmpPDU getCopyConfigStatusPDU(int[] index) {
        SnmpPDU ccStatusPDU = new SnmpPDU(-96, new VarBindList());
        ccStatusPDU.addNull(new SnmpOID(MibNode.get((String)"ccCopyState").getOid(), index));
        ccStatusPDU.addNull(new SnmpOID(MibNode.get((String)"ccCopyFailCause").getOid(), index));
        return ccStatusPDU;
    }

    public static void deleteCopyConfigEntry(SnmpPeer peer, int[] index) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get((String)"ccCopyEntryRowStatus").getOid(), index), (SnmpVar)new SnmpInt(6));
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
    }
}

