/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.InterfaceEditor;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.mds.PortChooserIf;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetCellCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicBorders;

public class InterfacePortsCellEditor
extends DefaultCellEditor
implements ActionListener,
PortChooserIf {
    private JPanel _panel;
    private JTextField _data;
    private Object _value;
    private static Icon _more = Util.loadIcon("icons/more.gif");
    int _row;
    int _column;
    JTable _table;
    public static PortChooser _PortChooser;
    public static InterfaceEditor _interfaceEditor;
    protected JMenu _menu;
    String _windowTitle;
    int _type;
    boolean _exclusive;
    PortEditorCardAttribute[] _slotmembers;
    PortEditorFilter _filters;
    PortSetCellCallbackIf _cellCallback;
    int[] _cardFilters;
    int[] _ifFilters;
    int _cardOperator;
    int[] _cardFilterOnIfType;
    SnmpPeer _peer;
    int _logical_Interface_type;
    boolean _isFICON;
    String _physicalIfName;
    String _logicalIfName;
    boolean _showIfPrefix;
    boolean _allowNoSelectionWhenExclusive;
    IfIndexIf _ifIndexIf;

    public InterfacePortsCellEditor(String title, boolean exclusive, IfIndexIf ifIndexIf, PortEditorCardAttribute[] slotmembers, PortEditorFilter filters) {
        this(title, 1, exclusive, ifIndexIf, slotmembers, filters, null, -1);
    }

    public InterfacePortsCellEditor(String title, boolean exclusive, SnmpPeer peer, IfIndexIf ifIndexIf, int logical_Interface_type) {
        this(title, 2, exclusive, ifIndexIf, null, null, peer, logical_Interface_type);
    }

    public InterfacePortsCellEditor(String title, int type, boolean exclusive, IfIndexIf ifIndexIf, PortEditorCardAttribute[] slotmembers, PortEditorFilter filters, SnmpPeer peer, int logical_Interface_type) {
        super(new JComboBox());
        this.setClickCountToStart(2);
        this._windowTitle = title;
        this._type = type;
        this._exclusive = exclusive;
        this._ifIndexIf = ifIndexIf;
        this._slotmembers = slotmembers;
        this._filters = filters;
        this._cardFilters = this._filters == null ? null : this._filters.getCardFilter();
        this._ifFilters = this._filters == null ? null : this._filters.getIfFilter();
        this._cardOperator = this._filters == null ? 0 : this._filters.getCardOperator();
        this._cardFilterOnIfType = this._filters == null ? null : this._filters.getCardFilterOnIfType();
        this._peer = peer;
        this._logical_Interface_type = logical_Interface_type;
        this._isFICON = false;
        this._showIfPrefix = false;
        this._panel = new JPanel(new BorderLayout());
        this._data = new JTextField();
        this._data.setBorder(BorderFactory.createLineBorder(Color.black));
        this._data.setFont(ChangedCellRenderer.getChangeFont());
        this._panel.add((Component)this._data, "Center");
        JButton btn = new JButton(_more);
        btn.setPreferredSize(new Dimension(_more.getIconWidth(), btn.getPreferredSize().height));
        btn.setBorder(BasicBorders.getButtonBorder());
        btn.addActionListener(this);
        this._panel.add((Component)btn, "East");
        this._panel.setBorder(null);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._column = column;
        this._table = table;
        this._value = value;
        this._data.setText(value != null ? value.toString() : "");
        Component[] changeListeners = ((SnmpKTable)this._table).getChangeListener();
        if (changeListeners != null) {
            for (int i = 0; i < changeListeners.length; ++i) {
                changeListeners[i].setEnabled(true);
            }
        }
        return this._panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this._data.getText();
    }

    protected void setIsFiconPortDialog(boolean isFicon) {
        _PortChooser.setIsFICON(isFicon, this._peer);
    }

    protected void setPreSelectFilterEnable(boolean enabled) {
        _PortChooser.setPreSelectFilterEnable(enabled);
    }

    protected void sanityCheckFilter() {
    }

    protected void setShowIfPrefix(boolean showIfPrefix) {
        _PortChooser.setShowIfPrefix(true);
    }

    public void setIfIndexIf(IfIndexIf ifIndexIf) {
        this._ifIndexIf = ifIndexIf;
    }

    public void setAllowNoSelectionWhenExclusive(boolean allowNoSelectionWhenExclusive) {
        this._allowNoSelectionWhenExclusive = allowNoSelectionWhenExclusive;
    }

    @Override
    public void portChooserCB(String ifName, Object context) {
        this._data.setText(ifName);
    }

    public void setCellCallBack(PortSetCellCallbackIf cellCallback) {
        this._cellCallback = cellCallback;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (_PortChooser == null) {
            _PortChooser = new PortChooser(Util.getFrameAncestor(this._table));
        }
        _PortChooser.setCellCallBack(this._cellCallback);
        _PortChooser.setType(this._type);
        _PortChooser.setTitle(this._windowTitle);
        _PortChooser.setFilters(new PortEditorFilter(this._cardFilters, this._ifFilters, this._cardOperator, this._cardFilterOnIfType));
        _PortChooser.setTarget(this);
        _PortChooser.setIfIndexIf(this._ifIndexIf);
        _PortChooser.setAllowNoSelectionWhenExclusive(this._allowNoSelectionWhenExclusive);
        this.setIsFiconPortDialog(this._isFICON);
        this.setPreSelectFilterEnable(false);
        Object value = ((SnmpTableModel)this._table.getModel()).getSetValueAt(this.getCellEditorValue(), this._table.getSelectedRow(), this._table.convertColumnIndexToModel(this._table.getSelectedColumn()));
        if (value != null && value instanceof SnmpIntList) {
            _PortChooser.setSelected(SnmpIntList.valueOf(((SnmpIntList)((Object)value)).getValue()));
        } else if (value != null && value instanceof InterfaceIndex) {
            _PortChooser.setSelected(new int[]{((InterfaceIndex)((Object)value)).getValue()});
        } else {
            _PortChooser.setSelected(null);
        }
        this.sanityCheckFilter();
        _PortChooser.setSlotMembers(this._slotmembers);
        _PortChooser.setLogicalInterfaceType(this._logical_Interface_type);
        _PortChooser.setExclusive(this._exclusive);
        this.setShowIfPrefix(this._showIfPrefix);
        _PortChooser.showPortDialog((JComponent)e.getSource());
    }
}

