/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.util.StringUtil;

public class MibVariableSet {
    public static IfIndexIf _IfIndexIf;
    public static final String[] _RevokeChkMethodString;
    public static final byte[][] _RevokeChkMethodValue;
    public static final int REVOKE_CHK_METHOD_LEN = 16;

    private MibVariableSet() {
    }

    public static SnmpVar cefcModuleAdminStatus(Object value) {
        return new SnmpInt(3);
    }

    public static SnmpVar dmFcIdPurge(Object value) {
        return new SnmpInt(2);
    }

    public static SnmpVar commonRoleScopeRestriction(Object value) {
        return new SnmpInt((Boolean)value != false ? 2 : 1);
    }

    public static SnmpVar iscsi2FcNodeFcAddrAssignment(Object value) {
        return new SnmpInt((Boolean)value != false ? 1 : 2);
    }

    public static SnmpVar portChannelExtPersistent(Object value) {
        return new SnmpInt((Boolean)value != false ? 2 : 1);
    }

    public static SnmpVar portChannelAddType(Object value) {
        return new SnmpInt((Boolean)value != false ? 2 : 1);
    }

    public static SnmpVar cippfIpFilterPrecedence(Object value) {
        int sel = ((MibEnum)value).getValue();
        if (sel == 99) {
            return new SnmpInt(-1);
        }
        return null;
    }

    public static SnmpVar cfcspDhChapGroupList(Object value) throws Exception {
        String[] groupList = new String[]{"null", "1024", "1280", "1536", "2048"};
        String[] list = StringUtil.tokenize(value.toString(), ":");
        StringBuffer names = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                names.append(':');
            }
            boolean found = false;
            for (int j = 0; j < groupList.length; ++j) {
                if (!groupList[j].equals(list[i])) continue;
                names.append(j);
                found = true;
                break;
            }
            if (found) continue;
            throw new Exception("illegal DH code");
        }
        return new SnmpString(names.toString());
    }

    public static SnmpVar ccmCommonUserSNMPPrivProtocol(Object value) throws Exception {
        return MibVariableSet.ccmCommonUserSNMPAuthProtocol(value);
    }

    public static SnmpVar ccmCommonUserSNMPAuthProtocol(Object value) throws Exception {
        return new SnmpOID(MibVariableFormat._UsmUserProtocolOid[((MibEnum)value).getValue()]);
    }

    public static SnmpVar cigIscsiInitTgtSecondaryVsan(Object value) throws Exception {
        if (value instanceof String && (((String)value).equals("") || ((String)value).equals("none") || ((String)value).equals("n/a"))) {
            return new SnmpInt(0);
        }
        int vsan = Integer.parseInt((String)value);
        return new SnmpInt(vsan);
    }

    public static SnmpVar cpkiRevokeCheckMethods(Object value) throws Exception {
        String strVal = (String)value;
        for (int i = 0; i < _RevokeChkMethodString.length; ++i) {
            if (!strVal.equals(_RevokeChkMethodString[i])) continue;
            byte[] outValue = new byte[16];
            byte[] selValue = _RevokeChkMethodValue[i];
            for (int j = 0; j < selValue.length; ++j) {
                outValue[j] = selValue[j];
            }
            return new SnmpString(outValue);
        }
        return null;
    }

    public static SnmpVar cHcAlarmVariable(Object value) throws Exception {
        return MibVariableSet.alarmVariable(value);
    }

    public static SnmpVar alarmVariable(Object value) throws Exception {
        if (value instanceof SnmpOID) {
            return (SnmpOID)value;
        }
        if (!(value instanceof String)) {
            return null;
        }
        String var = (String)value;
        if (var.length() == 0) {
            throw new Exception("Please enter a value");
        }
        if (var.indexOf(46) == var.length() - 1 || var.indexOf(46) == -1) {
            throw new Exception("Please provide interface");
        }
        if (Character.isLetter(var.charAt(0))) {
            if (var.indexOf(47) != -1) {
                int dot = var.indexOf(46) + 1;
                String ifName = var.substring(dot);
                int ifIndex = _IfIndexIf.nameToIfIndex(ifName);
                var = var.substring(0, dot) + Integer.toString(ifIndex);
            }
            int[] oid = MibNode.parseName((String)var);
            return new SnmpOID(oid);
        }
        String[] oids = StringUtil.tokenize(var, ".");
        int[] oid = new int[oids.length];
        for (int i = 0; i < oid.length; ++i) {
            oid[i] = Integer.valueOf(oids[i]);
        }
        return new SnmpOID(oid);
    }

    public static Object vlanTrunkPortVlansEnabled(Object value) throws Exception {
        return new SnmpBitmap((String)value, false, 4094);
    }

    static {
        _RevokeChkMethodString = new String[]{"crl", "ocsp", "crl, ocsp", "ocsp, crl", "crl, none", "ocsp, none", "crl, ocsp, none", "ocsp, crl, none", "none"};
        _RevokeChkMethodValue = new byte[][]{{2}, {3}, {2, 3}, {3, 2}, {2, 1}, {3, 1}, {2, 3, 1}, {3, 2, 1}, {1}};
    }
}

