/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.FexEntity;
import com.cisco.dcbu.lib.mds.FexEntityV50Less;
import com.cisco.dcbu.lib.mds.N1KEntity;
import com.cisco.dcbu.lib.mds.N1KEntitySP13Less;
import com.cisco.dcbu.lib.mds.N1KV421SV2Entity;
import com.cisco.dcbu.lib.mds.NexusEntity;
import com.cisco.dcbu.lib.mds.NexusEntityV30Less;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.type.PlatformType;

public class NexusEntityMibHelper {
    public static final int ModuleSlot_ClassType = 100;
    public static final int PowerBay_ClassType = 101;
    public static final int FanBay_ClassType = 102;
    public static final int Processor_ClassType = 103;
    private static final NexusEntity _nexusEntity = new NexusEntity();
    private static final N1KEntity _n1kEntity = new N1KEntity();
    private static final N1KV421SV2Entity _n1kv421sv2Entity = new N1KV421SV2Entity();
    private static final N1KEntitySP13Less _n1kEntitySp13Less = new N1KEntitySP13Less();
    private static final NexusEntityV30Less _nexusEntityV30Less = new NexusEntityV30Less();
    private static final FexEntity _fexEntity = new FexEntity();
    private static final FexEntityV50Less _fexEntityV50Less = new FexEntityV50Less();

    private NexusEntityMibHelper() {
        throw new AssertionError();
    }

    public static HwInventoryType[] getClassOrder() {
        return _nexusEntity.getClassOrder();
    }

    public static int getChassisPhyIndex() {
        return NexusEntityMibHelper.getEntityIndex(_nexusEntity, HwInventoryType.CHASSIS.value());
    }

    public static int getChassisPhyIndex(PlatformType type) {
        if (type == PlatformType.N1K || type == PlatformType.N1KV || type == PlatformType.N1K1) {
            return NexusEntityMibHelper.getEntityIndex(_n1kEntity, HwInventoryType.CHASSIS.value());
        }
        if (PlatformType.isMdsSwitch((PlatformType)type) || PlatformType.isNexusSwitch((PlatformType)type)) {
            return NexusEntityMibHelper.getEntityIndex(_nexusEntity, HwInventoryType.CHASSIS.value());
        }
        return -1;
    }

    public static int getOtherChassisPhyIndex(PlatformType type) {
        if (type == PlatformType.N1K) {
            return NexusEntityMibHelper.getEntityIndex(_n1kEntitySp13Less, HwInventoryType.CHASSIS.value());
        }
        if (type == PlatformType.N1KV) {
            return NexusEntityMibHelper.getEntityIndex(_n1kv421sv2Entity, HwInventoryType.CHASSIS.value());
        }
        return -1;
    }

    public static int getEntityPhyIndex(PlatformType type, int classType) {
        if (type == PlatformType.N1K || type == PlatformType.N1KV) {
            return NexusEntityMibHelper.getEntityIndex(_n1kEntity, classType);
        }
        if (PlatformType.isMdsSwitch((PlatformType)type) || PlatformType.isNexusSwitch((PlatformType)type)) {
            return NexusEntityMibHelper.getEntityIndex(_nexusEntity, classType);
        }
        return -1;
    }

    public static int getEntityPhyMaxIndex(PlatformType type, int classType) {
        if (type == PlatformType.N1K || type == PlatformType.N1KV) {
            return NexusEntityMibHelper.getEntityMaxIndex(_n1kEntity, classType);
        }
        if (PlatformType.isMdsSwitch((PlatformType)type) || PlatformType.isNexusSwitch((PlatformType)type)) {
            return NexusEntityMibHelper.getEntityMaxIndex(_nexusEntity, classType);
        }
        return -1;
    }

    private static int getEntityIndex(NexusEntity entity, int classType) {
        return entity.getEntityPhyIndex(classType);
    }

    private static int getEntityMaxIndex(NexusEntity entity, int classType) {
        return entity.getEntityMaxPhyIndex(classType);
    }

    public static int getFexChassisPhyIndex() {
        return _fexEntity.getFexChassisPhyIndex();
    }

    public static int getFexChassisPhyIndexMax() {
        return _fexEntity.getFexChassisMaxPhyIndex();
    }

    public static int getFexChassisPhyIndex(int fexId) {
        return _fexEntity.getFexChassisPhyIndex(fexId);
    }

    public static boolean isFexChassisPhyIndex(int phyIndex) {
        return phyIndex >= NexusEntityMibHelper.getFexChassisPhyIndex() && phyIndex <= NexusEntityMibHelper.getFexChassisPhyIndexMax();
    }

    public static int getFexLinkPhyIndex(SwitchVersion version) {
        if (version.lessThan(FRUConstants.VERSION_5_0)) {
            return _fexEntityV50Less.getFexLinkPhyIndex();
        }
        return _fexEntity.getFexLinkPhyIndex();
    }

    public static int getFexLinkPhyMaxIndex(SwitchVersion version) {
        if (version.lessThan(FRUConstants.VERSION_5_0)) {
            return _fexEntityV50Less.getFexLinkMaxPhyIndex();
        }
        return _fexEntity.getFexLinkMaxPhyIndex();
    }

    public static int getFexLinkEdgePhyIndex(SwitchVersion version, int fexId) {
        if (version.lessThan(FRUConstants.VERSION_5_0)) {
            return _fexEntityV50Less.getFexLinkEdgePhyIndex(fexId);
        }
        return _fexEntity.getFexLinkEdgePhyIndex(fexId);
    }

    public static int getFexLinkEdgeMaxPhyIndex(SwitchVersion version, int fexId, int numUplPort) {
        return NexusEntityMibHelper.getFexLinkEdgePhyIndex(version, fexId) + numUplPort;
    }

    public static int getFexLinkEdgePhyIndex(SwitchVersion version, int fexId, int port) {
        if (version.lessThan(FRUConstants.VERSION_5_0)) {
            return _fexEntityV50Less.getFexLinkEdgePhyIndex(fexId, port);
        }
        return _fexEntity.getFexLinkEdgePhyIndex(fexId, port);
    }

    public static int getFexEntityIndex(int classType, int fexId) {
        if (classType == HwInventoryType.CHASSIS.value()) {
            return NexusEntityMibHelper.getFexChassisPhyIndex(fexId);
        }
        return _fexEntity.getFexEntityPhyIndex(fexId, _nexusEntity.getEntityPhyIndex(classType));
    }

    public static int getFexEntityMaxIndex(int classType, int fexId) {
        if (classType == HwInventoryType.CHASSIS.value() || classType == HwInventoryType.MODULE.value()) {
            return NexusEntityMibHelper.getFexEntityIndex(classType, fexId);
        }
        return _fexEntity.getFexEntityPhyIndex(fexId, _nexusEntity.getEntityMaxPhyIndex(classType));
    }

    public static int getFexIdByPhyIndex(int phyIndex) {
        return _fexEntity.getFexIdByPhyIndex(phyIndex);
    }

    public static int getFexPortByPhyIndex(int phyIndex) {
        return _fexEntity.getFexPortByPhyIndex(phyIndex);
    }

    public static boolean isFexPhyIndex(int phyIndex) {
        return NexusEntityMibHelper.getFexIdByPhyIndex(phyIndex) > 0;
    }

    public static boolean hasOtherChassisIndex(int phyIndex) {
        return phyIndex == NexusEntityMibHelper._n1kEntity.Chassis_PhyIndex || phyIndex == NexusEntityMibHelper._n1kv421sv2Entity.Chassis_PhyIndex || phyIndex == NexusEntityMibHelper._n1kEntitySp13Less.Chassis_PhyIndex;
    }
}

