/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSet;
import com.cisco.dcbu.lib.mds.PortSetEditor;
import com.cisco.dcbu.lib.mds.PortSetEditorIf;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.table.TableModel;

public class PortSetCellEditor
extends DefaultCellEditor
implements ActionListener,
PortSetEditorIf {
    public PortSetEditor _portSetEditor;
    protected TableModel _model;
    protected JTable _table;
    protected SnmpPeer _node;
    protected IfIndexIf _ifIndexIf;
    protected PortEditorFilter _filter;
    protected PortEditorCardAttribute[] _slotMembers;
    protected int[] _logicalIfs;
    protected boolean _exclusive;
    protected boolean _allowLogicalIf;
    protected PortSet _disabledPorts;
    protected PortSet _cardPortSelected;
    private JPanel _panel;
    protected JTextField _data;
    private static Icon _more = Util.loadIcon("icons/more.gif");
    protected JButton btn;

    public PortSetCellEditor(JTable table, boolean exclusive, PortEditorFilter filter) {
        super(new JComboBox());
        this.setClickCountToStart(2);
        this._exclusive = exclusive;
        this._filter = filter;
        this._portSetEditor = PortSetEditor.getInstance(Util.getFrameAncestor(table));
        this._portSetEditor.setTarget(this);
        this._table = table;
        this._model = table.getModel();
        this._panel = new JPanel(new BorderLayout());
        this._data = new JTextField();
        this._data.setBorder(BorderFactory.createLineBorder(Color.black));
        this._data.setFont(ChangedCellRenderer.getChangeFont());
        this._panel.add((Component)this._data, "Center");
        this.btn = new JButton(_more);
        this.btn.setPreferredSize(new Dimension(_more.getIconWidth(), this.btn.getPreferredSize().height));
        this.btn.setBorder(BasicBorders.getButtonBorder());
        this.btn.addActionListener(this);
        this._panel.add((Component)this.btn, "East");
        this._panel.setBorder(null);
    }

    @Override
    public void portSetEditorCB(String ifNames, Object context) {
        this._data.setText(ifNames);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._data.setText(value != null ? value.toString() : "");
        Component[] changeListeners = ((SnmpKTable)this._table).getChangeListener();
        if (changeListeners != null) {
            for (int i = 0; i < changeListeners.length; ++i) {
                changeListeners[i].setEnabled(true);
            }
        }
        return this._panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this._data.getText();
    }

    public void updateEditor(int row, int col) {
        int modelCol = this._table.convertColumnIndexToModel(col);
        this._portSetEditor.setTarget(this);
        this._portSetEditor.setContext(new Cell(row, modelCol));
        this._portSetEditor.setTitle(this._node.toString() + "-" + ((KTableModel)this._model).getHeaders()[modelCol]);
        this._portSetEditor.setIfIndexIf(this._ifIndexIf);
        this._portSetEditor.setFilter(this._filter);
        Object value = ((SnmpTableModel)this._table.getModel()).getSetValueAt(this.getCellEditorValue(), this._table.getSelectedRow(), this._table.convertColumnIndexToModel(this._table.getSelectedColumn()));
        String preSelected = value != null ? value.toString() : null;
        Switch sw = ClientController.findFabricSwitchByIpAddress((InetAddress)this._node.getAddress());
        try {
            this._portSetEditor.setSelected(preSelected != null ? PortSet.parse(preSelected, this._slotMembers, new Integer[]{4, 8}) : null);
            this._portSetEditor.setLogicalSelected(SnmpIntList.parse(preSelected, (IfIndexIf)sw));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this._portSetEditor.setSlotMembers(this._slotMembers);
        this._portSetEditor.setLogicalInterfaces(this._allowLogicalIf ? this._logicalIfs : null);
        this._portSetEditor.setExclusive(this._exclusive);
        this.disablePorts();
    }

    protected void setDisablePorts(PortSet ps) {
        this._disabledPorts = ps;
    }

    private void disablePorts() {
        if (this._disabledPorts == null) {
            return;
        }
        try {
            Integer[] rows = this._disabledPorts.getCards();
            Integer[] cols = this._disabledPorts.getPorts();
            if (rows == null || cols == null) {
                return;
            }
            if (rows.length != cols.length) {
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                try {
                    this._portSetEditor.setCellDisabled(rows[i] - 1, cols[i] - 1);
                    continue;
                }
                catch (NullPointerException ne) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNode(SnmpPeer node) {
        this._node = node;
    }

    public void setIfIndexIf(IfIndexIf ifIndexIf) {
        this._ifIndexIf = ifIndexIf;
    }

    public void setSelected(PortSet cardPortSelected) {
        this._cardPortSelected = cardPortSelected;
    }

    public void setLogicalInterfaces(int[] logicalIfs) {
        this._logicalIfs = logicalIfs;
    }

    public void setSlotMembers(PortEditorCardAttribute[] slotMembers) {
        this._slotMembers = slotMembers;
    }

    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    public void setAllowLogicalIf(boolean allowLogicalIf) {
        this._allowLogicalIf = allowLogicalIf;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row = this._table.getSelectedRow();
        int column = this._table.getSelectedColumn();
        this.updateEditor(row, column);
        this._portSetEditor.displayDlg(this._table, row, column);
    }

    public void setTextable(boolean b) {
        this._data.setEditable(b);
    }
}

