/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.mds.Panel;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SAMenuButton
extends MenuButton {
    SnmpPeer _peer;
    Panel _parent;
    int _type;
    IfIndexIf _switch;
    protected static final int MAX_ITEMS_TOTAL = 1200;

    public SAMenuButton(JMenu menu, SnmpPeer peer, IfIndexIf sw) {
        super(menu);
        this._peer = peer;
        this._parent = null;
        this._switch = sw;
    }

    public void setParent(Panel parent) {
        this._parent = parent;
    }

    public void setPeer(SnmpPeer peer) {
        this._peer = peer;
        this._menu = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._menu = new JMenu();
        try {
            Object[] names = this.getSAs(this._peer);
            if (names == null || names.length == 0) {
                this.setEnabled(false);
                return;
            }
            this.buildMenu(names);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
        super.actionPerformed(e);
        if (e.getSource() instanceof JMenuItem && this._parent != null) {
            this._parent.setChanged((FieldPanel)this.getParent());
        }
    }

    protected String[] getSAs(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] salt = MibNode.get((String)"cfcspSalt").getOid();
        int oidLen = salt.length;
        vbl.add(new SnmpVarBind(new SnmpOID(salt)));
        vbl = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl, (int)0).getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        Array spID = new Array();
        for (int i = 0; i < vbl.size() && i < 1200; ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            spID.addElement((Object)SnmpOID.toString((int[])oid, (int)oidLen, (int)oid.length));
        }
        if (spID.size() == 0) {
            return null;
        }
        String[] names = new String[spID.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)spID.elementAt(i);
        }
        return names;
    }
}

