/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.ficon;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import java.util.Arrays;
import java.util.StringTokenizer;

public class FiconPortList
extends SnmpIntList {
    SnmpPeer _peer;

    public FiconPortList(byte[] byteValue, IfIndexIf ifIndexIf, SnmpPeer peer) {
        super(byteValue, ifIndexIf);
        this._peer = peer;
    }

    public FiconPortList(String s, IfIndexIf ifIndexIf, SnmpPeer peer) throws SnmpException {
        super(SnmpIntList.valueOf(FiconPortList.parse(s, ifIndexIf, peer)), ifIndexIf);
        this._value = s;
        this._peer = peer;
    }

    public FiconPortList(String s, IfIndexIf ifIndexIf, SnmpPeer peer, boolean errorCheck) throws SnmpException {
        super(SnmpIntList.valueOf(FiconPortList.parse(s, ifIndexIf, peer, true, errorCheck)), ifIndexIf);
        this._value = s;
        this._peer = peer;
    }

    @Override
    public String toString() {
        if (this._value == null) {
            this._value = FiconPortList.toString(this._byteValue, this._ifIndexIf, this._peer);
        }
        return this._value;
    }

    public static String toString(byte[] b, IfIndexIf ifIndexIf, SnmpPeer peer) {
        if (!FiconPortByIfIndexCache.getInstance(peer).getIsFiconEnabled()) {
            return SnmpIntList.toString(b, ifIndexIf);
        }
        if (b == null || b.length == 0) {
            return null;
        }
        int[] ifIndeces = FiconPortList.valueOf(b);
        StringBuffer sb = new StringBuffer(32);
        int ficonPort = FiconPortByIfIndexCache.getInstance(peer).getFiconPort(ifIndeces[0]);
        sb.append(ficonPort == -1 ? "" : SnmpFiconPort.toString(ficonPort));
        boolean inRange = ifIndeces.length >= 2 && FiconPortList.contigious(ficonPort, FiconPortByIfIndexCache.getInstance(peer).getFiconPort(ifIndeces[1]), ifIndexIf);
        for (int i = 1; i < ifIndeces.length; ++i) {
            int port2;
            int port1 = FiconPortByIfIndexCache.getInstance(peer).getFiconPort(ifIndeces[i - 1]);
            if (!FiconPortList.contigious(port1, port2 = FiconPortByIfIndexCache.getInstance(peer).getFiconPort(ifIndeces[i]), ifIndexIf)) {
                if (inRange) {
                    sb.append('-');
                    sb.append(port1 == -1 ? "" : SnmpFiconPort.toString(port1));
                }
                if (port2 != -1) {
                    sb.append(',');
                    sb.append(SnmpFiconPort.toString(port2));
                }
                inRange = false;
                continue;
            }
            inRange = true;
        }
        if (ifIndeces.length > 1 && inRange) {
            sb.append('-');
            ficonPort = FiconPortByIfIndexCache.getInstance(peer).getFiconPort(ifIndeces[ifIndeces.length - 1]);
            sb.append(ficonPort == -1 ? "" : SnmpFiconPort.toString(ficonPort));
        }
        return sb.toString();
    }

    public static int[] parse(String idList, IfIndexIf ifIndexIf, SnmpPeer peer) throws SnmpException {
        return FiconPortList.parse(idList, ifIndexIf, peer, true, false);
    }

    public static int[] parse(String idList, IfIndexIf ifIndexIf, SnmpPeer peer, boolean rtnIfIndex) throws SnmpException {
        return FiconPortList.parse(idList, ifIndexIf, peer, rtnIfIndex, false);
    }

    public static int[] parse(String idList, IfIndexIf ifIndexIf, SnmpPeer peer, boolean rtnIfIndex, boolean errorCheck) throws SnmpException {
        int[] ids = new int[704];
        int idNum = 0;
        StringTokenizer st = new StringTokenizer(idList, ",-", true);
        boolean inRange = false;
        int start = 0;
        int lastFiconPort = -1;
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (t.charAt(0) == ',') continue;
            if (t.charAt(0) == '-') {
                lastFiconPort = start;
                inRange = true;
                continue;
            }
            t = t.indexOf("0x") != -1 ? t.substring(2) : t;
            int ficonPort = SnmpFiconPort.parse(t, true);
            String ifPortString = null;
            if (t.indexOf(47) != -1 && t.indexOf(40) != -1 && t.indexOf(41) != -1) {
                ifPortString = t.substring(0, t.indexOf(40));
            }
            if (inRange) {
                for (int i = lastFiconPort + 1; i <= ficonPort; ++i) {
                    if (rtnIfIndex) {
                        Array list = FiconPortByIfIndexCache.getInstance(peer).getFiconIfIndexByPortAddr(i);
                        if (list == null) continue;
                        for (int j = 0; j < list.size(); ++j) {
                            int ifIndex = (Integer)list.elementAt(j);
                            if (ifIndex == -1 || ifPortString != null && (ifPortString == null || ifIndexIf.nameToIfIndex(ifPortString) != ifIndex)) continue;
                            ids[idNum++] = ifIndex;
                        }
                        continue;
                    }
                    ids[idNum++] = i;
                }
                inRange = false;
            } else {
                if (rtnIfIndex) {
                    Array list = FiconPortByIfIndexCache.getInstance(peer).getFiconIfIndexByPortAddr(ficonPort);
                    if (list != null) {
                        for (int j = 0; j < list.size(); ++j) {
                            int ifIndex = (Integer)list.elementAt(j);
                            if (ifIndex == -1 || ifPortString != null && (ifPortString == null || ifIndexIf.nameToIfIndex(ifPortString) != ifIndex)) continue;
                            ids[idNum++] = ifIndex;
                        }
                    }
                } else {
                    ids[idNum++] = ficonPort;
                }
                if (errorCheck && ids[idNum - 1] == -1) {
                    throw new SnmpException("bad interface " + ficonPort);
                }
            }
            start = ficonPort;
        }
        int[] ifIndeces = new int[idNum];
        System.arraycopy(ids, 0, ifIndeces, 0, ifIndeces.length);
        boolean error = false;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] != -1) continue;
            error = true;
            break;
        }
        if (rtnIfIndex && !error) {
            Arrays.sort(ifIndeces);
        }
        return ifIndeces;
    }
}

