/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.renderers;

import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class SensorValueRenderer
extends BorderCellRenderer {
    int low_warning_col = -1;
    int sensor_val_col = -1;
    int high_warning_col = -1;

    public SensorValueRenderer() {
        this.low_warning_col = -1;
        this.sensor_val_col = -1;
        this.high_warning_col = -1;
    }

    public SensorValueRenderer(int lowWarningCol, int highWarningCol, int sensorValCol) {
        this.low_warning_col = lowWarningCol;
        this.sensor_val_col = sensorValCol;
        this.high_warning_col = highWarningCol;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null && !value.equals("n/a") && this.low_warning_col != -1 && this.high_warning_col != -1 && this.sensor_val_col != -1) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            try {
                double lowWarn = Double.parseDouble((String)table.getModel().getValueAt(row, this.low_warning_col));
                double highWarn = Double.parseDouble((String)table.getModel().getValueAt(row, this.high_warning_col));
                String fullvalString = (String)table.getModel().getValueAt(row, this.sensor_val_col);
                String valueString = fullvalString.substring(0, fullvalString.indexOf(32));
                double valueShown = Double.parseDouble(valueString);
                if (valueShown < lowWarn || valueShown > highWarn) {
                    this.setBackground(Color.yellow);
                }
                this.setBackground(table.getBackground());
            }
            catch (Exception ex) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        } else {
            this.setBackground(table.getBackground());
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

