/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.SmlCommandsHandler;
import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.DefaultZoneAttributes;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;

public class QlogicCommandHandler
extends CommandHandler {
    public static final String ZONE_SAVE_CMD = "Cmd.Zoning.SaveConfig";
    public static final String ZONE_EDIT_CMD = "Cmd.Zoning.EditConfig";
    public static final String ZONE_EDIT_CANCEL = "smlsetb Cmd.Zoning.CancelConfig\n";
    public static final String[] EDIT_ZONEOK_ERR_CODE = new String[]{"0", "52"};
    public static final String RENAME = ".Rename.";
    public static final String CMD_ZONING_ALIAS = "Cmd.Zoning.Alias.";
    public static final String CMD_ZONING_ZONE = "Cmd.Zoning.Zone.";
    public static final String CMD_ZONING_ZONESET = "Cmd.Zoning.ZoneSet.";
    public static final int WWN_MEMBER = 1;
    public static final int DOMAIN_PORT_MEMBER = 2;
    public static final int FCID_MEMBER = 3;
    public static final int ALIS_MEMBER = 4;
    public static final int SWITCHIF_MEMBER = 10;
    public static final int DIDIF_MEMBER = 11;
    protected SmlCommandsHandler _smlCmd;

    public QlogicCommandHandler(ZoneCapability cap, int vsan, VersionPeer sw, StatusIf statusIf) throws IOException, SnmpException {
        super(cap, vsan, statusIf, sw);
    }

    @Override
    public void cleanup() {
        this._smlCmd.cleanup();
    }

    @Override
    public ArrayList discoverZoneSets(boolean enforced, ArrayList zns) throws SnmpException {
        ArrayList<ZoneSet> zonesets = new ArrayList<ZoneSet>();
        String[] znstCmd = new String[]{"Oper.Zoning.ZoneSetList.0"};
        boolean moreZoneSets = true;
        ArrayList<String[]> zonesetTokens = new ArrayList<String[]>();
        while (moreZoneSets) {
            String[] tokens;
            String[] stringArray;
            if (this._stopDiscovery) {
                return zonesets;
            }
            if (enforced) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "Oper.Zoning.ActiveZoneSet";
            } else {
                stringArray = znstCmd;
            }
            String[] zonesetList = this._smlCmd.executeSmlCommands("smlgetb", stringArray, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
            moreZoneSets = false;
            if (zonesetList == null || zonesetList.length <= 0 || (tokens = StringUtil.tokenize(zonesetList[0], ",")) == null || tokens.length <= 0) continue;
            boolean bl = moreZoneSets = zonesetList[0].charAt(zonesetList[0].length() - 1) == ',';
            if (moreZoneSets) {
                znstCmd = new String[]{"Oper.Zoning.ZoneSetList.0." + tokens[tokens.length - 1].trim()};
            }
            zonesetTokens.add(tokens);
        }
        String prependCmd = enforced ? "Oper.Zoning.ActiveZoneSet" : "Oper.Zoning.ZoneSet.";
        ArrayList<String> zoneList = new ArrayList<String>();
        int indexCounter = 0;
        for (int t = 0; t < zonesetTokens.size(); ++t) {
            String[] tokens = (String[])zonesetTokens.get(t);
            if (tokens == null || tokens.length <= 0) continue;
            for (int i = 0; i < tokens.length; ++i) {
                ZoneSet zset = new ZoneSet(this._vsanId, ++indexCounter, tokens[i].trim(), new byte[0], 0L);
                zonesets.add(zset);
                boolean moreZoneSetMembers = true;
                ArrayList<String[]> zonesetMemTokens = new ArrayList<String[]>();
                String[] znstMemCmd = new String[]{prependCmd + (enforced ? "" : tokens[i].trim()) + ".ZoneList.0"};
                while (moreZoneSetMembers) {
                    String[] tokensMem;
                    if (this._stopDiscovery) {
                        return zonesets;
                    }
                    String[] allMemZones = this._smlCmd.executeSmlCommands("smlgetb", znstMemCmd, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
                    moreZoneSetMembers = false;
                    if (allMemZones == null || allMemZones.length <= 0 || (tokensMem = StringUtil.tokenize(allMemZones[0], ",")) == null || tokensMem.length <= 0) continue;
                    moreZoneSetMembers = allMemZones[0].charAt(allMemZones[0].length() - 1) == ',';
                    zonesetMemTokens.add(tokensMem);
                    if (!moreZoneSetMembers) continue;
                    znstMemCmd = new String[]{prependCmd + (enforced ? "" : tokens[i].trim()) + ".ZoneList.0." + tokensMem[tokensMem.length - 1]};
                }
                zoneList.clear();
                for (int mem = 0; mem < zonesetMemTokens.size(); ++mem) {
                    String[] allMemZones = (String[])zonesetMemTokens.get(mem);
                    if (allMemZones == null || allMemZones.length <= 0) continue;
                    for (int z = 0; z < allMemZones.length; ++z) {
                        zoneList.add(allMemZones[z].trim());
                    }
                }
                zset.setMembers(this.buildMemberList(zoneList, zns));
            }
        }
        return zonesets;
    }

    @Override
    public ArrayList discoverZonesetName(boolean enforced) throws SnmpException {
        ArrayList<ZoneSet> zonesets = new ArrayList<ZoneSet>();
        String[] znstCmd = new String[]{"Oper.Zoning.ZoneSetList.0"};
        boolean moreZoneSets = true;
        ArrayList<String[]> zonesetTokens = new ArrayList<String[]>();
        while (moreZoneSets) {
            String[] tokens;
            String[] stringArray;
            if (this._stopDiscovery) {
                return zonesets;
            }
            if (enforced) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "Oper.Zoning.ActiveZoneSet";
            } else {
                stringArray = znstCmd;
            }
            String[] zonesetList = this._smlCmd.executeSmlCommands("smlgetb", stringArray, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
            moreZoneSets = false;
            if (zonesetList == null || zonesetList.length <= 0 || (tokens = StringUtil.tokenize(zonesetList[0], ",")) == null || tokens.length <= 0) continue;
            boolean bl = moreZoneSets = zonesetList[0].charAt(zonesetList[0].length() - 1) == ',';
            if (moreZoneSets) {
                znstCmd = new String[]{"Oper.Zoning.ZoneSetList.0." + tokens[tokens.length - 1].trim()};
            }
            zonesetTokens.add(tokens);
        }
        int indexCounter = 0;
        for (int t = 0; t < zonesetTokens.size(); ++t) {
            String[] tokens = (String[])zonesetTokens.get(t);
            if (tokens == null || tokens.length <= 0) continue;
            for (int i = 0; i < tokens.length; ++i) {
                ZoneSet zset = new ZoneSet(this._vsanId, ++indexCounter, tokens[i].trim(), new byte[0], 0L);
                zonesets.add(zset);
            }
        }
        return zonesets;
    }

    @Override
    public ArrayList discoverZones(boolean enforced, ArrayList members, ArrayList aliases) throws SnmpException {
        String[] stringArray;
        ArrayList<Zone> discoveredZones = new ArrayList<Zone>();
        if (enforced) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Oper.Zoning.ActiveZoneSet.ZoneList.0";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "Oper.Zoning.ZoneList.0";
        }
        String[] znCmd = stringArray;
        boolean moreZones = true;
        ArrayList<String[]> zoneTokens = new ArrayList<String[]>();
        while (moreZones) {
            String[] tokens;
            if (this._stopDiscovery) {
                return discoveredZones;
            }
            String[] zoneList = this._smlCmd.executeSmlCommands("smlgetb", znCmd, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
            moreZones = false;
            if (zoneList == null || zoneList.length <= 0 || (tokens = StringUtil.tokenize(zoneList[0], ",")) == null || tokens.length <= 0) continue;
            boolean bl = moreZones = zoneList[0].charAt(zoneList[0].length() - 1) == ',';
            if (moreZones) {
                String[] stringArray4;
                if (enforced) {
                    String[] stringArray5 = new String[1];
                    stringArray4 = stringArray5;
                    stringArray5[0] = "Oper.Zoning.ActiveZoneSet.ZoneList.0.";
                } else {
                    String[] stringArray6 = new String[1];
                    stringArray4 = stringArray6;
                    stringArray6[0] = "Oper.Zoning.ZoneList.0.";
                }
                znCmd = stringArray4;
                znCmd[0] = znCmd[0] + tokens[tokens.length - 1].trim();
            }
            zoneTokens.add(tokens);
        }
        String prependCmd = enforced ? "Oper.Zoning.ActiveZone." : "Oper.Zoning.Zone.";
        int indexCounter = 0;
        for (int t = 0; t < zoneTokens.size(); ++t) {
            String[] tokens = (String[])zoneTokens.get(t);
            if (tokens == null || tokens.length <= 0) continue;
            for (int i = 0; i < tokens.length; ++i) {
                Zone zn = new Zone(this._vsanId, ++indexCounter, tokens[i].trim(), new byte[0], 0L, false, false, -1, false);
                discoveredZones.add(zn);
                boolean moreZoneMembers = true;
                ArrayList<String[]> zonesetMemTokens = new ArrayList<String[]>();
                String[] znstMemCmd = new String[]{prependCmd + (enforced ? "" : tokens[i].trim()) + ".ZoneMemberList.0"};
                while (moreZoneMembers) {
                    String[] tokensMem;
                    if (this._stopDiscovery) {
                        return discoveredZones;
                    }
                    String[] allMemZones = this._smlCmd.executeSmlCommands("smlgetb", znstMemCmd, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
                    moreZoneMembers = false;
                    if (allMemZones == null || allMemZones.length <= 0 || (tokensMem = StringUtil.tokenize(allMemZones[0], ",")) == null || tokensMem.length <= 0) continue;
                    moreZoneMembers = allMemZones[0].charAt(allMemZones[0].length() - 1) == ',';
                    zonesetMemTokens.add(tokensMem);
                    if (!moreZoneMembers) continue;
                    znstMemCmd = new String[]{prependCmd + (enforced ? "" : tokens[i].trim()) + ".ZoneMemberList.0." + tokensMem[tokensMem.length - 1].trim().substring(2)};
                }
                ArrayList aliasMems = new ArrayList();
                for (int mem = 0; mem < zonesetMemTokens.size(); ++mem) {
                    String[] allMemZones = (String[])zonesetMemTokens.get(mem);
                    if (allMemZones == null || allMemZones.length <= 0) continue;
                    for (int allMem = 0; allMem < allMemZones.length; ++allMem) {
                        aliasMems.addAll(this.buildMembersList(allMemZones[allMem], 1, indexCounter, members));
                    }
                }
                zn.setZoneAliases(this.buildMemberList(aliasMems, aliases));
            }
        }
        return discoveredZones;
    }

    @Override
    public ArrayList discoverAliases(boolean enforced, ArrayList members) throws SnmpException {
        ArrayList<ZoneAlias> aliases = new ArrayList<ZoneAlias>();
        String[] znCmd = new String[]{"Oper.Zoning.AliasList.0"};
        boolean moreAliases = true;
        ArrayList<String[]> zoneTokens = new ArrayList<String[]>();
        while (moreAliases) {
            String[] tokens;
            if (this._stopDiscovery) {
                return aliases;
            }
            String[] zoneList = this._smlCmd.executeSmlCommands("smlgetb", znCmd, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
            moreAliases = false;
            if (zoneList == null || zoneList.length <= 0 || (tokens = StringUtil.tokenize(zoneList[0], ",")) == null || tokens.length <= 0) continue;
            boolean bl = moreAliases = zoneList[0].charAt(zoneList[0].length() - 1) == ',';
            if (moreAliases) {
                znCmd = new String[]{"Oper.Zoning.AliasList.0."};
                znCmd[0] = znCmd[0] + tokens[tokens.length - 1].trim();
            }
            zoneTokens.add(tokens);
        }
        String prependCmd = "Oper.Zoning.Alias.";
        int indexCounter = 0;
        for (int t = 0; t < zoneTokens.size(); ++t) {
            String[] tokens = (String[])zoneTokens.get(t);
            if (tokens == null || tokens.length <= 0) continue;
            for (int i = 0; i < tokens.length; ++i) {
                ZoneAlias zn = new ZoneAlias(this._vsanId, ++indexCounter, tokens[i].trim(), 0L);
                aliases.add(zn);
                boolean moreZoneMembers = true;
                ArrayList<String[]> zonesetMemTokens = new ArrayList<String[]>();
                String[] znstMemCmd = new String[]{prependCmd + tokens[i].trim() + ".ZoneMemberList.0"};
                while (moreZoneMembers) {
                    String[] tokensMem;
                    if (this._stopDiscovery) {
                        return aliases;
                    }
                    String[] allMemZones = this._smlCmd.executeSmlCommands("smlgetb", znstMemCmd, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
                    moreZoneMembers = false;
                    if (allMemZones == null || allMemZones.length <= 0 || (tokensMem = StringUtil.tokenize(allMemZones[0], ",")) == null || tokensMem.length <= 0) continue;
                    moreZoneMembers = allMemZones[0].charAt(allMemZones[0].length() - 1) == ',';
                    zonesetMemTokens.add(tokensMem);
                    if (!moreZoneMembers) continue;
                    znstMemCmd = new String[]{prependCmd + tokens[i].trim() + ".ZoneMemberList.0." + tokensMem[tokensMem.length - 1].trim().substring(2)};
                }
                for (int mem = 0; mem < zonesetMemTokens.size(); ++mem) {
                    String[] allMemZones = (String[])zonesetMemTokens.get(mem);
                    if (allMemZones == null || allMemZones.length <= 0) continue;
                    for (int allMem = 0; allMem < allMemZones.length; ++allMem) {
                        this.buildMembersList(allMemZones[allMem], 2, indexCounter, members);
                    }
                }
            }
        }
        return aliases;
    }

    @Override
    public DefaultZoneAttributes discoverDefaultZoneAttributes() throws SnmpException {
        DefaultZoneAttributes att = new DefaultZoneAttributes();
        if (!this.isIvr()) {
            if (this._stopDiscovery) {
                return att;
            }
            String[] defList = this._smlCmd.executeSmlCommands("smlgetb", new String[]{"Config.Zoning.DefaultZone", "Config.Zoning.FullZoneSet"}, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
            att._defaultZonePolicy = defList[0].equalsIgnoreCase("True") ? 1 : 2;
            att._zonePropagation = defList[1].equalsIgnoreCase("True") ? 1 : 2;
        }
        return att;
    }

    @Override
    public void ModifyDefaultZoneAttributes(DefaultZoneAttributes src, DefaultZoneAttributes mod) throws SnmpException {
        ArrayList<String> cmds = new ArrayList<String>();
        if (src._defaultZonePolicy != mod._defaultZonePolicy) {
            cmds.add("Config.Zoning.DefaultZone." + (mod._defaultZonePolicy == 1 ? "True" : "False"));
        }
        if (src._zonePropagation != mod._zonePropagation) {
            cmds.add("Config.Zoning.FullZoneSet." + (mod._zonePropagation == 2 ? "False" : "True"));
        }
        if (cmds.size() > 0) {
            cmds.add(0, "Cmd.Switch.EditConfig");
            cmds.add("Cmd.Switch.SaveConfig");
            cmds.add("Cmd.Switch.ActConfig");
            String[] arCmd = cmds.toArray(new String[cmds.size()]);
            this._smlCmd.executeSmlCommands("smlsetb", arCmd, EDIT_ZONEOK_ERR_CODE, "Cmd.Switch.CancelConfig");
            if (src._defaultZonePolicy != mod._defaultZonePolicy) {
                src._defaultZonePolicy = mod._defaultZonePolicy;
            }
            if (src._zonePropagation != mod._zonePropagation) {
                src._zonePropagation = mod._zonePropagation;
            }
        }
    }

    @Override
    public ArrayList discoverMembers(boolean enforced, ArrayList members) throws SnmpException {
        return members;
    }

    protected ArrayList buildMembersList(String memList, int parentType, int parentId, ArrayList members) {
        return new ArrayList();
    }

    public static int convertToMDSType(int qlogicType) {
        switch (qlogicType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 11: {
                return 7;
            }
            case 10: {
                return 6;
            }
        }
        return 0;
    }

    private byte[] buildMemberList(ArrayList memberName, ArrayList memberList) {
        byte[] mem = new byte[]{};
        block0: for (int k = 0; k < memberName.size(); ++k) {
            for (int i = 0; i < memberList.size(); ++i) {
                AbstractZone member = (AbstractZone)memberList.get(i);
                if (!member.getZoneName().equals(memberName.get(k))) continue;
                mem = AbstractZone.testBit(mem, member.zoneIndex, false);
                SnmpString.setBit((byte[])mem, (int)member.zoneIndex);
                continue block0;
            }
        }
        return mem;
    }

    static int convertToQLogicType(int mdsType) {
        switch (mdsType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 7: {
                return 11;
            }
            case 6: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public void addMembers(AbstractZone z, AbstractZone[] members) throws SnmpException {
        if (z instanceof Zone) {
            this.addMembersToZoneOrAlias((Zone)z, members);
        } else if (z instanceof ZoneSet) {
            this.addMembersToZoneSet((ZoneSet)z, members);
        } else if (z instanceof ZoneAlias) {
            this.addMembersToZoneOrAlias((ZoneAlias)z, members);
        }
    }

    private String buildZoneMemberCmd(AbstractZone az) throws SnmpException {
        if (az.isAlias()) {
            return az.getZoneName();
        }
        ZoneMember zm = (ZoneMember)az;
        String member = null;
        if (zm.getMemFormat() == 2) {
            byte[] didPort = zm.getMemId();
            member = (didPort[0] < 16 ? "0" : "") + Integer.toHexString(didPort[0]) + (didPort[1] < 16 ? "0" : "") + Integer.toHexString(didPort[1]);
        } else if (zm.getMemFormat() == 1) {
            member = SnmpString.toHexString((byte[])zm.getMemId(), (int)0, (int)zm.getMemId().length, (boolean)false);
        } else if (zm.getMemFormat() == 3) {
            member = SnmpString.toHexString((byte[])zm.getMemId(), (int)0, (int)zm.getMemId().length, (boolean)false);
        } else if (zm.getMemFormat() == 6) {
            byte[] id = zm.getMemId();
            byte[] ifBytes = new byte[4];
            System.arraycopy(id, 0, ifBytes, 0, 4);
            int ifIndex = SnmpIntList.bytesToInt(ifBytes, 0);
            int card = this._verPeer.getIfIndexIf().ifIndex2Card(ifIndex);
            int port = this._verPeer.getIfIndexIf().ifIndex2Port(ifIndex) + 1;
            member = (card > 15 ? "" : "0") + Integer.toHexString(card) + (port > 15 ? "" : "0") + Integer.toHexString(port) + SnmpString.toHexString((byte[])id, (int)4, (int)id.length, (boolean)false);
        } else if (zm.getMemFormat() == 7) {
            byte[] id = zm.getMemId();
            int ifIndex = SnmpIntList.bytesToInt(id, 1);
            int card = this._verPeer.getIfIndexIf().ifIndex2Card(ifIndex);
            int port = this._verPeer.getIfIndexIf().ifIndex2Port(ifIndex) + 1;
            member = "0" + (id[0] > 15 ? "" : "0") + Integer.toHexString(id[0]) + (card > 15 ? "" : "0") + Integer.toHexString(card) + (port > 15 ? "" : "0") + Integer.toHexString(port);
        } else {
            throw new SnmpException("Unsupported Zone Member Format " + zm.getFormatName() + " for " + az + ".");
        }
        return member;
    }

    private void addMembersToZoneOrAlias(AbstractZone zn, AbstractZone[] az) throws SnmpException {
        String smlCmd = "Cmd.Zoning." + (zn.isAlias() ? "Alias." : "Zone.") + zn.getZoneName() + ".AddZoneMember.";
        if (az != null && az.length > 0) {
            int i;
            String[] zAddCmd = new String[az.length + 2];
            for (i = 0; i < az.length; ++i) {
                zAddCmd[i + 1] = smlCmd + this.buildZoneMemberCmd(az[i]);
            }
            zAddCmd[0] = ZONE_EDIT_CMD;
            zAddCmd[zAddCmd.length - 1] = ZONE_SAVE_CMD;
            this._smlCmd.executeSmlCommands("smlsetb", zAddCmd, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
            for (i = 0; i < az.length; ++i) {
                if (!az[i].isAlias()) continue;
                byte[] aliases = ((Zone)zn).getZoneAliases();
                aliases = AbstractZone.testBit(aliases, az[i].zoneIndex, false);
                SnmpString.setBit((byte[])aliases, (int)az[i].zoneIndex);
                ((Zone)zn).setZoneAliases(aliases);
            }
        }
    }

    private void addMembersToZoneSet(ZoneSet zs, AbstractZone[] az) throws SnmpException {
        String[] smlCmds = new String[]{CMD_ZONING_ZONESET + zs.getZoneName() + ".AddZone."};
        if (az != null && az.length > 0) {
            String[] zAddCmd = new String[az.length + 2];
            for (int i = 0; i < az.length; ++i) {
                zAddCmd[i + 1] = smlCmds[0] + az[i].getZoneName();
            }
            zAddCmd[0] = ZONE_EDIT_CMD;
            zAddCmd[zAddCmd.length - 1] = ZONE_SAVE_CMD;
            this._smlCmd.executeSmlCommands("smlsetb", zAddCmd, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
            byte[] memClone = null;
            for (int i = 0; i < az.length; ++i) {
                memClone = zs.getMembers();
                memClone = AbstractZone.testBit(memClone, az[i].zoneIndex, false);
                SnmpString.setBit((byte[])memClone, (int)az[i].zoneIndex);
            }
            zs.setMembers(memClone);
        }
    }

    @Override
    public ZoneAlias createNewZoneAlias(int vsan, int index, ArrayList members, String name, long sysUpTime) throws SnmpException {
        String[] cmds = new String[members != null && members.size() > 0 ? members.size() + 3 : 3];
        cmds[0] = ZONE_EDIT_CMD;
        cmds[1] = CMD_ZONING_ALIAS + name + ".Create";
        cmds[cmds.length - 1] = ZONE_SAVE_CMD;
        if (members != null && members.size() > 0) {
            String smlCmd = CMD_ZONING_ALIAS + name + ".AddZoneMember.";
            for (int i = 0; i < members.size(); ++i) {
                cmds[i + 2] = smlCmd + this.buildZoneMemberCmd((AbstractZone)members.get(i));
            }
        }
        this._smlCmd.executeSmlCommands("smlsetb", cmds, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
        return new ZoneAlias(vsan, index, name, sysUpTime);
    }

    @Override
    public void buildNewZoneVbList(int vsan, int index, boolean readOnly, byte[] aliases, ArrayList members, String name, boolean qos, int qospriority, boolean broadcast, boolean smtzone, VarBindList vbLst) {
    }

    @Override
    public Zone createNewZone(Zone zn, ArrayList members, ArrayList aliasMembers) throws SnmpException {
        int i;
        String smlCmd;
        int cmdLength = (members != null && members.size() > 0 ? members.size() : 0) + (aliasMembers != null && aliasMembers.size() > 0 ? aliasMembers.size() : 0);
        String[] cmds = new String[cmdLength + 3];
        cmds[0] = ZONE_EDIT_CMD;
        cmds[1] = CMD_ZONING_ZONE + zn.getZoneName() + ".Create";
        cmds[cmds.length - 1] = ZONE_SAVE_CMD;
        if (members != null && members.size() > 0) {
            smlCmd = CMD_ZONING_ZONE + zn.getZoneName() + ".AddZoneMember.";
            for (i = 0; i < members.size(); ++i) {
                cmds[i + 2] = smlCmd + this.buildZoneMemberCmd((AbstractZone)members.get(i));
            }
        }
        if (zn.getZoneAliases() != null && zn.getZoneAliases().length > 0) {
            smlCmd = CMD_ZONING_ZONE + zn.getZoneName() + ".AddZoneMember.";
            for (int k = 0; k < aliasMembers.size(); ++k) {
                cmds[k + i + 2] = smlCmd + this.buildZoneMemberCmd((AbstractZone)aliasMembers.get(i));
            }
        }
        this._smlCmd.executeSmlCommands("smlsetb", cmds, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
        return zn;
    }

    @Override
    public ZoneSet createNewZoneset(ZoneSet zs, Zone[] zones) throws SnmpException {
        String[] cmds = new String[zones != null && zones.length > 0 ? zones.length + 3 : 3];
        cmds[0] = ZONE_EDIT_CMD;
        cmds[1] = CMD_ZONING_ZONESET + zs.getZoneName() + ".Create";
        cmds[cmds.length - 1] = ZONE_SAVE_CMD;
        if (zones != null && zones.length > 0) {
            for (int i = 0; i < zones.length; ++i) {
                cmds[i + 2] = CMD_ZONING_ZONESET + zs.getZoneName() + ".AddZone." + zones[i].getZoneName();
            }
        }
        this._smlCmd.executeSmlCommands("smlsetb", cmds, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
        return zs;
    }

    public void copyActiveToLocal(ZoneSet active) throws SnmpException {
    }

    @Override
    public void updateActiveZoneSetTimeStamp(ZoneSet activeZs) throws SnmpException {
    }

    @Override
    public void createNewMembers(ArrayList members, AbstractZone parent) throws SnmpException {
        ArrayList cmds;
        if (members != null && members.size() > 0 && (cmds = this.buildNewMemberCommand(members, parent)) != null && cmds.size() > 0) {
            cmds.add(0, ZONE_EDIT_CMD);
            cmds.add(ZONE_SAVE_CMD);
            this._smlCmd.executeSmlCommands("smlsetb", cmds.toArray(new String[cmds.size()]), EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
        }
    }

    private ArrayList buildNewMemberCommand(ArrayList members, AbstractZone parent) throws SnmpException {
        ArrayList<String> cmds;
        block2: {
            block3: {
                cmds = new ArrayList<String>();
                if (members == null || members.size() <= 0) break block2;
                if (!parent.isZoneset()) break block3;
                for (int i = 0; i < members.size(); ++i) {
                    cmds.add(CMD_ZONING_ZONESET + parent.getZoneName() + ".AddZone." + ((AbstractZone)members.get(i)).getZoneName());
                }
                break block2;
            }
            if (!parent.isZone() && !parent.isAlias()) break block2;
            String smlCmd = "Cmd.Zoning." + (parent.isZone() ? "Zone." : "Alias.") + parent.getZoneName() + ".AddZoneMember.";
            for (int i = 0; i < members.size(); ++i) {
                cmds.add(smlCmd + this.buildZoneMemberCmd((AbstractZone)members.get(i)));
            }
        }
        return cmds;
    }

    public void clearZoneConfiguration(int vsan) throws SnmpException {
        String[] cmds = new String[]{ZONE_EDIT_CMD, "Cmd.Zoning.ClearConfig", ZONE_SAVE_CMD};
        this._smlCmd.executeSmlCommands("smlsetb", cmds, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
    }

    @Override
    public void CreateNewZDBFromFullZoneArray(ArrayList cmdList, int targetVsan, AbstractMdsAction copyAction) throws SnmpException {
        String[] cmds = new String[cmdList.size() + 3];
        cmds[0] = ZONE_EDIT_CMD;
        cmds[1] = "Cmd.Zoning.ClearConfig";
        cmds[cmds.length - 1] = ZONE_SAVE_CMD;
        for (int k = 0; !(k >= cmdList.size() || copyAction != null && copyAction.isStopped()); ++k) {
            cmds[k + 2] = cmdList.get(k).toString();
        }
        this._smlCmd.executeSmlCommands("smlsetb", cmds, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
    }

    @Override
    public void delete(AbstractZone[] parent, AbstractZone[] az) throws SnmpException {
        int i;
        ArrayList<String> cmdStrs = new ArrayList<String>();
        for (i = 0; i < az.length; ++i) {
            if (parent != null && parent[i] != null) {
                if (parent[i].isZoneset()) {
                    cmdStrs.add(CMD_ZONING_ZONESET + parent[i].getZoneName() + ".RemoveZone." + az[i].getZoneName());
                    continue;
                }
                if (!parent[i].isZone() && !parent[i].isAlias()) continue;
                cmdStrs.add((parent[i].isZone() ? CMD_ZONING_ZONE : CMD_ZONING_ALIAS) + parent[i].getZoneName() + ".RemZoneMember." + this.buildZoneMemberCmd(az[i]));
                continue;
            }
            cmdStrs.add((az[i].isAlias() ? CMD_ZONING_ALIAS : (az[i].isZone() ? CMD_ZONING_ZONE : CMD_ZONING_ZONESET)) + az[i].getZoneName() + ".Delete");
        }
        if (cmdStrs.size() > 0) {
            cmdStrs.add(0, ZONE_EDIT_CMD);
            cmdStrs.add(ZONE_SAVE_CMD);
            this._smlCmd.executeSmlCommands("smlsetb", cmdStrs.toArray(new String[cmdStrs.size()]), EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
            for (i = 0; i < az.length; ++i) {
                if (parent == null || parent[i] == null) continue;
                parent[i].removeLink(az[i]);
            }
        }
    }

    @Override
    public void modifyAbstractZoneName(ArrayList list, long sysUpTime) throws SnmpException {
        if (list != null && list.size() > 0) {
            AbstractZone zs;
            Object[] ob;
            int i;
            ArrayList<String> cmdArr = new ArrayList<String>();
            for (i = 0; i < list.size(); ++i) {
                ob = (Object[])list.get(i);
                zs = (AbstractZone)ob[0];
                String newName = (String)ob[1];
                if (zs.zoneName.equals(newName)) continue;
                if (zs.isAlias()) {
                    cmdArr.add(CMD_ZONING_ALIAS + zs.getZoneName() + RENAME + newName);
                    continue;
                }
                if (zs.isZoneset()) {
                    cmdArr.add(CMD_ZONING_ZONESET + zs.getZoneName() + RENAME + newName);
                    continue;
                }
                if (!zs.isZone()) continue;
                cmdArr.add(CMD_ZONING_ZONE + zs.getZoneName() + RENAME + newName);
            }
            if (cmdArr.size() > 0) {
                cmdArr.add(0, ZONE_EDIT_CMD);
                cmdArr.add(ZONE_SAVE_CMD);
                this._smlCmd.executeSmlCommands("smlsetb", cmdArr.toArray(new String[cmdArr.size()]), EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
                for (i = 0; i < list.size(); ++i) {
                    ob = (Object[])list.get(i);
                    zs = (AbstractZone)ob[0];
                    zs.zoneName = (String)ob[1];
                    zs.setZoneLastModtime(sysUpTime);
                }
            }
        }
    }

    @Override
    public void modifyZoneMember(ArrayList zoneMemberList, long sysUpTime) throws SnmpException {
    }

    @Override
    public void modifyZone(ArrayList zoneList, long sysUpTime) throws SnmpException {
        this.modifyAbstractZoneName(zoneList, sysUpTime);
    }

    @Override
    public void clearAllZoneMembers(int vsanId, String[] zns) throws SnmpException {
        if (zns == null || zns.length == 0) {
            return;
        }
        String[] zoneList = this._smlCmd.executeSmlCommands("smlgetb", new String[]{"Oper.Zoning.ZoneList.0"}, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
        ArrayList<String> filteredZoneList = new ArrayList<String>();
        if (zoneList != null) {
            block0: for (int i = 0; i < zns.length; ++i) {
                for (int j = 0; j < zoneList.length; ++j) {
                    if (!zoneList[j].equals(zns[i])) continue;
                    filteredZoneList.add(zoneList[j]);
                    continue block0;
                }
            }
        }
        if (filteredZoneList.size() > 0) {
            String prependCmd = "Oper.Zoning.Zone.";
            String[] cmds = new String[filteredZoneList.size()];
            for (int i = 0; i < filteredZoneList.size(); ++i) {
                cmds[i] = prependCmd + filteredZoneList.get(i) + ".ZoneMemberList.0";
            }
            String[] allMemZones = this._smlCmd.executeSmlCommands("smlgetb", cmds, SmlCommandsHandler.DEFAULT_EXPECTED_VAL, null);
            ArrayList<String> remCmd = new ArrayList<String>();
            if (allMemZones != null && allMemZones.length == filteredZoneList.size()) {
                for (int i = 0; i < filteredZoneList.size(); ++i) {
                    int k;
                    ArrayList members = new ArrayList();
                    ArrayList aliasMems = null;
                    if (allMemZones[i] != null && allMemZones.length > 0) {
                        aliasMems = this.buildMembersList(allMemZones[i], 1, i + 1, members);
                    }
                    for (k = 0; k < members.size(); ++k) {
                        remCmd.add(CMD_ZONING_ZONE + filteredZoneList.get(i) + ".RemZoneMember." + this.buildZoneMemberCmd((AbstractZone)members.get(k)));
                    }
                    if (aliasMems == null) continue;
                    for (k = 0; k < aliasMems.size(); ++k) {
                        remCmd.add(CMD_ZONING_ZONE + filteredZoneList.get(i) + ".RemZoneMember." + this.buildZoneMemberCmd((AbstractZone)aliasMems.get(k)));
                    }
                }
            }
            if (remCmd.size() > 0) {
                remCmd.add(0, ZONE_EDIT_CMD);
                remCmd.add(ZONE_SAVE_CMD);
                this._smlCmd.executeSmlCommands("smlsetb", remCmd.toArray(new String[remCmd.size()]), EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
            }
        }
    }

    @Override
    public void activateZoneSet(ZoneSet zs, boolean b) throws SnmpException {
        String[] cmds = new String[]{CMD_ZONING_ZONESET + (b ? zs.getZoneName() + ".Activate" : "Deactivate")};
        this._smlCmd.executeSmlCommands("smlsetb", cmds, new String[]{"0", "52"}, null);
    }

    @Override
    public ArrayList buildFullZoneCmdArray(ArrayList zonesets, ArrayList zns, ArrayList members, ArrayList aliases, int vsanId) throws SnmpException {
        ArrayList vbArray = new ArrayList();
        return vbArray;
    }

    @Override
    public void exportImportZdb(boolean doImport, int portId) throws SnmpException {
        String[] cmds = new String[]{doImport ? "Cmd.Zoning.ImportDatabase." + portId : "Cmd.Zoning.ExportDatabase"};
        this._smlCmd.executeSmlCommands("smlsetb", cmds, EDIT_ZONEOK_ERR_CODE, ZONE_EDIT_CANCEL);
    }

    @Override
    public void CopyRunningToRemoteFile(String remoteFileName, String srvrAddress) throws SnmpException {
        String[] cmds = new String[]{"Cmd.Switch.TFTPSetup.LocalFileName.running-config", "Cmd.Switch.TFTPSetup.RemoteFileName." + remoteFileName, "Cmd.Switch.TFTPSetup.RemoteIPAddress." + SnmpIpAddress.toHexString((byte[])SnmpIpAddress.parse((String)srvrAddress), (int)0, (int)4, (boolean)false), "Cmd.Switch.TFTPPut"};
        this._smlCmd.executeSmlCommands("smlsetb", cmds, new String[]{"0"}, null);
    }

    @Override
    public void SaveRunningToStarup() throws SnmpException {
        String output;
        if (this._smlCmd.isInConfigMode()) {
            this._smlCmd.executeCLICommand("end", (String)null, false);
        }
        if ((output = this._smlCmd.executeCLICommand("copy running-config startup-config", (String)null, false)).trim().indexOf("100") == -1) {
            throw new SnmpException("Copy Running to Startup failed.");
        }
    }

    @Override
    public AbstractZone clone(AbstractZone originalZone, int index, String cloneName, long sysuptime) throws SnmpException {
        throw new SnmpException("Unsupported API");
    }

    @Override
    public ArrayList discoverMembersOfAliasOrZone(boolean enforced, ArrayList mem, AbstractZone az) throws SnmpException {
        return new ArrayList();
    }
}

