/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.jnm.SwitchVersion;

public class ZoneCapability {
    private boolean _isIvr;
    private int _supportedFeatureId;
    static final int VER_10 = 1;
    static final int VER_12 = 2;
    static final int VER_13 = 3;
    static final int VER_133 = 4;
    static final int VER_20 = 5;
    static final int VER_21 = 6;
    static final int VER_30 = 7;
    static final int VER_302 = 8;
    static final int VER_303 = 9;
    static final int VER_31 = 10;
    static final int VER_51 = 11;
    public static final String SZ_VERSION = "5.2(6)";
    protected SwitchVersion _version;
    protected boolean _isMDS;
    protected boolean _isQuail;
    protected boolean _isN5K;
    protected boolean _isSmartZoningEnabled;
    protected boolean _isSmartZoningSupported = true;

    public ZoneCapability(boolean isMds, boolean isQuail, boolean isN5K, SwitchVersion version, boolean isIvr) {
        this._isN5K = isN5K;
        this._version = version;
        this._isMDS = isMds;
        this._isQuail = isQuail;
        this._supportedFeatureId = this.isVersionLessThan("1.2(0)") ? 1 : (this.isVersionLessThan("1.3(0)") ? 2 : (this.isVersionLessThan("1.3(3)") ? 3 : (this.isVersionLessThan("2.0(0)") ? 4 : (this.isVersionLessThan("2.1(0)") ? 5 : (this.isVersionLessThan("3.0(0)") ? 6 : (this.isVersionLessThan("3.0(2)") ? 7 : (this.isVersionLessThan("3.0(3)") ? 8 : (this.isVersionLessThan("3.1(0)") ? 9 : (this.isVersionLessThan("5.0(0)") ? 10 : 11)))))))));
        this._isIvr = isIvr;
    }

    public boolean isROSupported() {
        if (this._isN5K) {
            return false;
        }
        return !this._isIvr && this._isMDS && this._supportedFeatureId >= 2 || this._isIvr && this._supportedFeatureId > 6;
    }

    public boolean isQosSupported() {
        if (this._isN5K) {
            return false;
        }
        return this._isMDS && (!this._isIvr && this._supportedFeatureId >= 5 || this._isIvr && this._supportedFeatureId >= 6);
    }

    public boolean isBroadcastSupported() {
        if (this._isN5K) {
            return false;
        }
        return this._isMDS && !this._isIvr && this._supportedFeatureId >= 5;
    }

    public boolean isZoneRenameupported() {
        return this._isMDS && this._supportedFeatureId >= 2 || this._isQuail;
    }

    public boolean isIscsiSupported() {
        return !this._isIvr && this._isMDS && this._supportedFeatureId > 1;
    }

    public boolean isLunZoningSupported() {
        if (this._isN5K) {
            return false;
        }
        return this._isMDS && (!this._isIvr && this._supportedFeatureId >= 2 || this._isIvr && this._supportedFeatureId >= 6);
    }

    public boolean isOsBasedLunDiscoverySupported() {
        if (this._isN5K) {
            return false;
        }
        return this._isMDS && this._supportedFeatureId >= 3;
    }

    public boolean isBrcdDIDSupported() {
        return !this._isIvr && (this._isMDS && this._supportedFeatureId >= 2 || this._isQuail && this._supportedFeatureId >= 9);
    }

    public boolean isMdsDIDOrIscsiSubnetSupported() {
        return this._isMDS && !this._isIvr && this._supportedFeatureId >= 3;
    }

    public boolean isDistributeSupported() {
        return this._isMDS && !this._isIvr && this._supportedFeatureId >= 4;
    }

    public boolean isAliasRenameSupported() {
        return !this._isIvr && (this._isMDS && this._supportedFeatureId >= 5 || this._isQuail);
    }

    public boolean isZoneSetRenameSupported() {
        return this._isMDS && this._supportedFeatureId >= 5 || this._isQuail;
    }

    public boolean isEnhancedSupported() {
        return !this._isIvr && this._isMDS && this._supportedFeatureId >= 5;
    }

    public boolean isCFSSupported() {
        return this._isMDS && this._supportedFeatureId >= 5;
    }

    public boolean isNatAutoTopoAfidSupported() {
        return this._isIvr && this._isMDS && this._supportedFeatureId >= 6;
    }

    public boolean isIvrCapable() {
        if (this._isN5K) {
            return false;
        }
        return this._isMDS && this._supportedFeatureId >= 3;
    }

    public boolean isSwitchPortWWNSupported() {
        return !this._isIvr && this._isMDS;
    }

    public boolean isZonesetValidationSupported() {
        return !this._isIvr && this._isMDS && this._supportedFeatureId >= 11;
    }

    public boolean isSwitchPortInterfaceSupported() {
        return !this._isIvr && (this._isMDS && this._supportedFeatureId >= 2 || this._isQuail && this._supportedFeatureId >= 9);
    }

    public boolean isMergeAnalysisSupported() {
        return this._isMDS;
    }

    public boolean isFcidSupported() {
        return this._isMDS && !this._isIvr;
    }

    public boolean areMoreThan2KZonesSupported() {
        if (this._isIvr) {
            return this._isMDS && this._supportedFeatureId >= 9;
        }
        return this._isMDS && this._supportedFeatureId >= 7;
    }

    public boolean isIPv6ZoneMemberSupported() {
        return this._isMDS && !this._isIvr && this._supportedFeatureId >= 7;
    }

    public boolean isDeviceAliasZoneSupported() {
        return this._isMDS && this._supportedFeatureId >= 10;
    }

    public boolean isVersionGreaterThan(String version) {
        if (!this._isMDS && !this._isQuail) {
            return false;
        }
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._version != null && this._version.compareTo(targetVersion) > 0;
    }

    public boolean isVersionGreaterThanEqual(String version) {
        if (!this._isMDS && !this._isQuail) {
            return false;
        }
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._version != null && this._version.compareTo(targetVersion) >= 0;
    }

    public boolean isVersionLessThan(String version) {
        if (!this._isMDS && this._isQuail) {
            return false;
        }
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._version != null && this._version.lessThan(targetVersion);
    }

    public boolean isVersionLessThanEqual(String version) {
        if (!this._isMDS && this._isQuail) {
            return false;
        }
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._version != null && this._version.lessThanEqual(targetVersion);
    }

    public boolean isVersion1_0() {
        return this._isMDS && this._version != null && this._version.toString().startsWith("1.0");
    }

    public boolean isIvr() {
        return this._isIvr;
    }

    public boolean isMDS() {
        return this._isMDS;
    }

    public boolean isQuail() {
        return this._isQuail;
    }

    public boolean isSmartZoningSupported() {
        return this._isSmartZoningSupported && this.isVersionGreaterThanEqual(SZ_VERSION) && !this._isIvr;
    }

    public boolean isSmartZoningEnabled() {
        return this._isSmartZoningEnabled;
    }

    public void setSmartZoningStatus(boolean status) {
        this._isSmartZoningEnabled = status;
    }

    public void setSmartZoningSupport(boolean status) {
        this._isSmartZoningSupported = status;
    }
}

