/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.MdsCommandHandler;
import com.cisco.dcbu.lib.mds.zm.QlogicCommandHandler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneActivationAction;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneCommitAction;
import com.cisco.dcbu.lib.mds.zm.ZoneMember;
import com.cisco.dcbu.lib.mds.zm.ZoneMode;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.mds.zm.ZoneUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZoneData {
    protected ArrayList zonesets = new ArrayList();
    protected ArrayList zonesList = new ArrayList();
    protected ArrayList aliases = new ArrayList();
    protected ArrayList zoneMembers = new ArrayList();
    protected ZoneSet activeZoneSetInLocalDB;
    protected ZoneSet activeZoneSet;
    protected boolean enhanced;
    protected boolean commitRequired;
    protected ZoneMode zmMode;
    protected ZoneCapability capability;
    protected CommandHandler cmdHandler;
    protected VersionPeer verPeer;
    protected int vsanId;
    private boolean isEnhancedDeviceAliaseEnabled;

    public boolean isLockedByAnotherUserOrSwitch() {
        if (this.vsanId > 0) {
            String lockOwner = this.getLockOwner();
            int ownerType = this.getLockOwnerType();
            if (ownerType == 5 && lockOwner != null && lockOwner.equals(this.verPeer.getSwitchPeer().getUserName())) {
                return false;
            }
        } else if (this.zmMode.getLockingSwitch() != null && SnmpString.equals((byte[])this.zmMode.getLockingSwitch(), (byte[])this.verPeer.getSwitchPeer().getAddress().getAddress())) {
            return false;
        }
        return true;
    }

    public boolean isEnhancedDeviceAliaseEnabled() {
        return this.isEnhancedDeviceAliaseEnabled;
    }

    public boolean isActiveLocalModifiedActive() {
        if (this.activeZoneSetInLocalDB != null && this.activeZoneSet != null) {
            return ZoneSet.isModifiedActive(this.activeZoneSet, this.activeZoneSetInLocalDB);
        }
        return false;
    }

    public int getVsanId() {
        return this.vsanId;
    }

    public SnmpPeer getSwitchPeer() {
        return this.verPeer.getSwitchPeer();
    }

    public void setVsanSwitch(VersionPeer sw, int vsan, StatusIf statusIf) throws SnmpException {
        this.vsanId = vsan;
        this.verPeer = sw;
        ZoneCapability zoneCapability = this.capability = this.vsanId == -1 ? this.verPeer.getIvrCapability() : this.verPeer.getNonIvrCapability();
        if (this.vsanId != -1 && this.capability.isSmartZoningSupported()) {
            int smartZoningFeature = ZoneUtil.checkSmartZoningVsanActivated(this.verPeer.getSwitchPeer(), this.vsanId);
            boolean smartZoningEnabled = smartZoningFeature == 2;
            this.capability.setSmartZoningStatus(smartZoningEnabled);
            if (smartZoningFeature == 0) {
                this.capability.setSmartZoningSupport(false);
            }
        }
        this.creteCommandHandler(statusIf);
        this.inValidateData();
    }

    protected void creteCommandHandler(StatusIf statusIf) throws SnmpException {
        if (this.verPeer.isMds()) {
            this.cmdHandler = new MdsCommandHandler(this.capability, this.vsanId, statusIf, this.verPeer);
            return;
        }
        if (this.verPeer.isQuail()) {
            try {
                this.cmdHandler = new QlogicCommandHandler(this.capability, this.vsanId, this.verPeer, statusIf);
                return;
            }
            catch (IOException ex) {
                throw new SnmpException(ex.getMessage());
            }
        }
        throw new SnmpException("No Command Handler available.");
    }

    public void modifySwitchWoInvalidation(VersionPeer sw) {
        this.verPeer = sw;
    }

    public void setVsanPeer(VersionPeer vPeer, int vsan) {
        this.vsanId = vsan;
        this.verPeer = vPeer;
        this.capability = this.vsanId == -1 ? this.verPeer.getIvrCapability() : this.verPeer.getNonIvrCapability();
        this.inValidateData();
    }

    protected void inValidateData() {
        this.activeZoneSetInLocalDB = null;
        this.zonesets = null;
        this.zonesList.clear();
        this.aliases.clear();
        this.zoneMembers.clear();
    }

    public ZoneSet getLocalActiveZoneSet() {
        return this.activeZoneSetInLocalDB;
    }

    public ZoneSet getActiveZoneSet() {
        return this.activeZoneSet;
    }

    public void resetActiveZoneset() {
        this.activeZoneSet = null;
    }

    public void populateData() throws SnmpException {
        this.aliases = ZoneAlias.discover(this.cmdHandler, this.zoneMembers);
        this.populateZoneZoneSetData(false);
        this.populateZoneMemberData(false);
    }

    public void refreshZoningMode() throws SnmpException {
        this.enhanced = false;
        this.commitRequired = false;
        if (this.capability.isCFSSupported()) {
            this.zmMode = this.cmdHandler.getZoneMode();
            boolean bl = this.enhanced = this.zmMode != null ? this.zmMode.isEnhanced() : false;
            if (this.enhanced) {
                this.commitRequired = this.zmMode.isCommitPending();
            }
            this.updateReadFrom();
        }
        this.isEnhancedDeviceAliaseEnabled = this.cmdHandler.discoverDeviceAliasMode() == 2;
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    public boolean isCommitRequired() {
        return this.commitRequired;
    }

    public void updateCommit(boolean b) throws SnmpException {
        if (this.enhanced && this.commitRequired != b) {
            this.commitRequired = b;
        }
        this.updateReadFrom();
    }

    protected void updateReadFrom() throws SnmpException {
        if (this.capability.isCFSSupported() && this.zmMode != null) {
            int readFrom;
            int n = readFrom = this.enhanced && this.commitRequired ? 2 : 1;
            if (readFrom == 2 && this.zmMode.isReadFromPending() || readFrom == 1 && !this.zmMode.isReadFromPending()) {
                return;
            }
            VarBindList mode = new VarBindList();
            if (this.vsanId != -1) {
                mode.add(MibNode.get((String)"czseReadFrom").getOid(), 0, (SnmpVar)new SnmpInt(readFrom));
            } else {
                mode.add(MibNode.get((String)"cfsFeatureOpShowCfgOption").getOid(), MdsCommandHandler.IVR_CFS_INDEX, (SnmpVar)new SnmpInt(readFrom));
            }
            SnmpFetch.set((SnmpPeer)this.verPeer.getSwitchPeer(), (VarBindList)mode);
            this.zmMode.setReadFromPending(readFrom == 2);
        }
    }

    public void populateZoneZoneSetData(boolean enforced) throws SnmpException {
        this.zonesList = enforced ? Zone.discoverEnforced(this.cmdHandler, this.zoneMembers, this.aliases) : this.cmdHandler.discoverZones(false, this.zoneMembers, this.aliases);
        this.zonesets = enforced ? ZoneSet.discover(this.cmdHandler, this.zonesList) : ZoneSet.discover(this.cmdHandler, this.zonesList);
        this.fetchActiveZoneSet();
        this.cacheActiveLocalZoneset(true);
    }

    public void populateZoneMemberData(boolean enforced) throws SnmpException {
        this.zoneMembers = enforced ? ZoneMember.discoverEnforced(this.cmdHandler, this.zoneMembers) : ZoneMember.discover(this.cmdHandler, this.zoneMembers);
    }

    public void fetchActiveZoneSet() {
        try {
            this.activeZoneSet = null;
            ArrayList active = ZoneSet.discoverEnforced(this.cmdHandler, this.zonesList);
            if (active.size() > 0) {
                this.activeZoneSet = (ZoneSet)active.get(0);
            }
        }
        catch (SnmpException ex) {
            System.out.println("Failed to get active zoneset " + ex.getMessage());
        }
    }

    public int getNextZoneSetId() {
        return this.getNextAbstractZoneId(this.zonesets);
    }

    public int getNextZoneId() {
        return this.getNextAbstractZoneId(this.zonesList);
    }

    public int getNextZoneAliasId() {
        return this.getNextAbstractZoneId(this.aliases);
    }

    public int getNextZoneMemberId(int parentType, int parentIndex, int usedIndices) {
        ZoneMember mem;
        int nextZoneMemberIndex = 0;
        for (int startIndex = this.getMemberListLocation(parentType, parentIndex); startIndex < this.zoneMembers.size() && parentType == (mem = (ZoneMember)this.zoneMembers.get(startIndex)).getParentType() && mem.getParentIndex() == parentIndex; ++startIndex) {
            int newZoneMemberIndex = mem.getZoneIndex();
            if (newZoneMemberIndex - nextZoneMemberIndex > 1 + usedIndices) {
                return nextZoneMemberIndex + 1 + usedIndices;
            }
            nextZoneMemberIndex = newZoneMemberIndex;
        }
        return nextZoneMemberIndex + 1 + usedIndices;
    }

    int getLocationForNewZoneMember(int parentType, int parentIndex, int memberIndex) {
        ZoneMember mem;
        int startIndex;
        for (startIndex = this.getMemberListLocation(parentType, parentIndex); startIndex < this.zoneMembers.size() && parentType == (mem = (ZoneMember)this.zoneMembers.get(startIndex)).getParentType() && mem.getParentIndex() == parentIndex; ++startIndex) {
            if (mem.getZoneIndex() <= memberIndex) continue;
            return startIndex;
        }
        return startIndex;
    }

    protected int getNextAbstractZoneId(ArrayList coll) {
        int nextId = 0;
        for (int i = 0; i < coll.size(); ++i) {
            int newIndex = ((AbstractZone)coll.get(i)).getZoneIndex();
            if (newIndex - nextId > 1) {
                return nextId + 1;
            }
            nextId = newIndex;
        }
        return nextId + 1;
    }

    public ArrayList getZoneMembers(Zone az) {
        return ZoneData.getZoneMembers(az, this.zoneMembers, this.aliases);
    }

    public static ArrayList getZoneMembers(Zone az, ArrayList members, ArrayList allAliases) {
        byte[] aliases = az.getZoneAliases();
        ArrayList list = ZoneData.getZoneMembersOnly(az, members);
        if (allAliases != null) {
            for (int i = 0; i < allAliases.size(); ++i) {
                ZoneAlias alias = (ZoneAlias)allAliases.get(i);
                byte[] newByte = AbstractZone.testBit(aliases, alias.getZoneIndex(), false);
                if (!SnmpString.getBit((byte[])newByte, (int)alias.getZoneIndex())) continue;
                list.add(alias);
            }
        }
        return list;
    }

    public ArrayList getAliasMembersOfZone(Zone az) {
        return ZoneData.getAliasMembersOfZone(az, this.aliases);
    }

    public static ArrayList getAliasMembersOfZone(Zone az, ArrayList allAliases) {
        ArrayList<ZoneAlias> list = new ArrayList<ZoneAlias>();
        if (az != null && allAliases != null) {
            byte[] aliases = az.getZoneAliases();
            if (allAliases != null) {
                for (int i = 0; i < allAliases.size(); ++i) {
                    ZoneAlias alias = (ZoneAlias)allAliases.get(i);
                    byte[] newByte = AbstractZone.testBit(aliases, alias.getZoneIndex(), false);
                    if (!SnmpString.getBit((byte[])newByte, (int)alias.getZoneIndex())) continue;
                    list.add(alias);
                }
            }
        }
        return list;
    }

    public static ArrayList getZoneMembersOnly(Zone az, ArrayList members) {
        ArrayList<ZoneMember> list = new ArrayList<ZoneMember>();
        for (int i = 0; i < members.size(); ++i) {
            ZoneMember mem = (ZoneMember)members.get(i);
            if (!mem.isZoneParent() || mem.getParentIndex() != az.getZoneIndex()) continue;
            list.add(mem);
        }
        return list;
    }

    public static ArrayList getAliasMembersOnly(ZoneAlias az, ArrayList members) {
        ArrayList<ZoneMember> list = new ArrayList<ZoneMember>();
        for (int i = 0; i < members.size(); ++i) {
            ZoneMember mem = (ZoneMember)members.get(i);
            if (!mem.isAliasParent() || mem.getParentIndex() != az.getZoneIndex()) continue;
            list.add(mem);
        }
        return list;
    }

    public ArrayList getAliasMembers(ZoneAlias az) {
        return ZoneData.getAliasMembersOnly(az, this.zoneMembers);
    }

    public ArrayList getAsZoneMembers(Zone az) {
        int i;
        ArrayList<ZoneMember> list = new ArrayList<ZoneMember>();
        byte[] filteredAliases = az.getZoneAliases();
        ArrayList<ZoneAlias> aliasList = new ArrayList<ZoneAlias>();
        if (this.aliases != null) {
            for (i = 0; i < this.aliases.size(); ++i) {
                ZoneAlias alias = (ZoneAlias)this.aliases.get(i);
                byte[] newByte = AbstractZone.testBit(filteredAliases, alias.getZoneIndex(), false);
                if (!SnmpString.getBit((byte[])newByte, (int)alias.getZoneIndex())) continue;
                aliasList.add(alias);
            }
        }
        block1: for (i = 0; i < this.zoneMembers.size(); ++i) {
            ZoneMember mem = (ZoneMember)this.zoneMembers.get(i);
            if (mem.isZoneParent() && mem.getParentIndex() == az.getZoneIndex()) {
                list.add(mem);
                continue;
            }
            if (!mem.isAliasParent()) continue;
            for (int k = 0; k < aliasList.size(); ++k) {
                if (((ZoneAlias)aliasList.get(k)).getZoneIndex() != mem.getParentIndex()) continue;
                if (list.contains(mem)) continue block1;
                list.add(mem);
                continue block1;
            }
        }
        return list;
    }

    public ArrayList getDetailedZoneMembers(Zone az) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        ArrayList memberList = this.getZoneMembers(az);
        for (int i = 0; i < memberList.size(); ++i) {
            AbstractZone aZone = (AbstractZone)memberList.get(i);
            ArrayList zoneList = this.getZoneMembershipOfMember(aZone);
            list.add(new Object[]{aZone, zoneList});
        }
        return list;
    }

    public ArrayList getZoneMembershipOfMember(AbstractZone aZone) {
        ArrayList<Zone> zoneList = new ArrayList<Zone>();
        for (int k = 0; k < this.zonesList.size(); ++k) {
            Zone zn = (Zone)this.zonesList.get(k);
            if (aZone.isZoneMember()) {
                ArrayList zoneMembers = this.getZoneMembers(zn);
                for (int m = 0; m < zoneMembers.size(); ++m) {
                    if (!((AbstractZone)zoneMembers.get(m)).isZoneMember() || !((ZoneMember)zoneMembers.get(m)).equals((ZoneMember)aZone)) continue;
                    zoneList.add(zn);
                }
                continue;
            }
            byte[] newByte = AbstractZone.testBit(zn.getZoneAliases(), aZone.getZoneIndex(), false);
            if (!SnmpString.getBit((byte[])newByte, (int)aZone.getZoneIndex())) continue;
            zoneList.add(zn);
        }
        return zoneList;
    }

    public ArrayList getDetailedAliasMembers(ZoneAlias az) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        ArrayList memberList = ZoneData.getAliasMembersOnly(az, this.zoneMembers);
        for (int i = 0; i < memberList.size(); ++i) {
            AbstractZone aZone = (AbstractZone)memberList.get(i);
            list.add(new Object[]{aZone, null});
        }
        return list;
    }

    public AbstractZone clone(AbstractZone az, int index, String name, long sysupTime) throws SnmpException {
        AbstractZone cloneAz = az.clone(this.cmdHandler, index, name, sysupTime);
        if (cloneAz != null) {
            if (cloneAz.isZone() || cloneAz.isAlias()) {
                int parentType = -1;
                ArrayList<ZoneMember> members = new ArrayList<ZoneMember>();
                int startIndex = -1;
                if (az != null) {
                    ZoneMember mem;
                    parentType = az.isZone() ? 1 : 2;
                    int newZoneMemberIndex = 1;
                    for (startIndex = this.getMemberListLocation(parentType, az.getZoneIndex()); startIndex < this.zoneMembers.size() && (mem = (ZoneMember)this.zoneMembers.get(startIndex)).getParentIndex() == az.getZoneIndex() && mem.getParentType() == parentType; ++startIndex) {
                        members.add(mem.cloneMember(newZoneMemberIndex++, parentType, index));
                    }
                }
                this.updateCommit(true);
                if (cloneAz.isZone()) {
                    this.insert(cloneAz, this.zonesList);
                } else {
                    this.insert(cloneAz, this.aliases);
                }
                if (cloneAz != null && members.size() > 0) {
                    this.zoneMembers.addAll(this.getMemberListLocation(parentType, cloneAz.getZoneIndex()), members);
                }
                this.updateCommit(true);
            } else if (cloneAz.isZoneset()) {
                this.updateCommit(true);
                this.insert(cloneAz, this.zonesets);
            }
        }
        return cloneAz;
    }

    public ZoneSet createNewZoneset(ZoneSet az, String name, int index, long sysUpTime) throws SnmpException {
        ArrayList zoneMembers = this.getZoneSetMembers(az);
        Zone[] memberArr = zoneMembers.toArray(new Zone[zoneMembers.size()]);
        ZoneSet zs = ZoneSet.createNewZoneset(this.vsanId, memberArr, sysUpTime, index, name, this.cmdHandler);
        this.updateCommit(true);
        this.insert(zs, this.zonesets);
        return zs;
    }

    public ZoneSet createNewZoneset(ZoneSet az, String name, Zone[] members, long sysUpTime) throws SnmpException {
        ZoneSet zs = ZoneSet.createNewZoneset(this.vsanId, members, sysUpTime, this.getNextZoneSetId(), name, this.cmdHandler);
        this.updateCommit(true);
        this.insert(zs, this.zonesets);
        return zs;
    }

    public void validateZoneSetForCopy(ZoneSet az, boolean append, ArrayList zones, String extra) throws SnmpException {
        String newZsName;
        String string = newZsName = append ? az.getZoneName() + "_" + extra : extra + "-" + az.getZoneName();
        if (this.findZoneSet(newZsName) != null) {
            throw new SnmpException("A Zoneset with name " + newZsName + " already exists.\n" + "Please choose a different " + (append ? "suffix." : "prefix."));
        }
        this.validateZonesForCopy(zones, append, extra);
    }

    public void validateZonesForCopy(ArrayList zones, boolean append, String extra) throws SnmpException {
        if (zones == null) {
            return;
        }
        for (int i = 0; i < zones.size(); ++i) {
            String newZnName;
            Zone zn = (Zone)zones.get(i);
            String string = newZnName = append ? zn.getZoneName() + "_" + extra : extra + "-" + zn.getZoneName();
            if (this.findZone(newZnName) == null) continue;
            throw new SnmpException("A Zone with name " + newZnName + " already exists.\n" + "Please choose a different " + (append ? "suffix." : "prefix."));
        }
    }

    public Zone createNewZone(Zone az, String name, boolean readOnly, int index, boolean qos, int qospriority, boolean broadcast, boolean smtzone, long sysUpTime) throws SnmpException {
        byte[] alias;
        byte[] byArray = alias = az != null ? az.getZoneAliases() : null;
        if (alias != null) {
            byte[] newAlias = new byte[alias.length];
            System.arraycopy(alias, 0, newAlias, 0, alias.length);
            alias = newAlias;
        }
        int parentType = -1;
        ArrayList<ZoneMember> members = new ArrayList<ZoneMember>();
        int startIndex = -1;
        if (az != null) {
            ZoneMember mem;
            parentType = az.isZone() ? 1 : 2;
            int newZoneMemberIndex = 1;
            for (startIndex = this.getMemberListLocation(parentType, az.getZoneIndex()); startIndex < this.zoneMembers.size() && (mem = (ZoneMember)this.zoneMembers.get(startIndex)).getParentIndex() == az.getZoneIndex() && mem.getParentType() == parentType; ++startIndex) {
                members.add(mem.cloneMember(newZoneMemberIndex++, parentType, index));
            }
        }
        Zone zs = Zone.createNewZone(this.vsanId, index, readOnly, alias, ZoneData.getAliasMembersOfZone(az, this.aliases), null, name, qos, qospriority, broadcast, smtzone, this.cmdHandler, sysUpTime);
        this.updateCommit(true);
        this.insert(zs, this.zonesList);
        if (az != null && members.size() > 0) {
            int i = 0;
            while (i < members.size()) {
                ArrayList modMembers = new ArrayList();
                while (modMembers.size() <= 10 && i < members.size()) {
                    modMembers.add(members.get(i++));
                }
                this.cmdHandler.createNewMembers(modMembers, zs);
            }
            this.zoneMembers.addAll(this.getMemberListLocation(parentType, zs.getZoneIndex()), members);
        }
        return zs;
    }

    public void removeLink(AbstractZone zn) {
        block2: {
            block3: {
                if (zn == null) break block2;
                if (!(zn instanceof Zone)) break block3;
                for (int k = 0; k < this.zonesets.size(); ++k) {
                    ((ZoneSet)this.zonesets.get(k)).removeLink(zn);
                }
                break block2;
            }
            if (!(zn instanceof ZoneAlias)) break block2;
            for (int k = 0; k < this.zonesList.size(); ++k) {
                ((Zone)this.zonesList.get(k)).removeLink(zn);
            }
        }
    }

    public void removeZoneMembers(Zone zn) {
        if (this.zoneMembers != null) {
            Iterator itr = this.zoneMembers.iterator();
            while (itr.hasNext()) {
                ZoneMember mem = (ZoneMember)itr.next();
                if (!mem.isZoneParent() || mem.getParentIndex() != zn.getZoneIndex()) continue;
                itr.remove();
            }
        }
    }

    public void removeAliaseMembers(ZoneAlias zn) {
        if (this.zoneMembers != null) {
            Iterator itr = this.zoneMembers.iterator();
            while (itr.hasNext()) {
                ZoneMember mem = (ZoneMember)itr.next();
                if (!mem.isAliasParent() || mem.getParentIndex() != zn.getZoneIndex()) continue;
                itr.remove();
            }
        }
    }

    protected int getMemberListLocation(int parentType, int parentIndex) {
        ZoneMember mem;
        int i;
        for (i = 0; i < this.zoneMembers.size() && (parentType > (mem = (ZoneMember)this.zoneMembers.get(i)).getParentType() || parentIndex > mem.getParentIndex()); ++i) {
        }
        return i;
    }

    protected void insert(AbstractZone az, ArrayList collection) {
        for (int i = 0; i < collection.size(); ++i) {
            if (((AbstractZone)collection.get(i)).getZoneIndex() <= az.getZoneIndex()) continue;
            collection.add(i, az);
            return;
        }
        collection.add(az);
    }

    public void updateTimeStamp() throws SnmpException {
        if (this.activeZoneSetInLocalDB != null) {
            this.cmdHandler.updateActiveZoneSetTimeStamp(this.activeZoneSetInLocalDB);
        }
    }

    public void delete(AbstractZone[] parent, AbstractZone[] child) throws SnmpException {
        AbstractZone.delete(this.cmdHandler, parent, child);
        this.updateCommit(true);
        this.updateTimeStamp();
        block0: for (int i = 0; i < child.length; ++i) {
            ArrayList coll = null;
            if (parent == null || parent[i] == null) {
                coll = this.zonesets;
                if (child[i].isAlias()) {
                    coll = this.aliases;
                    this.removeLink((ZoneAlias)child[i]);
                    this.removeAliaseMembers((ZoneAlias)child[i]);
                } else if (child[i].isZone()) {
                    coll = this.zonesList;
                    this.removeLink((Zone)child[i]);
                    this.removeZoneMembers((Zone)child[i]);
                } else if (child[i].isZoneMember()) {
                    coll = this.zoneMembers;
                }
            } else if (child[i].isZoneMember()) {
                coll = this.zoneMembers;
            }
            if (coll == this.zoneMembers) {
                for (int k = 0; k < coll.size(); ++k) {
                    if (!((ZoneMember)child[i]).attributeEquals((ZoneMember)coll.get(k))) continue;
                    coll.remove(k);
                    continue block0;
                }
                continue;
            }
            if (coll == null) continue;
            coll.remove(child[i]);
        }
    }

    protected AbstractZone[] buildZoneMemberObjects(Object[] child, AbstractZone parent, HashMap vsanAfid) {
        AbstractZone[] az = new AbstractZone[child.length];
        byte[] lunId = new byte[]{};
        int usedIndices = 0;
        int format = 1;
        int faId = 1;
        int ivrVsanId = 0;
        int devType = -1;
        for (int i = 0; i < child.length; ++i) {
            byte[] id;
            lunId = new byte[]{};
            if (child[i] instanceof ZoneMember) {
                id = ((ZoneMember)child[i]).getMemId();
                lunId = ((ZoneMember)child[i]).getMemLunId();
                format = ((ZoneMember)child[i]).getMemFormat();
                ivrVsanId = ((ZoneMember)child[i]).getIvrVsanIndex();
                faId = ((ZoneMember)child[i]).getAfid();
                devType = ((ZoneMember)child[i]).getDeviceType();
            } else if (child[i] instanceof byte[]) {
                id = (byte[])child[i];
                format = 1;
            } else {
                az[i] = (AbstractZone)child[i];
                continue;
            }
            int nextIndex = this.getNextZoneMemberId(parent.isZone() ? 1 : 2, parent.getZoneIndex(), usedIndices++);
            az[i] = this.cmdHandler.constructZoneMember(this.vsanId, nextIndex, parent.isZone() ? 1 : 2, parent.getZoneIndex(), format, id, lunId, faId, ivrVsanId, devType);
        }
        return az;
    }

    public ZoneAlias createNewZoneAlias(ZoneAlias az, String name, int index, long sysUpTime) throws SnmpException {
        ArrayList<ZoneMember> members = new ArrayList<ZoneMember>();
        int startIndex = -1;
        if (az != null) {
            ZoneMember mem;
            int newZoneMemberIndex = 1;
            for (startIndex = this.getMemberListLocation(2, az.getZoneIndex()); startIndex < this.zoneMembers.size() && (mem = (ZoneMember)this.zoneMembers.get(startIndex)).getParentIndex() == az.getZoneIndex() && mem.getParentType() == 2; ++startIndex) {
                members.add(mem.cloneMember(newZoneMemberIndex++, 2, index));
            }
        }
        ZoneAlias zs = ZoneAlias.createNewZoneAlias(this.cmdHandler, this.vsanId, index, null, name, sysUpTime);
        this.updateCommit(true);
        this.insert(zs, this.aliases);
        if (az != null && members.size() > 0) {
            int i = 0;
            while (i < members.size()) {
                ArrayList modMembers = new ArrayList();
                while (modMembers.size() <= 10 && i < members.size()) {
                    modMembers.add(members.get(i++));
                }
                this.cmdHandler.createNewMembers(modMembers, zs);
            }
            this.zoneMembers.addAll(this.getMemberListLocation(2, zs.getZoneIndex()), members);
        }
        return zs;
    }

    public ZoneAlias createNewZoneAlias(String name, byte[] wwn, int type, long sysUpTime) throws SnmpException {
        return this.createNewZoneAlias(name, wwn, type, sysUpTime, -1);
    }

    public ZoneAlias createNewZoneAlias(String name, byte[] wwn, int type, long sysUpTime, int devType) throws SnmpException {
        ZoneAlias za = null;
        int newAliasIndex = this.getNextZoneAliasId();
        za = ZoneAlias.createNewZoneAlias(this.cmdHandler, this.vsanId, newAliasIndex, null, name, sysUpTime);
        this.updateCommit(true);
        this.insert(za, this.aliases);
        if (wwn != null && wwn.length > 0) {
            ZoneMember member = this.cmdHandler.constructZoneMember(this.vsanId, 1, 2, newAliasIndex, type, wwn, null, -1, -1, devType);
            ArrayList<ZoneMember> memberList = new ArrayList<ZoneMember>();
            memberList.add(member);
            this.cmdHandler.createNewMembers(memberList, za);
            this.zoneMembers.add(this.getLocationForNewZoneMember(2, newAliasIndex, 1), member);
        }
        return za;
    }

    public void addMembers(Object[] transferObjects, AbstractZone parent, boolean clone, HashMap vsanAfid) throws SnmpException {
        AbstractZone[] child;
        if (clone) {
            child = this.buildZoneMemberObjects(transferObjects, parent, vsanAfid);
        } else {
            child = new AbstractZone[transferObjects.length];
            System.arraycopy(transferObjects, 0, child, 0, transferObjects.length);
        }
        parent.addMembers(this.cmdHandler, child);
        this.updateCommit(true);
        this.updateTimeStamp();
        if (parent.isZone() || parent.isAlias()) {
            AbstractZone zn = parent;
            for (int i = 0; i < child.length; ++i) {
                if (!child[i].isZoneMember()) continue;
                this.zoneMembers.add(this.getLocationForNewZoneMember(parent.isZone() ? 1 : 2, zn.getZoneIndex(), child[i].getZoneIndex()), child[i]);
            }
        }
    }

    public Object[] getAvailableZones(ZoneSet zs, AbstractZone[] members) {
        ArrayList filteredZones = new ArrayList(this.zonesList);
        for (int i = 0; i < members.length; ++i) {
            filteredZones.remove(members[i]);
        }
        return filteredZones.toArray();
    }

    public ArrayList getZoneSetMembers(ZoneSet az) {
        return ZoneData.getZoneSetMembers(az, this.zonesList);
    }

    public static ArrayList getZoneSetMembers(ZoneSet az, ArrayList zones) {
        ArrayList<Zone> members = new ArrayList<Zone>();
        if (az != null) {
            byte[] mem = az.getMembers();
            if (mem != null) {
                for (int j = 0; j < zones.size(); ++j) {
                    Zone zn = (Zone)zones.get(j);
                    int zoneIndex = zn.getZoneIndex();
                    byte[] newByte = AbstractZone.testBit(mem, zoneIndex, false);
                    if (!SnmpString.getBit((byte[])newByte, (int)zoneIndex)) continue;
                    members.add(zn);
                }
            }
            Collections.sort(members);
        }
        return members;
    }

    public ArrayList getDetailedAliases() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        if (this.aliases == null) {
            return list;
        }
        for (int k = 0; k < this.aliases.size(); ++k) {
            AbstractZone az = (AbstractZone)this.aliases.get(k);
            list.add(new Object[]{az, this.getAliasMembers((ZoneAlias)az)});
        }
        return list;
    }

    public ArrayList getDetailedZones(ArrayList zoneList) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int k = 0; k < zoneList.size(); ++k) {
            Zone az = (Zone)zoneList.get(k);
            list.add(new Object[]{az, this.getZoneMembers(az)});
        }
        return list;
    }

    public ArrayList getDetailedZonesets() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int k = 0; k < this.zonesets.size(); ++k) {
            ZoneSet az = (ZoneSet)this.zonesets.get(k);
            list.add(new Object[]{az, this.getZoneSetMembers(az)});
        }
        return list;
    }

    public void cacheActiveLocalZoneset(boolean updateTimestamp) throws SnmpException {
        if (this.zonesets == null) {
            return;
        }
        for (int i = 0; i < this.zonesets.size(); ++i) {
            ZoneSet zs = (ZoneSet)this.zonesets.get(i);
            if (this.activeZoneSet == null || !this.activeZoneSet.getZoneName().equals(zs.getZoneName())) continue;
            this.activeZoneSetInLocalDB = zs;
            if (updateTimestamp) {
                this.cmdHandler.updateActiveZoneSetTimeStamp(this.activeZoneSetInLocalDB);
            }
            return;
        }
        this.activeZoneSetInLocalDB = null;
    }

    public HashMap buidZoneSetComparisonHashMap(ZoneSet zs) {
        HashMap map = new HashMap();
        ArrayList zones = this.getZoneSetMembers(zs);
        if (zones != null) {
            for (int i = 0; i < zones.size(); ++i) {
                map.put(zones.get(i), this.getAsZoneMembers((Zone)zones.get(i)));
            }
        }
        return map;
    }

    public static void compareZoneSets(HashMap source, HashMap target) {
        Iterator itr = source.entrySet().iterator();
        block0: while (itr.hasNext()) {
            Map.Entry obEntry = itr.next();
            String sourceZoneName = obEntry.getKey().toString();
            ArrayList membersS = (ArrayList)obEntry.getValue();
            Iterator itrT = target.entrySet().iterator();
            while (itrT.hasNext()) {
                Map.Entry obEntryT = itrT.next();
                String targetZoneName = obEntryT.getKey().toString();
                if (!sourceZoneName.equals(targetZoneName)) continue;
                ArrayList membersT = (ArrayList)obEntryT.getValue();
                Iterator itrMs = membersS.iterator();
                while (itrMs.hasNext()) {
                    Object srcZonemember = itrMs.next();
                    boolean removeIt = false;
                    Iterator itrMt = membersT.iterator();
                    while (itrMt.hasNext()) {
                        Object tgtZonemember = itrMt.next();
                        if (!srcZonemember.equals(tgtZonemember)) continue;
                        itrMt.remove();
                        removeIt = true;
                        break;
                    }
                    if (!removeIt) continue;
                    itrMs.remove();
                }
                if (membersT.size() == 0) {
                    itrT.remove();
                }
                if (membersS.size() != 0) continue block0;
                itr.remove();
                continue block0;
            }
        }
    }

    public ZoneSet findZoneSet(String name) {
        if (this.zonesets != null) {
            for (int i = 0; i < this.zonesets.size(); ++i) {
                if (!((ZoneSet)this.zonesets.get(i)).toString().equals(name)) continue;
                return (ZoneSet)this.zonesets.get(i);
            }
        }
        return null;
    }

    public ZoneMember findZoneMember(int index, int parentType, int parentIndex) {
        if (this.zoneMembers != null) {
            for (int i = 0; i < this.zoneMembers.size(); ++i) {
                ZoneMember mem = (ZoneMember)this.zoneMembers.get(i);
                if (mem.getParentType() != parentType || mem.parentIndex != parentIndex || mem.zoneIndex != index) continue;
                return mem;
            }
        }
        return null;
    }

    public Zone findZone(String name) {
        if (this.zonesList != null) {
            for (int i = 0; i < this.zonesList.size(); ++i) {
                if (!((Zone)this.zonesList.get(i)).toString().equals(name)) continue;
                return (Zone)this.zonesList.get(i);
            }
        }
        return null;
    }

    public Zone findZone(int index) {
        if (this.zonesList != null) {
            for (int i = 0; i < this.zonesList.size(); ++i) {
                if (((Zone)this.zonesList.get(i)).getZoneIndex() != index) continue;
                return (Zone)this.zonesList.get(i);
            }
        }
        return null;
    }

    public ZoneAlias findZoneAlias(String name) {
        if (this.aliases != null) {
            for (int i = 0; i < this.aliases.size(); ++i) {
                if (!((ZoneAlias)this.aliases.get(i)).toString().equals(name)) continue;
                return (ZoneAlias)this.aliases.get(i);
            }
        }
        return null;
    }

    public boolean isEmpty(ZoneSet zs) {
        ArrayList zones = this.getZoneSetMembers(zs);
        if (zones == null || zones.size() == 0) {
            return true;
        }
        for (int i = 0; i < zones.size(); ++i) {
            Zone az = (Zone)zones.get(i);
            ArrayList mem = this.getAsZoneMembers(az);
            if (mem != null && mem.size() != 0) continue;
            return true;
        }
        return false;
    }

    public ArrayList getZoneMembers() {
        return this.zoneMembers;
    }

    public ArrayList getZonesets() {
        return this.zonesets;
    }

    public ArrayList getZones() {
        return this.zonesList;
    }

    public ArrayList getAliases() {
        return this.aliases;
    }

    public ZoneMode getZoneMode() {
        return this.zmMode;
    }

    public String getLockOwner() {
        if (this.zmMode != null && this.zmMode.isCommitPending()) {
            return this.zmMode.getOwner();
        }
        return "";
    }

    public int getLockOwnerType() {
        if (this.zmMode != null && this.zmMode.isCommitPending()) {
            return this.zmMode.getOwnerType();
        }
        return -1;
    }

    public boolean isAutoTopologyEnabled() {
        return this.zmMode != null && this.zmMode.isAutoTopology();
    }

    public ZoneCapability getZoneCapability() {
        return this.capability;
    }

    public CommandHandler getCmdHandler() {
        return this.cmdHandler;
    }

    public ZoneSet createZoneSet(String zonesetName, String zoneName, int zoneIndex, boolean readOnly, Array members, boolean qos, int qospriority, boolean broadcast, boolean smtzone, HashMap vsanAfid, long sysUpTime) throws SnmpException {
        int i;
        ZoneSet zs = this.findZoneSet(zonesetName);
        Zone zn = this.findZone(zoneName);
        if (zn == null) {
            zn = this.createNewZone(null, zoneName, readOnly, zoneIndex, qos, qospriority, broadcast, smtzone, sysUpTime);
        }
        if (zs == null) {
            Zone[] znAray = new Zone[]{zn};
            zs = ZoneSet.createNewZoneset(this.vsanId, znAray, sysUpTime, this.getNextZoneSetId(), zonesetName, this.cmdHandler);
            this.insert(zs, this.zonesets);
        } else {
            zs.addMembers(this.cmdHandler, new Zone[]{zn});
        }
        byte[] lun = new byte[]{};
        ArrayList<ZoneMember> zoneMembersToCreate = new ArrayList<ZoneMember>();
        if (members != null) {
            for (i = 0; i < members.size(); ++i) {
                int ivrVsan = 0;
                int format = 1;
                byte[] id = null;
                if (members.elementAt(i) instanceof byte[]) {
                    byte[] data = (byte[])members.elementAt(i);
                    if (data == null || data.length != 8) continue;
                    id = data;
                    format = 1;
                }
                int afId = 1;
                zoneMembersToCreate.add(this.cmdHandler.constructZoneMember(this.vsanId, i + 1, 1, zoneIndex, format, id, lun, afId, ivrVsan));
            }
        }
        if (zoneMembersToCreate.size() > 0) {
            i = 0;
            while (i < zoneMembersToCreate.size()) {
                ArrayList modMembers = new ArrayList();
                while (modMembers.size() < 10 && i < zoneMembersToCreate.size()) {
                    modMembers.add(zoneMembersToCreate.get(i++));
                }
                this.cmdHandler.createNewMembers(modMembers, zn);
            }
            if (this.zoneMembers != null && zs != null) {
                this.zoneMembers.addAll(this.getMemberListLocation(1, zs.getZoneIndex()), zoneMembersToCreate);
            }
        }
        if (this.zonesList != null && !this.zonesList.contains(zn)) {
            this.insert(zn, this.zonesList);
        }
        return zs;
    }

    public ZoneSet createZoneSet(String zonesetName, String zoneName, int zoneIndex, boolean readOnly, Array members, boolean qos, int qospriority, boolean broadcast, HashMap vsanAfid, long sysUpTime) throws SnmpException {
        return this.createZoneSet(zonesetName, zoneName, zoneIndex, readOnly, members, qos, qospriority, broadcast, false, vsanAfid, sysUpTime);
    }

    public void populatefcAliasData() throws SnmpException {
        this.aliases = ZoneAlias.discover(this.cmdHandler, this.zoneMembers);
    }

    public void populateZoneData(boolean enforced) throws SnmpException {
        this.zonesList = enforced ? Zone.discoverEnforced(this.cmdHandler, this.zoneMembers, this.aliases) : this.cmdHandler.discoverZones(false, this.zoneMembers, this.aliases);
    }

    public void populateZoneSetData(boolean enforced, ArrayList zoneList) throws SnmpException {
        this.zonesets = enforced ? ZoneSet.discover(this.cmdHandler, this.zonesList) : ZoneSet.discover(this.cmdHandler, this.zonesList);
    }

    public void populateZoneMemberDataForZone(boolean enforced, AbstractZone az) throws SnmpException {
        this.zoneMembers = enforced ? ZoneMember.discoverEnforced(this.cmdHandler, this.zoneMembers, az) : ZoneMember.discover(this.cmdHandler, this.zoneMembers, az);
    }

    public boolean activateDeactivateZoneSet(SnmpPeer prr, String zoneSetName, boolean activate) throws NumberFormatException, SnmpException {
        if (prr == null) {
            throw new SnmpException("Switch " + prr + " is not reachable.");
        }
        ZoneSet zs = this.findZoneSet(zoneSetName);
        if (zs == null) {
            throw new SnmpException("The selected zoneset " + zoneSetName + " does not exist.  Please try rediscovering Zones");
        }
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get((String)"zoneSetActivateRowStatus").getOid(), zs.getZoneVsanId(), (SnmpVar)new SnmpInt(4));
        byte varType = SnmpFetch.get((SnmpPeer)prr, (VarBindList)vbl).getVar(0).getType();
        if (varType == 2) {
            vbl.clear();
        }
        vbl.add(activate ? ZoneActivationAction.ZONESET_ACTIVATE : ZoneActivationAction.ZONESET_DEACTIVATE, this.getVsanId(), (SnmpVar)(activate ? new SnmpUnsignedInt((long)zs.getZoneIndex()) : new SnmpInt(1)));
        if (this.isEnhanced()) {
            vbl.add(ZoneCommitAction.ZONESET_COMMIT, this.getVsanId(), (SnmpVar)new SnmpInt(1));
        }
        SnmpFetch.set((SnmpPeer)prr, (SnmpPDU)new SnmpPDU(-93, vbl));
        return true;
    }

    public boolean commitZones() throws SnmpException {
        SnmpPeer prr = this.verPeer.getSwitchPeer();
        VarBindList vbl = new VarBindList();
        vbl.add(ZoneCommitAction.ZONESET_COMMIT, this.getVsanId(), (SnmpVar)new SnmpInt(1));
        SnmpFetch.set((SnmpPeer)prr, (SnmpPDU)new SnmpPDU(-93, vbl));
        return true;
    }

    public int getCommitStatus() throws SnmpException {
        SnmpPeer prr = this.verPeer.getSwitchPeer();
        VarBindList vbl = new VarBindList();
        vbl.add(ZoneCommitAction.ZONESET_COMMIT_RESULT, this.getVsanId());
        VarBindList response = SnmpFetch.get((SnmpPeer)prr, (VarBindList)vbl).getVariables();
        return response.intValue(0);
    }

    public Object[] getActivationDeactivationStatus(boolean activate) throws SnmpException {
        VarBindList response;
        int activateResult;
        String actDetStr = activate ? " Activation " : " Deactivation ";
        Object[] ret = new Object[2];
        SnmpPeer prr = this.verPeer.getSwitchPeer();
        VarBindList vbl = new VarBindList();
        vbl.add(ZoneActivationAction.ZONESET_ACTIVATE_RESULT, this.getVsanId());
        vbl.add(ZoneActivationAction.ZONESET_FAIL_CAUSE, this.getVsanId());
        vbl.add(ZoneActivationAction.ZONESET_DOMAIN_ID, this.getVsanId());
        if (this.isEnhanced()) {
            vbl.add(ZoneCommitAction.ZONESET_COMMIT_RESULT, this.getVsanId());
        }
        if ((activateResult = (response = SnmpFetch.get((SnmpPeer)prr, (VarBindList)vbl).getVariables()).intValue(0)) == 5) {
            ret[0] = 3;
            ret[1] = actDetStr + "in Progress";
        } else if (activate && activateResult == 1 || !activate && activateResult == 3) {
            ret[0] = 1;
            ret[1] = actDetStr + "Success";
        } else {
            ret[0] = 2;
            ret[1] = actDetStr + "Failed. ";
            MibNode _causeNode = MibNode.oidToNode((int[])MibNode.get((String)"zoneSetFailCause").getOid());
            MibEnum[] causeEnums = _causeNode.getEnums();
            int causeVal = response.intValue(1);
            ret[1] = actDetStr + "Failed. " + MibEnum.getLabel((MibEnum[])causeEnums, (int)causeVal) + " , domain id:" + response.intValue(2);
        }
        if (this.isEnhanced()) {
            int commitResult = response.intValue(3);
            if (commitResult == 2) {
                ret[1] = ret[1].toString() + "\n" + " Commit failed ";
                ret[0] = 2;
            } else if (commitResult != 1) {
                ret[0] = 3;
                ret[1] = actDetStr + "and Commit in Progress";
            }
        }
        return ret;
    }

    public boolean clearZoneLock() throws SnmpException {
        int[] nArray;
        SnmpPeer prr = this.verPeer.getSwitchPeer();
        VarBindList vbl = new VarBindList();
        int vsanId = this.getVsanId();
        int[] nArray2 = vsanId != -1 ? ZoneCommitAction.ZONESET_COMMIT : ZoneCommitAction.IVR_ZONESET_COMMIT;
        if (vsanId != -1) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = vsanId;
        } else {
            nArray = MdsCommandHandler.IVR_CFS_INDEX;
        }
        vbl.add(nArray2, nArray, (SnmpVar)new SnmpInt(vsanId != -1 ? 2 : 5));
        SnmpFetch.set((SnmpPeer)prr, (SnmpPDU)new SnmpPDU(-93, vbl));
        return true;
    }
}

