/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.ZoneData;
import com.cisco.dcbu.lib.snmp.SnmpException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ZoneDataCache {
    static Logger _Logger = LogManager.getLogger((String)"fms.ws");
    HashMap cachedZoneData = new HashMap();
    public static final int ZONEDATA_INDEX = 0;
    public static final int TIMESTAMP = 1;
    public static final int DEFAULT_STALE_TIME = 30;
    private int STALE_DATA_TIME = 30;
    private int POLE_DATA_TIME = this.STALE_DATA_TIME / 3 < 5 ? this.STALE_DATA_TIME / 3 : 5;
    private static ZoneDataCache _instance;
    private Timer _Timer = null;
    private ZoneDataSyncTask _SyncTask;

    protected ZoneDataCache() {
        try {
            this.STALE_DATA_TIME = Integer.parseInt(System.getProperty("ZONE_WEB_SERVICE_CACHE", Integer.toString(30)));
        }
        catch (Exception ex) {
            this.STALE_DATA_TIME = 30;
        }
    }

    public static ZoneDataCache getZoneDataCahche() {
        if (_instance == null) {
            _instance = new ZoneDataCache();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateData(VersionPeer sw, int vsanId) throws SnmpException {
        ZoneData znData = new ZoneData();
        znData.setVsanSwitch(sw, vsanId, null);
        znData.populateData();
        znData.refreshZoningMode();
        ZoneDataCache zoneDataCache = this;
        synchronized (zoneDataCache) {
            HashMap<Integer, Object[]> zoneDataMap = (HashMap<Integer, Object[]>)this.cachedZoneData.get(sw.getSwitchPeer().getAddress());
            if (zoneDataMap == null) {
                zoneDataMap = new HashMap<Integer, Object[]>();
                this.cachedZoneData.put(sw.getSwitchPeer().getAddress(), zoneDataMap);
            }
            zoneDataMap.put(vsanId, new Object[]{znData, System.currentTimeMillis()});
            if (_Logger != null) {
                _Logger.info((Object)("Created Zone cache for Switch:" + sw + " VSAN ID:" + vsanId));
            }
            this.startTimer();
        }
    }

    protected void startTimer() {
        block3: {
            try {
                if (this._Timer != null) {
                    this._Timer.cancel();
                    this._Timer = null;
                }
                this._Timer = new Timer();
                this._SyncTask = new ZoneDataSyncTask();
                this._Timer.schedule((TimerTask)this._SyncTask, 60000 * this.POLE_DATA_TIME);
            }
            catch (Exception ex) {
                if (_Logger == null) break block3;
                _Logger.info((Object)("Timer failed. " + ex));
            }
        }
    }

    public synchronized ZoneData getCachedZoneData(InetAddress swAddress, int vsanId) {
        Object[] znOb;
        HashMap zMap = (HashMap)this.cachedZoneData.get(swAddress);
        if (zMap != null && (znOb = (Object[])zMap.get(vsanId)) != null && znOb.length == 2) {
            return (ZoneData)znOb[0];
        }
        return null;
    }

    public synchronized void invalidateCache() {
        this.cachedZoneData.clear();
    }

    class ZoneDataSyncTask
    extends TimerTask {
        boolean keepAlive = true;
        int count = 0;
        Lock aggregationlocker = new ReentrantLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ZoneDataCache zoneDataCache = _instance;
            synchronized (zoneDataCache) {
                long curTime = System.currentTimeMillis();
                Iterator itr = ZoneDataCache.this.cachedZoneData.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry obEntry = itr.next();
                    HashMap zMap = (HashMap)obEntry.getValue();
                    Iterator itrV = zMap.entrySet().iterator();
                    while (itrV.hasNext()) {
                        Map.Entry vsanMap = itrV.next();
                        int vsanKey = (Integer)vsanMap.getKey();
                        long cacheTimeInMS = (Long)((Object[])vsanMap.getValue())[1];
                        if ((curTime - cacheTimeInMS) / 60000L < (long)ZoneDataCache.this.STALE_DATA_TIME) continue;
                        itrV.remove();
                        if (zMap.size() == 0) {
                            itr.remove();
                        }
                        if (_Logger == null) continue;
                        _Logger.info((Object)("Removed Zone cache for Switch:" + obEntry.getKey() + " VSAN ID:" + vsanKey));
                    }
                }
                if (ZoneDataCache.this.cachedZoneData.size() == 0) {
                    ZoneDataCache.this._Timer.cancel();
                    ZoneDataCache.this._Timer = null;
                } else {
                    ZoneDataCache.this.startTimer();
                }
            }
        }
    }
}

