/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.net;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;

public class EZServerSocket
extends ServerSocket {
    private InetAddress[] _bindAddrs;

    public EZServerSocket(int port, int backlog, InetAddress[] bindAddrs) throws IOException {
        super(port, backlog, null);
        this._bindAddrs = bindAddrs;
    }

    @Override
    public Socket accept() throws IOException {
        Socket s = super.accept();
        if (this._bindAddrs == null || this._bindAddrs.length == 0) {
            return s;
        }
        for (int i = 0; i < this._bindAddrs.length; ++i) {
            if (!s.getLocalAddress().equals(this._bindAddrs[i])) continue;
            return s;
        }
        s.close();
        throw new IOException("Connection refused");
    }

    public static InetAddress[] parseHostnames(String hostnames) {
        if (hostnames == null || hostnames.trim().length() == 0) {
            return null;
        }
        String[] names = hostnames.split(",");
        HashSet<InetAddress> addrs = new HashSet<InetAddress>();
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].trim();
            try {
                NetworkInterface ni = NetworkInterface.getByName(names[i]);
                if (ni != null) {
                    Enumeration<InetAddress> en = ni.getInetAddresses();
                    while (en.hasMoreElements()) {
                        addrs.add(en.nextElement());
                    }
                    continue;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                InetAddress addr = InetAddress.getByName(names[i]);
                if (addr.isAnyLocalAddress() || !addr.isLoopbackAddress() && names[i].equals(addr.getHostName()) && !addr.getHostAddress().equals(addr.getHostName())) {
                    return null;
                }
                addrs.add(addr);
                continue;
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        if (addrs.size() != 0) {
            try {
                addrs.add(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
                addrs.add(Inet6Address.getByName("::1"));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return addrs.toArray(new InetAddress[addrs.size()]);
        }
        return null;
    }
}

