/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.rmi;

import com.cisco.dcbu.lib.rmi.ClientSocketFactory;
import com.cisco.dcbu.lib.rmi.ServerSocketFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import java.rmi.server.ServerNotActiveException;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.ObjectTable;

public class EZRemoteObject
extends RemoteObject {
    private static final long serialVersionUID = 1L;
    public static final String PROP_USE_SSL = "server.useSsl";
    public static final String PROP_PORT = "server.data.port";
    private int _port = 0;
    private ClientSocketFactory _csf = null;
    private ServerSocketFactory _ssf = null;

    protected EZRemoteObject() throws RemoteException {
        this(0);
    }

    protected EZRemoteObject(int port) throws RemoteException {
        this._port = port;
        this._csf = new ClientSocketFactory(port);
        this._ssf = new ServerSocketFactory();
        EZRemoteObject.exportObject(this, port, this._csf, this._ssf);
    }

    protected EZRemoteObject(String hostname, int port) throws RemoteException {
        this._port = port;
        this._csf = new ClientSocketFactory(hostname, port);
        this._ssf = new ServerSocketFactory(hostname);
        EZRemoteObject.exportObject(this, port, this._csf, this._ssf);
    }

    protected EZRemoteObject(int startport, int endport) throws RemoteException {
        if (endport < startport) {
            throw new RemoteException("invalid port range: " + startport + " - " + endport);
        }
        this._csf = new ClientSocketFactory();
        this._ssf = new ServerSocketFactory();
        for (int i = startport; i <= endport; ++i) {
            try {
                EZRemoteObject.exportObject(this, i, this._csf, this._ssf);
                this._csf.setServerPort(i);
                this._port = i;
                break;
            }
            catch (RemoteException re) {
                if (i != endport) continue;
                throw re;
            }
        }
    }

    public String getClientHost() throws ServerNotActiveException {
        return RemoteServer.getClientHost();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        EZRemoteObject.exportObject(this, this._port, this._csf, this._ssf);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            EZRemoteObject cloned = (EZRemoteObject)super.clone();
            cloned.reexport();
            return cloned;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Clone failed", e);
        }
    }

    private void reexport() throws RemoteException {
        if (this._csf == null && this._ssf == null) {
            EZRemoteObject.exportObject((Remote)this, this._port);
        } else {
            EZRemoteObject.exportObject(this, this._port, this._csf, this._ssf);
        }
    }

    public static RemoteStub exportObject(Remote obj) throws RemoteException {
        return (RemoteStub)EZRemoteObject.exportObject(obj, new UnicastServerRef(true));
    }

    public static Remote exportObject(Remote obj, int port) throws RemoteException {
        return EZRemoteObject.exportObject(obj, new UnicastServerRef(port));
    }

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        return EZRemoteObject.exportObject(obj, new UnicastServerRef2(port, csf, ssf));
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        return ObjectTable.unexportObject(obj, force);
    }

    private static Remote exportObject(Remote obj, UnicastServerRef sref) throws RemoteException {
        if (obj instanceof EZRemoteObject) {
            ((EZRemoteObject)obj).ref = sref;
        }
        return sref.exportObject(obj, null, false);
    }
}

