/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.JTextComponent;

public class FieldPanelWithReset
extends FieldPanel {
    int _reset;

    public FieldPanelWithReset(int width, int value, int min, int max, int reset) {
        this(width, min, max, reset, null);
        this.setText(Integer.toString(value));
    }

    public FieldPanelWithReset(int width, int value, int min, int max, int reset, String units) {
        this(width, min, max, reset, units);
        this.setText(Integer.toString(value));
    }

    public FieldPanelWithReset(int width, int value, int min, int max, int reset, String units, boolean showRange) {
        this(width, min, max, reset, units, showRange);
        this.setText(Integer.toString(value));
    }

    public FieldPanelWithReset(int width, int min, int max, int reset, String units) {
        this(width, min, max, reset, units, true);
    }

    public FieldPanelWithReset(int width, int min, int max, int reset, String units, boolean showRange) {
        this(width, min, max, reset, units, showRange, null);
    }

    public FieldPanelWithReset(int width, int min, int max, int reset, String units, boolean showRange, String customerHint) {
        super(width);
        BasicArrowButton up = new BasicArrowButton(1);
        up.addActionListener(_UpButtonHandler);
        up.addMouseListener(_UpButtonHandler);
        BasicArrowButton down = new BasicArrowButton(5);
        down.addActionListener(_DownButtonHandler);
        down.addMouseListener(_DownButtonHandler);
        Box box = new Box(1);
        box.add(up);
        box.add(down);
        this.add(box);
        Dimension d = new Dimension(this._field.getPreferredSize());
        d.width = (int)((double)d.height * 0.75);
        box.setPreferredSize(d);
        this._min = min;
        this._reset = reset;
        if (max != -1) {
            this._max = max;
        }
        StringBuffer label = new StringBuffer();
        if (showRange) {
            label.append(' ');
            label.append(min);
            label.append("..");
            label.append(this._max);
            label.append(" (");
            label.append(reset);
            label.append(" for reset)");
        }
        if (units != null) {
            label.append(' ');
            label.append(units);
        }
        if (customerHint != null) {
            label.append(' ');
            label.append(customerHint);
        }
        JLabel l = new JLabel(label.toString());
        l.setFont(ChangedCellRenderer.getNormalFont());
        this.add(l);
        this._field.addFocusListener(new FieldPanel.IntegerValidation());
    }

    public FieldPanelWithReset(int width, int min, int reset, String units) {
        this(width, min, -1, reset, units);
    }

    @Override
    public String getText() throws NumberFormatException {
        int n;
        String strValue;
        if (this._min != Integer.MIN_VALUE && this._max != Integer.MAX_VALUE && (strValue = this._field.getText()).length() > 0 && ((n = FieldPanelWithReset.getNumber(strValue)) < this._min || n > this._max) && n != this._reset) {
            throw new NumberFormatException("not in range");
        }
        if (this._field != null) {
            return this._field.getText();
        }
        if (this._c1 != null && this._c1 instanceof JTextComponent) {
            return ((JTextComponent)this._c1).getText();
        }
        return "";
    }
}

