/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public final class Histogram
implements Icon {
    Color _bg;
    Color _color;
    int _width;
    int _height;
    String _value;
    int _x;
    int _percent;

    public Histogram(Color bg, int width, int height) {
        this._bg = bg;
        this._width = width;
        this._height = height;
        this._x = width / 2 - 8;
    }

    public void setAttr(Color c, String value, int percent) {
        this._color = c;
        this._value = value;
        this._percent = percent;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this._bg);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        g.setColor(this._color);
        g.fillRect(x, y, (int)((double)this._width * ((double)this._percent / 100.0)), this.getIconHeight());
        g.setColor(Color.black);
        if (this._value != null) {
            g.drawString(this._value, this._x, this._height);
        }
    }

    @Override
    public int getIconWidth() {
        return this._width;
    }

    @Override
    public int getIconHeight() {
        return this._height;
    }

    public int getPercent() {
        return this._percent;
    }
}

