/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class IdleTimeOut
implements AWTEventListener,
ActionListener {
    private static IdleTimeOut instance = new IdleTimeOut();
    private static int timeOutInterval = 0;
    private boolean enabled = false;
    private long eventMask = 131096L;
    private Timer logoutTimer = null;
    private Date walkedAwayTime = new Date();
    Window parentWindow = null;
    Runnable closeAction = null;

    public static IdleTimeOut getInstance() {
        return instance;
    }

    private IdleTimeOut() {
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (this.logoutTimer != null && this.logoutTimer.isRunning()) {
            this.logoutTimer.restart();
            this.walkedAwayTime = new Date();
        }
    }

    public static int getTimeOutInterval() {
        return timeOutInterval;
    }

    public static void setTimeOutInterval(int timeOutInterval) {
        IdleTimeOut.timeOutInterval = timeOutInterval;
        if (timeOutInterval < 0) {
            timeOutInterval = 0;
        }
        if (timeOutInterval == 0) {
            instance.setEnabled(false);
        } else {
            instance.setEnabled(true);
        }
    }

    private void setEnabled(boolean enable) {
        if (enable && enable == this.enabled) {
            this.logoutTimer.setDelay(timeOutInterval * 60000);
            this.logoutTimer.restart();
            return;
        }
        if (enable) {
            if (this.logoutTimer == null) {
                this.logoutTimer = new Timer(timeOutInterval * 60000, this);
            }
            this.logoutTimer.setDelay(timeOutInterval * 60000);
            this.logoutTimer.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(instance, this.eventMask);
        } else {
            if (this.logoutTimer != null && this.logoutTimer.isRunning()) {
                this.logoutTimer.stop();
            }
            Toolkit.getDefaultToolkit().removeAWTEventListener(instance);
        }
        this.enabled = enable;
    }

    public static void setParentWindow(Window parentWindow) {
        IdleTimeOut.instance.parentWindow = parentWindow;
    }

    public static void setCloseAction(Runnable runnable) {
        IdleTimeOut.instance.closeAction = runnable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setEnabled(false);
        Object[] options = new Object[]{"Exit"};
        int n = JOptionPane.showOptionDialog(this.parentWindow, "Timed out after " + timeOutInterval + " minute(s) of inactivity.\nIdle since " + this.walkedAwayTime, "Time Out Alert", -1, 2, null, options, options[0]);
        if (this.closeAction != null) {
            this.closeAction.run();
        }
    }

    class CountDownDialog
    extends JDialog {
        CountDownDialog() {
        }
    }
}

