/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.comps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Editor
extends JPanel {
    private JTextArea _tpScript = null;
    private DefaultStyledDocument _scriptDoc = null;
    private SimpleAttributeSet _normal = new SimpleAttributeSet();
    private SimpleAttributeSet _special = new SimpleAttributeSet();
    private static final String SCRIPT = "Script";
    private static final String BLANK = " ";
    private static final String NEWLINE = "\r\n";
    private static final int BORDER = 5;
    private String _status = "";
    private JLabel _label = new JLabel();

    public Editor() {
        this._scriptDoc = new DefaultStyledDocument();
        this._tpScript = new JTextArea(this._scriptDoc);
        this._label.setText(this.getHeader());
        JPanel pnlScript = this.getPanelForTextComponent(this._label, this._tpScript);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)pnlScript, "Center");
        StyleConstants.setForeground(this._normal, Color.black);
        StyleConstants.setForeground(this._special, Color.blue);
        StyleConstants.setBold(this._special, true);
    }

    public void setScript(String str) {
        this._tpScript.setText(str);
    }

    public String getScript() {
        return this._tpScript.getText();
    }

    private JPanel getPanelForTextComponent(JLabel label, JTextComponent comp) {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setLayout(layout);
        JScrollPane textScroller = new JScrollPane(comp);
        textScroller.setAlignmentX(0.0f);
        label.setLabelFor(comp);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(textScroller);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    private Object[] split(String src, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(src, delim);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            list.add(token);
        }
        return list.toArray();
    }

    private String getHeader() {
        String str = SCRIPT;
        if (this._status != null && !this._status.trim().equals("")) {
            str = str + " (" + this._status + ")";
        }
        return str;
    }

    public void setStatus(String status) {
        if (status != null) {
            this._status = status;
            this._label.setText(this.getHeader());
        }
    }
}

